/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.locks;

import java.util.concurrent.ThreadLocalRandom;
import sun.misc.Unsafe;

public class LockSupport {
    private static final Unsafe UNSAFE;
    private static final long parkBlockerOffset;
    private static final long SEED;
    private static final long PROBE;
    private static final long SECONDARY;

    private LockSupport() {
    }

    private static void setBlocker(Thread thread, Object object) {
        UNSAFE.putObject((Object)thread, parkBlockerOffset, object);
    }

    public static void unpark(Thread thread) {
        if (thread != null) {
            UNSAFE.unpark(thread);
        }
    }

    public static void park(Object object) {
        Thread thread = Thread.currentThread();
        LockSupport.setBlocker(thread, object);
        UNSAFE.park(false, 0L);
        LockSupport.setBlocker(thread, null);
    }

    public static void parkNanos(Object object, long l) {
        if (l > 0L) {
            Thread thread = Thread.currentThread();
            LockSupport.setBlocker(thread, object);
            UNSAFE.park(false, l);
            LockSupport.setBlocker(thread, null);
        }
    }

    public static void parkUntil(Object object, long l) {
        Thread thread = Thread.currentThread();
        LockSupport.setBlocker(thread, object);
        UNSAFE.park(true, l);
        LockSupport.setBlocker(thread, null);
    }

    public static Object getBlocker(Thread thread) {
        if (thread == null) {
            throw new NullPointerException();
        }
        return UNSAFE.getObjectVolatile(thread, parkBlockerOffset);
    }

    public static void park() {
        UNSAFE.park(false, 0L);
    }

    public static void parkNanos(long l) {
        if (l > 0L) {
            UNSAFE.park(false, l);
        }
    }

    public static void parkUntil(long l) {
        UNSAFE.park(true, l);
    }

    static final int nextSecondarySeed() {
        Thread thread = Thread.currentThread();
        int n = UNSAFE.getInt((Object)thread, SECONDARY);
        if (n != 0) {
            n ^= n << 13;
            n ^= n >>> 17;
            n ^= n << 5;
        } else {
            n = ThreadLocalRandom.current().nextInt();
            if (n == 0) {
                n = 1;
            }
        }
        UNSAFE.putInt((Object)thread, SECONDARY, n);
        return n;
    }

    static {
        try {
            UNSAFE = Unsafe.getUnsafe();
            Class<Thread> clazz = Thread.class;
            parkBlockerOffset = UNSAFE.objectFieldOffset(clazz.getDeclaredField("parkBlocker"));
            SEED = UNSAFE.objectFieldOffset(clazz.getDeclaredField("threadLocalRandomSeed"));
            PROBE = UNSAFE.objectFieldOffset(clazz.getDeclaredField("threadLocalRandomProbe"));
            SECONDARY = UNSAFE.objectFieldOffset(clazz.getDeclaredField("threadLocalRandomSecondarySeed"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }
}

