/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.TMSchema;
import com.sun.java.swing.plaf.windows.WindowsGraphicsUtils;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import sun.awt.AppContext;

public class WindowsButtonUI
extends BasicButtonUI {
    protected int dashedRectGapX;
    protected int dashedRectGapY;
    protected int dashedRectGapWidth;
    protected int dashedRectGapHeight;
    protected Color focusColor;
    private boolean defaults_initialized = false;
    private static final Object WINDOWS_BUTTON_UI_KEY = new Object();
    private Rectangle viewRect = new Rectangle();

    public static ComponentUI createUI(JComponent jComponent) {
        AppContext appContext = AppContext.getAppContext();
        WindowsButtonUI windowsButtonUI = (WindowsButtonUI)appContext.get(WINDOWS_BUTTON_UI_KEY);
        if (windowsButtonUI == null) {
            windowsButtonUI = new WindowsButtonUI();
            appContext.put(WINDOWS_BUTTON_UI_KEY, windowsButtonUI);
        }
        return windowsButtonUI;
    }

    @Override
    protected void installDefaults(AbstractButton abstractButton) {
        Object object;
        super.installDefaults(abstractButton);
        if (!this.defaults_initialized) {
            object = this.getPropertyPrefix();
            this.dashedRectGapX = UIManager.getInt((String)object + "dashedRectGapX");
            this.dashedRectGapY = UIManager.getInt((String)object + "dashedRectGapY");
            this.dashedRectGapWidth = UIManager.getInt((String)object + "dashedRectGapWidth");
            this.dashedRectGapHeight = UIManager.getInt((String)object + "dashedRectGapHeight");
            this.focusColor = UIManager.getColor((String)object + "focus");
            this.defaults_initialized = true;
        }
        if ((object = XPStyle.getXP()) != null) {
            abstractButton.setBorder(((XPStyle)object).getBorder(abstractButton, WindowsButtonUI.getXPButtonType(abstractButton)));
            LookAndFeel.installProperty(abstractButton, "rolloverEnabled", Boolean.TRUE);
        }
    }

    @Override
    protected void uninstallDefaults(AbstractButton abstractButton) {
        super.uninstallDefaults(abstractButton);
        this.defaults_initialized = false;
    }

    protected Color getFocusColor() {
        return this.focusColor;
    }

    @Override
    protected void paintText(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, String string) {
        WindowsGraphicsUtils.paintText(graphics, abstractButton, rectangle, string, this.getTextShiftOffset());
    }

    @Override
    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        int n = abstractButton.getWidth();
        int n2 = abstractButton.getHeight();
        graphics.setColor(this.getFocusColor());
        BasicGraphicsUtils.drawDashedRect(graphics, this.dashedRectGapX, this.dashedRectGapY, n - this.dashedRectGapWidth, n2 - this.dashedRectGapHeight);
    }

    @Override
    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
        this.setTextShiftOffset();
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        AbstractButton abstractButton = (AbstractButton)jComponent;
        if (dimension != null && abstractButton.isFocusPainted()) {
            if (dimension.width % 2 == 0) {
                ++dimension.width;
            }
            if (dimension.height % 2 == 0) {
                ++dimension.height;
            }
        }
        return dimension;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        if (XPStyle.getXP() != null) {
            WindowsButtonUI.paintXPButtonBackground(graphics, jComponent);
        }
        super.paint(graphics, jComponent);
    }

    static TMSchema.Part getXPButtonType(AbstractButton abstractButton) {
        if (abstractButton instanceof JCheckBox) {
            return TMSchema.Part.BP_CHECKBOX;
        }
        if (abstractButton instanceof JRadioButton) {
            return TMSchema.Part.BP_RADIOBUTTON;
        }
        boolean bl = abstractButton.getParent() instanceof JToolBar;
        return bl ? TMSchema.Part.TP_BUTTON : TMSchema.Part.BP_PUSHBUTTON;
    }

    static TMSchema.State getXPButtonState(AbstractButton abstractButton) {
        TMSchema.Part part = WindowsButtonUI.getXPButtonType(abstractButton);
        ButtonModel buttonModel = abstractButton.getModel();
        TMSchema.State state = TMSchema.State.NORMAL;
        switch (part) {
            case BP_RADIOBUTTON: 
            case BP_CHECKBOX: {
                if (!buttonModel.isEnabled()) {
                    state = buttonModel.isSelected() ? TMSchema.State.CHECKEDDISABLED : TMSchema.State.UNCHECKEDDISABLED;
                    break;
                }
                if (buttonModel.isPressed() && buttonModel.isArmed()) {
                    state = buttonModel.isSelected() ? TMSchema.State.CHECKEDPRESSED : TMSchema.State.UNCHECKEDPRESSED;
                    break;
                }
                if (buttonModel.isRollover()) {
                    state = buttonModel.isSelected() ? TMSchema.State.CHECKEDHOT : TMSchema.State.UNCHECKEDHOT;
                    break;
                }
                state = buttonModel.isSelected() ? TMSchema.State.CHECKEDNORMAL : TMSchema.State.UNCHECKEDNORMAL;
                break;
            }
            case BP_PUSHBUTTON: 
            case TP_BUTTON: {
                boolean bl = abstractButton.getParent() instanceof JToolBar;
                if (bl) {
                    if (buttonModel.isArmed() && buttonModel.isPressed()) {
                        state = TMSchema.State.PRESSED;
                        break;
                    }
                    if (!buttonModel.isEnabled()) {
                        state = TMSchema.State.DISABLED;
                        break;
                    }
                    if (buttonModel.isSelected() && buttonModel.isRollover()) {
                        state = TMSchema.State.HOTCHECKED;
                        break;
                    }
                    if (buttonModel.isSelected()) {
                        state = TMSchema.State.CHECKED;
                        break;
                    }
                    if (buttonModel.isRollover()) {
                        state = TMSchema.State.HOT;
                        break;
                    }
                    if (!abstractButton.hasFocus()) break;
                    state = TMSchema.State.HOT;
                    break;
                }
                if (buttonModel.isArmed() && buttonModel.isPressed() || buttonModel.isSelected()) {
                    state = TMSchema.State.PRESSED;
                    break;
                }
                if (!buttonModel.isEnabled()) {
                    state = TMSchema.State.DISABLED;
                    break;
                }
                if (buttonModel.isRollover() || buttonModel.isPressed()) {
                    state = TMSchema.State.HOT;
                    break;
                }
                if (abstractButton instanceof JButton && ((JButton)abstractButton).isDefaultButton()) {
                    state = TMSchema.State.DEFAULTED;
                    break;
                }
                if (!abstractButton.hasFocus()) break;
                state = TMSchema.State.HOT;
                break;
            }
            default: {
                state = TMSchema.State.NORMAL;
            }
        }
        return state;
    }

    static void paintXPButtonBackground(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        XPStyle xPStyle = XPStyle.getXP();
        TMSchema.Part part = WindowsButtonUI.getXPButtonType(abstractButton);
        if (abstractButton.isContentAreaFilled() && xPStyle != null) {
            XPStyle.Skin skin = xPStyle.getSkin(abstractButton, part);
            TMSchema.State state = WindowsButtonUI.getXPButtonState(abstractButton);
            Dimension dimension = jComponent.getSize();
            int n = 0;
            int n2 = 0;
            int n3 = dimension.width;
            int n4 = dimension.height;
            Border border = jComponent.getBorder();
            Insets insets = border != null ? WindowsButtonUI.getOpaqueInsets(border, jComponent) : jComponent.getInsets();
            if (insets != null) {
                n += insets.left;
                n2 += insets.top;
                n3 -= insets.left + insets.right;
                n4 -= insets.top + insets.bottom;
            }
            skin.paintSkin(graphics, n, n2, n3, n4, state);
        }
    }

    private static Insets getOpaqueInsets(Border border, Component component) {
        if (border == null) {
            return null;
        }
        if (border.isBorderOpaque()) {
            return border.getBorderInsets(component);
        }
        if (border instanceof CompoundBorder) {
            CompoundBorder compoundBorder = (CompoundBorder)border;
            Insets insets = WindowsButtonUI.getOpaqueInsets(compoundBorder.getOutsideBorder(), component);
            if (insets != null && insets.equals(compoundBorder.getOutsideBorder().getBorderInsets(component))) {
                Insets insets2 = WindowsButtonUI.getOpaqueInsets(compoundBorder.getInsideBorder(), component);
                if (insets2 == null) {
                    return insets;
                }
                return new Insets(insets.top + insets2.top, insets.left + insets2.left, insets.bottom + insets2.bottom, insets.right + insets2.right);
            }
            return insets;
        }
        return null;
    }
}

