/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicRadioButtonUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import sun.tools.jconsole.InternalDialog;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.LabeledComponent;
import sun.tools.jconsole.LocalVirtualMachine;
import sun.tools.jconsole.Messages;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.Utilities;

public class ConnectDialog
extends InternalDialog
implements DocumentListener,
FocusListener,
ItemListener,
ListSelectionListener,
KeyListener {
    private static final int COL_NAME = 0;
    private static final int COL_PID = 1;
    JConsole jConsole;
    JTextField userNameTF;
    JTextField passwordTF;
    JRadioButton localRadioButton;
    JRadioButton remoteRadioButton;
    JLabel localMessageLabel;
    JLabel remoteMessageLabel;
    JTextField remoteTF;
    JButton connectButton;
    JButton cancelButton;
    JPanel radioButtonPanel;
    private Icon mastheadIcon = new InternalDialog.MastheadIcon(this, Messages.CONNECT_DIALOG_MASTHEAD_TITLE);
    private Color hintTextColor;
    private Color disabledTableCellColor;
    JTable vmTable;
    ManagedVmTableModel vmModel = null;
    JScrollPane localTableScrollPane = null;
    private Action connectAction;
    private Action cancelAction;
    private static JLabel tmpLabel = new JLabel();

    public ConnectDialog(JConsole jConsole) {
        super(jConsole, Messages.CONNECT_DIALOG_TITLE, true);
        JPanel jPanel;
        Serializable serializable;
        Serializable serializable2;
        Object object;
        this.jConsole = jConsole;
        Utilities.setAccessibleDescription(this, Messages.CONNECT_DIALOG_ACCESSIBLE_DESCRIPTION);
        this.setDefaultCloseOperation(1);
        this.setResizable(false);
        JComponent jComponent = (JComponent)this.getContentPane();
        this.radioButtonPanel = new JPanel(new BorderLayout(0, 12));
        this.radioButtonPanel.setBorder(new EmptyBorder(6, 12, 12, 12));
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.statusBar = new JLabel(" ", 0);
        Utilities.setAccessibleName(this.statusBar, Messages.CONNECT_DIALOG_STATUS_BAR_ACCESSIBLE_NAME);
        Font font = this.statusBar.getFont();
        Font font2 = font.deriveFont(1);
        Font font3 = font.deriveFont(font.getSize2D() - 1.0f);
        JLabel jLabel = new JLabel(this.mastheadIcon);
        Utilities.setAccessibleName(jLabel, Messages.CONNECT_DIALOG_MASTHEAD_ACCESSIBLE_NAME);
        jComponent.add((Component)jLabel, "North");
        jComponent.add((Component)this.radioButtonPanel, "Center");
        jComponent.add((Component)jPanel2, "South");
        this.createActions();
        this.remoteTF = new JTextField();
        this.remoteTF.addActionListener(this.connectAction);
        this.remoteTF.getDocument().addDocumentListener(this);
        this.remoteTF.addFocusListener(this);
        this.remoteTF.setPreferredSize(this.remoteTF.getPreferredSize());
        Utilities.setAccessibleName(this.remoteTF, Messages.REMOTE_PROCESS_TEXT_FIELD_ACCESSIBLE_NAME);
        if (JConsole.isLocalAttachAvailable()) {
            this.vmModel = new ManagedVmTableModel();
            this.vmTable = new LocalTabJTable(this.vmModel);
            this.vmTable.setSelectionMode(0);
            this.vmTable.setPreferredScrollableViewportSize(new Dimension(400, 250));
            this.vmTable.setColumnSelectionAllowed(false);
            this.vmTable.addFocusListener(this);
            this.vmTable.getSelectionModel().addListSelectionListener(this);
            object = this.vmTable.getColumnModel();
            serializable2 = object.getColumn(1);
            ((TableColumn)serializable2).setMaxWidth(ConnectDialog.getLabelWidth("9999999"));
            ((TableColumn)serializable2).setResizable(false);
            serializable = object.getColumn(0);
            ((TableColumn)serializable).setResizable(false);
            this.localRadioButton = new JRadioButton(Messages.LOCAL_PROCESS_COLON);
            this.localRadioButton.setMnemonic(Resources.getMnemonicInt(Messages.LOCAL_PROCESS_COLON));
            this.localRadioButton.setFont(font2);
            this.localRadioButton.addItemListener(this);
            buttonGroup.add(this.localRadioButton);
            JPanel jPanel3 = new JPanel(new BorderLayout());
            jPanel = new JPanel(new BorderLayout());
            this.radioButtonPanel.add((Component)jPanel3, "North");
            jPanel3.add((Component)this.localRadioButton, "North");
            jPanel3.add((Component)new Padder(this.localRadioButton), "Before");
            jPanel3.add((Component)jPanel, "Center");
            this.localTableScrollPane = new JScrollPane(this.vmTable);
            jPanel.add((Component)this.localTableScrollPane, "North");
            this.localMessageLabel = new JLabel(" ");
            this.localMessageLabel.setFont(font3);
            this.localMessageLabel.setForeground(this.hintTextColor);
            jPanel.add((Component)this.localMessageLabel, "South");
        }
        this.remoteRadioButton = new JRadioButton(Messages.REMOTE_PROCESS_COLON);
        this.remoteRadioButton.setMnemonic(Resources.getMnemonicInt(Messages.REMOTE_PROCESS_COLON));
        this.remoteRadioButton.setFont(font2);
        buttonGroup.add(this.remoteRadioButton);
        object = new JPanel(new BorderLayout());
        if (this.localRadioButton != null) {
            ((Container)object).add((Component)this.remoteRadioButton, "North");
            ((Container)object).add((Component)new Padder(this.remoteRadioButton), "Before");
            serializable2 = new AbstractAction("nextRadioButton"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JRadioButton jRadioButton = actionEvent.getSource() == ConnectDialog.this.localRadioButton ? ConnectDialog.this.remoteRadioButton : ConnectDialog.this.localRadioButton;
                    jRadioButton.doClick();
                    jRadioButton.requestFocus();
                }
            };
            this.localRadioButton.getActionMap().put("nextRadioButton", (Action)((Object)serializable2));
            this.remoteRadioButton.getActionMap().put("nextRadioButton", (Action)((Object)serializable2));
            this.localRadioButton.getInputMap().put(KeyStroke.getKeyStroke(40, 0), "nextRadioButton");
            this.remoteRadioButton.getInputMap().put(KeyStroke.getKeyStroke(38, 0), "nextRadioButton");
        } else {
            serializable2 = new JLabel(this.remoteRadioButton.getText());
            ((JComponent)serializable2).setFont(font2);
            ((Container)object).add((Component)serializable2, "North");
        }
        this.radioButtonPanel.add((Component)object, "South");
        serializable2 = new JPanel(new BorderLayout());
        ((Container)object).add((Component)serializable2, "Center");
        ((Container)serializable2).add(this.remoteTF, "North");
        this.remoteMessageLabel = new JLabel("<html>" + Messages.REMOTE_TF_USAGE + "</html>");
        this.remoteMessageLabel.setFont(font3);
        this.remoteMessageLabel.setForeground(this.hintTextColor);
        ((Container)serializable2).add(this.remoteMessageLabel, "Center");
        serializable = new JPanel(new FlowLayout(3, 0, 0));
        ((JComponent)serializable).setBorder(new EmptyBorder(12, 0, 0, 0));
        int n = JConsole.IS_WIN ? 12 : 8;
        this.userNameTF = new JTextField(n);
        this.userNameTF.addActionListener(this.connectAction);
        this.userNameTF.getDocument().addDocumentListener(this);
        this.userNameTF.addFocusListener(this);
        Utilities.setAccessibleName(this.userNameTF, Messages.USERNAME_ACCESSIBLE_NAME);
        jPanel = new LabeledComponent(Messages.USERNAME_COLON_, Resources.getMnemonicInt(Messages.USERNAME_COLON_), this.userNameTF);
        ((LabeledComponent)jPanel).label.setFont(font2);
        ((Container)serializable).add(jPanel);
        this.passwordTF = new JPasswordField(n);
        this.passwordTF.setPreferredSize(this.userNameTF.getPreferredSize());
        this.passwordTF.addActionListener(this.connectAction);
        this.passwordTF.getDocument().addDocumentListener(this);
        this.passwordTF.addFocusListener(this);
        Utilities.setAccessibleName(this.passwordTF, Messages.PASSWORD_ACCESSIBLE_NAME);
        jPanel = new LabeledComponent(Messages.PASSWORD_COLON_, Resources.getMnemonicInt(Messages.PASSWORD_COLON_), this.passwordTF);
        jPanel.setBorder(new EmptyBorder(0, 12, 0, 0));
        ((LabeledComponent)jPanel).label.setFont(font2);
        ((Container)serializable).add(jPanel);
        ((Container)serializable2).add((Component)serializable, "South");
        String string = Messages.CONNECT_DIALOG_CONNECT_BUTTON_TOOLTIP;
        this.connectButton = new JButton(this.connectAction);
        this.connectButton.setToolTipText(string);
        this.cancelButton = new JButton(this.cancelAction);
        JPanel jPanel4 = new JPanel(new FlowLayout(4));
        jPanel4.setBorder(new EmptyBorder(12, 12, 2, 12));
        if (JConsole.IS_GTK) {
            jPanel4.add(this.cancelButton);
            jPanel4.add(this.connectButton);
        } else {
            jPanel4.add(this.connectButton);
            jPanel4.add(this.cancelButton);
        }
        jPanel2.add((Component)jPanel4, "North");
        jPanel2.add((Component)this.statusBar, "South");
        this.updateButtonStates();
        Utilities.updateTransparency(this);
    }

    @Override
    public void revalidate() {
        Color color = UIManager.getColor("Label.disabledForeground");
        if (color == null) {
            color = UIManager.getColor("Label.disabledText");
        }
        this.hintTextColor = Utilities.ensureContrast(color, UIManager.getColor("Panel.background"));
        this.disabledTableCellColor = Utilities.ensureContrast(new Color(0x808080), UIManager.getColor("Table.background"));
        if (this.remoteMessageLabel != null) {
            this.remoteMessageLabel.setForeground(this.hintTextColor);
            String string = String.format("%06x", this.hintTextColor.getRGB() & 0xFFFFFF);
            this.remoteMessageLabel.setText("<html><font color=#" + string + ">" + Messages.REMOTE_TF_USAGE);
        }
        if (this.localMessageLabel != null) {
            this.localMessageLabel.setForeground(this.hintTextColor);
            this.valueChanged(null);
        }
        super.revalidate();
    }

    private void createActions() {
        this.connectAction = new AbstractAction(Messages.CONNECT){
            {
                this.putValue("MnemonicKey", Resources.getMnemonicInt(Messages.CONNECT));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!this.isEnabled() || !ConnectDialog.this.isVisible()) {
                    return;
                }
                ConnectDialog.this.setVisible(false);
                ConnectDialog.this.statusBar.setText("");
                if (ConnectDialog.this.remoteRadioButton.isSelected()) {
                    String string = ConnectDialog.this.remoteTF.getText().trim();
                    String string2 = ConnectDialog.this.userNameTF.getText().trim();
                    string2 = string2.equals("") ? null : string2;
                    String string3 = ConnectDialog.this.passwordTF.getText();
                    string3 = string3.equals("") ? null : string3;
                    try {
                        if (string.startsWith("service:jmx:")) {
                            String string4 = string;
                            ConnectDialog.this.jConsole.addUrl(string4, string2, string3, false);
                            ConnectDialog.this.remoteTF.setText("service:jmx:");
                            return;
                        }
                        String string5 = ConnectDialog.this.remoteTF.getText().trim();
                        String string6 = "0";
                        int n = string5.lastIndexOf(":");
                        if (n >= 0) {
                            string6 = string5.substring(n + 1);
                            string5 = string5.substring(0, n);
                        }
                        if (string5.length() > 0 && string6.length() > 0) {
                            int n2 = Integer.parseInt(string6.trim());
                            ConnectDialog.this.jConsole.addHost(string5, n2, string2, string3);
                            ConnectDialog.this.remoteTF.setText("");
                            ConnectDialog.this.userNameTF.setText("");
                            ConnectDialog.this.passwordTF.setText("");
                            return;
                        }
                    }
                    catch (Exception exception) {
                        ConnectDialog.this.statusBar.setText(exception.toString());
                    }
                    ConnectDialog.this.setVisible(true);
                } else if (ConnectDialog.this.localRadioButton != null && ConnectDialog.this.localRadioButton.isSelected()) {
                    int n = ConnectDialog.this.vmTable.getSelectedRow();
                    if (n >= 0) {
                        ConnectDialog.this.jConsole.addVmid(ConnectDialog.this.vmModel.vmAt(n));
                    }
                    ConnectDialog.this.refresh();
                }
            }
        };
        this.cancelAction = new AbstractAction(Messages.CANCEL){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConnectDialog.this.setVisible(false);
                ConnectDialog.this.statusBar.setText("");
            }
        };
    }

    public static int getLabelWidth(String string) {
        tmpLabel.setText(string);
        return (int)tmpLabel.getPreferredSize().getWidth() + 1;
    }

    public void setConnectionParameters(String string, String string2, int n, String string3, String string4, String string5) {
        if (string != null && string.length() > 0 || string2 != null && string2.length() > 0 && n > 0) {
            this.remoteRadioButton.setSelected(true);
            if (string != null && string.length() > 0) {
                this.remoteTF.setText(string);
            } else {
                this.remoteTF.setText(string2 + ":" + n);
            }
            this.userNameTF.setText(string3 != null ? string3 : "");
            this.passwordTF.setText(string4 != null ? string4 : "");
            this.statusBar.setText(string5 != null ? string5 : "");
            if (this.getPreferredSize().width > this.getWidth()) {
                this.pack();
            }
            this.remoteTF.requestFocus();
            this.remoteTF.selectAll();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (!this.localRadioButton.isSelected()) {
            this.vmTable.getSelectionModel().clearSelection();
        }
        this.updateButtonStates();
    }

    private void updateButtonStates() {
        int n;
        boolean bl = false;
        if (this.remoteRadioButton.isSelected()) {
            bl = JConsole.isValidRemoteString(this.remoteTF.getText());
        } else if (this.localRadioButton != null && this.localRadioButton.isSelected() && (n = this.vmTable.getSelectedRow()) >= 0) {
            LocalVirtualMachine localVirtualMachine = this.vmModel.vmAt(n);
            bl = localVirtualMachine.isManageable() || localVirtualMachine.isAttachable();
        }
        this.connectAction.setEnabled(bl);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateButtonStates();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateButtonStates();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateButtonStates();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        Component component = focusEvent.getOppositeComponent();
        if (!focusEvent.isTemporary() && object instanceof JTextField && component instanceof JComponent && SwingUtilities.getRootPane(component) == this.getRootPane()) {
            ((JTextField)object).selectAll();
        }
        if (object == this.remoteTF) {
            this.remoteRadioButton.setSelected(true);
        } else if (object == this.vmTable) {
            this.localRadioButton.setSelected(true);
            if (this.vmModel.getRowCount() == 1) {
                this.vmTable.setRowSelectionInterval(0, 0);
            }
        }
        this.updateButtonStates();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c == '\u001b') {
            this.setVisible(false);
        } else if (!Character.isDigit(c) && c != '\b' && c != '\u007f') {
            this.getToolkit().beep();
            keyEvent.consume();
        }
    }

    @Override
    public void setVisible(boolean bl) {
        boolean bl2 = this.isVisible();
        super.setVisible(bl);
        if (bl && !bl2) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ConnectDialog.this.remoteRadioButton.isSelected()) {
                        ConnectDialog.this.remoteTF.requestFocus();
                        ConnectDialog.this.remoteTF.selectAll();
                    }
                }
            });
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object object;
        this.updateButtonStates();
        String string = " ";
        int n = this.vmTable.getSelectedRow();
        if (n >= 0 && !((LocalVirtualMachine)(object = this.vmModel.vmAt(n))).isManageable()) {
            string = ((LocalVirtualMachine)object).isAttachable() ? Messages.MANAGEMENT_WILL_BE_ENABLED : Messages.MANAGEMENT_NOT_ENABLED;
        }
        object = String.format("%06x", this.hintTextColor.getRGB() & 0xFFFFFF);
        this.localMessageLabel.setText("<html><font color=#" + (String)object + ">" + string);
    }

    public void refresh() {
        if (this.vmModel != null) {
            LocalVirtualMachine localVirtualMachine = null;
            int n = this.vmTable.getSelectedRow();
            if (n >= 0) {
                localVirtualMachine = this.vmModel.vmAt(n);
            }
            this.vmModel.refresh();
            int n2 = -1;
            int n3 = this.vmModel.getRowCount();
            if (localVirtualMachine != null) {
                for (int i = 0; i < n3; ++i) {
                    LocalVirtualMachine localVirtualMachine2 = this.vmModel.vmAt(i);
                    if (localVirtualMachine.vmid() != localVirtualMachine2.vmid() || !localVirtualMachine.toString().equals(localVirtualMachine2.toString())) continue;
                    n2 = i;
                    break;
                }
            }
            if (n2 > -1) {
                this.vmTable.setRowSelectionInterval(n2, n2);
            } else {
                this.vmTable.getSelectionModel().clearSelection();
            }
            Dimension dimension = this.vmTable.getPreferredSize();
            dimension.height = Math.min(dimension.height - 1, 100);
            this.localTableScrollPane.setVerticalScrollBarPolicy(dimension.height < 100 ? 21 : 20);
            this.localTableScrollPane.getViewport().setMinimumSize(dimension);
            this.localTableScrollPane.getViewport().setPreferredSize(dimension);
        }
        this.pack();
        this.setLocationRelativeTo(this.jConsole);
    }

    private static class Padder
    extends JPanel {
        JRadioButton radioButton;

        Padder(JRadioButton jRadioButton) {
            this.radioButton = jRadioButton;
            Utilities.setAccessibleName(this, Messages.BLANK);
        }

        @Override
        public Dimension getPreferredSize() {
            Rectangle rectangle = Padder.getTextRectangle(this.radioButton);
            int n = rectangle != null && rectangle.x > 8 ? rectangle.x : 22;
            return new Dimension(n, 0);
        }

        private static Rectangle getTextRectangle(AbstractButton abstractButton) {
            Icon icon;
            String string = abstractButton.getText();
            Icon icon2 = icon = abstractButton.isEnabled() ? abstractButton.getIcon() : abstractButton.getDisabledIcon();
            if (icon == null && abstractButton.getUI() instanceof BasicRadioButtonUI) {
                icon = ((BasicRadioButtonUI)abstractButton.getUI()).getDefaultIcon();
            }
            if (icon == null && string == null) {
                return null;
            }
            Rectangle rectangle = new Rectangle();
            Rectangle rectangle2 = new Rectangle();
            Rectangle rectangle3 = new Rectangle();
            Insets insets = new Insets(0, 0, 0, 0);
            insets = abstractButton.getInsets(insets);
            rectangle3.x = insets.left;
            rectangle3.y = insets.top;
            rectangle3.width = abstractButton.getWidth() - (insets.left + insets.right);
            rectangle3.height = abstractButton.getHeight() - (insets.top + insets.bottom);
            Graphics graphics = abstractButton.getGraphics();
            if (graphics == null) {
                return null;
            }
            SwingUtilities.layoutCompoundLabel(abstractButton, graphics.getFontMetrics(), string, icon, abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), rectangle3, rectangle, rectangle2, abstractButton.getIconTextGap());
            return rectangle2;
        }
    }

    private static class ManagedVmTableModel
    extends AbstractTableModel {
        private static String[] columnNames = new String[]{Messages.COLUMN_NAME, Messages.COLUMN_PID};
        private List<LocalVirtualMachine> vmList;

        @Override
        public int getColumnCount() {
            return columnNames.length;
        }

        @Override
        public String getColumnName(int n) {
            return columnNames[n];
        }

        @Override
        public synchronized int getRowCount() {
            return this.vmList.size();
        }

        @Override
        public synchronized Object getValueAt(int n, int n2) {
            assert (n2 >= 0 && n2 <= columnNames.length);
            LocalVirtualMachine localVirtualMachine = this.vmList.get(n);
            switch (n2) {
                case 0: {
                    return localVirtualMachine.displayName();
                }
                case 1: {
                    return localVirtualMachine.vmid();
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Integer.class;
                }
            }
            return super.getColumnClass(n);
        }

        public ManagedVmTableModel() {
            this.refresh();
        }

        public synchronized LocalVirtualMachine vmAt(int n) {
            return this.vmList.get(n);
        }

        public synchronized void refresh() {
            Map<Integer, LocalVirtualMachine> map = LocalVirtualMachine.getAllVirtualMachines();
            this.vmList = new ArrayList<LocalVirtualMachine>();
            this.vmList.addAll(map.values());
            this.fireTableDataChanged();
        }
    }

    private class LocalTabJTable
    extends JTable {
        ManagedVmTableModel vmModel;
        Border rendererBorder;

        public LocalTabJTable(ManagedVmTableModel managedVmTableModel) {
            super(managedVmTableModel);
            this.rendererBorder = new EmptyBorder(0, 6, 0, 6);
            this.vmModel = managedVmTableModel;
            if (!JConsole.IS_GTK) {
                this.setShowVerticalLines(false);
                this.setIntercellSpacing(new Dimension(0, 1));
            }
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        ConnectDialog.this.connectButton.doClick();
                    }
                }
            });
            this.getActionMap().put("connect", ConnectDialog.this.connectAction);
            InputMap inputMap = this.getInputMap(1);
            inputMap.put(KeyStroke.getKeyStroke(10, 0), "connect");
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            String string = null;
            Point point = mouseEvent.getPoint();
            int n = this.rowAtPoint(point);
            int n2 = this.columnAtPoint(point);
            int n3 = this.convertColumnIndexToModel(n2);
            if (n3 == 0) {
                LocalVirtualMachine localVirtualMachine = this.vmModel.vmAt(n);
                string = localVirtualMachine.toString();
            }
            return string;
        }

        @Override
        public TableCellRenderer getCellRenderer(int n, int n2) {
            return new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    Object object2;
                    Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    if (!(bl || ((LocalVirtualMachine)(object2 = LocalTabJTable.this.vmModel.vmAt(n))).isManageable() || ((LocalVirtualMachine)object2).isAttachable())) {
                        component.setForeground(ConnectDialog.this.disabledTableCellColor);
                    }
                    if (component instanceof JLabel) {
                        object2 = (JLabel)component;
                        ((JComponent)object2).setBorder(LocalTabJTable.this.rendererBorder);
                        if (object instanceof Integer) {
                            ((JLabel)object2).setHorizontalAlignment(4);
                        }
                    }
                    return component;
                }
            };
        }
    }
}

