/*
 * Decompiled with CFR 0.152.
 */
package com.apple.eawt;

import com.apple.eawt.AppEvent;
import com.apple.eawt.FullScreenListener;
import java.awt.Window;
import java.util.LinkedList;
import java.util.List;
import javax.swing.RootPaneContainer;
import sun.awt.SunToolkit;

final class FullScreenHandler {
    private static final String CLIENT_PROPERTY = "com.apple.eawt.event.internalFullScreenHandler";
    static final int FULLSCREEN_WILL_ENTER = 1;
    static final int FULLSCREEN_DID_ENTER = 2;
    static final int FULLSCREEN_WILL_EXIT = 3;
    static final int FULLSCREEN_DID_EXIT = 4;
    final List<FullScreenListener> listeners = new LinkedList<FullScreenListener>();

    static void addFullScreenListenerTo(RootPaneContainer rootPaneContainer, FullScreenListener fullScreenListener) {
        Object object = rootPaneContainer.getRootPane().getClientProperty(CLIENT_PROPERTY);
        if (object instanceof FullScreenHandler) {
            ((FullScreenHandler)object).addListener(fullScreenListener);
            return;
        }
        if (object != null) {
            return;
        }
        FullScreenHandler fullScreenHandler = new FullScreenHandler();
        fullScreenHandler.addListener(fullScreenListener);
        rootPaneContainer.getRootPane().putClientProperty(CLIENT_PROPERTY, fullScreenHandler);
    }

    static void removeFullScreenListenerFrom(RootPaneContainer rootPaneContainer, FullScreenListener fullScreenListener) {
        Object object = rootPaneContainer.getRootPane().getClientProperty(CLIENT_PROPERTY);
        if (!(object instanceof FullScreenHandler)) {
            return;
        }
        ((FullScreenHandler)object).removeListener(fullScreenListener);
    }

    static FullScreenHandler getHandlerFor(RootPaneContainer rootPaneContainer) {
        Object object = rootPaneContainer.getRootPane().getClientProperty(CLIENT_PROPERTY);
        if (object instanceof FullScreenHandler) {
            return (FullScreenHandler)object;
        }
        return null;
    }

    static void handleFullScreenEventFromNative(final Window window, final int n) {
        if (!(window instanceof RootPaneContainer)) {
            return;
        }
        SunToolkit.executeOnEventHandlerThread(window, new Runnable(){

            @Override
            public void run() {
                FullScreenHandler fullScreenHandler = FullScreenHandler.getHandlerFor((RootPaneContainer)((Object)window));
                if (fullScreenHandler != null) {
                    fullScreenHandler.notifyListener(new AppEvent.FullScreenEvent(window), n);
                }
            }
        });
    }

    FullScreenHandler() {
    }

    void addListener(FullScreenListener fullScreenListener) {
        this.listeners.add(fullScreenListener);
    }

    void removeListener(FullScreenListener fullScreenListener) {
        this.listeners.remove(fullScreenListener);
    }

    void notifyListener(AppEvent.FullScreenEvent fullScreenEvent, int n) {
        for (FullScreenListener fullScreenListener : this.listeners) {
            switch (n) {
                case 1: {
                    fullScreenListener.windowEnteringFullScreen(fullScreenEvent);
                    return;
                }
                case 2: {
                    fullScreenListener.windowEnteredFullScreen(fullScreenEvent);
                    return;
                }
                case 3: {
                    fullScreenListener.windowExitingFullScreen(fullScreenEvent);
                    return;
                }
                case 4: {
                    fullScreenListener.windowExitedFullScreen(fullScreenEvent);
                    return;
                }
            }
        }
    }
}

