/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.mbeanserver.GetPropertyAction;
import com.sun.jmx.mbeanserver.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.AccessController;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationFilterSupport;
import javax.management.ObjectName;

public class MBeanServerNotificationFilter
extends NotificationFilterSupport {
    private static final long oldSerialVersionUID = 6001782699077323605L;
    private static final long newSerialVersionUID = 2605900539589789736L;
    private static final ObjectStreamField[] oldSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("mySelectObjNameList", Vector.class), new ObjectStreamField("myDeselectObjNameList", Vector.class)};
    private static final ObjectStreamField[] newSerialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("selectedNames", List.class), new ObjectStreamField("deselectedNames", List.class)};
    private static final long serialVersionUID;
    private static final ObjectStreamField[] serialPersistentFields;
    private static boolean compat;
    private List<ObjectName> selectedNames = new Vector<ObjectName>();
    private List<ObjectName> deselectedNames = null;

    public MBeanServerNotificationFilter() {
        JmxProperties.RELATION_LOGGER.entering(MBeanServerNotificationFilter.class.getName(), "MBeanServerNotificationFilter");
        this.enableType("JMX.mbean.registered");
        this.enableType("JMX.mbean.unregistered");
        JmxProperties.RELATION_LOGGER.exiting(MBeanServerNotificationFilter.class.getName(), "MBeanServerNotificationFilter");
    }

    public synchronized void disableAllObjectNames() {
        JmxProperties.RELATION_LOGGER.entering(MBeanServerNotificationFilter.class.getName(), "disableAllObjectNames");
        this.selectedNames = new Vector<ObjectName>();
        this.deselectedNames = null;
        JmxProperties.RELATION_LOGGER.exiting(MBeanServerNotificationFilter.class.getName(), "disableAllObjectNames");
    }

    public synchronized void disableObjectName(ObjectName objectName) throws IllegalArgumentException {
        if (objectName == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        JmxProperties.RELATION_LOGGER.entering(MBeanServerNotificationFilter.class.getName(), "disableObjectName", objectName);
        if (this.selectedNames != null && this.selectedNames.size() != 0) {
            this.selectedNames.remove(objectName);
        }
        if (this.deselectedNames != null && !this.deselectedNames.contains(objectName)) {
            this.deselectedNames.add(objectName);
        }
        JmxProperties.RELATION_LOGGER.exiting(MBeanServerNotificationFilter.class.getName(), "disableObjectName");
    }

    public synchronized void enableAllObjectNames() {
        JmxProperties.RELATION_LOGGER.entering(MBeanServerNotificationFilter.class.getName(), "enableAllObjectNames");
        this.selectedNames = null;
        this.deselectedNames = new Vector<ObjectName>();
        JmxProperties.RELATION_LOGGER.exiting(MBeanServerNotificationFilter.class.getName(), "enableAllObjectNames");
    }

    public synchronized void enableObjectName(ObjectName objectName) throws IllegalArgumentException {
        if (objectName == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        JmxProperties.RELATION_LOGGER.entering(MBeanServerNotificationFilter.class.getName(), "enableObjectName", objectName);
        if (this.deselectedNames != null && this.deselectedNames.size() != 0) {
            this.deselectedNames.remove(objectName);
        }
        if (this.selectedNames != null && !this.selectedNames.contains(objectName)) {
            this.selectedNames.add(objectName);
        }
        JmxProperties.RELATION_LOGGER.exiting(MBeanServerNotificationFilter.class.getName(), "enableObjectName");
    }

    public synchronized Vector<ObjectName> getEnabledObjectNames() {
        if (this.selectedNames != null) {
            return new Vector<ObjectName>(this.selectedNames);
        }
        return null;
    }

    public synchronized Vector<ObjectName> getDisabledObjectNames() {
        if (this.deselectedNames != null) {
            return new Vector<ObjectName>(this.deselectedNames);
        }
        return null;
    }

    @Override
    public synchronized boolean isNotificationEnabled(Notification notification) throws IllegalArgumentException {
        if (notification == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        JmxProperties.RELATION_LOGGER.entering(MBeanServerNotificationFilter.class.getName(), "isNotificationEnabled", notification);
        String string = notification.getType();
        Vector<String> vector = this.getEnabledTypes();
        if (!vector.contains(string)) {
            JmxProperties.RELATION_LOGGER.logp(Level.FINER, MBeanServerNotificationFilter.class.getName(), "isNotificationEnabled", "Type not selected, exiting");
            return false;
        }
        MBeanServerNotification mBeanServerNotification = (MBeanServerNotification)notification;
        ObjectName objectName = mBeanServerNotification.getMBeanName();
        boolean bl = false;
        if (this.selectedNames != null) {
            if (this.selectedNames.size() == 0) {
                JmxProperties.RELATION_LOGGER.logp(Level.FINER, MBeanServerNotificationFilter.class.getName(), "isNotificationEnabled", "No ObjectNames selected, exiting");
                return false;
            }
            bl = this.selectedNames.contains(objectName);
            if (!bl) {
                JmxProperties.RELATION_LOGGER.logp(Level.FINER, MBeanServerNotificationFilter.class.getName(), "isNotificationEnabled", "ObjectName not in selected list, exiting");
                return false;
            }
        }
        if (!bl) {
            if (this.deselectedNames == null) {
                JmxProperties.RELATION_LOGGER.logp(Level.FINER, MBeanServerNotificationFilter.class.getName(), "isNotificationEnabled", "ObjectName not selected, and all names deselected, exiting");
                return false;
            }
            if (this.deselectedNames.contains(objectName)) {
                JmxProperties.RELATION_LOGGER.logp(Level.FINER, MBeanServerNotificationFilter.class.getName(), "isNotificationEnabled", "ObjectName explicitly not selected, exiting");
                return false;
            }
        }
        JmxProperties.RELATION_LOGGER.logp(Level.FINER, MBeanServerNotificationFilter.class.getName(), "isNotificationEnabled", "ObjectName selected, exiting");
        return true;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (compat) {
            ObjectInputStream.GetField getField = objectInputStream.readFields();
            this.selectedNames = (List)Util.cast(getField.get("mySelectObjNameList", null));
            if (getField.defaulted("mySelectObjNameList")) {
                throw new NullPointerException("mySelectObjNameList");
            }
            this.deselectedNames = (List)Util.cast(getField.get("myDeselectObjNameList", null));
            if (getField.defaulted("myDeselectObjNameList")) {
                throw new NullPointerException("myDeselectObjNameList");
            }
        } else {
            objectInputStream.defaultReadObject();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (compat) {
            ObjectOutputStream.PutField putField = objectOutputStream.putFields();
            putField.put("mySelectObjNameList", this.selectedNames);
            putField.put("myDeselectObjNameList", this.deselectedNames);
            objectOutputStream.writeFields();
        } else {
            objectOutputStream.defaultWriteObject();
        }
    }

    static {
        compat = false;
        try {
            GetPropertyAction getPropertyAction = new GetPropertyAction("jmx.serial.form");
            String string = AccessController.doPrivileged(getPropertyAction);
            compat = string != null && string.equals("1.0");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (compat) {
            serialPersistentFields = oldSerialPersistentFields;
            serialVersionUID = 6001782699077323605L;
        } else {
            serialPersistentFields = newSerialPersistentFields;
            serialVersionUID = 2605900539589789736L;
        }
    }
}

