/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.net.ssl.SSLException;
import sun.security.ssl.Alert;
import sun.security.ssl.Authenticator;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.CipherType;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.ContentType;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.SSLCipher;
import sun.security.ssl.SSLConsumer;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLKeyDerivation;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLTrafficKeyDerivation;
import sun.security.ssl.TransportContext;

final class ChangeCipherSpec {
    static final SSLConsumer t10Consumer = new T10ChangeCipherSpecConsumer();
    static final HandshakeProducer t10Producer = new T10ChangeCipherSpecProducer();
    static final SSLConsumer t13Consumer = new T13ChangeCipherSpecConsumer();

    ChangeCipherSpec() {
    }

    private static final class T13ChangeCipherSpecConsumer
    implements SSLConsumer {
        private T13ChangeCipherSpecConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, ByteBuffer byteBuffer) throws IOException {
            TransportContext transportContext = (TransportContext)connectionContext;
            transportContext.consumers.remove(ContentType.CHANGE_CIPHER_SPEC.id);
            if (byteBuffer.remaining() != 1 || byteBuffer.get() != 1) {
                throw transportContext.fatal(Alert.UNEXPECTED_MESSAGE, "Malformed or unexpected ChangeCipherSpec message");
            }
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming ChangeCipherSpec message", new Object[0]);
            }
        }
    }

    private static final class T10ChangeCipherSpecConsumer
    implements SSLConsumer {
        private T10ChangeCipherSpecConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, ByteBuffer byteBuffer) throws IOException {
            SSLCipher.SSLReadCipher sSLReadCipher;
            TransportContext transportContext = (TransportContext)connectionContext;
            transportContext.consumers.remove(ContentType.CHANGE_CIPHER_SPEC.id);
            if (byteBuffer.remaining() != 1 || byteBuffer.get() != 1) {
                throw transportContext.fatal(Alert.UNEXPECTED_MESSAGE, "Malformed or unexpected ChangeCipherSpec message");
            }
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming ChangeCipherSpec message", new Object[0]);
            }
            if (transportContext.handshakeContext == null) {
                throw transportContext.fatal(Alert.HANDSHAKE_FAILURE, "Unexpected ChangeCipherSpec message");
            }
            HandshakeContext handshakeContext = transportContext.handshakeContext;
            if (handshakeContext.handshakeKeyDerivation == null) {
                throw transportContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unexpected ChangeCipherSpec message");
            }
            SSLKeyDerivation sSLKeyDerivation = handshakeContext.handshakeKeyDerivation;
            if (sSLKeyDerivation instanceof SSLTrafficKeyDerivation.LegacyTrafficKeyDerivation) {
                Authenticator authenticator;
                SSLTrafficKeyDerivation.LegacyTrafficKeyDerivation legacyTrafficKeyDerivation = (SSLTrafficKeyDerivation.LegacyTrafficKeyDerivation)sSLKeyDerivation;
                CipherSuite cipherSuite = handshakeContext.negotiatedCipherSuite;
                if (cipherSuite.bulkCipher.cipherType == CipherType.AEAD_CIPHER) {
                    authenticator = Authenticator.valueOf(handshakeContext.negotiatedProtocol);
                } else {
                    try {
                        authenticator = Authenticator.valueOf(handshakeContext.negotiatedProtocol, cipherSuite.macAlg, legacyTrafficKeyDerivation.getTrafficKey(handshakeContext.sslConfig.isClientMode ? "serverMacKey" : "clientMacKey"));
                    }
                    catch (InvalidKeyException | NoSuchAlgorithmException generalSecurityException) {
                        throw new SSLException("Algorithm missing:  ", generalSecurityException);
                    }
                }
                SecretKey secretKey = legacyTrafficKeyDerivation.getTrafficKey(handshakeContext.sslConfig.isClientMode ? "serverWriteKey" : "clientWriteKey");
                SecretKey secretKey2 = legacyTrafficKeyDerivation.getTrafficKey(handshakeContext.sslConfig.isClientMode ? "serverWriteIv" : "clientWriteIv");
                IvParameterSpec ivParameterSpec = secretKey2 == null ? null : new IvParameterSpec(secretKey2.getEncoded());
                try {
                    sSLReadCipher = cipherSuite.bulkCipher.createReadCipher(authenticator, handshakeContext.negotiatedProtocol, secretKey, ivParameterSpec, handshakeContext.sslContext.getSecureRandom());
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new SSLException("Algorithm missing:  ", generalSecurityException);
                }
                if (sSLReadCipher == null) {
                    throw handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Illegal cipher suite (" + (Object)((Object)handshakeContext.negotiatedCipherSuite) + ") and protocol version (" + (Object)((Object)handshakeContext.negotiatedProtocol) + ")");
                }
            } else {
                throw new UnsupportedOperationException("Not supported.");
            }
            transportContext.inputRecord.changeReadCiphers(sSLReadCipher);
        }
    }

    private static final class T10ChangeCipherSpecProducer
    implements HandshakeProducer {
        private T10ChangeCipherSpecProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            SSLCipher.SSLWriteCipher sSLWriteCipher;
            Authenticator authenticator;
            HandshakeContext handshakeContext = (HandshakeContext)connectionContext;
            SSLKeyDerivation sSLKeyDerivation = handshakeContext.handshakeKeyDerivation;
            if (!(sSLKeyDerivation instanceof SSLTrafficKeyDerivation.LegacyTrafficKeyDerivation)) {
                throw new UnsupportedOperationException("Not supported.");
            }
            SSLTrafficKeyDerivation.LegacyTrafficKeyDerivation legacyTrafficKeyDerivation = (SSLTrafficKeyDerivation.LegacyTrafficKeyDerivation)sSLKeyDerivation;
            CipherSuite cipherSuite = handshakeContext.negotiatedCipherSuite;
            if (cipherSuite.bulkCipher.cipherType == CipherType.AEAD_CIPHER) {
                authenticator = Authenticator.valueOf(handshakeContext.negotiatedProtocol);
            } else {
                try {
                    authenticator = Authenticator.valueOf(handshakeContext.negotiatedProtocol, cipherSuite.macAlg, legacyTrafficKeyDerivation.getTrafficKey(handshakeContext.sslConfig.isClientMode ? "clientMacKey" : "serverMacKey"));
                }
                catch (InvalidKeyException | NoSuchAlgorithmException generalSecurityException) {
                    throw new SSLException("Algorithm missing:  ", generalSecurityException);
                }
            }
            SecretKey secretKey = legacyTrafficKeyDerivation.getTrafficKey(handshakeContext.sslConfig.isClientMode ? "clientWriteKey" : "serverWriteKey");
            SecretKey secretKey2 = legacyTrafficKeyDerivation.getTrafficKey(handshakeContext.sslConfig.isClientMode ? "clientWriteIv" : "serverWriteIv");
            IvParameterSpec ivParameterSpec = secretKey2 == null ? null : new IvParameterSpec(secretKey2.getEncoded());
            try {
                sSLWriteCipher = cipherSuite.bulkCipher.createWriteCipher(authenticator, handshakeContext.negotiatedProtocol, secretKey, ivParameterSpec, handshakeContext.sslContext.getSecureRandom());
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new SSLException("Algorithm missing:  ", generalSecurityException);
            }
            if (sSLWriteCipher == null) {
                throw handshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Illegal cipher suite (" + (Object)((Object)cipherSuite) + ") and protocol version (" + (Object)((Object)handshakeContext.negotiatedProtocol) + ")");
            }
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced ChangeCipherSpec message", new Object[0]);
            }
            handshakeContext.conContext.outputRecord.changeWriteCiphers(sSLWriteCipher, true);
            return null;
        }
    }
}

