/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations;

import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverException;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import org.w3c.dom.Element;

public class SecretKeyResolver
extends KeyResolverSpi {
    private static final Logger LOG = LoggerFactory.getLogger(SecretKeyResolver.class);
    private KeyStore keyStore;
    private char[] password;

    public SecretKeyResolver(KeyStore keyStore, char[] cArray) {
        this.keyStore = keyStore;
        this.password = cArray;
    }

    @Override
    public boolean engineCanResolve(Element element, String string, StorageResolver storageResolver) {
        return XMLUtils.elementIsInSignatureSpace(element, "KeyName");
    }

    @Override
    public PublicKey engineLookupAndResolvePublicKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        return null;
    }

    @Override
    public X509Certificate engineLookupResolveX509Certificate(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        return null;
    }

    @Override
    public SecretKey engineResolveSecretKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        LOG.debug("Can I resolve {}?", element.getTagName());
        if (XMLUtils.elementIsInSignatureSpace(element, "KeyName")) {
            String string2 = element.getFirstChild().getNodeValue();
            try {
                Key key = this.keyStore.getKey(string2, this.password);
                if (key instanceof SecretKey) {
                    return (SecretKey)key;
                }
            }
            catch (Exception exception) {
                LOG.debug("Cannot recover the key", exception);
            }
        }
        LOG.debug("I can't");
        return null;
    }

    @Override
    public PrivateKey engineLookupAndResolvePrivateKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        return null;
    }
}

