/*
 * Decompiled with CFR 0.152.
 */
package javax.script;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.SimpleBindings;

public class ScriptEngineManager {
    private static final boolean DEBUG = false;
    private HashSet<ScriptEngineFactory> engineSpis;
    private HashMap<String, ScriptEngineFactory> nameAssociations;
    private HashMap<String, ScriptEngineFactory> extensionAssociations;
    private HashMap<String, ScriptEngineFactory> mimeTypeAssociations;
    private Bindings globalScope;

    public ScriptEngineManager() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        this.init(classLoader);
    }

    public ScriptEngineManager(ClassLoader classLoader) {
        this.init(classLoader);
    }

    private void init(ClassLoader classLoader) {
        this.globalScope = new SimpleBindings();
        this.engineSpis = new HashSet();
        this.nameAssociations = new HashMap();
        this.extensionAssociations = new HashMap();
        this.mimeTypeAssociations = new HashMap();
        this.initEngines(classLoader);
    }

    private ServiceLoader<ScriptEngineFactory> getServiceLoader(ClassLoader classLoader) {
        if (classLoader != null) {
            return ServiceLoader.load(ScriptEngineFactory.class, classLoader);
        }
        return ServiceLoader.loadInstalled(ScriptEngineFactory.class);
    }

    private void initEngines(final ClassLoader classLoader) {
        Object object;
        Iterator<ScriptEngineFactory> iterator = null;
        try {
            object = AccessController.doPrivileged(new PrivilegedAction<ServiceLoader<ScriptEngineFactory>>(){

                @Override
                public ServiceLoader<ScriptEngineFactory> run() {
                    return ScriptEngineManager.this.getServiceLoader(classLoader);
                }
            });
            iterator = ((ServiceLoader)object).iterator();
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            System.err.println("Can't find ScriptEngineFactory providers: " + serviceConfigurationError.getMessage());
            return;
        }
        try {
            while (iterator.hasNext()) {
                try {
                    object = iterator.next();
                    this.engineSpis.add((ScriptEngineFactory)object);
                }
                catch (ServiceConfigurationError serviceConfigurationError) {
                    System.err.println("ScriptEngineManager providers.next(): " + serviceConfigurationError.getMessage());
                }
            }
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            System.err.println("ScriptEngineManager providers.hasNext(): " + serviceConfigurationError.getMessage());
            return;
        }
    }

    public void setBindings(Bindings bindings) {
        if (bindings == null) {
            throw new IllegalArgumentException("Global scope cannot be null.");
        }
        this.globalScope = bindings;
    }

    public Bindings getBindings() {
        return this.globalScope;
    }

    public void put(String string, Object object) {
        this.globalScope.put(string, object);
    }

    public Object get(String string) {
        return this.globalScope.get(string);
    }

    public ScriptEngine getEngineByName(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        ScriptEngineFactory scriptEngineFactory = this.nameAssociations.get(string);
        if (null != scriptEngineFactory) {
            ScriptEngineFactory scriptEngineFactory2 = scriptEngineFactory;
            try {
                ScriptEngine scriptEngine = scriptEngineFactory2.getScriptEngine();
                scriptEngine.setBindings(this.getBindings(), 200);
                return scriptEngine;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (ScriptEngineFactory scriptEngineFactory3 : this.engineSpis) {
            List<String> list = null;
            try {
                list = scriptEngineFactory3.getNames();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (list == null) continue;
            for (String string2 : list) {
                if (!string.equals(string2)) continue;
                try {
                    ScriptEngine scriptEngine = scriptEngineFactory3.getScriptEngine();
                    scriptEngine.setBindings(this.getBindings(), 200);
                    return scriptEngine;
                }
                catch (Exception exception) {
                }
            }
        }
        return null;
    }

    public ScriptEngine getEngineByExtension(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        ScriptEngineFactory scriptEngineFactory = this.extensionAssociations.get(string);
        if (null != scriptEngineFactory) {
            ScriptEngineFactory scriptEngineFactory2 = scriptEngineFactory;
            try {
                ScriptEngine scriptEngine = scriptEngineFactory2.getScriptEngine();
                scriptEngine.setBindings(this.getBindings(), 200);
                return scriptEngine;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (ScriptEngineFactory scriptEngineFactory3 : this.engineSpis) {
            List<String> list = null;
            try {
                list = scriptEngineFactory3.getExtensions();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (list == null) continue;
            for (String string2 : list) {
                if (!string.equals(string2)) continue;
                try {
                    ScriptEngine scriptEngine = scriptEngineFactory3.getScriptEngine();
                    scriptEngine.setBindings(this.getBindings(), 200);
                    return scriptEngine;
                }
                catch (Exception exception) {
                }
            }
        }
        return null;
    }

    public ScriptEngine getEngineByMimeType(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        ScriptEngineFactory scriptEngineFactory = this.mimeTypeAssociations.get(string);
        if (null != scriptEngineFactory) {
            ScriptEngineFactory scriptEngineFactory2 = scriptEngineFactory;
            try {
                ScriptEngine scriptEngine = scriptEngineFactory2.getScriptEngine();
                scriptEngine.setBindings(this.getBindings(), 200);
                return scriptEngine;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (ScriptEngineFactory scriptEngineFactory3 : this.engineSpis) {
            List<String> list = null;
            try {
                list = scriptEngineFactory3.getMimeTypes();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (list == null) continue;
            for (String string2 : list) {
                if (!string.equals(string2)) continue;
                try {
                    ScriptEngine scriptEngine = scriptEngineFactory3.getScriptEngine();
                    scriptEngine.setBindings(this.getBindings(), 200);
                    return scriptEngine;
                }
                catch (Exception exception) {
                }
            }
        }
        return null;
    }

    public List<ScriptEngineFactory> getEngineFactories() {
        ArrayList<ScriptEngineFactory> arrayList = new ArrayList<ScriptEngineFactory>(this.engineSpis.size());
        for (ScriptEngineFactory scriptEngineFactory : this.engineSpis) {
            arrayList.add(scriptEngineFactory);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public void registerEngineName(String string, ScriptEngineFactory scriptEngineFactory) {
        if (string == null || scriptEngineFactory == null) {
            throw new NullPointerException();
        }
        this.nameAssociations.put(string, scriptEngineFactory);
    }

    public void registerEngineMimeType(String string, ScriptEngineFactory scriptEngineFactory) {
        if (string == null || scriptEngineFactory == null) {
            throw new NullPointerException();
        }
        this.mimeTypeAssociations.put(string, scriptEngineFactory);
    }

    public void registerEngineExtension(String string, ScriptEngineFactory scriptEngineFactory) {
        if (string == null || scriptEngineFactory == null) {
            throw new NullPointerException();
        }
        this.extensionAssociations.put(string, scriptEngineFactory);
    }
}

