/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset.serial;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Ref;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import javax.sql.rowset.serial.SerialException;

public class SerialRef
implements Ref,
Serializable,
Cloneable {
    private String baseTypeName;
    private Object object;
    private Ref reference;
    static final long serialVersionUID = -4727123500609662274L;

    public SerialRef(Ref ref) throws SerialException, SQLException {
        if (ref == null) {
            throw new SQLException("Cannot instantiate a SerialRef object with a null Ref object");
        }
        this.reference = ref;
        this.object = ref;
        if (ref.getBaseTypeName() == null) {
            throw new SQLException("Cannot instantiate a SerialRef object that returns a null base type name");
        }
        this.baseTypeName = ref.getBaseTypeName();
    }

    @Override
    public String getBaseTypeName() throws SerialException {
        return this.baseTypeName;
    }

    @Override
    public Object getObject(Map<String, Class<?>> map) throws SerialException {
        map = new Hashtable(map);
        if (this.object != null) {
            return map.get(this.object);
        }
        throw new SerialException("The object is not set");
    }

    @Override
    public Object getObject() throws SerialException {
        if (this.reference != null) {
            try {
                return this.reference.getObject();
            }
            catch (SQLException sQLException) {
                throw new SerialException("SQLException: " + sQLException.getMessage());
            }
        }
        if (this.object != null) {
            return this.object;
        }
        throw new SerialException("The object is not set");
    }

    @Override
    public void setObject(Object object) throws SerialException {
        try {
            this.reference.setObject(object);
        }
        catch (SQLException sQLException) {
            throw new SerialException("SQLException: " + sQLException.getMessage());
        }
        this.object = object;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SerialRef) {
            SerialRef serialRef = (SerialRef)object;
            return this.baseTypeName.equals(serialRef.baseTypeName) && this.object.equals(serialRef.object);
        }
        return false;
    }

    public int hashCode() {
        return (31 + this.object.hashCode()) * 31 + this.baseTypeName.hashCode();
    }

    public Object clone() {
        try {
            SerialRef serialRef = (SerialRef)super.clone();
            serialRef.reference = null;
            return serialRef;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        this.object = getField.get("object", null);
        this.baseTypeName = (String)getField.get("baseTypeName", null);
        this.reference = (Ref)getField.get("reference", null);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException, ClassNotFoundException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("baseTypeName", this.baseTypeName);
        putField.put("object", this.object);
        putField.put("reference", this.reference instanceof Serializable ? this.reference : null);
        objectOutputStream.writeFields();
    }
}

