/*
 * Decompiled with CFR 0.152.
 */
package sun.security.timestamp;

import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.Map;
import sun.misc.IOUtils;
import sun.security.timestamp.TSRequest;
import sun.security.timestamp.TSResponse;
import sun.security.timestamp.Timestamper;
import sun.security.util.Debug;

public class HttpTimestamper
implements Timestamper {
    private static final int CONNECT_TIMEOUT = 15000;
    private static final String TS_QUERY_MIME_TYPE = "application/timestamp-query";
    private static final String TS_REPLY_MIME_TYPE = "application/timestamp-reply";
    private static final Debug debug = Debug.getInstance("ts");
    private URI tsaURI = null;

    public HttpTimestamper(URI uRI) {
        if (!uRI.getScheme().equalsIgnoreCase("http") && !uRI.getScheme().equalsIgnoreCase("https")) {
            throw new IllegalArgumentException("TSA must be an HTTP or HTTPS URI");
        }
        this.tsaURI = uRI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TSResponse generateTimestamp(TSRequest tSRequest) throws IOException {
        Object object;
        Object object2;
        Object object3;
        HttpURLConnection httpURLConnection = (HttpURLConnection)this.tsaURI.toURL().openConnection();
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setRequestProperty("Content-Type", TS_QUERY_MIME_TYPE);
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setConnectTimeout(15000);
        if (debug != null) {
            object3 = httpURLConnection.getRequestProperties().entrySet();
            debug.println(httpURLConnection.getRequestMethod() + " " + this.tsaURI + " HTTP/1.1");
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                debug.println("  " + object);
            }
            debug.println();
        }
        httpURLConnection.connect();
        object3 = null;
        try {
            object3 = new DataOutputStream(httpURLConnection.getOutputStream());
            object2 = tSRequest.encode();
            ((DataOutputStream)object3).write((byte[])object2, 0, ((byte[])object2).length);
            ((DataOutputStream)object3).flush();
            if (debug != null) {
                debug.println("sent timestamp query (length=" + ((Object)object2).length + ")");
            }
        }
        finally {
            if (object3 != null) {
                ((FilterOutputStream)object3).close();
            }
        }
        object2 = null;
        object = null;
        try {
            object2 = new BufferedInputStream(httpURLConnection.getInputStream());
            if (debug != null) {
                String string = httpURLConnection.getHeaderField(0);
                debug.println(string);
                int n = 1;
                while ((string = httpURLConnection.getHeaderField(n)) != null) {
                    String string2 = httpURLConnection.getHeaderFieldKey(n);
                    debug.println("  " + (string2 == null ? "" : string2 + ": ") + string);
                    ++n;
                }
                debug.println();
            }
            HttpTimestamper.verifyMimeType(httpURLConnection.getContentType());
            int n = httpURLConnection.getContentLength();
            object = IOUtils.readAllBytes((InputStream)object2);
            if (n != -1 && ((Object)object).length != n) {
                throw new EOFException("Expected:" + n + ", read:" + ((Object)object).length);
            }
            if (debug != null) {
                debug.println("received timestamp response (length=" + ((Object)object).length + ")");
            }
        }
        finally {
            if (object2 != null) {
                ((BufferedInputStream)object2).close();
            }
        }
        return new TSResponse((byte[])object);
    }

    private static void verifyMimeType(String string) throws IOException {
        if (!TS_REPLY_MIME_TYPE.equalsIgnoreCase(string)) {
            throw new IOException("MIME Content-Type is not application/timestamp-reply");
        }
    }
}

