/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import sun.misc.SharedSecrets;
import sun.misc.Unsafe;

public class HashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 362498820763181265L;
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int TREEIFY_THRESHOLD = 8;
    static final int UNTREEIFY_THRESHOLD = 6;
    static final int MIN_TREEIFY_CAPACITY = 64;
    transient Node<K, V>[] table;
    transient Set<Map.Entry<K, V>> entrySet;
    transient int size;
    transient int modCount;
    int threshold;
    final float loadFactor;

    static final int hash(Object object) {
        int n;
        if (object == null) {
            n = 0;
        } else {
            int n2 = object.hashCode();
            n = n2 ^ n2 >>> 16;
        }
        return n;
    }

    static Class<?> comparableClassFor(Object object) {
        if (object instanceof Comparable) {
            Class<?> clazz = object.getClass();
            if (clazz == String.class) {
                return clazz;
            }
            Type[] typeArray = clazz.getGenericInterfaces();
            if (typeArray != null) {
                for (int i = 0; i < typeArray.length; ++i) {
                    Type[] typeArray2;
                    ParameterizedType parameterizedType;
                    Type type = typeArray[i];
                    if (!(type instanceof ParameterizedType) || (parameterizedType = (ParameterizedType)type).getRawType() != Comparable.class || (typeArray2 = parameterizedType.getActualTypeArguments()) == null || typeArray2.length != 1 || typeArray2[0] != clazz) continue;
                    return clazz;
                }
            }
        }
        return null;
    }

    static int compareComparables(Class<?> clazz, Object object, Object object2) {
        return object2 == null || object2.getClass() != clazz ? 0 : ((Comparable)object).compareTo(object2);
    }

    static final int tableSizeFor(int n) {
        int n2 = n - 1;
        n2 |= n2 >>> 1;
        n2 |= n2 >>> 2;
        n2 |= n2 >>> 4;
        n2 |= n2 >>> 8;
        return (n2 |= n2 >>> 16) < 0 ? 1 : (n2 >= 0x40000000 ? 0x40000000 : n2 + 1);
    }

    public HashMap(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + n);
        }
        if (n > 0x40000000) {
            n = 0x40000000;
        }
        if (f <= 0.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException("Illegal load factor: " + f);
        }
        this.loadFactor = f;
        this.threshold = HashMap.tableSizeFor(n);
    }

    public HashMap(int n) {
        this(n, 0.75f);
    }

    public HashMap() {
        this.loadFactor = 0.75f;
    }

    public HashMap(Map<? extends K, ? extends V> map) {
        this.loadFactor = 0.75f;
        this.putMapEntries(map, false);
    }

    final void putMapEntries(Map<? extends K, ? extends V> map, boolean bl) {
        int n = map.size();
        if (n > 0) {
            if (this.table == null) {
                int n2;
                float f = (float)n / this.loadFactor + 1.0f;
                int n3 = n2 = f < 1.0737418E9f ? (int)f : 0x40000000;
                if (n2 > this.threshold) {
                    this.threshold = HashMap.tableSizeFor(n2);
                }
            } else if (n > this.threshold) {
                this.resize();
            }
            for (Map.Entry<K, V> entry : map.entrySet()) {
                K k = entry.getKey();
                V v = entry.getValue();
                this.putVal(HashMap.hash(k), k, v, false, bl);
            }
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public V get(Object object) {
        Node<K, V> node = this.getNode(HashMap.hash(object), object);
        return node == null ? null : (V)node.value;
    }

    final Node<K, V> getNode(int n, Object object) {
        Node<K, V> node;
        int n2;
        Node<K, V>[] nodeArray = this.table;
        if (this.table != null && (n2 = nodeArray.length) > 0 && (node = nodeArray[n2 - 1 & n]) != null) {
            Object k;
            if (node.hash == n && ((k = node.key) == object || object != null && object.equals(k))) {
                return node;
            }
            Node node2 = node.next;
            if (node2 != null) {
                if (node instanceof TreeNode) {
                    return ((TreeNode)node).getTreeNode(n, object);
                }
                do {
                    if (node2.hash != n || (k = node2.key) != object && (object == null || !object.equals(k))) continue;
                    return node2;
                } while ((node2 = node2.next) != null);
            }
        }
        return null;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.getNode(HashMap.hash(object), object) != null;
    }

    @Override
    public V put(K k, V v) {
        return this.putVal(HashMap.hash(k), k, v, false, true);
    }

    final V putVal(int n, K k, V v, boolean bl, boolean bl2) {
        int n2;
        Node<K, V> node;
        int n3;
        Node<K, V>[] nodeArray = this.table;
        if (this.table == null || (n3 = nodeArray.length) == 0) {
            nodeArray = this.resize();
            n3 = nodeArray.length;
        }
        if ((node = nodeArray[n2 = n3 - 1 & n]) == null) {
            nodeArray[n2] = this.newNode(n, k, v, null);
        } else {
            Node<K, V> node2;
            Object k2;
            if (node.hash == n && ((k2 = node.key) == k || k != null && k.equals(k2))) {
                node2 = node;
            } else if (node instanceof TreeNode) {
                node2 = ((TreeNode)node).putTreeVal(this, nodeArray, n, k, v);
            } else {
                int n4 = 0;
                while (true) {
                    if ((node2 = node.next) == null) {
                        node.next = this.newNode(n, k, v, null);
                        if (n4 < 7) break;
                        this.treeifyBin(nodeArray, n);
                        break;
                    }
                    if (node2.hash == n && ((k2 = node2.key) == k || k != null && k.equals(k2))) break;
                    node = node2;
                    ++n4;
                }
            }
            if (node2 != null) {
                Object v2 = node2.value;
                if (!bl || v2 == null) {
                    node2.value = v;
                }
                this.afterNodeAccess(node2);
                return v2;
            }
        }
        ++this.modCount;
        if (++this.size > this.threshold) {
            this.resize();
        }
        this.afterNodeInsertion(bl2);
        return null;
    }

    final Node<K, V>[] resize() {
        int n;
        Node<K, V>[] nodeArray = this.table;
        int n2 = nodeArray == null ? 0 : nodeArray.length;
        int n3 = this.threshold;
        int n4 = 0;
        if (n2 > 0) {
            if (n2 >= 0x40000000) {
                this.threshold = Integer.MAX_VALUE;
                return nodeArray;
            }
            n = n2 << 1;
            if (n < 0x40000000 && n2 >= 16) {
                n4 = n3 << 1;
            }
        } else if (n3 > 0) {
            n = n3;
        } else {
            n = 16;
            n4 = 12;
        }
        if (n4 == 0) {
            float f = (float)n * this.loadFactor;
            n4 = n < 0x40000000 && f < 1.0737418E9f ? (int)f : Integer.MAX_VALUE;
        }
        this.threshold = n4;
        Node[] nodeArray2 = new Node[n];
        this.table = nodeArray2;
        if (nodeArray != null) {
            for (int i = 0; i < n2; ++i) {
                Node node;
                Node<K, V> node2 = nodeArray[i];
                if (node2 == null) continue;
                nodeArray[i] = null;
                if (node2.next == null) {
                    nodeArray2[node2.hash & n - 1] = node2;
                    continue;
                }
                if (node2 instanceof TreeNode) {
                    ((TreeNode)node2).split(this, nodeArray2, i, n2);
                    continue;
                }
                Node<K, V> node3 = null;
                Node<K, V> node4 = null;
                Node<K, V> node5 = null;
                Node<K, V> node6 = null;
                do {
                    node = node2.next;
                    if ((node2.hash & n2) == 0) {
                        if (node4 == null) {
                            node3 = node2;
                        } else {
                            node4.next = node2;
                        }
                        node4 = node2;
                        continue;
                    }
                    if (node6 == null) {
                        node5 = node2;
                    } else {
                        node6.next = node2;
                    }
                    node6 = node2;
                } while ((node2 = node) != null);
                if (node4 != null) {
                    node4.next = null;
                    nodeArray2[i] = node3;
                }
                if (node6 == null) continue;
                node6.next = null;
                nodeArray2[i + n2] = node5;
            }
        }
        return nodeArray2;
    }

    final void treeifyBin(Node<K, V>[] nodeArray, int n) {
        int n2;
        if (nodeArray == null || (n2 = nodeArray.length) < 64) {
            this.resize();
        } else {
            int n3 = n2 - 1 & n;
            Node<K, V> node = nodeArray[n3];
            if (node != null) {
                TreeNode<K, V> treeNode = null;
                TreeNode<K, V> treeNode2 = null;
                do {
                    TreeNode<K, V> treeNode3 = this.replacementTreeNode(node, null);
                    if (treeNode2 == null) {
                        treeNode = treeNode3;
                    } else {
                        treeNode3.prev = treeNode2;
                        treeNode2.next = treeNode3;
                    }
                    treeNode2 = treeNode3;
                } while ((node = node.next) != null);
                nodeArray[n3] = treeNode;
                if (nodeArray[n3] != null) {
                    treeNode.treeify(nodeArray);
                }
            }
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.putMapEntries(map, true);
    }

    @Override
    public V remove(Object object) {
        Node<K, V> node = this.removeNode(HashMap.hash(object), object, null, false, true);
        return node == null ? null : (V)node.value;
    }

    final Node<K, V> removeNode(int n, Object object, Object object2, boolean bl, boolean bl2) {
        int n2;
        Node<K, V> node;
        int n3;
        Node<K, V>[] nodeArray = this.table;
        if (this.table != null && (n3 = nodeArray.length) > 0 && (node = nodeArray[n2 = n3 - 1 & n]) != null) {
            Object v;
            Object k;
            Node<K, V> node2 = null;
            if (node.hash == n && ((k = node.key) == object || object != null && object.equals(k))) {
                node2 = node;
            } else {
                Node node3 = node.next;
                if (node3 != null) {
                    if (node instanceof TreeNode) {
                        node2 = ((TreeNode)node).getTreeNode(n, object);
                    } else {
                        do {
                            if (node3.hash == n && ((k = node3.key) == object || object != null && object.equals(k))) {
                                node2 = node3;
                                break;
                            }
                            node = node3;
                        } while ((node3 = node3.next) != null);
                    }
                }
            }
            if (node2 != null && (!bl || (v = node2.value) == object2 || object2 != null && object2.equals(v))) {
                if (node2 instanceof TreeNode) {
                    ((TreeNode)node2).removeTreeNode(this, nodeArray, bl2);
                } else if (node2 == node) {
                    nodeArray[n2] = node2.next;
                } else {
                    node.next = node2.next;
                }
                ++this.modCount;
                --this.size;
                this.afterNodeRemoval(node2);
                return node2;
            }
        }
        return null;
    }

    @Override
    public void clear() {
        ++this.modCount;
        Node<K, V>[] nodeArray = this.table;
        if (this.table != null && this.size > 0) {
            this.size = 0;
            for (int i = 0; i < nodeArray.length; ++i) {
                nodeArray[i] = null;
            }
        }
    }

    @Override
    public boolean containsValue(Object object) {
        Node<K, V>[] nodeArray = this.table;
        if (this.table != null && this.size > 0) {
            for (int i = 0; i < nodeArray.length; ++i) {
                Node<K, V> node = nodeArray[i];
                while (node != null) {
                    Object v = node.value;
                    if (v == object || object != null && object.equals(v)) {
                        return true;
                    }
                    node = node.next;
                }
            }
        }
        return false;
    }

    @Override
    public Set<K> keySet() {
        Set set = this.keySet;
        if (set == null) {
            this.keySet = set = new KeySet();
        }
        return set;
    }

    @Override
    public Collection<V> values() {
        Collection collection = this.values;
        if (collection == null) {
            this.values = collection = new Values();
        }
        return collection;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet = this.entrySet;
        return entrySet == null ? (this.entrySet = new EntrySet()) : entrySet;
    }

    @Override
    public V getOrDefault(Object object, V v) {
        Node<K, V> node = this.getNode(HashMap.hash(object), object);
        return node == null ? v : node.value;
    }

    @Override
    public V putIfAbsent(K k, V v) {
        return this.putVal(HashMap.hash(k), k, v, true, true);
    }

    @Override
    public boolean remove(Object object, Object object2) {
        return this.removeNode(HashMap.hash(object), object, object2, true, true) != null;
    }

    @Override
    public boolean replace(K k, V v, V v2) {
        Object v3;
        Node<K, V> node = this.getNode(HashMap.hash(k), k);
        if (node != null && ((v3 = node.value) == v || v3 != null && v3.equals(v))) {
            node.value = v2;
            this.afterNodeAccess(node);
            return true;
        }
        return false;
    }

    @Override
    public V replace(K k, V v) {
        Node<K, V> node = this.getNode(HashMap.hash(k), k);
        if (node != null) {
            Object v2 = node.value;
            node.value = v;
            this.afterNodeAccess(node);
            return v2;
        }
        return null;
    }

    @Override
    public V computeIfAbsent(K k, Function<? super K, ? extends V> function) {
        Object object;
        int n;
        Node<K, V> node;
        int n2;
        Node<K, V>[] nodeArray;
        Node node2;
        TreeNode treeNode;
        int n3;
        int n4;
        block16: {
            block15: {
                if (function == null) {
                    throw new NullPointerException();
                }
                n4 = HashMap.hash(k);
                n3 = 0;
                treeNode = null;
                node2 = null;
                if (this.size > this.threshold) break block15;
                nodeArray = this.table;
                if (this.table != null && (n2 = nodeArray.length) != 0) break block16;
            }
            nodeArray = this.resize();
            n2 = nodeArray.length;
        }
        if ((node = nodeArray[n = n2 - 1 & n4]) != null) {
            if (node instanceof TreeNode) {
                treeNode = (TreeNode)node;
                node2 = treeNode.getTreeNode(n4, k);
            } else {
                object = node;
                do {
                    Object k2;
                    if (((Node)object).hash == n4 && ((k2 = ((Node)object).key) == k || k != null && k.equals(k2))) {
                        node2 = object;
                        break;
                    }
                    ++n3;
                } while ((object = ((Node)object).next) != null);
            }
            if (node2 != null && (object = node2.value) != null) {
                this.afterNodeAccess(node2);
                return object;
            }
        }
        if ((object = function.apply(k)) == null) {
            return null;
        }
        if (node2 != null) {
            node2.value = object;
            this.afterNodeAccess(node2);
            return object;
        }
        if (treeNode != null) {
            treeNode.putTreeVal(this, nodeArray, n4, k, object);
        } else {
            nodeArray[n] = this.newNode(n4, k, object, node);
            if (n3 >= 7) {
                this.treeifyBin(nodeArray, n4);
            }
        }
        ++this.modCount;
        ++this.size;
        this.afterNodeInsertion(true);
        return object;
    }

    @Override
    public V computeIfPresent(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
        Object v;
        if (biFunction == null) {
            throw new NullPointerException();
        }
        int n = HashMap.hash(k);
        Node<K, V> node = this.getNode(n, k);
        if (node != null && (v = node.value) != null) {
            V v2 = biFunction.apply(k, v);
            if (v2 != null) {
                node.value = v2;
                this.afterNodeAccess(node);
                return v2;
            }
            this.removeNode(n, k, null, false, true);
        }
        return null;
    }

    @Override
    public V compute(K k, BiFunction<? super K, ? super V, ? extends V> biFunction) {
        Object object;
        Node<K, V> node;
        int n;
        Node<K, V> node2;
        int n2;
        Node<K, V>[] nodeArray;
        Node node3;
        TreeNode treeNode;
        int n3;
        int n4;
        block18: {
            block17: {
                if (biFunction == null) {
                    throw new NullPointerException();
                }
                n4 = HashMap.hash(k);
                n3 = 0;
                treeNode = null;
                node3 = null;
                if (this.size > this.threshold) break block17;
                nodeArray = this.table;
                if (this.table != null && (n2 = nodeArray.length) != 0) break block18;
            }
            nodeArray = this.resize();
            n2 = nodeArray.length;
        }
        if ((node2 = nodeArray[n = n2 - 1 & n4]) != null) {
            if (node2 instanceof TreeNode) {
                treeNode = (TreeNode)node2;
                node3 = treeNode.getTreeNode(n4, k);
            } else {
                node = node2;
                do {
                    if (node.hash == n4 && ((object = node.key) == k || k != null && k.equals(object))) {
                        node3 = node;
                        break;
                    }
                    ++n3;
                } while ((node = node.next) != null);
            }
        }
        node = node3 == null ? null : node3.value;
        object = biFunction.apply(k, node);
        if (node3 != null) {
            if (object != null) {
                node3.value = object;
                this.afterNodeAccess(node3);
            } else {
                this.removeNode(n4, k, null, false, true);
            }
        } else if (object != null) {
            if (treeNode != null) {
                treeNode.putTreeVal(this, nodeArray, n4, k, object);
            } else {
                nodeArray[n] = this.newNode(n4, k, object, node2);
                if (n3 >= 7) {
                    this.treeifyBin(nodeArray, n4);
                }
            }
            ++this.modCount;
            ++this.size;
            this.afterNodeInsertion(true);
        }
        return object;
    }

    @Override
    public V merge(K k, V v, BiFunction<? super V, ? super V, ? extends V> biFunction) {
        Node<K, V> node;
        int n;
        Node<K, V> node2;
        int n2;
        Node<K, V>[] nodeArray;
        Node node3;
        TreeNode treeNode;
        int n3;
        int n4;
        block18: {
            block17: {
                if (v == null) {
                    throw new NullPointerException();
                }
                if (biFunction == null) {
                    throw new NullPointerException();
                }
                n4 = HashMap.hash(k);
                n3 = 0;
                treeNode = null;
                node3 = null;
                if (this.size > this.threshold) break block17;
                nodeArray = this.table;
                if (this.table != null && (n2 = nodeArray.length) != 0) break block18;
            }
            nodeArray = this.resize();
            n2 = nodeArray.length;
        }
        if ((node2 = nodeArray[n = n2 - 1 & n4]) != null) {
            if (node2 instanceof TreeNode) {
                treeNode = (TreeNode)node2;
                node3 = treeNode.getTreeNode(n4, k);
            } else {
                node = node2;
                do {
                    Object k2;
                    if (node.hash == n4 && ((k2 = node.key) == k || k != null && k.equals(k2))) {
                        node3 = node;
                        break;
                    }
                    ++n3;
                } while ((node = node.next) != null);
            }
        }
        if (node3 != null) {
            node = node3.value != null ? biFunction.apply(node3.value, v) : v;
            if (node != null) {
                node3.value = node;
                this.afterNodeAccess(node3);
            } else {
                this.removeNode(n4, k, null, false, true);
            }
            return (V)node;
        }
        if (v != null) {
            if (treeNode != null) {
                treeNode.putTreeVal(this, nodeArray, n4, k, v);
            } else {
                nodeArray[n] = this.newNode(n4, k, v, node2);
                if (n3 >= 7) {
                    this.treeifyBin(nodeArray, n4);
                }
            }
            ++this.modCount;
            ++this.size;
            this.afterNodeInsertion(true);
        }
        return v;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> biConsumer) {
        if (biConsumer == null) {
            throw new NullPointerException();
        }
        if (this.size > 0) {
            Node<K, V>[] nodeArray = this.table;
            if (this.table != null) {
                int n = this.modCount;
                for (int i = 0; i < nodeArray.length; ++i) {
                    Node<K, V> node = nodeArray[i];
                    while (node != null) {
                        biConsumer.accept(node.key, node.value);
                        node = node.next;
                    }
                }
                if (this.modCount != n) {
                    throw new ConcurrentModificationException();
                }
            }
        }
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> biFunction) {
        if (biFunction == null) {
            throw new NullPointerException();
        }
        if (this.size > 0) {
            Node<K, V>[] nodeArray = this.table;
            if (this.table != null) {
                int n = this.modCount;
                for (int i = 0; i < nodeArray.length; ++i) {
                    Node<K, V> node = nodeArray[i];
                    while (node != null) {
                        node.value = biFunction.apply(node.key, node.value);
                        node = node.next;
                    }
                }
                if (this.modCount != n) {
                    throw new ConcurrentModificationException();
                }
            }
        }
    }

    @Override
    public Object clone() {
        HashMap hashMap;
        try {
            hashMap = (HashMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException);
        }
        hashMap.reinitialize();
        hashMap.putMapEntries(this, false);
        return hashMap;
    }

    final float loadFactor() {
        return this.loadFactor;
    }

    final int capacity() {
        return this.table != null ? this.table.length : (this.threshold > 0 ? this.threshold : 16);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n = this.capacity();
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(n);
        objectOutputStream.writeInt(this.size);
        this.internalWriteEntries(objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        float f = getField.get("loadFactor", 0.75f);
        if (f <= 0.0f || Float.isNaN(f)) {
            throw new InvalidObjectException("Illegal load factor: " + f);
        }
        f = Math.min(Math.max(0.25f, f), 4.0f);
        UnsafeHolder.putLoadFactor(this, f);
        this.reinitialize();
        objectInputStream.readInt();
        int n = objectInputStream.readInt();
        if (n < 0) {
            throw new InvalidObjectException("Illegal mappings count: " + n);
        }
        if (n != 0 && n > 0) {
            float f2 = (float)n / f + 1.0f;
            int n2 = f2 < 16.0f ? 16 : (f2 >= 1.0737418E9f ? 0x40000000 : HashMap.tableSizeFor((int)f2));
            float f3 = (float)n2 * f;
            this.threshold = n2 < 0x40000000 && f3 < 1.0737418E9f ? (int)f3 : Integer.MAX_VALUE;
            SharedSecrets.getJavaOISAccess().checkArray(objectInputStream, Map.Entry[].class, n2);
            Node[] nodeArray = new Node[n2];
            this.table = nodeArray;
            for (int i = 0; i < n; ++i) {
                Object object = objectInputStream.readObject();
                Object object2 = objectInputStream.readObject();
                this.putVal(HashMap.hash(object), object, object2, false, false);
            }
        }
    }

    Node<K, V> newNode(int n, K k, V v, Node<K, V> node) {
        return new Node<K, V>(n, k, v, node);
    }

    Node<K, V> replacementNode(Node<K, V> node, Node<K, V> node2) {
        return new Node(node.hash, node.key, node.value, node2);
    }

    TreeNode<K, V> newTreeNode(int n, K k, V v, Node<K, V> node) {
        return new TreeNode<K, V>(n, k, v, node);
    }

    TreeNode<K, V> replacementTreeNode(Node<K, V> node, Node<K, V> node2) {
        return new TreeNode(node.hash, node.key, node.value, node2);
    }

    void reinitialize() {
        this.table = null;
        this.entrySet = null;
        this.keySet = null;
        this.values = null;
        this.modCount = 0;
        this.threshold = 0;
        this.size = 0;
    }

    void afterNodeAccess(Node<K, V> node) {
    }

    void afterNodeInsertion(boolean bl) {
    }

    void afterNodeRemoval(Node<K, V> node) {
    }

    void internalWriteEntries(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.size > 0) {
            Node<K, V>[] nodeArray = this.table;
            if (this.table != null) {
                for (int i = 0; i < nodeArray.length; ++i) {
                    Node<K, V> node = nodeArray[i];
                    while (node != null) {
                        objectOutputStream.writeObject(node.key);
                        objectOutputStream.writeObject(node.value);
                        node = node.next;
                    }
                }
            }
        }
    }

    static final class TreeNode<K, V>
    extends LinkedHashMap.Entry<K, V> {
        TreeNode<K, V> parent;
        TreeNode<K, V> left;
        TreeNode<K, V> right;
        TreeNode<K, V> prev;
        boolean red;

        TreeNode(int n, K k, V v, Node<K, V> node) {
            super(n, k, v, node);
        }

        final TreeNode<K, V> root() {
            TreeNode<K, V> treeNode = this;
            TreeNode<K, V> treeNode2;
            while ((treeNode2 = treeNode.parent) != null) {
                treeNode = treeNode2;
            }
            return treeNode;
        }

        static <K, V> void moveRootToFront(Node<K, V>[] nodeArray, TreeNode<K, V> treeNode) {
            int n;
            if (treeNode != null && nodeArray != null && (n = nodeArray.length) > 0) {
                int n2 = n - 1 & treeNode.hash;
                TreeNode treeNode2 = (TreeNode)nodeArray[n2];
                if (treeNode != treeNode2) {
                    nodeArray[n2] = treeNode;
                    TreeNode<K, V> treeNode3 = treeNode.prev;
                    Node node = treeNode.next;
                    if (node != null) {
                        ((TreeNode)node).prev = treeNode3;
                    }
                    if (treeNode3 != null) {
                        treeNode3.next = node;
                    }
                    if (treeNode2 != null) {
                        treeNode2.prev = treeNode;
                    }
                    treeNode.next = treeNode2;
                    treeNode.prev = null;
                }
                assert (TreeNode.checkInvariants(treeNode));
            }
        }

        final TreeNode<K, V> find(int n, Object object, Class<?> clazz) {
            TreeNode<K, V> treeNode = this;
            do {
                int n2;
                TreeNode<K, V> treeNode2 = treeNode.left;
                TreeNode<K, V> treeNode3 = treeNode.right;
                int n3 = treeNode.hash;
                if (n3 > n) {
                    treeNode = treeNode2;
                    continue;
                }
                if (n3 < n) {
                    treeNode = treeNode3;
                    continue;
                }
                Object object2 = treeNode.key;
                if (object2 == object || object != null && object.equals(object2)) {
                    return treeNode;
                }
                if (treeNode2 == null) {
                    treeNode = treeNode3;
                    continue;
                }
                if (treeNode3 == null) {
                    treeNode = treeNode2;
                    continue;
                }
                if ((clazz != null || (clazz = HashMap.comparableClassFor(object)) != null) && (n2 = HashMap.compareComparables(clazz, object, object2)) != 0) {
                    treeNode = n2 < 0 ? treeNode2 : treeNode3;
                    continue;
                }
                TreeNode<K, V> treeNode4 = treeNode3.find(n, object, clazz);
                if (treeNode4 != null) {
                    return treeNode4;
                }
                treeNode = treeNode2;
            } while (treeNode != null);
            return null;
        }

        final TreeNode<K, V> getTreeNode(int n, Object object) {
            return (this.parent != null ? this.root() : this).find(n, object, null);
        }

        static int tieBreakOrder(Object object, Object object2) {
            int n;
            if (object == null || object2 == null || (n = object.getClass().getName().compareTo(object2.getClass().getName())) == 0) {
                n = System.identityHashCode(object) <= System.identityHashCode(object2) ? -1 : 1;
            }
            return n;
        }

        final void treeify(Node<K, V>[] nodeArray) {
            TreeNode<K, V> treeNode = null;
            TreeNode<K, V> treeNode2 = this;
            while (treeNode2 != null) {
                TreeNode treeNode3 = (TreeNode)treeNode2.next;
                treeNode2.right = null;
                treeNode2.left = null;
                if (treeNode == null) {
                    treeNode2.parent = null;
                    treeNode2.red = false;
                    treeNode = treeNode2;
                } else {
                    TreeNode<K, V> treeNode4;
                    int n;
                    Object object = treeNode2.key;
                    int n2 = treeNode2.hash;
                    Class<?> clazz = null;
                    TreeNode<K, V> treeNode5 = treeNode;
                    do {
                        Object object2 = treeNode5.key;
                        int n3 = treeNode5.hash;
                        if (n3 > n2) {
                            n = -1;
                        } else if (n3 < n2) {
                            n = 1;
                        } else if (clazz == null && (clazz = HashMap.comparableClassFor(object)) == null || (n = HashMap.compareComparables(clazz, object, object2)) == 0) {
                            n = TreeNode.tieBreakOrder(object, object2);
                        }
                        treeNode4 = treeNode5;
                    } while ((treeNode5 = n <= 0 ? treeNode5.left : treeNode5.right) != null);
                    treeNode2.parent = treeNode4;
                    if (n <= 0) {
                        treeNode4.left = treeNode2;
                    } else {
                        treeNode4.right = treeNode2;
                    }
                    treeNode = TreeNode.balanceInsertion(treeNode, treeNode2);
                }
                treeNode2 = treeNode3;
            }
            TreeNode.moveRootToFront(nodeArray, treeNode);
        }

        final Node<K, V> untreeify(HashMap<K, V> hashMap) {
            Node<K, V> node = null;
            Node<K, V> node2 = null;
            Node node3 = this;
            while (node3 != null) {
                Node<K, V> node4 = hashMap.replacementNode(node3, null);
                if (node2 == null) {
                    node = node4;
                } else {
                    node2.next = node4;
                }
                node2 = node4;
                node3 = node3.next;
            }
            return node;
        }

        final TreeNode<K, V> putTreeVal(HashMap<K, V> hashMap, Node<K, V>[] nodeArray, int n, K k, V v) {
            TreeNode<K, V> treeNode;
            TreeNode<K, V> treeNode2;
            int n2;
            TreeNode<K, V> treeNode3;
            Class<?> clazz = null;
            boolean bl = false;
            TreeNode<K, V> treeNode4 = treeNode3 = this.parent != null ? this.root() : this;
            do {
                int n3;
                if ((n3 = treeNode4.hash) > n) {
                    n2 = -1;
                } else if (n3 < n) {
                    n2 = 1;
                } else {
                    Object object = treeNode4.key;
                    if (object == k || k != null && k.equals(object)) {
                        return treeNode4;
                    }
                    if (clazz == null && (clazz = HashMap.comparableClassFor(k)) == null || (n2 = HashMap.compareComparables(clazz, k, object)) == 0) {
                        if (!bl) {
                            bl = true;
                            treeNode2 = treeNode4.left;
                            if (treeNode2 != null && (treeNode = treeNode2.find(n, k, clazz)) != null || (treeNode2 = treeNode4.right) != null && (treeNode = treeNode2.find(n, k, clazz)) != null) {
                                return treeNode;
                            }
                        }
                        n2 = TreeNode.tieBreakOrder(k, object);
                    }
                }
                treeNode = treeNode4;
            } while ((treeNode4 = n2 <= 0 ? treeNode4.left : treeNode4.right) != null);
            treeNode2 = treeNode.next;
            TreeNode<K, V> treeNode5 = hashMap.newTreeNode(n, k, v, treeNode2);
            if (n2 <= 0) {
                treeNode.left = treeNode5;
            } else {
                treeNode.right = treeNode5;
            }
            treeNode.next = treeNode5;
            treeNode5.prev = treeNode;
            treeNode5.parent = treeNode5.prev;
            if (treeNode2 != null) {
                treeNode2.prev = treeNode5;
            }
            TreeNode.moveRootToFront(nodeArray, TreeNode.balanceInsertion(treeNode3, treeNode5));
            return null;
        }

        final void removeTreeNode(HashMap<K, V> hashMap, Node<K, V>[] nodeArray, boolean bl) {
            TreeNode<K, V> treeNode;
            TreeNode<K, V> treeNode2;
            TreeNode<K, V> treeNode3;
            TreeNode<K, V> treeNode4;
            TreeNode<K, V> treeNode5;
            int n;
            if (nodeArray == null || (n = nodeArray.length) == 0) {
                return;
            }
            int n2 = n - 1 & this.hash;
            TreeNode<K, V> treeNode6 = treeNode5 = (TreeNode<K, V>)nodeArray[n2];
            TreeNode treeNode7 = (TreeNode)this.next;
            TreeNode<K, V> treeNode8 = this.prev;
            if (treeNode8 == null) {
                treeNode5 = treeNode7;
                nodeArray[n2] = treeNode5;
            } else {
                treeNode8.next = treeNode7;
            }
            if (treeNode7 != null) {
                treeNode7.prev = treeNode8;
            }
            if (treeNode5 == null) {
                return;
            }
            if (treeNode6.parent != null) {
                treeNode6 = treeNode6.root();
            }
            if (treeNode6 == null || bl && (treeNode6.right == null || (treeNode4 = treeNode6.left) == null || treeNode4.left == null)) {
                nodeArray[n2] = treeNode5.untreeify(hashMap);
                return;
            }
            TreeNode<K, V> treeNode9 = this;
            TreeNode<K, V> treeNode10 = this.left;
            TreeNode<K, V> treeNode11 = this.right;
            if (treeNode10 != null && treeNode11 != null) {
                treeNode3 = treeNode11;
                while ((treeNode2 = treeNode3.left) != null) {
                    treeNode3 = treeNode2;
                }
                boolean bl2 = treeNode3.red;
                treeNode3.red = treeNode9.red;
                treeNode9.red = bl2;
                TreeNode<K, V> treeNode12 = treeNode3.right;
                TreeNode<K, V> treeNode13 = treeNode9.parent;
                if (treeNode3 == treeNode11) {
                    treeNode9.parent = treeNode3;
                    treeNode3.right = treeNode9;
                } else {
                    TreeNode<K, V> treeNode14 = treeNode3.parent;
                    treeNode9.parent = treeNode14;
                    if (treeNode9.parent != null) {
                        if (treeNode3 == treeNode14.left) {
                            treeNode14.left = treeNode9;
                        } else {
                            treeNode14.right = treeNode9;
                        }
                    }
                    if ((treeNode3.right = treeNode11) != null) {
                        treeNode11.parent = treeNode3;
                    }
                }
                treeNode9.left = null;
                treeNode9.right = treeNode12;
                if (treeNode9.right != null) {
                    treeNode12.parent = treeNode9;
                }
                if ((treeNode3.left = treeNode10) != null) {
                    treeNode10.parent = treeNode3;
                }
                if ((treeNode3.parent = treeNode13) == null) {
                    treeNode6 = treeNode3;
                } else if (treeNode9 == treeNode13.left) {
                    treeNode13.left = treeNode3;
                } else {
                    treeNode13.right = treeNode3;
                }
                treeNode = treeNode12 != null ? treeNode12 : treeNode9;
            } else {
                treeNode = treeNode10 != null ? treeNode10 : (treeNode11 != null ? treeNode11 : treeNode9);
            }
            if (treeNode != treeNode9) {
                treeNode.parent = treeNode9.parent;
                treeNode3 = treeNode.parent;
                if (treeNode3 == null) {
                    treeNode6 = treeNode;
                    treeNode.red = false;
                } else if (treeNode9 == treeNode3.left) {
                    treeNode3.left = treeNode;
                } else {
                    treeNode3.right = treeNode;
                }
                treeNode9.parent = null;
                treeNode9.right = null;
                treeNode9.left = null;
            }
            TreeNode<K, V> treeNode15 = treeNode3 = treeNode9.red ? treeNode6 : TreeNode.balanceDeletion(treeNode6, treeNode);
            if (treeNode == treeNode9) {
                treeNode2 = treeNode9.parent;
                treeNode9.parent = null;
                if (treeNode2 != null) {
                    if (treeNode9 == treeNode2.left) {
                        treeNode2.left = null;
                    } else if (treeNode9 == treeNode2.right) {
                        treeNode2.right = null;
                    }
                }
            }
            if (bl) {
                TreeNode.moveRootToFront(nodeArray, treeNode3);
            }
        }

        final void split(HashMap<K, V> hashMap, Node<K, V>[] nodeArray, int n, int n2) {
            TreeNode treeNode = this;
            TreeNode treeNode2 = null;
            TreeNode treeNode3 = null;
            TreeNode treeNode4 = null;
            TreeNode treeNode5 = null;
            int n3 = 0;
            int n4 = 0;
            TreeNode treeNode6 = treeNode;
            while (treeNode6 != null) {
                TreeNode treeNode7 = (TreeNode)treeNode6.next;
                treeNode6.next = null;
                if ((treeNode6.hash & n2) == 0) {
                    treeNode6.prev = treeNode3;
                    if (treeNode6.prev == null) {
                        treeNode2 = treeNode6;
                    } else {
                        treeNode3.next = treeNode6;
                    }
                    treeNode3 = treeNode6;
                    ++n3;
                } else {
                    treeNode6.prev = treeNode5;
                    if (treeNode6.prev == null) {
                        treeNode4 = treeNode6;
                    } else {
                        treeNode5.next = treeNode6;
                    }
                    treeNode5 = treeNode6;
                    ++n4;
                }
                treeNode6 = treeNode7;
            }
            if (treeNode2 != null) {
                if (n3 <= 6) {
                    nodeArray[n] = treeNode2.untreeify(hashMap);
                } else {
                    nodeArray[n] = treeNode2;
                    if (treeNode4 != null) {
                        treeNode2.treeify(nodeArray);
                    }
                }
            }
            if (treeNode4 != null) {
                if (n4 <= 6) {
                    nodeArray[n + n2] = treeNode4.untreeify(hashMap);
                } else {
                    nodeArray[n + n2] = treeNode4;
                    if (treeNode2 != null) {
                        treeNode4.treeify(nodeArray);
                    }
                }
            }
        }

        static <K, V> TreeNode<K, V> rotateLeft(TreeNode<K, V> treeNode, TreeNode<K, V> treeNode2) {
            TreeNode<K, V> treeNode3;
            if (treeNode2 != null && (treeNode3 = treeNode2.right) != null) {
                treeNode2.right = treeNode3.left;
                TreeNode<K, V> treeNode4 = treeNode2.right;
                if (treeNode2.right != null) {
                    treeNode4.parent = treeNode2;
                }
                TreeNode<K, V> treeNode5 = treeNode3.parent = treeNode2.parent;
                if (treeNode3.parent == null) {
                    treeNode = treeNode3;
                    treeNode3.red = false;
                } else if (treeNode5.left == treeNode2) {
                    treeNode5.left = treeNode3;
                } else {
                    treeNode5.right = treeNode3;
                }
                treeNode3.left = treeNode2;
                treeNode2.parent = treeNode3;
            }
            return treeNode;
        }

        static <K, V> TreeNode<K, V> rotateRight(TreeNode<K, V> treeNode, TreeNode<K, V> treeNode2) {
            TreeNode<K, V> treeNode3;
            if (treeNode2 != null && (treeNode3 = treeNode2.left) != null) {
                treeNode2.left = treeNode3.right;
                TreeNode<K, V> treeNode4 = treeNode2.left;
                if (treeNode2.left != null) {
                    treeNode4.parent = treeNode2;
                }
                TreeNode<K, V> treeNode5 = treeNode3.parent = treeNode2.parent;
                if (treeNode3.parent == null) {
                    treeNode = treeNode3;
                    treeNode3.red = false;
                } else if (treeNode5.right == treeNode2) {
                    treeNode5.right = treeNode3;
                } else {
                    treeNode5.left = treeNode3;
                }
                treeNode3.right = treeNode2;
                treeNode2.parent = treeNode3;
            }
            return treeNode;
        }

        static <K, V> TreeNode<K, V> balanceInsertion(TreeNode<K, V> treeNode, TreeNode<K, V> treeNode2) {
            treeNode2.red = true;
            while (true) {
                TreeNode<K, V> treeNode3;
                TreeNode<K, V> treeNode4;
                if ((treeNode4 = treeNode2.parent) == null) {
                    treeNode2.red = false;
                    return treeNode2;
                }
                if (!treeNode4.red || (treeNode3 = treeNode4.parent) == null) {
                    return treeNode;
                }
                TreeNode<K, V> treeNode5 = treeNode3.left;
                if (treeNode4 == treeNode5) {
                    TreeNode<K, V> treeNode6 = treeNode3.right;
                    if (treeNode6 != null && treeNode6.red) {
                        treeNode6.red = false;
                        treeNode4.red = false;
                        treeNode3.red = true;
                        treeNode2 = treeNode3;
                        continue;
                    }
                    if (treeNode2 == treeNode4.right) {
                        treeNode2 = treeNode4;
                        treeNode = TreeNode.rotateLeft(treeNode, treeNode2);
                        treeNode4 = treeNode2.parent;
                        TreeNode<K, V> treeNode7 = treeNode3 = treeNode4 == null ? null : treeNode4.parent;
                    }
                    if (treeNode4 == null) continue;
                    treeNode4.red = false;
                    if (treeNode3 == null) continue;
                    treeNode3.red = true;
                    treeNode = TreeNode.rotateRight(treeNode, treeNode3);
                    continue;
                }
                if (treeNode5 != null && treeNode5.red) {
                    treeNode5.red = false;
                    treeNode4.red = false;
                    treeNode3.red = true;
                    treeNode2 = treeNode3;
                    continue;
                }
                if (treeNode2 == treeNode4.left) {
                    treeNode2 = treeNode4;
                    treeNode = TreeNode.rotateRight(treeNode, treeNode2);
                    treeNode4 = treeNode2.parent;
                    TreeNode<K, V> treeNode8 = treeNode3 = treeNode4 == null ? null : treeNode4.parent;
                }
                if (treeNode4 == null) continue;
                treeNode4.red = false;
                if (treeNode3 == null) continue;
                treeNode3.red = true;
                treeNode = TreeNode.rotateLeft(treeNode, treeNode3);
            }
        }

        static <K, V> TreeNode<K, V> balanceDeletion(TreeNode<K, V> treeNode, TreeNode<K, V> treeNode2) {
            while (treeNode2 != null && treeNode2 != treeNode) {
                TreeNode<K, V> treeNode3;
                TreeNode<K, V> treeNode4;
                TreeNode<K, V> treeNode5 = treeNode2.parent;
                if (treeNode5 == null) {
                    treeNode2.red = false;
                    return treeNode2;
                }
                if (treeNode2.red) {
                    treeNode2.red = false;
                    return treeNode;
                }
                TreeNode<K, V> treeNode6 = treeNode5.left;
                if (treeNode6 == treeNode2) {
                    TreeNode<K, V> treeNode7 = treeNode5.right;
                    if (treeNode7 != null && treeNode7.red) {
                        treeNode7.red = false;
                        treeNode5.red = true;
                        treeNode = TreeNode.rotateLeft(treeNode, treeNode5);
                        treeNode5 = treeNode2.parent;
                        TreeNode<K, V> treeNode8 = treeNode7 = treeNode5 == null ? null : treeNode5.right;
                    }
                    if (treeNode7 == null) {
                        treeNode2 = treeNode5;
                        continue;
                    }
                    treeNode4 = treeNode7.left;
                    treeNode3 = treeNode7.right;
                    if (!(treeNode3 != null && treeNode3.red || treeNode4 != null && treeNode4.red)) {
                        treeNode7.red = true;
                        treeNode2 = treeNode5;
                        continue;
                    }
                    if (treeNode3 == null || !treeNode3.red) {
                        if (treeNode4 != null) {
                            treeNode4.red = false;
                        }
                        treeNode7.red = true;
                        treeNode = TreeNode.rotateRight(treeNode, treeNode7);
                        treeNode5 = treeNode2.parent;
                        TreeNode<K, V> treeNode9 = treeNode7 = treeNode5 == null ? null : treeNode5.right;
                    }
                    if (treeNode7 != null) {
                        treeNode7.red = treeNode5 == null ? false : treeNode5.red;
                        treeNode3 = treeNode7.right;
                        if (treeNode3 != null) {
                            treeNode3.red = false;
                        }
                    }
                    if (treeNode5 != null) {
                        treeNode5.red = false;
                        treeNode = TreeNode.rotateLeft(treeNode, treeNode5);
                    }
                    treeNode2 = treeNode;
                    continue;
                }
                if (treeNode6 != null && treeNode6.red) {
                    treeNode6.red = false;
                    treeNode5.red = true;
                    treeNode = TreeNode.rotateRight(treeNode, treeNode5);
                    treeNode5 = treeNode2.parent;
                    TreeNode<K, V> treeNode10 = treeNode6 = treeNode5 == null ? null : treeNode5.left;
                }
                if (treeNode6 == null) {
                    treeNode2 = treeNode5;
                    continue;
                }
                treeNode4 = treeNode6.left;
                treeNode3 = treeNode6.right;
                if (!(treeNode4 != null && treeNode4.red || treeNode3 != null && treeNode3.red)) {
                    treeNode6.red = true;
                    treeNode2 = treeNode5;
                    continue;
                }
                if (treeNode4 == null || !treeNode4.red) {
                    if (treeNode3 != null) {
                        treeNode3.red = false;
                    }
                    treeNode6.red = true;
                    treeNode = TreeNode.rotateLeft(treeNode, treeNode6);
                    treeNode5 = treeNode2.parent;
                    TreeNode<K, V> treeNode11 = treeNode6 = treeNode5 == null ? null : treeNode5.left;
                }
                if (treeNode6 != null) {
                    treeNode6.red = treeNode5 == null ? false : treeNode5.red;
                    treeNode4 = treeNode6.left;
                    if (treeNode4 != null) {
                        treeNode4.red = false;
                    }
                }
                if (treeNode5 != null) {
                    treeNode5.red = false;
                    treeNode = TreeNode.rotateRight(treeNode, treeNode5);
                }
                treeNode2 = treeNode;
            }
            return treeNode;
        }

        static <K, V> boolean checkInvariants(TreeNode<K, V> treeNode) {
            TreeNode<K, V> treeNode2 = treeNode.parent;
            TreeNode<K, V> treeNode3 = treeNode.left;
            TreeNode<K, V> treeNode4 = treeNode.right;
            TreeNode<K, V> treeNode5 = treeNode.prev;
            TreeNode treeNode6 = (TreeNode)treeNode.next;
            if (treeNode5 != null && treeNode5.next != treeNode) {
                return false;
            }
            if (treeNode6 != null && treeNode6.prev != treeNode) {
                return false;
            }
            if (treeNode2 != null && treeNode != treeNode2.left && treeNode != treeNode2.right) {
                return false;
            }
            if (treeNode3 != null && (treeNode3.parent != treeNode || treeNode3.hash > treeNode.hash)) {
                return false;
            }
            if (treeNode4 != null && (treeNode4.parent != treeNode || treeNode4.hash < treeNode.hash)) {
                return false;
            }
            if (treeNode.red && treeNode3 != null && treeNode3.red && treeNode4 != null && treeNode4.red) {
                return false;
            }
            if (treeNode3 != null && !TreeNode.checkInvariants(treeNode3)) {
                return false;
            }
            return treeNode4 == null || TreeNode.checkInvariants(treeNode4);
        }
    }

    static final class EntrySpliterator<K, V>
    extends HashMapSpliterator<K, V>
    implements Spliterator<Map.Entry<K, V>> {
        EntrySpliterator(HashMap<K, V> hashMap, int n, int n2, int n3, int n4) {
            super(hashMap, n, n2, n3, n4);
        }

        public EntrySpliterator<K, V> trySplit() {
            EntrySpliterator<K, V> entrySpliterator;
            int n = this.index;
            int n2 = this.getFence();
            int n3 = n + n2 >>> 1;
            if (n >= n3 || this.current != null) {
                entrySpliterator = null;
            } else {
                this.index = n3;
                EntrySpliterator<K, V> entrySpliterator2 = new EntrySpliterator<K, V>(this.map, n, this.index, this.est >>>= 1, this.expectedModCount);
                entrySpliterator = entrySpliterator2;
            }
            return entrySpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super Map.Entry<K, V>> consumer) {
            int n;
            int n2;
            if (consumer == null) {
                throw new NullPointerException();
            }
            HashMap hashMap = this.map;
            Node<K, V>[] nodeArray = hashMap.table;
            int n3 = this.fence;
            if (n3 < 0) {
                n2 = this.expectedModCount = hashMap.modCount;
                this.fence = nodeArray == null ? 0 : nodeArray.length;
                n3 = this.fence;
            } else {
                n2 = this.expectedModCount;
            }
            if (nodeArray != null && nodeArray.length >= n3 && (n = this.index) >= 0 && (n < (this.index = n3) || this.current != null)) {
                Node node = this.current;
                this.current = null;
                do {
                    if (node == null) {
                        node = nodeArray[n++];
                        continue;
                    }
                    consumer.accept(node);
                    node = node.next;
                } while (node != null || n < n3);
                if (hashMap.modCount != n2) {
                    throw new ConcurrentModificationException();
                }
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super Map.Entry<K, V>> consumer) {
            int n;
            if (consumer == null) {
                throw new NullPointerException();
            }
            Node<K, V>[] nodeArray = this.map.table;
            if (nodeArray != null && nodeArray.length >= (n = this.getFence()) && this.index >= 0) {
                while (this.current != null || this.index < n) {
                    if (this.current == null) {
                        this.current = nodeArray[this.index++];
                        continue;
                    }
                    Node node = this.current;
                    this.current = this.current.next;
                    consumer.accept(node);
                    if (this.map.modCount != this.expectedModCount) {
                        throw new ConcurrentModificationException();
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        public int characteristics() {
            return (this.fence < 0 || this.est == this.map.size ? 64 : 0) | 1;
        }
    }

    static final class ValueSpliterator<K, V>
    extends HashMapSpliterator<K, V>
    implements Spliterator<V> {
        ValueSpliterator(HashMap<K, V> hashMap, int n, int n2, int n3, int n4) {
            super(hashMap, n, n2, n3, n4);
        }

        public ValueSpliterator<K, V> trySplit() {
            ValueSpliterator<K, V> valueSpliterator;
            int n = this.index;
            int n2 = this.getFence();
            int n3 = n + n2 >>> 1;
            if (n >= n3 || this.current != null) {
                valueSpliterator = null;
            } else {
                this.index = n3;
                ValueSpliterator<K, V> valueSpliterator2 = new ValueSpliterator<K, V>(this.map, n, this.index, this.est >>>= 1, this.expectedModCount);
                valueSpliterator = valueSpliterator2;
            }
            return valueSpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super V> consumer) {
            int n;
            int n2;
            if (consumer == null) {
                throw new NullPointerException();
            }
            HashMap hashMap = this.map;
            Node<K, V>[] nodeArray = hashMap.table;
            int n3 = this.fence;
            if (n3 < 0) {
                n2 = this.expectedModCount = hashMap.modCount;
                this.fence = nodeArray == null ? 0 : nodeArray.length;
                n3 = this.fence;
            } else {
                n2 = this.expectedModCount;
            }
            if (nodeArray != null && nodeArray.length >= n3 && (n = this.index) >= 0 && (n < (this.index = n3) || this.current != null)) {
                Node node = this.current;
                this.current = null;
                do {
                    if (node == null) {
                        node = nodeArray[n++];
                        continue;
                    }
                    consumer.accept(node.value);
                    node = node.next;
                } while (node != null || n < n3);
                if (hashMap.modCount != n2) {
                    throw new ConcurrentModificationException();
                }
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super V> consumer) {
            int n;
            if (consumer == null) {
                throw new NullPointerException();
            }
            Node<K, V>[] nodeArray = this.map.table;
            if (nodeArray != null && nodeArray.length >= (n = this.getFence()) && this.index >= 0) {
                while (this.current != null || this.index < n) {
                    if (this.current == null) {
                        this.current = nodeArray[this.index++];
                        continue;
                    }
                    Object v = this.current.value;
                    this.current = this.current.next;
                    consumer.accept(v);
                    if (this.map.modCount != this.expectedModCount) {
                        throw new ConcurrentModificationException();
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        public int characteristics() {
            return this.fence < 0 || this.est == this.map.size ? 64 : 0;
        }
    }

    static final class KeySpliterator<K, V>
    extends HashMapSpliterator<K, V>
    implements Spliterator<K> {
        KeySpliterator(HashMap<K, V> hashMap, int n, int n2, int n3, int n4) {
            super(hashMap, n, n2, n3, n4);
        }

        public KeySpliterator<K, V> trySplit() {
            KeySpliterator<K, V> keySpliterator;
            int n = this.index;
            int n2 = this.getFence();
            int n3 = n + n2 >>> 1;
            if (n >= n3 || this.current != null) {
                keySpliterator = null;
            } else {
                this.index = n3;
                KeySpliterator<K, V> keySpliterator2 = new KeySpliterator<K, V>(this.map, n, this.index, this.est >>>= 1, this.expectedModCount);
                keySpliterator = keySpliterator2;
            }
            return keySpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super K> consumer) {
            int n;
            int n2;
            if (consumer == null) {
                throw new NullPointerException();
            }
            HashMap hashMap = this.map;
            Node<K, V>[] nodeArray = hashMap.table;
            int n3 = this.fence;
            if (n3 < 0) {
                n2 = this.expectedModCount = hashMap.modCount;
                this.fence = nodeArray == null ? 0 : nodeArray.length;
                n3 = this.fence;
            } else {
                n2 = this.expectedModCount;
            }
            if (nodeArray != null && nodeArray.length >= n3 && (n = this.index) >= 0 && (n < (this.index = n3) || this.current != null)) {
                Node node = this.current;
                this.current = null;
                do {
                    if (node == null) {
                        node = nodeArray[n++];
                        continue;
                    }
                    consumer.accept(node.key);
                    node = node.next;
                } while (node != null || n < n3);
                if (hashMap.modCount != n2) {
                    throw new ConcurrentModificationException();
                }
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super K> consumer) {
            int n;
            if (consumer == null) {
                throw new NullPointerException();
            }
            Node<K, V>[] nodeArray = this.map.table;
            if (nodeArray != null && nodeArray.length >= (n = this.getFence()) && this.index >= 0) {
                while (this.current != null || this.index < n) {
                    if (this.current == null) {
                        this.current = nodeArray[this.index++];
                        continue;
                    }
                    Object k = this.current.key;
                    this.current = this.current.next;
                    consumer.accept(k);
                    if (this.map.modCount != this.expectedModCount) {
                        throw new ConcurrentModificationException();
                    }
                    return true;
                }
            }
            return false;
        }

        @Override
        public int characteristics() {
            return (this.fence < 0 || this.est == this.map.size ? 64 : 0) | 1;
        }
    }

    static class HashMapSpliterator<K, V> {
        final HashMap<K, V> map;
        Node<K, V> current;
        int index;
        int fence;
        int est;
        int expectedModCount;

        HashMapSpliterator(HashMap<K, V> hashMap, int n, int n2, int n3, int n4) {
            this.map = hashMap;
            this.index = n;
            this.fence = n2;
            this.est = n3;
            this.expectedModCount = n4;
        }

        final int getFence() {
            int n = this.fence;
            if (n < 0) {
                HashMap<K, V> hashMap = this.map;
                this.est = hashMap.size;
                this.expectedModCount = hashMap.modCount;
                Node<K, V>[] nodeArray = hashMap.table;
                this.fence = nodeArray == null ? 0 : nodeArray.length;
                n = this.fence;
            }
            return n;
        }

        public final long estimateSize() {
            this.getFence();
            return this.est;
        }
    }

    final class EntryIterator
    extends HashIterator
    implements Iterator<Map.Entry<K, V>> {
        EntryIterator() {
        }

        @Override
        public final Map.Entry<K, V> next() {
            return this.nextNode();
        }
    }

    final class ValueIterator
    extends HashIterator
    implements Iterator<V> {
        ValueIterator() {
        }

        @Override
        public final V next() {
            return this.nextNode().value;
        }
    }

    final class KeyIterator
    extends HashIterator
    implements Iterator<K> {
        KeyIterator() {
        }

        @Override
        public final K next() {
            return this.nextNode().key;
        }
    }

    abstract class HashIterator {
        Node<K, V> next;
        Node<K, V> current;
        int expectedModCount;
        int index;

        HashIterator() {
            this.expectedModCount = HashMap.this.modCount;
            Node<K, V>[] nodeArray = HashMap.this.table;
            this.next = null;
            this.current = null;
            this.index = 0;
            if (nodeArray != null && HashMap.this.size > 0) {
                while (this.index < nodeArray.length && (this.next = nodeArray[this.index++]) == null) {
                }
            }
        }

        public final boolean hasNext() {
            return this.next != null;
        }

        final Node<K, V> nextNode() {
            Node node = this.next;
            if (HashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (node == null) {
                throw new NoSuchElementException();
            }
            this.current = node;
            this.next = this.current.next;
            if (this.next == null) {
                Node<K, V>[] nodeArray = HashMap.this.table;
                if (HashMap.this.table != null) {
                    while (this.index < nodeArray.length && (this.next = nodeArray[this.index++]) == null) {
                    }
                }
            }
            return node;
        }

        public final void remove() {
            Node node = this.current;
            if (node == null) {
                throw new IllegalStateException();
            }
            if (HashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.current = null;
            Object k = node.key;
            HashMap.this.removeNode(HashMap.hash(k), k, null, false, false);
            this.expectedModCount = HashMap.this.modCount;
        }
    }

    private static final class UnsafeHolder {
        private static final Unsafe unsafe = Unsafe.getUnsafe();
        private static final long LF_OFFSET;

        private UnsafeHolder() {
            throw new InternalError();
        }

        static void putLoadFactor(HashMap<?, ?> hashMap, float f) {
            unsafe.putFloat(hashMap, LF_OFFSET, f);
        }

        static {
            try {
                LF_OFFSET = unsafe.objectFieldOffset(HashMap.class.getDeclaredField("loadFactor"));
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new InternalError();
            }
        }
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public final int size() {
            return HashMap.this.size;
        }

        @Override
        public final void clear() {
            HashMap.this.clear();
        }

        @Override
        public final Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public final boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object k = entry.getKey();
            Node node = HashMap.this.getNode(HashMap.hash(k), k);
            return node != null && node.equals(entry);
        }

        @Override
        public final boolean remove(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                Object k = entry.getKey();
                Object v = entry.getValue();
                return HashMap.this.removeNode(HashMap.hash(k), k, v, true, true) != null;
            }
            return false;
        }

        @Override
        public final Spliterator<Map.Entry<K, V>> spliterator() {
            return new EntrySpliterator(HashMap.this, 0, -1, 0, 0);
        }

        @Override
        public final void forEach(Consumer<? super Map.Entry<K, V>> consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            if (HashMap.this.size > 0) {
                Node<K, V>[] nodeArray = HashMap.this.table;
                if (HashMap.this.table != null) {
                    int n = HashMap.this.modCount;
                    for (int i = 0; i < nodeArray.length; ++i) {
                        Node node = nodeArray[i];
                        while (node != null) {
                            consumer.accept(node);
                            node = node.next;
                        }
                    }
                    if (HashMap.this.modCount != n) {
                        throw new ConcurrentModificationException();
                    }
                }
            }
        }
    }

    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public final int size() {
            return HashMap.this.size;
        }

        @Override
        public final void clear() {
            HashMap.this.clear();
        }

        @Override
        public final Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public final boolean contains(Object object) {
            return HashMap.this.containsValue(object);
        }

        @Override
        public final Spliterator<V> spliterator() {
            return new ValueSpliterator(HashMap.this, 0, -1, 0, 0);
        }

        @Override
        public final void forEach(Consumer<? super V> consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            if (HashMap.this.size > 0) {
                Node<K, V>[] nodeArray = HashMap.this.table;
                if (HashMap.this.table != null) {
                    int n = HashMap.this.modCount;
                    for (int i = 0; i < nodeArray.length; ++i) {
                        Node node = nodeArray[i];
                        while (node != null) {
                            consumer.accept(node.value);
                            node = node.next;
                        }
                    }
                    if (HashMap.this.modCount != n) {
                        throw new ConcurrentModificationException();
                    }
                }
            }
        }
    }

    final class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public final int size() {
            return HashMap.this.size;
        }

        @Override
        public final void clear() {
            HashMap.this.clear();
        }

        @Override
        public final Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public final boolean contains(Object object) {
            return HashMap.this.containsKey(object);
        }

        @Override
        public final boolean remove(Object object) {
            return HashMap.this.removeNode(HashMap.hash(object), object, null, false, true) != null;
        }

        @Override
        public final Spliterator<K> spliterator() {
            return new KeySpliterator(HashMap.this, 0, -1, 0, 0);
        }

        @Override
        public final void forEach(Consumer<? super K> consumer) {
            if (consumer == null) {
                throw new NullPointerException();
            }
            if (HashMap.this.size > 0) {
                Node<K, V>[] nodeArray = HashMap.this.table;
                if (HashMap.this.table != null) {
                    int n = HashMap.this.modCount;
                    for (int i = 0; i < nodeArray.length; ++i) {
                        Node node = nodeArray[i];
                        while (node != null) {
                            consumer.accept(node.key);
                            node = node.next;
                        }
                    }
                    if (HashMap.this.modCount != n) {
                        throw new ConcurrentModificationException();
                    }
                }
            }
        }
    }

    static class Node<K, V>
    implements Map.Entry<K, V> {
        final int hash;
        final K key;
        V value;
        Node<K, V> next;

        Node(int n, K k, V v, Node<K, V> node) {
            this.hash = n;
            this.key = k;
            this.value = v;
            this.next = node;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        public final String toString() {
            return this.key + "=" + this.value;
        }

        @Override
        public final int hashCode() {
            return Objects.hashCode(this.key) ^ Objects.hashCode(this.value);
        }

        @Override
        public final V setValue(V v) {
            V v2 = this.value;
            this.value = v;
            return v2;
        }

        @Override
        public final boolean equals(Object object) {
            Map.Entry entry;
            if (object == this) {
                return true;
            }
            return object instanceof Map.Entry && Objects.equals(this.key, (entry = (Map.Entry)object).getKey()) && Objects.equals(this.value, entry.getValue());
        }
    }
}

