/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap.sasl;

import com.sun.jndi.ldap.Connection;
import com.sun.jndi.ldap.LdapClient;
import com.sun.jndi.ldap.LdapResult;
import com.sun.jndi.ldap.sasl.DefaultCallbackHandler;
import com.sun.jndi.ldap.sasl.SaslInputStream;
import com.sun.jndi.ldap.sasl.SaslOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.AuthenticationException;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.NamingException;
import javax.naming.ldap.Control;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

public final class LdapSasl {
    private static final String SASL_CALLBACK = "java.naming.security.sasl.callback";
    private static final String SASL_AUTHZ_ID = "java.naming.security.sasl.authorizationId";
    private static final String SASL_REALM = "java.naming.security.sasl.realm";
    private static final int LDAP_SUCCESS = 0;
    private static final int LDAP_SASL_BIND_IN_PROGRESS = 14;
    private static final byte[] NO_BYTES = new byte[0];

    private LdapSasl() {
    }

    public static LdapResult saslBind(LdapClient ldapClient, Connection connection, String string, String string2, Object object, String string3, Hashtable<?, ?> hashtable, Control[] controlArray) throws IOException, NamingException {
        CallbackHandler callbackHandler;
        SaslClient saslClient = null;
        boolean bl = false;
        CallbackHandler callbackHandler2 = callbackHandler = hashtable != null ? (CallbackHandler)hashtable.get(SASL_CALLBACK) : null;
        if (callbackHandler == null) {
            callbackHandler = new DefaultCallbackHandler(string2, object, (String)hashtable.get(SASL_REALM));
            bl = true;
        }
        String string4 = hashtable != null ? (String)hashtable.get(SASL_AUTHZ_ID) : null;
        String[] stringArray = LdapSasl.getSaslMechanismNames(string3);
        try {
            Object object2;
            saslClient = Sasl.createSaslClient(stringArray, string4, "ldap", string, hashtable, callbackHandler);
            if (saslClient == null) {
                throw new AuthenticationNotSupportedException(string3);
            }
            String string5 = saslClient.getMechanismName();
            byte[] byArray = saslClient.hasInitialResponse() ? saslClient.evaluateChallenge(NO_BYTES) : null;
            LdapResult ldapResult = ldapClient.ldapBind(null, byArray, controlArray, string5, true);
            while (!(saslClient.isComplete() || ldapResult.status != 14 && ldapResult.status != 0)) {
                byArray = saslClient.evaluateChallenge(ldapResult.serverCreds != null ? ldapResult.serverCreds : NO_BYTES);
                if (ldapResult.status == 0) {
                    if (byArray == null) break;
                    throw new AuthenticationException("SASL client generated response after success");
                }
                ldapResult = ldapClient.ldapBind(null, byArray, controlArray, string5, true);
            }
            if (ldapResult.status == 0) {
                if (!saslClient.isComplete()) {
                    throw new AuthenticationException("SASL authentication not complete despite server claims");
                }
                object2 = (String)saslClient.getNegotiatedProperty("javax.security.sasl.qop");
                if (object2 != null && (((String)object2).equalsIgnoreCase("auth-int") || ((String)object2).equalsIgnoreCase("auth-conf"))) {
                    SaslInputStream saslInputStream = new SaslInputStream(saslClient, connection.inStream);
                    SaslOutputStream saslOutputStream = new SaslOutputStream(saslClient, connection.outStream);
                    connection.replaceStreams(saslInputStream, saslOutputStream);
                } else {
                    saslClient.dispose();
                }
            }
            object2 = ldapResult;
            return object2;
        }
        catch (SaslException saslException) {
            AuthenticationException authenticationException = new AuthenticationException(string3);
            authenticationException.setRootCause(saslException);
            throw authenticationException;
        }
        finally {
            if (bl) {
                ((DefaultCallbackHandler)callbackHandler).clearPassword();
            }
        }
    }

    private static String[] getSaslMechanismNames(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        Vector<String> vector = new Vector<String>(10);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }
}

