/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.security.timestamp;

import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.Date;
import jdk.test.lib.security.timestamp.TsaParam;

public interface RespInterceptor {
    default public X509Certificate[] getSignerCertChain(X509Certificate[] signerCertChain, boolean certReq) throws Exception {
        return certReq ? signerCertChain : new X509Certificate[]{};
    }

    default public String getSigAlgo(String sigAlgo) throws Exception {
        return sigAlgo;
    }

    default public TsaParam getRespParam(TsaParam reqParam) {
        TsaParam respParam = TsaParam.newInstance();
        respParam.version(1);
        respParam.status(0);
        respParam.policyId(reqParam.policyId() == null ? "2.3.4" : reqParam.policyId());
        respParam.digestAlgo(reqParam.digestAlgo());
        respParam.hashedMessage(reqParam.hashedMessage());
        respParam.serialNumber(BigInteger.ONE);
        respParam.genTime(Date.from(Instant.now()));
        respParam.nonce(reqParam.nonce());
        return respParam;
    }
}

