/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.net;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.StringTokenizer;
import java.util.function.Supplier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class SimpleSSLContext {
    SSLContext ssl;

    public SimpleSSLContext() throws IOException {
        this(() -> "TLS");
    }

    private SimpleSSLContext(Supplier<String> protocols) throws IOException {
        String proto = protocols.get();
        String paths = System.getProperty("test.src.path");
        StringTokenizer st = new StringTokenizer(paths, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String path = st.nextToken();
            File f = new File(path, "jdk/test/lib/net/testkeys");
            if (!f.exists()) continue;
            try (FileInputStream fis = new FileInputStream(f);){
                this.init(fis, proto);
                break;
            }
        }
    }

    public SimpleSSLContext(String dir) throws IOException {
        String file = dir + "/testkeys";
        try (FileInputStream fis = new FileInputStream(file);){
            this.init(fis, "TLS");
        }
    }

    private void init(InputStream i, String protocol) throws IOException {
        try {
            char[] passphrase = "passphrase".toCharArray();
            KeyStore ks = KeyStore.getInstance("PKCS12");
            ks.load(i, passphrase);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("PKIX");
            kmf.init(ks, passphrase);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("PKIX");
            tmf.init(ks);
            this.ssl = SSLContext.getInstance(protocol);
            this.ssl.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static SSLContext getContext(String protocol) throws IOException {
        if (protocol == null || protocol.isEmpty()) {
            return new SimpleSSLContext().get();
        }
        return new SimpleSSLContext(() -> protocol).get();
    }

    public SSLContext get() {
        return this.ssl;
    }
}

