/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.security;

import java.security.SecureRandom;
import java.util.Random;

public class SeededSecureRandom
extends SecureRandom {
    private static final long serialVersionUID = 4657031557630518194L;
    private final Random rnd;

    public static long seed() {
        String value = System.getProperty("secure.random.seed");
        long seed = value != null ? Long.parseLong(value) : new Random().nextLong();
        System.out.println("SeededSecureRandom: seed = " + seed);
        return seed;
    }

    public SeededSecureRandom(long seed) {
        this.rnd = new Random(seed);
    }

    public static SeededSecureRandom one() {
        return new SeededSecureRandom(SeededSecureRandom.seed());
    }

    @Override
    public void nextBytes(byte[] bytes) {
        this.rnd.nextBytes(bytes);
    }

    @Override
    public byte[] generateSeed(int numBytes) {
        byte[] out = new byte[numBytes];
        this.rnd.nextBytes(out);
        return out;
    }

    public byte[] nBytes(int n) {
        byte[] out = new byte[n];
        this.nextBytes(out);
        return out;
    }
}

