/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.dcmd;

import java.util.List;
import jdk.test.lib.JDKToolFinder;
import jdk.test.lib.dcmd.CommandExecutor;
import jdk.test.lib.dcmd.CommandExecutorException;
import jdk.test.lib.process.OutputAnalyzer;
import jdk.test.lib.process.ProcessTools;

public abstract class JcmdExecutor
extends CommandExecutor {
    protected String jcmdBinary = JDKToolFinder.getJDKTool("jcmd");
    protected String jcmdDisableStreamingOption = "-J-Djdk.attach.allowStreamingOutput=false";

    protected abstract List<String> createCommandLine(String var1) throws CommandExecutorException;

    protected JcmdExecutor() {
    }

    public List<String> getCommandLine(String ... cmds) {
        return this.createCommandLine(String.join((CharSequence)" ", cmds));
    }

    @Override
    protected OutputAnalyzer executeImpl(String cmd) throws CommandExecutorException {
        List<String> commandLine = this.createCommandLine(cmd);
        try {
            System.out.printf("Executing command '%s'%n", commandLine);
            OutputAnalyzer output = ProcessTools.executeProcess(new ProcessBuilder(commandLine));
            System.out.printf("Command returned with exit code %d%n", output.getExitValue());
            return output;
        }
        catch (Exception e) {
            String message = String.format("Caught exception while executing '%s'", commandLine);
            throw new CommandExecutorException(message, e);
        }
    }
}

