/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import jdk.test.lib.JDKToolFinder;

public class JDKToolLauncher {
    private final String executable;
    private final List<String> vmArgs = new ArrayList<String>();
    private final List<String> toolArgs = new ArrayList<String>();

    private JDKToolLauncher(String tool, boolean useCompilerJDK) {
        this.executable = useCompilerJDK ? JDKToolFinder.getJDKTool(tool) : JDKToolFinder.getTestJDKTool(tool);
    }

    public static JDKToolLauncher create(String tool) {
        return new JDKToolLauncher(tool, true);
    }

    public static JDKToolLauncher createUsingTestJDK(String tool) {
        return new JDKToolLauncher(tool, false);
    }

    public JDKToolLauncher addVMArg(String arg) {
        this.vmArgs.add(arg);
        return this;
    }

    public JDKToolLauncher addVMArgs(String[] args) {
        Stream.of(args).forEach(this.vmArgs::add);
        return this;
    }

    public JDKToolLauncher addToolArg(String arg) {
        this.toolArgs.add(arg);
        return this;
    }

    public String[] getCommand() {
        ArrayList<Object> command = new ArrayList<Object>();
        command.add(this.executable);
        for (String arg : this.vmArgs) {
            command.add("-J" + arg);
        }
        command.addAll(this.toolArgs);
        return command.toArray(new String[command.size()]);
    }
}

