/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import jdk.test.lib.Utils;
import jdk.test.lib.util.JarUtils;

public class JavaAgentBuilder {
    public static void main(String ... args) throws Exception {
        String agentClass = args[0];
        String agentJar = args[1];
        System.out.println("Building " + agentJar + " with agent class " + agentClass);
        JavaAgentBuilder.build(agentClass, agentJar, JavaAgentBuilder.parseExtraAttrs(args));
    }

    private static Map<String, String> parseExtraAttrs(String[] args) throws Exception {
        HashMap<String, String> attrs = new HashMap<String, String>();
        for (int i = 2; i < args.length; ++i) {
            String[] parts = args[i].split(":");
            if (parts.length != 2) {
                throw new IllegalArgumentException("Extra attributes should be of format 'key:value'");
            }
            attrs.put(parts[0], parts[1]);
        }
        return attrs;
    }

    public static void build(String agentClass, String agentJar) throws IOException {
        JavaAgentBuilder.build(agentClass, agentJar, new HashMap<String, String>());
    }

    public static void build(String agentClass, String agentJar, Map<String, String> extraAttrs) throws IOException {
        Manifest mf = new Manifest();
        Attributes attrs = mf.getMainAttributes();
        attrs.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        attrs.putValue("Can-Redefine-Classes", "true");
        attrs.putValue("Can-Retransform-Classes", "true");
        attrs.putValue("Premain-Class", agentClass);
        attrs.putValue("Agent-Class", agentClass);
        extraAttrs.forEach((k, v) -> attrs.putValue((String)k, (String)v));
        Path jarFile = Paths.get(".", agentJar);
        String testClasses = Utils.TEST_CLASSES;
        String agentPath = agentClass.replace(".", File.separator) + ".class";
        Path agentFile = Paths.get(testClasses, agentPath);
        Path dir = Paths.get(testClasses, new String[0]);
        JarUtils.createJarFile(jarFile, mf, dir, agentFile);
        System.out.println("Agent built:" + String.valueOf(jarFile.toAbsolutePath()));
    }
}

