/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.hexdump;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import jdk.test.lib.hexdump.ASN1Formatter;
import jdk.test.lib.hexdump.HexPrinter;
import jdk.test.lib.hexdump.ObjectStreamPrinter;

public class StreamDump {
    static HexPrinter.Formatter defaultFormatter = null;

    public static void main(String[] args) {
        try {
            List<String> argList = StreamDump.parseOptions(args);
            StreamDump.dumpFiles(argList);
        }
        catch (IllegalArgumentException iae) {
            System.out.println(iae.getMessage());
            StreamDump.usage();
            System.exit(1);
        }
    }

    private static List<String> parseOptions(String[] arg) {
        for (int i = 0; i < arg.length; ++i) {
            if (!arg[i].startsWith("--")) {
                if (arg[i].startsWith("-")) {
                    throw new IllegalArgumentException("options start with '--', not single '-'");
                }
                return Arrays.asList(Arrays.copyOfRange(arg, i, arg.length));
            }
            if (!arg[i].equals("--formatter")) continue;
            if (++i >= arg.length) {
                throw new IllegalArgumentException("Formatter class name missing");
            }
            String fmtName = arg[i];
            try {
                defaultFormatter = StreamDump.findFormatter(Class.forName(fmtName));
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Formatter class not found: " + fmtName);
            }
        }
        throw new IllegalArgumentException("No file arguments");
    }

    private static void usage() {
        System.out.println("Usage: [--formatter <class name>] <files>");
    }

    static void dumpFiles(List<String> args) {
        String beforeFileSpacing = "";
        for (int i = 0; i < args.size(); ++i) {
            String file = args.get(i);
            try {
                System.out.print(beforeFileSpacing);
                String title = args.size() > 1 ? String.format("File: %s%n", file) : "";
                StreamDump.dumpFile(Path.of(file, new String[0]), defaultFormatter, title);
                beforeFileSpacing = System.lineSeparator();
                continue;
            }
            catch (FileNotFoundException | NoSuchFileException fnf) {
                System.out.printf("File: %s file not found%n", file);
                continue;
            }
            catch (IOException ioe) {
                System.out.printf("File: %s %s: %s%n", file, ioe.getClass().getName(), ioe.getMessage());
            }
        }
    }

    static void dumpFile(Path file, HexPrinter.Formatter defaultFormatter, String title) throws IOException {
        Objects.requireNonNull(file, "filename");
        Objects.requireNonNull(title, "title");
        try (InputStream fis = Files.newInputStream(file, new OpenOption[0]);){
            System.out.print(title);
            StreamDump.dumpFile(fis, defaultFormatter);
        }
    }

    static void dumpFile(InputStream fis, HexPrinter.Formatter formatter) throws IOException {
        try (BufferedInputStream is = new BufferedInputStream(fis);){
            is.mark(1024);
            InputStream decoded = StreamDump.decodeMaybe(is);
            if (!decoded.equals(is)) {
                if (formatter == null) {
                    formatter = StreamDump.findFormatter(ASN1Formatter.class);
                }
                decoded = new BufferedInputStream(decoded);
                decoded.mark(1024);
            } else {
                decoded.reset();
            }
            if (formatter == null && StreamDump.guessSerializable(decoded)) {
                formatter = StreamDump.findFormatter(ObjectStreamPrinter.class);
            }
            decoded.reset();
            if (formatter == null) {
                formatter = HexPrinter.Formatters.PRINTABLE;
            }
            HexPrinter.simple().formatter(formatter).dest(System.out).format(decoded);
        }
    }

    static InputStream decodeMaybe(InputStream is) throws IOException {
        DataInputStream dis = new DataInputStream(is);
        is.mark(1024);
        String line1 = dis.readLine();
        if (line1.startsWith("-----")) {
            return Base64.getMimeDecoder().wrap(is);
        }
        is.reset();
        return is;
    }

    static boolean guessSerializable(InputStream is) throws IOException {
        byte[] bytes = new byte[4];
        int l = is.read(bytes, 0, bytes.length);
        return l >= 4 && (bytes[0] & 0xFF) == 172 && (bytes[1] & 0xFF) == 237 && bytes[2] == 0 && bytes[3] == 5;
    }

    private static HexPrinter.Formatter findFormatter(Class<?> clazz) {
        Constructor<?>[] cons;
        Method[] methods;
        for (Method m : methods = clazz.getDeclaredMethods()) {
            if (m.getReturnType() != clazz || m.getParameterCount() != 0 || !Modifier.isStatic(m.getModifiers()) || !Modifier.isPublic(m.getModifiers())) continue;
            try {
                return (HexPrinter.Formatter)m.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        for (Constructor<?> m : cons = clazz.getDeclaredConstructors()) {
            if (m.getParameterCount() != 0 || !Modifier.isPublic(m.getModifiers())) continue;
            try {
                return (HexPrinter.Formatter)m.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        throw new RuntimeException("No formatter for class " + clazz.getName());
    }
}

