/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.hprof.model;

import java.io.IOException;
import jdk.test.lib.hprof.model.JavaBoolean;
import jdk.test.lib.hprof.model.JavaByte;
import jdk.test.lib.hprof.model.JavaChar;
import jdk.test.lib.hprof.model.JavaClass;
import jdk.test.lib.hprof.model.JavaDouble;
import jdk.test.lib.hprof.model.JavaField;
import jdk.test.lib.hprof.model.JavaFloat;
import jdk.test.lib.hprof.model.JavaHeapObject;
import jdk.test.lib.hprof.model.JavaHeapObjectVisitor;
import jdk.test.lib.hprof.model.JavaInt;
import jdk.test.lib.hprof.model.JavaLazyReadObject;
import jdk.test.lib.hprof.model.JavaLong;
import jdk.test.lib.hprof.model.JavaObjectRef;
import jdk.test.lib.hprof.model.JavaShort;
import jdk.test.lib.hprof.model.JavaThing;
import jdk.test.lib.hprof.model.JavaValueArray;
import jdk.test.lib.hprof.model.Snapshot;
import jdk.test.lib.hprof.parser.ReadBuffer;

public class JavaObject
extends JavaLazyReadObject {
    private Object clazz;

    public JavaObject(long classID, long offset) {
        super(offset);
        this.clazz = JavaObject.makeId(classID);
    }

    @Override
    public void resolve(Snapshot snapshot) {
        if (this.clazz instanceof JavaClass) {
            return;
        }
        if (this.clazz instanceof Number) {
            long classID = JavaObject.getIdValue((Number)this.clazz);
            this.clazz = snapshot.findThing(classID);
            if (!(this.clazz instanceof JavaClass)) {
                int length;
                this.warn("Class " + Long.toHexString(classID) + " not found, adding fake class!");
                ReadBuffer buf = snapshot.getReadBuffer();
                int idSize = snapshot.getIdentifierSize();
                long lenOffset = this.getOffset() + (long)(2 * idSize) + 4L;
                try {
                    length = buf.getInt(lenOffset);
                }
                catch (IOException exp) {
                    throw new RuntimeException(exp);
                }
                this.clazz = snapshot.addFakeInstanceClass(classID, length);
            }
        } else {
            throw new InternalError("should not reach here");
        }
        JavaClass cl = (JavaClass)this.clazz;
        cl.resolve(snapshot);
        this.parseFields(true);
        cl.addInstance(this);
        super.resolve(snapshot);
    }

    @Override
    public boolean isSameTypeAs(JavaThing other) {
        if (!(other instanceof JavaObject)) {
            return false;
        }
        JavaObject oo = (JavaObject)other;
        return this.getClazz().equals(oo.getClazz());
    }

    @Override
    public JavaClass getClazz() {
        return (JavaClass)this.clazz;
    }

    public JavaThing[] getFields() {
        return this.parseFields(false);
    }

    public JavaThing getField(String name) {
        JavaThing[] flds = this.getFields();
        JavaField[] instFields = this.getClazz().getFieldsForInstance();
        for (int i = 0; i < instFields.length; ++i) {
            if (!instFields[i].getName().equals(name)) continue;
            return flds[i];
        }
        return null;
    }

    @Override
    public int compareTo(JavaThing other) {
        if (other instanceof JavaObject) {
            JavaObject oo = (JavaObject)other;
            return this.getClazz().getName().compareTo(oo.getClazz().getName());
        }
        return super.compareTo(other);
    }

    @Override
    public void visitReferencedObjects(JavaHeapObjectVisitor v) {
        super.visitReferencedObjects(v);
        JavaThing[] flds = this.getFields();
        for (int i = 0; i < flds.length; ++i) {
            if (flds[i] == null || v.mightExclude() && v.exclude(this.getClazz().getClassForField(i), this.getClazz().getFieldForInstance(i)) || !(flds[i] instanceof JavaHeapObject)) continue;
            v.visit((JavaHeapObject)flds[i]);
        }
    }

    @Override
    public boolean refersOnlyWeaklyTo(Snapshot ss, JavaThing other) {
        if (ss.getWeakReferenceClass() != null) {
            int referentFieldIndex = ss.getReferentFieldIndex();
            if (ss.getWeakReferenceClass().isAssignableFrom(this.getClazz())) {
                JavaThing[] flds = this.getFields();
                for (int i = 0; i < flds.length; ++i) {
                    if (i == referentFieldIndex || flds[i] != other) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public String describeReferenceTo(JavaThing target, Snapshot ss) {
        JavaThing[] flds = this.getFields();
        for (int i = 0; i < flds.length; ++i) {
            if (flds[i] != target) continue;
            JavaField f = this.getClazz().getFieldForInstance(i);
            return "field " + f.getName();
        }
        return super.describeReferenceTo(target, ss);
    }

    @Override
    public String toString() {
        if (this.getClazz().isString()) {
            JavaThing value;
            JavaThing coder = this.getField("coder");
            boolean compact = false;
            if (coder instanceof JavaByte) {
                boolean bl = compact = ((JavaByte)coder).value == 0;
            }
            if ((value = this.getField("value")) instanceof JavaValueArray) {
                return ((JavaValueArray)value).valueAsString(compact);
            }
            return "null";
        }
        return super.toString();
    }

    @Override
    protected final long readValueLength() throws IOException {
        long lengthOffset = this.getOffset() + (long)(2 * this.idSize()) + 4L;
        return this.buf().getInt(lengthOffset);
    }

    @Override
    protected final JavaThing[] readValue() throws IOException {
        return this.parseFields(false);
    }

    private long dataStartOffset() {
        return this.getOffset() + (long)this.idSize() + 4L + (long)this.idSize() + 4L;
    }

    private JavaThing[] parseFields(boolean verbose) {
        JavaClass cl = this.getClazz();
        int target = cl.getNumFieldsForInstance();
        JavaField[] fields = cl.getFields();
        JavaThing[] fieldValues = new JavaThing[target];
        Snapshot snapshot = cl.getSnapshot();
        int fieldNo = 0;
        target -= fields.length;
        JavaClass currClass = cl;
        long offset = this.dataStartOffset();
        int i = 0;
        while (i < fieldValues.length) {
            while (fieldNo >= fields.length) {
                currClass = currClass.getSuperclass();
                fields = currClass.getFields();
                fieldNo = 0;
                target -= fields.length;
            }
            JavaField f = fields[fieldNo];
            char sig = f.getSignature().charAt(0);
            try {
                switch (sig) {
                    case 'L': 
                    case '[': {
                        long id = this.objectIdAt(offset);
                        offset += (long)this.idSize();
                        JavaObjectRef ref = new JavaObjectRef(id);
                        fieldValues[target + fieldNo] = ref.dereference(snapshot, f, verbose);
                        break;
                    }
                    case 'Z': {
                        byte value = this.byteAt(offset);
                        ++offset;
                        fieldValues[target + fieldNo] = new JavaBoolean(value != 0);
                        break;
                    }
                    case 'B': {
                        byte value = this.byteAt(offset);
                        ++offset;
                        fieldValues[target + fieldNo] = new JavaByte(value);
                        break;
                    }
                    case 'S': {
                        short value = this.shortAt(offset);
                        offset += 2L;
                        fieldValues[target + fieldNo] = new JavaShort(value);
                        break;
                    }
                    case 'C': {
                        char value = this.charAt(offset);
                        offset += 2L;
                        fieldValues[target + fieldNo] = new JavaChar(value);
                        break;
                    }
                    case 'I': {
                        int value = this.intAt(offset);
                        offset += 4L;
                        fieldValues[target + fieldNo] = new JavaInt(value);
                        break;
                    }
                    case 'J': {
                        long value = this.longAt(offset);
                        offset += 8L;
                        fieldValues[target + fieldNo] = new JavaLong(value);
                        break;
                    }
                    case 'F': {
                        float value = this.floatAt(offset);
                        offset += 4L;
                        fieldValues[target + fieldNo] = new JavaFloat(value);
                        break;
                    }
                    case 'D': {
                        double value = this.doubleAt(offset);
                        offset += 8L;
                        fieldValues[target + fieldNo] = new JavaDouble(value);
                        break;
                    }
                    default: {
                        throw new RuntimeException("invalid signature: " + sig);
                    }
                }
            }
            catch (IOException exp) {
                System.err.println("lazy read failed at offset " + offset);
                exp.printStackTrace();
                return Snapshot.EMPTY_JAVATHING_ARRAY;
            }
            ++i;
            ++fieldNo;
        }
        return fieldValues;
    }

    private void warn(String msg) {
        System.out.println("WARNING: " + msg);
    }
}

