/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_se_FI extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Greenwicha \u00e1igi",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Apia d\u00e1lve\u00e1igi",
               "",
               "Apia geasse\u00e1igi",
               "",
               "Apia \u00e1igi",
               "",
            };
        final String[] Cook = new String[] {
               "Cooksulloid d\u00e1lve\u00e1igi",
               "",
               "Cooksulloid geasi beallemuttu \u00e1igi",
               "",
               "Cooksulloid \u00e1igi",
               "",
            };
        final String[] Cuba = new String[] {
               "Cuba d\u00e1lve\u00e1igi",
               "CST",
               "Cuba geasse\u00e1igi",
               "CDT",
               "Cuba \u00e1igi",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Fiji d\u00e1lve\u00e1igi",
               "",
               "Fiji geasse\u00e1igi",
               "",
               "Fiji \u00e1igi",
               "",
            };
        final String[] Gulf = new String[] {
               "Golfa d\u00e1lve\u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Hovda d\u00e1lve\u00e1igi",
               "",
               "Hovda geasse\u00e1igi",
               "",
               "Hovda \u00e1igi",
               "",
            };
        final String[] Iran = new String[] {
               "Irana d\u00e1lve\u00e1igi",
               "",
               "Irana geasse\u00e1igi",
               "",
               "Irana \u00e1igi",
               "",
            };
        final String[] Niue = new String[] {
               "Niuea \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Omska d\u00e1lve\u00e1igi",
               "",
               "Omska geasse\u00e1igi",
               "",
               "Omska \u00e1igi",
               "",
            };
        final String[] Peru = new String[] {
               "Peru d\u00e1lve\u00e1igi",
               "",
               "Peru geasse\u00e1igi",
               "",
               "Peru \u00e1igi",
               "",
            };
        final String[] Truk = new String[] {
               "Chuuka \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Wakesullo \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Chile d\u00e1lve\u00e1igi",
               "",
               "Chile geasse\u00e1igi",
               "",
               "Chile \u00e1igi",
               "",
            };
        final String[] China = new String[] {
               "Kiinn\u00e1 d\u00e1lve\u00e1igi",
               "CST",
               "Kiinn\u00e1 geasse\u00e1igi",
               "CDT",
               "Kiinn\u00e1 \u00e1igi",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Kokossulloid \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Davisa \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "India d\u00e1lve\u00e1igi",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Jap\u00e1na d\u00e1lve\u00e1igi",
               "JST",
               "Jap\u00e1na geasse\u00e1igi",
               "JDT",
               "Jap\u00e1na \u00e1igi",
               "JT",
            };
        final String[] Korea = new String[] {
               "Korea d\u00e1lve\u00e1igi",
               "KST",
               "Korea geasse\u00e1igi",
               "KST",
               "Korea \u00e1igi",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Nauru \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Nepala \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Palaua \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Samoa d\u00e1lve\u00e1igi",
               "SST",
               "Samoa geasse\u00e1igi",
               "SST",
               "Samoa \u00e1igi",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Syowa \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tonga d\u00e1lve\u00e1igi",
               "",
               "Tonga geasse\u00e1igi",
               "",
               "Tonga \u00e1igi",
               "",
            };
        final String[] Alaska = new String[] {
               "Alaska d\u00e1lve\u00e1igi",
               "AKST",
               "Alaska geasse\u00e1igi",
               "AKDT",
               "Alaska \u00e1igi",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Amazona d\u00e1lve\u00e1igi",
               "",
               "Amazona geasse\u00e1igi",
               "",
               "Amazona \u00e1igi",
               "",
            };
        final String[] Azores = new String[] {
               "Azoraid d\u00e1lve\u00e1igi",
               "",
               "Azoraid geasse\u00e1igi",
               "",
               "Azoraid \u00e1igi",
               "",
            };
        final String[] Bhutan = new String[] {
               "Bhutana \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Brunei Darussalama \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Beass\u00e1\u0161sullo d\u00e1lve\u00e1igi",
               "",
               "Beass\u00e1\u0161sullo geasse\u00e1igi",
               "",
               "Beass\u00e1\u0161sullo \u00e1igi",
               "",
            };
        final String[] Guyana = new String[] {
               "Guyana \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Israela d\u00e1lve\u00e1igi",
               "IST",
               "Israela geasse\u00e1igi",
               "IDT",
               "Israela \u00e1igi",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Kosraea \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Mawsona \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Moskva d\u00e1lve\u00e1igi",
               "MSK",
               "Moskva geasse\u00e1igi",
               "MSK",
               "Moskva \u00e1igi",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Ponape \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Tahiti \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Taipeia d\u00e1lve\u00e1igi",
               "CST",
               "Taipeia geasse\u00e1igi",
               "CDT",
               "Taipeia \u00e1igi",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalu \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Vostoka \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Wallis- ja Futuna \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Ar\u00e1bia d\u00e1lve\u00e1igi",
               "",
               "Ar\u00e1bia geasse\u00e1igi",
               "",
               "Ar\u00e1bia \u00e1igi",
               "",
            };
        final String[] Armenia = new String[] {
               "Armenia d\u00e1lve\u00e1igi",
               "",
               "Armenia geasse\u00e1igi",
               "",
               "Armenia \u00e1igi",
               "",
            };
        final String[] Bolivia = new String[] {
               "Bolivia \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Chathama d\u00e1lve\u00e1igi",
               "",
               "Chathama geasse\u00e1igi",
               "",
               "Chathama \u00e1igi",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "koordinerejuvvon oktasa\u0161 \u00e1igi",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ecuadora \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Gambiera \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Georgia d\u00e1lve\u00e1igi",
               "",
               "Georgia geasse\u00e1igi",
               "",
               "Georgia \u00e1igi",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Irkucka d\u00e1lve\u00e1igi",
               "",
               "Irkucka geasse\u00e1igi",
               "",
               "Irkucka \u00e1igi",
               "",
            };
        final String[] Magadan = new String[] {
               "Magadana d\u00e1lve\u00e1igi",
               "",
               "Magadana geasse\u00e1igi",
               "",
               "Magadana \u00e1igi",
               "",
            };
        final String[] Myanmar = new String[] {
               "Myanmara \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Norfolksullo \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Noronha = new String[] {
               "Fernando de Noronha d\u00e1lve\u00e1igi",
               "",
               "Fernando de Noronha geasse\u00e1igi",
               "",
               "Fernando de Noronha \u00e1igi",
               "",
            };
        final String[] Reunion = new String[] {
               "Reuniona \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Rothera \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Salomonsulloid \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tokelaua \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Uruguaya d\u00e1lve\u00e1igi",
               "",
               "Uruguaya geasse\u00e1igi",
               "",
               "Uruguaya \u00e1igi",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatu d\u00e1lve\u00e1igi",
               "",
               "Vanuatu geasse\u00e1igi",
               "",
               "Vanuatu \u00e1igi",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Jakucka d\u00e1lve\u00e1igi",
               "",
               "Jakucka geasse\u00e1igi",
               "",
               "Jakucka \u00e1igi",
               "",
            };
        final String[] Atlantic = new String[] {
               "atl\u00e1ntala\u0161 d\u00e1lve\u00e1igi",
               "AST",
               "atl\u00e1ntala\u0161 geasse\u00e1igi",
               "AST",
               "atl\u00e1ntala\u0161 \u00e1igi",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Brasilia d\u00e1lve\u00e1igi",
               "",
               "Brasilia geasse\u00e1igi",
               "",
               "Brasilia \u00e1igi",
               "",
            };
        final String[] Chamorro = new String[] {
               "\u010camorro d\u00e1lve\u00e1igi",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Colombia d\u00e1lve\u00e1igi",
               "",
               "Colombia geasse\u00e1igi",
               "",
               "Colombia \u00e1igi",
               "",
            };
        final String[] Falkland = new String[] {
               "Falklandsulluid d\u00e1lve\u00e1igi",
               "",
               "Falklandsulluid geasse\u00e1igi",
               "",
               "Falklandsulluid \u00e1igi",
               "",
            };
        final String[] Malaysia = new String[] {
               "Malesia \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Malediivvaid \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ulan-Batora d\u00e1lve\u00e1igi",
               "",
               "Ulan-Batora geasse\u00e1igi",
               "",
               "Ulan-Batora \u00e1igi",
               "",
            };
        final String[] Pakistan = new String[] {
               "Pakistana d\u00e1lve\u00e1igi",
               "PKT",
               "Pakistana geasse\u00e1igi",
               "PKST",
               "Pakistana \u00e1igi",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Paraguaya d\u00e1lve\u00e1igi",
               "",
               "Paraguaya geasse\u00e1igi",
               "",
               "Paraguaya \u00e1igi",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Pitcairnsulloid \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Sahalina d\u00e1lve\u00e1igi",
               "",
               "Sahalina geasse\u00e1igi",
               "",
               "Sahalina \u00e1igi",
               "",
            };
        final String[] Suriname = new String[] {
               "Suriname \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Argentina d\u00e1lve\u00e1igi",
               "",
               "Argentina geasse\u00e1igi",
               "",
               "Argentina \u00e1igi",
               "",
            };
        final String[] Christmas = new String[] {
               "Juovlasullo \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Galapagosa \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Hong Konga d\u00e1lve\u00e1igi",
               "HKT",
               "Hong Konga geasse\u00e1igi",
               "HKST",
               "Hong Konga \u00e1igi",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Indokiinn\u00e1 \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Kirgisia \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Lord Howe d\u00e1lve\u00e1igi",
               "",
               "Lord Howe geasse\u00e1igi",
               "",
               "Lord Howe \u00e1igi",
               "",
            };
        final String[] Marquesas = new String[] {
               "Marquesasiid \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Mauritiusa d\u00e1lve\u00e1igi",
               "",
               "Mauritiusa geasse\u00e1igi",
               "",
               "Mauritiusa \u00e1igi",
               "",
            };
        final String[] Singapore = new String[] {
               "Singapore d\u00e1lve\u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Venezuela \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Volgograda d\u00e1lve\u00e1igi",
               "MSK",
               "Volgograda geasse\u00e1igi",
               "MSK",
               "Volgograda \u00e1igi",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Aserbai\u017eana d\u00e1lve\u00e1igi",
               "",
               "Aserbai\u017eana geasse\u00e1igi",
               "",
               "Aserbai\u017eana \u00e1igi",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Bangladesha d\u00e1lve\u00e1igi",
               "",
               "Bangladesha geasse\u00e1igi",
               "",
               "Bangladesha \u00e1igi",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Kap Verde d\u00e1lve\u00e1igi",
               "",
               "Kap Verde geasse\u00e1igi",
               "",
               "Kap Verde \u00e1igi",
               "",
            };
        final String[] East_Timor = new String[] {
               "Nuorta-Timora \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Seychellaid \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Ta\u017eikistana \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Usbekistana d\u00e1lve\u00e1igi",
               "",
               "Usbekistana geasse\u00e1igi",
               "",
               "Usbekistana \u00e1igi",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Afganisthana \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojarska d\u00e1lve\u00e1igi",
               "",
               "Krasnojarska geasse\u00e1igi",
               "",
               "Krasnojarska \u00e1igi",
               "",
            };
        final String[] New_Zealand = new String[] {
               "O\u0111\u0111a-Sel\u00e1nda d\u00e1lve\u00e1igi",
               "NZST",
               "O\u0111\u0111a-Sel\u00e1nda geasse\u00e1igi",
               "NZDT",
               "O\u0111\u0111a-Sel\u00e1nda \u00e1igi",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirska d\u00e1lve\u00e1igi",
               "",
               "Novosibirska geasse\u00e1igi",
               "",
               "Novosibirska \u00e1igi",
               "",
            };
        final String[] Philippines = new String[] {
               "Filippiinnaid d\u00e1lve\u00e1igi",
               "PST",
               "Filippiinnaid geasse\u00e1igi",
               "PDT",
               "Filippiinnaid \u00e1igi",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostoka d\u00e1lve\u00e1igi",
               "",
               "Vladivostoka geasse\u00e1igi",
               "",
               "Vladivostoka \u00e1igi",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "India\u00e1bi \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Linesulloid \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Newfoundlanda d\u00e1lve\u00e1igi",
               "NST",
               "Newfoundlanda geasse\u00e1igi",
               "NDT",
               "Newfoundlanda \u00e1igi",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmenistana d\u00e1lve\u00e1igi",
               "",
               "Turkmenistana geasse\u00e1igi",
               "",
               "Turkmenistana \u00e1igi",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Frankriikka Guyana \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "O\u0111\u0111a-Kaledonia d\u00e1lve\u00e1igi",
               "",
               "O\u0111\u0111a-Kaledonia geasse\u00e1igi",
               "",
               "O\u0111\u0111a-Kaledonia \u00e1igi",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Lulli-Georgia \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterinburga d\u00e1lve\u00e1igi",
               "",
               "Jekaterinburga geasse\u00e1igi",
               "",
               "Jekaterinburga \u00e1igi",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Gaska-Afrihk\u00e1 \u00e1igi",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Nuorta-Afrihk\u00e1 \u00e1igi",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Oarje-Afrihk\u00e1 d\u00e1lve\u00e1igi",
               "WAT",
               "Oarje-Afrihk\u00e1 geasse\u00e1igi",
               "WAT",
               "Oarje-Afrihk\u00e1 \u00e1igi",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont-d\u2019Urville \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Gaska-Eurohp\u00e1 d\u00e1lve\u00e1igi",
               "CET",
               "Gaska-Eurohp\u00e1 geasse\u00e1igi",
               "CEST",
               "Gaska-Eurohp\u00e1 \u00e1igi",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Nuorta-Eurohpa d\u00e1lve\u00e1igi",
               "EET",
               "Nuorta-Eurohpa geasse\u00e1igi",
               "EEST",
               "Nuorta-Eurohpa \u00e1igi",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Oarje-Eurohp\u00e1 d\u00e1lve\u00e1igi",
               "WET",
               "Oarje-Eurohp\u00e1 geasse\u00e1igi",
               "WEST",
               "Oarje-Eurohp\u00e1 \u00e1igi",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Meksiko J\u00e1skes\u00e1bi d\u00e1lve\u00e1igi",
               "MST",
               "Meksiko J\u00e1skes\u00e1bi geasse\u00e1igi",
               "MDT",
               "Meksiko J\u00e1skes\u00e1bi \u00e1igi",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Lulli-Afrihk\u00e1 d\u00e1lve\u00e1igi",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "d\u00e1b\u00e1la\u0161 d\u00e1lve\u00e1igi",
               "CST",
               "d\u00e1b\u00e1la\u0161 geasse\u00e1igi",
               "CDT",
               "d\u00e1b\u00e1la\u0161\u00e1igi",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "d\u00e1lve\u00e1igi nuortan",
               "EST",
               "geasse\u00e1igi nuortan",
               "EST",
               "\u00e1igi nuortan",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Jaskes\u00e1bi d\u00e1lve\u00e1igi",
               "PST",
               "Jaskes\u00e1bi geasse\u00e1igi",
               "PDT",
               "Jaskes\u00e1bi \u00e1igi",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Frankriikka lulli & ant\u00e1rktisa \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilbertsulloid \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hawaii-aleuhtala\u0161 d\u00e1lve\u00e1igi",
               "HST",
               "Hawaii-aleuhtala\u0161 geasse\u00e1igi",
               "HST",
               "Hawaii-aleuhtala\u0161 \u00e1igi",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "Phoenixsulloid \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "St. Pierre & Miquelo d\u00e1lve\u00e1igi",
               "",
               "St. Pierre & Miquelo geasse\u00e1igi",
               "",
               "St. Pierre & Miquelo \u00e1igi",
               "",
            };
        final String[] America_Mountain = new String[] {
               "d\u00e1lveduottar\u00e1igi",
               "MST",
               "geasseduottar\u00e1igi",
               "MST",
               "duottar\u00e1igi",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Marshallsulloid \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua O\u0111\u0111a-Guinea \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Gaska-Austr\u00e1lia d\u00e1lve\u00e1igi",
               "ACST",
               "Gaska-Austr\u00e1lia geasse\u00e1igi",
               "ACDT",
               "Gaska-Austr\u00e1lia \u00e1igi",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Nuorta-Austr\u00e1lia d\u00e1lve\u00e1igi",
               "AEST",
               "Nuorta-Austr\u00e1lia geasse\u00e1igi",
               "AEDT",
               "Nuorta-Austr\u00e1lia \u00e1igi",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Oarje-Austr\u00e1lia d\u00e1lve\u00e1igi",
               "AWST",
               "Oarje-Austr\u00e1lia geasse\u00e1igi",
               "AWDT",
               "Oarje-Austr\u00e1lia \u00e1igi",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Gaska-Indonesia \u00e1igi",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Nuorta-Indonesia \u00e1igi",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Oarje-Indonesia \u00e1igi",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Oarje-Kasakstana \u00e1igi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Gaska-Austr\u00e1lia oarjjabeali d\u00e1lve\u00e1igi",
               "",
               "Gaska-Austr\u00e1lia oarjjabeali geasse\u00e1igi",
               "",
               "Gaska-Austr\u00e1lia oarjjabeali \u00e1igi",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Greenwicha \u00e1igi",
                    "GMT",
                    "Brihtala\u0161 geasse\u00e1igi",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "koordinerejuvvon oktasa\u0161 \u00e1igi",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Greenwicha \u00e1igi",
                    "GMT",
                    "Irl\u00e1nddala\u0161 d\u00e1lve\u00e1igi",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "koordinerejuvvon oktasa\u0161 \u00e1igi",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "koordinerejuvvon oktasa\u0161 \u00e1igi",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Greenwicha \u00e1igi",
                    "GMT",
                    "Brihtala\u0161 geasse\u00e1igi",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "koordinerejuvvon oktasa\u0161 \u00e1igi",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan_Western },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "koordinerejuvvon oktasa\u0161 \u00e1igi",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan_Western },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan_Western },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "koordinerejuvvon oktasa\u0161 \u00e1igi",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Greenwicha \u00e1igi",
                    "GMT",
                    "Irl\u00e1nddala\u0161 d\u00e1lve\u00e1igi",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Greenwicha \u00e1igi",
                    "GMT",
                    "Brihtala\u0161 geasse\u00e1igi",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Greenwicha \u00e1igi",
                    "GMT",
                    "Brihtala\u0161 geasse\u00e1igi",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Greenwicha \u00e1igi",
                    "GMT",
                    "Brihtala\u0161 geasse\u00e1igi",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Greenwicha \u00e1igi",
                    "GMT",
                    "Brihtala\u0161 geasse\u00e1igi",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Greenwicha \u00e1igi",
                    "GMT",
                    "Brihtala\u0161 geasse\u00e1igi",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Tehran", "Teheran" },
            { "timezone.excity.Etc/Unknown", "Dovdameahttun g\u00e1vpot" },
            { "timezone.excity.Europe/Rome", "Roma" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Cairo", "Kairo" },
            { "timezone.excity.Asia/Irkutsk", "Irkuck" },
            { "timezone.excity.Asia/Rangoon", "Rangoon" },
            { "timezone.excity.Asia/Yakutsk", "Jakuck" },
            { "timezone.excity.Asia/Yerevan", "Jerevan" },
            { "timezone.excity.Indian/Cocos", "Kokos" },
            { "timezone.excity.Asia/Damascus", "Damaskos" },
            { "timezone.excity.Asia/Sakhalin", "Sahalin" },
            { "timezone.excity.Europe/Athens", "Athena" },
            { "timezone.excity.Europe/Lisbon", "Lisboa" },
            { "timezone.excity.Europe/Moscow", "Moskva" },
            { "timezone.excity.Europe/Prague", "Praha" },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Vienna", "Wien" },
            { "timezone.excity.Europe/Warsaw", "Warsawa" },
            { "timezone.excity.Europe/Zurich", "Z\u00fcrich" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Asia/Kamchatka", "Kam\u010datka" },
            { "timezone.excity.Atlantic/Azores", "Azorat" },
            { "timezone.excity.Atlantic/Canary", "Kan\u00e1ria" },
            { "timezone.excity.Europe/Belgrade", "Belgrad" },
            { "timezone.excity.Europe/Brussels", "Br\u00fcssel" },
            { "timezone.excity.Europe/Helsinki", "Helsset" },
            { "timezone.excity.Indian/Maldives", "Malediivvat" },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnojarsk" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulan-Bator" },
            { "timezone.excity.Europe/Bucharest", "Bukarest" },
            { "timezone.excity.Europe/Ulyanovsk", "Uljanovsk" },
            { "timezone.excity.Indian/Christmas", "Juovlasuolu" },
            { "timezone.excity.Asia/Novokuznetsk", "Novokusneck" },
            { "timezone.excity.Europe/Copenhagen", "K\u00f8benhavn" },
            { "timezone.excity.Europe/Luxembourg", "Luxenburg" },
            { "timezone.excity.Pacific/Marquesas", "Marquesasat" },
            { "timezone.excity.Asia/Yekaterinburg", "Jekaterinburg" },
            { "timezone.excity.Europe/Isle_of_Man", "Mansuolu" },
            { "timezone.excity.Atlantic/Cape_Verde", "Kap Verde" },
            { "timezone.excity.America/Danmarkshavn", "D\u00e1nm\u00e1rkkuh\u00e1mman" },
            { "timezone.excity.Atlantic/South_Georgia", "Lulli-Georgia" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Davvi-Dakota" },
            { "timezone.excity.America/North_Dakota/Center", "Guovdd\u00e1\u0161, Davvi-Dakota" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Davvi-Dakota" },
        };
        return data;
    }
}
