/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_no extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Greenwich middeltid",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "Acre normaltid",
               "",
               "Acre sommertid",
               "",
               "Acre-tid",
               "",
            };
        final String[] Apia = new String[] {
               "normaltid for Apia",
               "",
               "sommertid for Apia",
               "",
               "tidssone for Apia",
               "",
            };
        final String[] Cook = new String[] {
               "normaltid for Cook\u00f8yene",
               "",
               "halv sommertid for Cook\u00f8yene",
               "",
               "tidssone for Cook\u00f8yene",
               "",
            };
        final String[] Cuba = new String[] {
               "cubansk normaltid",
               "CST",
               "cubansk sommertid",
               "CDT",
               "cubansk tid",
               "CT",
            };
        final String[] Fiji = new String[] {
               "fijiansk normaltid",
               "",
               "fijiansk sommertid",
               "",
               "fijiansk tid",
               "",
            };
        final String[] Gulf = new String[] {
               "tidssone for Persiabukta",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "normaltid for Khovd",
               "",
               "sommertid for Khovd",
               "",
               "tidssone for Khovd",
               "",
            };
        final String[] Iran = new String[] {
               "iransk normaltid",
               "",
               "iransk sommertid",
               "",
               "iransk tid",
               "",
            };
        final String[] Niue = new String[] {
               "tidssone for Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "normaltid for Omsk",
               "",
               "sommertid for Omsk",
               "",
               "tidssone for Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "peruansk normaltid",
               "",
               "peruansk sommertid",
               "",
               "peruansk tid",
               "",
            };
        final String[] Truk = new String[] {
               "tidssone for Chuuk\u00f8yene",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "tidssone for Wake Island",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "chilensk normaltid",
               "",
               "chilensk sommertid",
               "",
               "chilensk tid",
               "",
            };
        final String[] China = new String[] {
               "kinesisk normaltid",
               "CST",
               "kinesisk sommertid",
               "CDT",
               "kinesisk tid",
               "CT",
            };
        final String[] Cocos = new String[] {
               "tidssone for Kokos\u00f8yene",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "tidssone for Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "indisk tid",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "japansk normaltid",
               "JST",
               "japansk sommertid",
               "JDT",
               "japansk tid",
               "JT",
            };
        final String[] Korea = new String[] {
               "koreansk normaltid",
               "KST",
               "koreansk sommertid",
               "KST",
               "koreansk tid",
               "KST",
            };
        final String[] Nauru = new String[] {
               "naurisk tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "nepalsk tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "palauisk tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "samoansk normaltid",
               "SST",
               "samoansk sommertid",
               "SST",
               "samoansk tid",
               "SST",
            };
        final String[] Syowa = new String[] {
               "tidssone for Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "tongansk normaltid",
               "",
               "tongansk sommertid",
               "",
               "tongansk tid",
               "",
            };
        final String[] Yukon = new String[] {
               "tidssone for Yukon",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "alaskisk normaltid",
               "AKST",
               "alaskisk sommertid",
               "AKDT",
               "alaskisk tid",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "normaltid for Amazonas",
               "",
               "sommertid for Amazonas",
               "",
               "tidssone for Amazonas",
               "",
            };
        final String[] Anadyr = new String[] {
               "Russisk (Anadyr) normaltid",
               "",
               "Russisk (Anadyr) sommertid",
               "",
               "Russisk (Anadyr) tid",
               "",
            };
        final String[] Azores = new String[] {
               "asorisk normaltid",
               "",
               "asorisk sommertid",
               "",
               "asorisk tid",
               "",
            };
        final String[] Bhutan = new String[] {
               "bhutansk tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "tidssone for Brunei Darussalam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "normaltid for P\u00e5ske\u00f8ya",
               "",
               "sommertid for P\u00e5ske\u00f8ya",
               "",
               "tidssone for P\u00e5ske\u00f8ya",
               "",
            };
        final String[] Guyana = new String[] {
               "guyansk tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "israelsk normaltid",
               "IST",
               "israelsk sommertid",
               "IDT",
               "israelsk tid",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "tidssone for Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "tidssone for Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "normaltid for Moskva",
               "MSK",
               "sommertid for Moskva",
               "MSK",
               "tidssone for Moskva",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "tidssone for Pohnpei",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Russisk (Samara) normaltid",
               "",
               "Russisk (Samara) sommertid",
               "",
               "Russisk (Samara) tid",
               "",
            };
        final String[] Tahiti = new String[] {
               "tahitisk tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "normaltid for Taipei",
               "CST",
               "sommertid for Taipei",
               "CDT",
               "tidssone for Taipei",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "tuvalsk tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "tidssone for Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "tidssone for Wallis- og Futuna\u00f8yene",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "arabisk standardtid",
               "",
               "arabisk sommertid",
               "",
               "arabisk tid",
               "",
            };
        final String[] Armenia = new String[] {
               "armensk normaltid",
               "",
               "armensk sommertid",
               "",
               "armensk tid",
               "",
            };
        final String[] Bolivia = new String[] {
               "boliviansk tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "normaltid for Chatham",
               "",
               "sommertid for Chatham",
               "",
               "tidssone for Chatham",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "koordinert universaltid",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "ecuadoriansk tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "tidssone for Gambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "georgisk normaltid",
               "",
               "georgisk sommertid",
               "",
               "georgisk tid",
               "",
            };
        final String[] Irkutsk = new String[] {
               "normaltid for Irkutsk",
               "",
               "sommertid for Irkutsk",
               "",
               "tidssone for Irkutsk",
               "",
            };
        final String[] Magadan = new String[] {
               "normaltid for Magadan",
               "",
               "sommertid for Magadan",
               "",
               "tidssone for Magadan",
               "",
            };
        final String[] Myanmar = new String[] {
               "myanmarsk tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "normaltid for Norfolk\u00f8ya",
               "",
               "sommertid for Norfolk\u00f8ya",
               "",
               "tidssone for Norfolk\u00f8ya",
               "",
            };
        final String[] Noronha = new String[] {
               "normaltid for Fernando de Noronha",
               "",
               "sommertid for Fernando de Noronha",
               "",
               "tidssone for Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "tidssone for R\u00e9union",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "tidssone for Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "salomonsk tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "tidssone for Tokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "uruguayansk normaltid",
               "",
               "uruguayansk sommertid",
               "",
               "uruguayansk tid",
               "",
            };
        final String[] Vanuatu = new String[] {
               "vanuatisk normaltid",
               "",
               "vanuatisk sommertid",
               "",
               "vanuatisk tid",
               "",
            };
        final String[] Yakutsk = new String[] {
               "normaltid for Jakutsk",
               "",
               "sommertid for Jakutsk",
               "",
               "tidssone for Jakutsk",
               "",
            };
        final String[] Atlantic = new String[] {
               "normaltid for den nordamerikanske atlanterhavskysten",
               "AST",
               "sommertid for den nordamerikanske atlanterhavskysten",
               "ADT",
               "tidssone for den nordamerikanske atlanterhavskysten",
               "AT",
            };
        final String[] Brasilia = new String[] {
               "normaltid for Brasilia",
               "",
               "sommertid for Brasilia",
               "",
               "tidssone for Brasilia",
               "",
            };
        final String[] Chamorro = new String[] {
               "tidssone for Chamorro",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "colombiansk normaltid",
               "",
               "colombiansk sommertid",
               "",
               "colombiansk tid",
               "",
            };
        final String[] Falkland = new String[] {
               "normaltid for Falklands\u00f8yene",
               "",
               "sommertid for Falklands\u00f8yene",
               "",
               "tidssone for Falklands\u00f8yene",
               "",
            };
        final String[] Malaysia = new String[] {
               "malaysisk tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "maldivisk tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "normaltid for Ulan Bator",
               "",
               "sommertid for Ulan Bator",
               "",
               "tidssone for Ulan Bator",
               "",
            };
        final String[] Pakistan = new String[] {
               "pakistansk normaltid",
               "PKT",
               "pakistansk sommertid",
               "PKST",
               "pakistansk tid",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "paraguayansk normaltid",
               "",
               "paraguayansk sommertid",
               "",
               "paraguayansk tid",
               "",
            };
        final String[] Pitcairn = new String[] {
               "tidssone for Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "normaltid for Sakhalin",
               "",
               "sommertid for Sakhalin",
               "",
               "tidssone for Sakhalin",
               "",
            };
        final String[] Suriname = new String[] {
               "surinamsk tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "argentinsk normaltid",
               "",
               "argentinsk sommertid",
               "",
               "argentinsk tid",
               "",
            };
        final String[] Christmas = new String[] {
               "tidssone for Christmas\u00f8ya",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "tidssone for Gal\u00e1pagos\u00f8yene",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "normaltid for Hongkong",
               "HKT",
               "sommertid for Hongkong",
               "HKST",
               "tidssone for Hongkong",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "indokinesisk tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Russisk (Petropavlovsk-Kamtsjatskij) normaltid",
               "",
               "Russisk (Petropavlovsk-Kamtsjatskij) sommertid",
               "",
               "Russisk (Petropavlovsk-Kamtsjatskij) tid",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "kirgisisk tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "normaltid for Lord Howe-\u00f8ya",
               "",
               "sommertid for Lord Howe-\u00f8ya",
               "",
               "tidssone for Lord Howe-\u00f8ya",
               "",
            };
        final String[] Marquesas = new String[] {
               "tidssone for Marquesas\u00f8yene",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "mauritisk normaltid",
               "",
               "mauritisk sommertid",
               "",
               "mauritisk tid",
               "",
            };
        final String[] Singapore = new String[] {
               "singaporsk tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "venezuelansk tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "normaltid for Volgograd",
               "MSK",
               "sommertid for Volgograd",
               "MSK",
               "tidssone for Volgograd",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "aserbajdsjansk normaltid",
               "",
               "aserbajdsjansk sommertid",
               "",
               "aserbajdsjansk tid",
               "",
            };
        final String[] Bangladesh = new String[] {
               "bangladeshisk normaltid",
               "",
               "bangladeshisk sommertid",
               "",
               "bangladeshisk tid",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "kappverdisk normaltid",
               "",
               "kappverdisk sommertid",
               "",
               "kappverdisk tid",
               "",
            };
        final String[] East_Timor = new String[] {
               "\u00f8sttimoresisk tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "seychellisk tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "tadsjikisk tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "usbekisk normaltid",
               "",
               "usbekisk sommertid",
               "",
               "usbekisk tid",
               "",
            };
        final String[] Afghanistan = new String[] {
               "afghansk tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "normaltid for Krasnojarsk",
               "",
               "sommertid for Krasnojarsk",
               "",
               "tidssone for Krasnojarsk",
               "",
            };
        final String[] New_Zealand = new String[] {
               "newzealandsk normaltid",
               "NZST",
               "newzealandsk sommertid",
               "NZDT",
               "newzealandsk tid",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "normaltid for Novosibirsk",
               "",
               "sommertid for Novosibirsk",
               "",
               "tidssone for Novosibirsk",
               "",
            };
        final String[] Philippines = new String[] {
               "filippinsk normaltid",
               "PST",
               "filippinsk sommertid",
               "PDT",
               "filippinsk tid",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "normaltid for Vladivostok",
               "",
               "sommertid for Vladivostok",
               "",
               "tidssone for Vladivostok",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "tidssone for Indiahavet",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "tidssone for Linje\u00f8yene",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "normaltid for Newfoundland",
               "NST",
               "sommertid for Newfoundland",
               "NDT",
               "tidssone for Newfoundland",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "turkmensk normaltid",
               "",
               "turkmensk sommertid",
               "",
               "turkmensk tid",
               "",
            };
        final String[] French_Guiana = new String[] {
               "tidssone for Fransk Guyana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "kaledonsk normaltid",
               "",
               "kaledonsk sommertid",
               "",
               "kaledonsk tid",
               "",
            };
        final String[] South_Georgia = new String[] {
               "tidssone for S\u00f8r-Georgia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "normaltid for Jekaterinburg",
               "",
               "sommertid for Jekaterinburg",
               "",
               "tidssone for Jekaterinburg",
               "",
            };
        final String[] Africa_Central = new String[] {
               "sentralafrikansk tid",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "\u00f8stafrikansk tid",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "vestafrikansk normaltid",
               "WAT",
               "vestafrikansk sommertid",
               "WAT",
               "vestafrikansk tid",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "tidssone for Dumont d\u2019Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "sentraleuropeisk normaltid",
               "CET",
               "sentraleuropeisk sommertid",
               "CEST",
               "sentraleuropeisk tid",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "\u00f8steuropeisk normaltid",
               "EET",
               "\u00f8steuropeisk sommertid",
               "EEST",
               "\u00f8steuropeisk tid",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "vesteuropeisk normaltid",
               "WET",
               "vesteuropeisk sommertid",
               "WEST",
               "vesteuropeisk tid",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "normaltid for den meksikanske Stillehavskysten",
               "MST",
               "sommertid for den meksikanske Stillehavskysten",
               "MDT",
               "tidssone for den meksikanske Stillehavskysten",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "s\u00f8rafrikansk tid",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "normaltid for det sentrale Nord-Amerika",
               "CST",
               "sommertid for det sentrale Nord-Amerika",
               "CDT",
               "tidssone for det sentrale Nord-Amerika",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "normaltid for den nordamerikanske \u00f8stkysten",
               "EST",
               "sommertid for den nordamerikanske \u00f8stkysten",
               "EDT",
               "tidssone for den nordamerikanske \u00f8stkysten",
               "ET",
            };
        final String[] America_Pacific = new String[] {
               "normaltid for den nordamerikanske Stillehavskysten",
               "PST",
               "sommertid for den nordamerikanske Stillehavskysten",
               "PDT",
               "tidssone for den nordamerikanske Stillehavskysten",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "tidssone for De franske s\u00f8rterritorier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "tidssone for Gilbert\u00f8yene",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "normaltid for Hawaii og Aleutene",
               "HAST",
               "sommertid for Hawaii og Aleutene",
               "HADT",
               "tidssone for Hawaii og Aleutene",
               "HAT",
            };
        final String[] Phoenix_Islands = new String[] {
               "tidssone for Phoenix\u00f8yene",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "normaltid for Saint-Pierre-et-Miquelon",
               "",
               "sommertid for Saint-Pierre-et-Miquelon",
               "",
               "tidssone for Saint-Pierre-et-Miquelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "normaltid for Rocky Mountains (USA)",
               "MST",
               "sommertid for Rocky Mountains (USA)",
               "MDT",
               "tidssone for Rocky Mountains (USA)",
               "MT",
            };
        final String[] Marshall_Islands = new String[] {
               "marshallesisk tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "papuansk tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "sentralaustralsk normaltid",
               "ACST",
               "sentralaustralsk sommertid",
               "ACDT",
               "sentralaustralsk tid",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "\u00f8staustralsk normaltid",
               "AEST",
               "\u00f8staustralsk sommertid",
               "AEDT",
               "\u00f8staustralsk tid",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "vestaustralsk normaltid",
               "AWST",
               "vestaustralsk sommertid",
               "AWDT",
               "vestaustralsk tid",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "sentralindonesisk tid",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "\u00f8stindonesisk tid",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "vestindonesisk tid",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Kazakhstan_Western = new String[] {
               "vestkasakhstansk tid",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "vest-sentralaustralsk normaltid",
               "",
               "vest-sentralaustralsk sommertid",
               "",
               "vest-sentralaustralsk tid",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu",
                new String[] {
                    "normaltid for Hawaii og Aleutene",
                    "HST",
                    "sommertid for Hawaii og Aleutene",
                    "HDT",
                    "tidssone for Hawaii og Aleutene",
                    "HST",
                }
            },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Greenwich middeltid",
                    "GMT",
                    "britisk sommertid",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST",
                new String[] {
                    "normaltid for Hawaii og Aleutene",
                    "HST",
                    "sommertid for Hawaii og Aleutene",
                    "HDT",
                    "tidssone for Hawaii og Aleutene",
                    "HST",
                }
            },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "koordinert universaltid",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Greenwich middeltid",
                    "GMT",
                    "irsk sommertid",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "koordinert universaltid",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "koordinert universaltid",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Greenwich middeltid",
                    "GMT",
                    "britisk sommertid",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "koordinert universaltid",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan_Western },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii",
                new String[] {
                    "normaltid for Hawaii og Aleutene",
                    "HST",
                    "sommertid for Hawaii og Aleutene",
                    "HDT",
                    "tidssone for Hawaii og Aleutene",
                    "HST",
                }
            },
            { "Universal",
                new String[] {
                    "koordinert universaltid",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan_Western },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan_Western },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "koordinert universaltid",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Greenwich middeltid",
                    "GMT",
                    "irsk sommertid",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Greenwich middeltid",
                    "GMT",
                    "britisk sommertid",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Greenwich middeltid",
                    "GMT",
                    "britisk sommertid",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10",
                new String[] {
                    "normaltid for Hawaii og Aleutene",
                    "HST",
                    "sommertid for Hawaii og Aleutene",
                    "HDT",
                    "tidssone for Hawaii og Aleutene",
                    "HST",
                }
            },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Greenwich middeltid",
                    "GMT",
                    "britisk sommertid",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Greenwich middeltid",
                    "GMT",
                    "britisk sommertid",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston",
                new String[] {
                    "normaltid for Hawaii og Aleutene",
                    "HST",
                    "sommertid for Hawaii og Aleutene",
                    "HDT",
                    "tidssone for Hawaii og Aleutene",
                    "HST",
                }
            },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Greenwich middeltid",
                    "GMT",
                    "britisk sommertid",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Aqtau", "Aktau" },
            { "timezone.excity.Asia/Chita", "Tsjita" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Lome", "Lom\u00e9" },
            { "timezone.excity.Asia/Aqtobe", "Aqt\u00f6be" },
            { "timezone.excity.Asia/Muscat", "Muskat" },
            { "timezone.excity.Asia/Saigon", "Ho Chi Minh-byen" },
            { "timezone.excity.Asia/Tehran", "Teheran" },
            { "timezone.excity.Asia/Urumqi", "\u00dcr\u00fcmqi" },
            { "timezone.excity.Etc/Unknown", "ukjent by" },
            { "timezone.excity.Europe/Rome", "Roma" },
            { "timezone.excity.Indian/Mahe", "Mah\u00e9" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Cairo", "Kairo" },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "timezone.excity.Asia/Bishkek", "Bisjkek" },
            { "timezone.excity.Asia/Nicosia", "Nikosia" },
            { "timezone.excity.Asia/Thimphu", "Thimpu" },
            { "timezone.excity.Asia/Yakutsk", "Jakutsk" },
            { "timezone.excity.Asia/Yerevan", "Jerevan" },
            { "timezone.excity.Indian/Cocos", "Kokos\u00f8yene" },
            { "timezone.excity.America/Belem", "Bel\u00e9m" },
            { "timezone.excity.Asia/Ashgabat", "Asjkhabad" },
            { "timezone.excity.Asia/Damascus", "Damaskus" },
            { "timezone.excity.Asia/Dushanbe", "Dusjanbe" },
            { "timezone.excity.Asia/Jayapura", "Jajapura" },
            { "timezone.excity.Asia/Katmandu", "Katmandu" },
            { "timezone.excity.Asia/Qostanay", "Kostanaj" },
            { "timezone.excity.Asia/Tashkent", "Tasjkent" },
            { "timezone.excity.Europe/Athens", "Athen" },
            { "timezone.excity.Europe/Lisbon", "Lisboa" },
            { "timezone.excity.Europe/Moscow", "Moskva" },
            { "timezone.excity.Europe/Prague", "Praha" },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Vienna", "Wien" },
            { "timezone.excity.Europe/Warsaw", "Warszawa" },
            { "timezone.excity.Europe/Zurich", "Z\u00fcrich" },
            { "timezone.excity.Indian/Comoro", "Komorene" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Algiers", "Alger" },
            { "timezone.excity.America/Bogota", "Bogot\u00e1" },
            { "timezone.excity.America/Cayman", "Cayman\u00f8yene" },
            { "timezone.excity.America/Cuiaba", "Cuiab\u00e1" },
            { "timezone.excity.America/Maceio", "Macei\u00f3" },
            { "timezone.excity.Asia/Hong_Kong", "Hongkong" },
            { "timezone.excity.Asia/Kamchatka", "Kamtsjatka" },
            { "timezone.excity.Asia/Qyzylorda", "Kyzylorda" },
            { "timezone.excity.Europe/Vatican", "Vatikanstaten" },
            { "timezone.excity.Pacific/Easter", "P\u00e5ske\u00f8ya" },
            { "timezone.excity.Pacific/Kanton", "Kanton\u00f8ya" },
            { "timezone.excity.Pacific/Noumea", "Noum\u00e9a" },
            { "timezone.excity.Africa/El_Aaiun", "El Aai\u00fan" },
            { "timezone.excity.America/Cordoba", "C\u00f3rdoba" },
            { "timezone.excity.Asia/Choibalsan", "Choybalsan" },
            { "timezone.excity.Atlantic/Azores", "Asorene" },
            { "timezone.excity.Atlantic/Canary", "Kanari\u00f8yene" },
            { "timezone.excity.Atlantic/Faeroe", "F\u00e6r\u00f8yene" },
            { "timezone.excity.Europe/Belgrade", "Beograd" },
            { "timezone.excity.Europe/Brussels", "Brussel" },
            { "timezone.excity.Europe/Busingen", "B\u00fcsingen" },
            { "timezone.excity.Europe/Chisinau", "Chi\u0219in\u0103u" },
            { "timezone.excity.Europe/Helsinki", "Helsingfors" },
            { "timezone.excity.Indian/Maldives", "Maldivene" },
            { "timezone.excity.Pacific/Norfolk", "Norfolk\u00f8ya" },
            { "timezone.excity.America/Santarem", "Santar\u00e9m" },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnojarsk" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulan Bator" },
            { "timezone.excity.Europe/Bucharest", "Bucure\u0219ti" },
            { "timezone.excity.Europe/Ulyanovsk", "Uljanovsk" },
            { "timezone.excity.Indian/Christmas", "Christmas\u00f8ya" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.America/Araguaina", "Aragua\u00edna" },
            { "timezone.excity.America/Sao_Paulo", "S\u00e3o Paulo" },
            { "timezone.excity.Europe/Copenhagen", "K\u00f8benhavn" },
            { "timezone.excity.Europe/Luxembourg", "Luxemburg" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Pacific/Galapagos", "Gal\u00e1pagos\u00f8yene" },
            { "timezone.excity.Africa/Addis_Ababa", "Addis Abeba" },
            { "timezone.excity.Asia/Yekaterinburg", "Jekaterinburg" },
            { "timezone.excity.Atlantic/Reykjavik", "Reykjav\u00edk" },
            { "timezone.excity.Europe/Isle_of_Man", "Man" },
            { "timezone.excity.America/Mexico_City", "Mexico by" },
            { "timezone.excity.Atlantic/Cape_Verde", "Kapp Verde" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Dar-es-Salaam" },
            { "timezone.excity.America/St_Barthelemy", "Saint-Barth\u00e9lemy" },
            { "timezone.excity.America/Bahia_Banderas", "Bah\u00eda Banderas" },
            { "timezone.excity.Atlantic/South_Georgia", "S\u00f8r-Georgia" },
            { "timezone.excity.America/Argentina/Tucuman", "Tucum\u00e1n" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Nord-Dakota" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Nord-Dakota" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Nord-Dakota" },
        };
        return data;
    }
}
