/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib;

import java.security.MessageDigest;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SigTestUtil {
    private static final String[] DIGEST_ALGS = new String[]{"SHA3-512", "SHA-512", "SHA3-384", "SHA-384", "SHA3-256", "SHA-256", "SHA-512/256", "SHA3-224", "SHA-224", "SHA-512/224", "SHA-1", "MD2", "MD5"};
    private static final int PKCS1_5_INDEX_768 = 0;
    private static final int PKCS1_5_INDEX_512 = 4;
    private static final int PKCS1_5_INDEX_END = DIGEST_ALGS.length;
    private static final int PSS_INDEX_2048 = 0;
    private static final int PSS_INDEX_1024 = 2;
    private static final int PSS_INDEX_768 = 4;
    private static final int PSS_INDEX_512 = 7;
    private static final int PSS_INDEX_END = DIGEST_ALGS.length - 2;

    public static Iterable<String> getDigestAlgorithms(SignatureType type, int keysize) throws RuntimeException {
        List<String> result = new ArrayList<String>(Arrays.asList(DIGEST_ALGS));
        int index = 0;
        switch (type.ordinal()) {
            case 0: {
                if (keysize >= 768) {
                    index = 0;
                } else if (keysize >= 512) {
                    index = 4;
                } else {
                    throw new RuntimeException("Keysize too small: " + keysize);
                }
                result = result.subList(index, PKCS1_5_INDEX_END);
                break;
            }
            case 1: {
                if (keysize >= 2048) {
                    index = 0;
                } else if (keysize >= 1024) {
                    index = 2;
                } else if (keysize >= 768) {
                    index = 4;
                } else if (keysize >= 512) {
                    index = 7;
                } else {
                    throw new RuntimeException("Keysize too small: " + keysize);
                }
                result = result.subList(index, PSS_INDEX_END);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported signature type: " + String.valueOf((Object)type));
            }
        }
        return result;
    }

    public static AlgorithmParameterSpec generateDefaultParameter(SignatureType type, String mdAlg) throws RuntimeException {
        switch (type.ordinal()) {
            case 1: {
                try {
                    MessageDigest md = MessageDigest.getInstance(mdAlg);
                    return new PSSParameterSpec(mdAlg, "MGF1", new MGF1ParameterSpec(mdAlg), md.getDigestLength(), 1);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return null;
    }

    public static String generateSigAlg(SignatureType type, String mdAlg) throws RuntimeException {
        switch (type.ordinal()) {
            case 0: {
                if (((String)mdAlg).startsWith("SHA-")) {
                    mdAlg = ((String)mdAlg).substring(0, 3) + ((String)mdAlg).substring(4);
                }
                return (String)mdAlg + "with" + type.toString();
            }
            case 1: {
                return type.toString();
            }
        }
        throw new RuntimeException("Unsupported signature type " + String.valueOf((Object)type));
    }

    public static enum SignatureType {
        RSA("RSA"),
        RSASSA_PSS("RSASSA-PSS");

        private String keyAlg;

        private SignatureType(String keyAlg) {
            this.keyAlg = keyAlg;
        }

        public String toString() {
            return this.keyAlg;
        }
    }
}

