/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.artifacts;

import java.io.UncheckedIOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import jdk.test.lib.artifacts.Artifact;
import jdk.test.lib.artifacts.ArtifactManager;
import jdk.test.lib.artifacts.ArtifactResolverException;
import jdk.test.lib.artifacts.DefaultArtifactManager;

public class JibArtifactManager
implements ArtifactManager {
    private static final String JIB_SERVICE_FACTORY = "com.oracle.jib.api.JibServiceFactory";
    public static final String JIB_HOME_ENV_NAME = "JIB_HOME";
    private static String jibVersion = "1.0";
    private Object installerObject;
    private ClassLoader classLoader;

    private JibArtifactManager(Object installerObject, ClassLoader classLoader) {
        this.installerObject = installerObject;
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JibArtifactManager newInstance() throws ClassNotFoundException {
        URL[] jarUrls;
        Path jibInstallDir = Paths.get(System.getenv(JIB_HOME_ENV_NAME), new String[0]);
        Path libDir = jibInstallDir.resolve("lib");
        if (!Files.isDirectory(libDir, new LinkOption[0])) {
            throw new ClassNotFoundException(JIB_SERVICE_FACTORY);
        }
        try (Stream<Path> files = Files.list(libDir);){
            jarUrls = (URL[])files.filter(path -> path.toString().endsWith(".jar")).map(path -> {
                try {
                    return path.toUri().toURL();
                }
                catch (MalformedURLException e) {
                    throw new UncheckedIOException(e);
                }
            }).toArray(URL[]::new);
        }
        URLClassLoader classLoader = new URLClassLoader(jarUrls, JibArtifactManager.class.getClassLoader().getParent());
        Thread currentThread = Thread.currentThread();
        ClassLoader oldContextLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(classLoader);
        Class<?> jibServiceFactory = classLoader.loadClass(JIB_SERVICE_FACTORY);
        try {
            Object jibArtifactInstaller = jibServiceFactory.getMethod("createJibArtifactInstaller", new Class[0]).invoke(null, new Object[0]);
            JibArtifactManager jibArtifactManager = new JibArtifactManager(jibArtifactInstaller, classLoader);
            currentThread.setContextClassLoader(oldContextLoader);
            return jibArtifactManager;
        }
        catch (Throwable throwable) {
            try {
                currentThread.setContextClassLoader(oldContextLoader);
                throw throwable;
            }
            catch (Exception e) {
                throw new ClassNotFoundException(JIB_SERVICE_FACTORY, e);
            }
        }
    }

    private Path download(String jibVersion, Map<String, Object> artifactDescription) throws Exception {
        return this.invokeInstallerMethod("download", jibVersion, artifactDescription);
    }

    private Path install(String jibVersion, Map<String, Object> artifactDescription) throws Exception {
        return this.invokeInstallerMethod("install", jibVersion, artifactDescription);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path invokeInstallerMethod(String methodName, String jibVersion, Map<String, Object> artifactDescription) throws Exception {
        Thread currentThread = Thread.currentThread();
        ClassLoader oldContextLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(this.classLoader);
        try {
            Method m = this.classLoader.loadClass("com.oracle.jib.api.JibArtifactInstaller").getMethod(methodName, String.class, Map.class);
            Path path = (Path)m.invoke(this.installerObject, jibVersion, artifactDescription);
            return path;
        }
        finally {
            currentThread.setContextClassLoader(oldContextLoader);
        }
    }

    @Override
    public Path resolve(Artifact artifact) throws ArtifactResolverException {
        HashMap<String, Object> artifactDescription = new HashMap<String, Object>();
        artifactDescription.put("module", artifact.name());
        artifactDescription.put("organization", artifact.organization());
        artifactDescription.put("ext", artifact.extension());
        artifactDescription.put("revision", artifact.revision());
        if (artifact.classifier().length() > 0) {
            artifactDescription.put("classifier", artifact.classifier());
        }
        return this.resolve(artifact.name(), artifactDescription, artifact.unpack());
    }

    @Override
    public Path resolve(String name, Map<String, Object> artifactDescription, boolean unpack) throws ArtifactResolverException {
        Path path;
        try {
            DefaultArtifactManager manager = new DefaultArtifactManager();
            path = manager.resolve(name);
        }
        catch (ArtifactResolverException e) {
            try {
                path = this.download(jibVersion, artifactDescription);
                if (unpack) {
                    path = this.install(jibVersion, artifactDescription);
                }
            }
            catch (Exception e2) {
                throw new ArtifactResolverException("Failed to resolve the artifact " + name, e2);
            }
        }
        return path;
    }
}

