/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.hprof.parser;

import java.io.IOException;
import java.io.RandomAccessFile;
import jdk.test.lib.hprof.parser.ReadBuffer;

class FileReadBuffer
implements ReadBuffer {
    private RandomAccessFile file;

    FileReadBuffer(RandomAccessFile file) {
        this.file = file;
    }

    private void seek(long pos) throws IOException {
        this.file.getChannel().position(pos);
    }

    public synchronized void get(long pos, byte[] buf) throws IOException {
        this.seek(pos);
        this.file.read(buf);
    }

    @Override
    public synchronized char getChar(long pos) throws IOException {
        this.seek(pos);
        return this.file.readChar();
    }

    @Override
    public synchronized byte getByte(long pos) throws IOException {
        this.seek(pos);
        return (byte)this.file.read();
    }

    @Override
    public synchronized short getShort(long pos) throws IOException {
        this.seek(pos);
        return this.file.readShort();
    }

    @Override
    public synchronized int getInt(long pos) throws IOException {
        this.seek(pos);
        return this.file.readInt();
    }

    @Override
    public synchronized long getLong(long pos) throws IOException {
        this.seek(pos);
        return this.file.readLong();
    }

    @Override
    public void close() throws Exception {
        this.file.close();
    }
}

