/*
 * Copyright (c) 2015, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * @test
 * @bug 8072945 8081854 8141492 8148985 8150188 4649116 8173707 8151743 8169819 8183037 8182765 8196202
 *      8202624 8210047 8184205 8221871 8223733 8223378 8261976
 * @summary Test the version of HTML generated by the javadoc tool.
 * @library ../../lib
 * @modules jdk.javadoc/jdk.javadoc.internal.tool
 * @build javadoc.tester.*
 * @run main TestHtmlVersion
 */

import javadoc.tester.JavadocTester;

public class TestHtmlVersion extends JavadocTester {

    public static void main(String... args) throws Exception {
        var tester = new TestHtmlVersion();
        tester.runTests();
    }

    @Test
    public void test1() {
        javadoc("-d", "out-1",
                "-private",
                "-linksource",
                "-bottom", "bottom text",
                "-sourcepath", testSrc,
                "-use",
                "pkg", "pkg1", "pkg2", "pkg3");
        checkExit(Exit.OK);

        html5Output();
        html5NegatedOutput();
    }

    @Test
    public void test4() {
        javadoc("-d", "out-4",
                "-private",
                "-linksource",
                "-bottom", "bottom text",
                "-sourcepath", testSrc,
                "-use",
                "pkg3");
        checkExit(Exit.OK);
    }

    void html5Output() {
        // Test for overview-summary page
        checkOutput("index.html", true,
                "<!DOCTYPE HTML>",
                "<meta name=\"dc.created\"",
                """
                    <ul id="navbar-top-firstrow" class="nav-list" title="Navigation">
                    """,
                """
                    <div id="all-packages-table">
                    <div class="caption"><span>Packages</span></div>
                    <div class="summary-table two-column-summary">""",
                """
                    <header role="banner">
                    <nav role="navigation">
                    <!-- ========= START OF TOP NAVBAR ======= -->""",
                """
                    <footer role="contentinfo">""",
                """
                    bottom text""");

        // Test for package-summary page
        checkOutput("pkg/package-summary.html", true,
                "<!DOCTYPE HTML>",
                "<meta name=\"dc.created\"",
                """
                    <ul id="navbar-top-firstrow" class="nav-list" title="Navigation">
                    """,
                """
                    <div class="summary-table two-column-summary" aria-labelledby="class-summary-tab0">""",
                """
                    <header role="banner">
                    <nav role="navigation">
                    <!-- ========= START OF TOP NAVBAR ======= -->""",
                """
                    <main role="main">
                    <div class="header">""",
                """
                    <section class="package-description" id="package-description">
                    <div class="block">Test package.</div>""",
                """
                    <footer role="contentinfo">""",
                """
                    bottom text""");
        // No package description
        checkOutput("pkg1/package-summary.html", true,
                """
                        <section class="summary">
                        <ul class="summary-list">
                        <li>
                        <div id="class-summary">
                        <div class="caption"><span>Classes</span></div>
                        <div class="summary-table two-column-summary">""");

        // Test for package-tree page
        checkOutput("pkg/package-tree.html", true,
                "<!DOCTYPE HTML>",
                "<meta name=\"dc.created\"",
                """
                    <ul id="navbar-top-firstrow" class="nav-list" title="Navigation">
                    """,
                "<li class=\"circle\">",
                """
                    <header role="banner">
                    <nav role="navigation">
                    <!-- ========= START OF TOP NAVBAR ======= -->""",
                """
                    <main role="main">
                    <div class="header">""",
                """
                    <section class="hierarchy">
                    <h2 title="Class Hierarchy">Class Hierarchy</h2>""",
                """
                    <section class="hierarchy">
                    <h2 title="Interface Hierarchy">Interface Hierarchy</h2>""",
                """
                    <section class="hierarchy">
                    <h2 title="Annotation Interface Hierarchy">Annotation Interface Hierarchy</h2>""",
                """
                    <section class="hierarchy">
                    <h2 title="Enum Class Hierarchy">Enum Class Hierarchy</h2>""",
                """
                    <footer role="contentinfo">""",
                """
                    bottom text""" );

        // Test for package-use page
        checkOutput("pkg1/package-use.html", true,
                "<!DOCTYPE HTML>",
                "<meta name=\"dc.created\"",
                """
                    <ul id="navbar-top-firstrow" class="nav-list" title="Navigation">
                    """,
                """
                    <div class="summary-table two-column-summary">""",
                """
                    <header role="banner">
                    <nav role="navigation">
                    <!-- ========= START OF TOP NAVBAR ======= -->""",
                """
                    <main role="main">
                    <div class="header">""",
                """
                    <footer role="contentinfo">""",
                """
                    bottom text""");

        // Test for constant-values page
        checkOutput("constant-values.html", true,
                "<!DOCTYPE HTML>",
                "<meta name=\"dc.created\"",
                """
                    <ul id="navbar-top-firstrow" class="nav-list" title="Navigation">
                    """,
                """
                    <div class="summary-table three-column-summary">""",
                """
                    <header role="banner">
                    <nav role="navigation">
                    <!-- ========= START OF TOP NAVBAR ======= -->""",
                """
                    <main role="main">
                    <div class="header">""",
                """
                    <section class="packages">
                    <h2 title="Contents">Contents</h2>
                    """,
                """
                    <section class="constants-summary" id="pkg">
                    <h2 title="pkg.*">pkg.*</h2>
                    """,
                """
                    <footer role="contentinfo">""",
                """
                    bottom text""");

        // Test for deprecated-list page
        checkOutput("deprecated-list.html", true,
                "<!DOCTYPE HTML>",
                "<meta name=\"dc.created\"",
                """
                    <ul id="navbar-top-firstrow" class="nav-list" title="Navigation">
                    """,
                """
                    <div class="summary-table two-column-summary">""",
                """
                    <header role="banner">
                    <nav role="navigation">
                    <!-- ========= START OF TOP NAVBAR ======= -->""",
                """
                    <main role="main">
                    <div class="header">""",
                """
                    <footer role="contentinfo">""",
                """
                    bottom text""");

        // Test for serialized-form page
        checkOutput("serialized-form.html", true,
                "<!DOCTYPE HTML>",
                "<meta name=\"dc.created\"",
                """
                    <ul id="navbar-top-firstrow" class="nav-list" title="Navigation">
                    """,
                """
                    <header role="banner">
                    <nav role="navigation">
                    <!-- ========= START OF TOP NAVBAR ======= -->""",
                """
                    <main role="main">
                    <div class="header">""",
                """
                    <section class="serialized-package-container">
                    <h2 title="Package">Package&nbsp;<a href="pkg/package-summary.html">pkg</a></h2>
                    """,
                """
                    <footer role="contentinfo">""",
                """
                    bottom text""");

        // Test for overview-tree page
        checkOutput("overview-tree.html", true,
                "<!DOCTYPE HTML>",
                "<meta name=\"dc.created\"",
                """
                    <ul id="navbar-top-firstrow" class="nav-list" title="Navigation">
                    """,
                "<li class=\"circle\">",
                """
                    <header role="banner">
                    <nav role="navigation">
                    <!-- ========= START OF TOP NAVBAR ======= -->""",
                """
                    <main role="main">
                    <div class="header">""",
                """
                    <section class="hierarchy">
                    <h2 title="Class Hierarchy">Class Hierarchy</h2>
                    """,
                """
                    <section class="hierarchy">
                    <h2 title="Interface Hierarchy">Interface Hierarchy</h2>
                    """,
                """
                    <section class="hierarchy">
                    <h2 title="Annotation Interface Hierarchy">Annotation Interface Hierarchy</h2>
                    """,
                """
                    <section class="hierarchy">
                    <h2 title="Enum Class Hierarchy">Enum Class Hierarchy</h2>
                    """,
                """
                    <footer role="contentinfo">""",
                """
                    bottom text""");

        // Test for index-all page
        checkOutput("index-all.html", true,
                "<!DOCTYPE HTML>",
                "<meta name=\"dc.created\"",
                """
                    <ul id="navbar-top-firstrow" class="nav-list" title="Navigation">
                    """,
                """
                    <header role="banner">
                    <nav role="navigation">
                    <!-- ========= START OF TOP NAVBAR ======= -->""",
                """
                    </header>
                    <main role="main">""",
                """
                    <footer role="contentinfo">""",
                """
                    bottom text""");

        // Test for src-html page
        checkOutput("src-html/pkg/AnotherClass.html", true,
                "<!DOCTYPE HTML>",
                """
                    <main role="main">
                    <div class="source-container">""");

        // Test for help-doc page
        checkOutput("help-doc.html", true,
                "<!DOCTYPE HTML>",
                "<meta name=\"dc.created\"",
                """
                    <ul id="navbar-top-firstrow" class="nav-list" title="Navigation">
                    """,
                """
                    <header role="banner">
                    <nav role="navigation">
                    <!-- ========= START OF TOP NAVBAR ======= -->""",
                """
                    <main role="main">
                    <h1 class="title">JavaDoc Help</h1>""",
                """
                    <section class="help-section" id="overview">
                    <h3>Overview</h3>
                    """,
                """
                    <section class="help-section" id="package">
                    <h3>Package</h3>
                    """,
                """
                    <section class="help-section" id="class">
                    <h3>Class or Interface</h3>
                    """,
                """
                    <footer role="contentinfo">""",
                """
                    bottom text""");

        // Test for a regular class page and members (nested class, field, constructore and method)
        checkOutput("pkg/AnotherClass.html", true,
                "<!DOCTYPE HTML>",
                "<meta name=\"dc.created\"",
                """
                    <ul id="navbar-top-firstrow" class="nav-list" title="Navigation">
                    """,
                """
                    <header role="banner">
                    <nav role="navigation">
                    <!-- ========= START OF TOP NAVBAR ======= -->""",
                """
                    <main role="main">
                    <!-- ======== START OF CLASS DATA ======== -->
                    <div class="header">""",
                """
                    <section class="nested-class-summary" id="nested-class-summary">
                    <h2>Nested Class Summary</h2>
                    <div class="caption"><span>Nested Classes</span></div>
                    <div class="summary-table three-column-summary">""",
                """
                    <section class="field-summary" id="field-summary">
                    <h2>Field Summary</h2>
                    <div class="caption"><span>Fields</span></div>
                    <div class="summary-table three-column-summary">""",
                """
                    <section class="constructor-summary" id="constructor-summary">
                    <h2>Constructor Summary</h2>
                    <div class="caption"><span>Constructors</span></div>
                    <div class="summary-table two-column-summary">""",
                """
                    <section class="method-summary" id="method-summary">
                    <h2>Method Summary</h2>""",
                """
                    <section class="field-details" id="field-detail">
                    <h2>Field Details</h2>
                    """,
                """
                    <section class="constructor-details" id="constructor-detail">
                    <h2>Constructor Details</h2>
                    """,
                """
                    <section class="method-details" id="method-detail">
                    <h2>Method Details</h2>
                    """,
                """
                    <footer role="contentinfo">""",
                """
                    bottom text""");

        // Test for enum page
        checkOutput("pkg/AnotherClass.ModalExclusionType.html", true,
                "<!DOCTYPE HTML>",
                "<meta name=\"dc.created\"",
                """
                    <ul id="navbar-top-firstrow" class="nav-list" title="Navigation">
                    """,
                """
                    <header role="banner">
                    <nav role="navigation">
                    <!-- ========= START OF TOP NAVBAR ======= -->""",
                """
                    <main role="main">
                    <!-- ======== START OF CLASS DATA ======== -->
                    <div class="header">""",
                """
                    <section class="constants-summary" id="enum-constant-summary">
                    <h2>Enum Constant Summary</h2>
                    <div class="caption"><span>Enum Constants</span></div>
                    """,
                """
                    <div class="summary-table three-column-summary" aria-labelledby="method-summary-table-tab0">
                    """,
                """
                    <section class="method-summary" id="method-summary">
                    <h2>Method Summary</h2>
                    <div id="method-summary-table">
                    """,
                """
                    <section class="constant-details" id="enum-constant-detail">
                    <h2>Enum Constant Details</h2>
                    """,
                """
                    <section class="method-details" id="method-detail">
                    <h2>Method Details</h2>
                    """,
                """
                    <footer role="contentinfo">""",
                """
                    bottom text""");

        // Test for interface page
        checkOutput("pkg2/Interface.html", true,
                "<!DOCTYPE HTML>",
                "<meta name=\"dc.created\"",
                """
                    <ul id="navbar-top-firstrow" class="nav-list" title="Navigation">
                    """,
                """
                    <header role="banner">
                    <nav role="navigation">
                    <!-- ========= START OF TOP NAVBAR ======= -->""",
                """
                    <main role="main">
                    <!-- ======== START OF CLASS DATA ======== -->
                    <div class="header">""",
                """
                    <section class="method-summary" id="method-summary">
                    <h2>Method Summary</h2>
                    <div id="method-summary-table">
                    """,
                """
                    <div class="summary-table three-column-summary" aria-labelledby="method-summary-table-tab0">
                    """,
                """
                    <section class="method-details" id="method-detail">
                    <h2>Method Details</h2>
                    """,
                """
                    <footer role="contentinfo">""",
                """
                    bottom text""");

        // Test for error page
        checkOutput("pkg/TestError.html", true,
                "<!DOCTYPE HTML>",
                "<meta name=\"dc.created\"",
                """
                    <ul id="navbar-top-firstrow" class="nav-list" title="Navigation">
                    """,
                """
                    <header role="banner">
                    <nav role="navigation">
                    <!-- ========= START OF TOP NAVBAR ======= -->""",
                """
                    <main role="main">
                    <!-- ======== START OF CLASS DATA ======== -->
                    <div class="header">""",
                """
                    <section class="constructor-summary" id="constructor-summary">
                    <h2>Constructor Summary</h2>""",
                """
                    <section class="constructor-details" id="constructor-detail">
                    <h2>Constructor Details</h2>
                    """,
                """
                    <footer role="contentinfo">""",
                """
                    bottom text""");

        // Test for exception page
        checkOutput("pkg/TestException.html", true,
                "<!DOCTYPE HTML>",
                "<meta name=\"dc.created\"",
                """
                    <ul id="navbar-top-firstrow" class="nav-list" title="Navigation">
                    """,
                """
                    <header role="banner">
                    <nav role="navigation">
                    <!-- ========= START OF TOP NAVBAR ======= -->""",
                """
                    <main role="main">
                    <!-- ======== START OF CLASS DATA ======== -->
                    <div class="header">""",
                """
                    <section class="constructor-summary" id="constructor-summary">
                    <h2>Constructor Summary</h2>""",
                """
                    <section class="constructor-details" id="constructor-detail">
                    <h2>Constructor Details</h2>
                    """,
                """
                    <footer role="contentinfo">""",
                """
                    bottom text""");

        // Test for annotation page
        checkOutput("pkg2/TestAnnotationType.html", true,
                "<!DOCTYPE HTML>",
                "<meta name=\"dc.created\"",
                """
                    <ul id="navbar-top-firstrow" class="nav-list" title="Navigation">
                    """,
                """
                    <header role="banner">
                    <nav role="navigation">
                    <!-- ========= START OF TOP NAVBAR ======= -->""",
                """
                    <main role="main">
                    <!-- ======== START OF CLASS DATA ======== -->
                    <div class="header">""",
                """
                    <section class="member-summary" id="annotation-interface-required-element-summary">
                    <h2>Required Element Summary</h2>
                    <div class="caption"><span>Required Elements</span></div>
                    <div class="summary-table three-column-summary">""",
                """
                    <section class="member-summary" id="annotation-interface-optional-element-summary">
                    <h2>Optional Element Summary</h2>
                    <div class="caption"><span>Optional Elements</span></div>
                    <div class="summary-table three-column-summary">""",
                """
                    <section class="details" id="annotation-interface-element-detail">
                    <ul class="details-list">
                    <!-- ============ ANNOTATION INTERFACE MEMBER DETAIL =========== -->
                    <li>
                    <section class="member-details">
                    <h2>Element Details</h2>
                    """,
                """
                    <footer role="contentinfo">""",
                """
                    bottom text""");

        // Test for class use page
        checkOutput("pkg1/class-use/RegClass.html", true,
                "<!DOCTYPE HTML>",
                "<meta name=\"dc.created\"",
                """
                    <ul id="navbar-top-firstrow" class="nav-list" title="Navigation">
                    """,
                """
                    <header role="banner">
                    <nav role="navigation">
                    <!-- ========= START OF TOP NAVBAR ======= -->""",
                """
                    <main role="main">
                    <div class="header">""",
                """
                    <div class="summary-table two-column-summary">""",
                """
                    <section class="detail" id="pkg">
                    <h2>Uses of <a href="../RegClass.html" title="class in pkg1">RegClass</a> in <a \
                    href="../../pkg/package-summary.html">pkg</a></h2>
                    <div class="caption"><span>Fields in <a href="../../pkg/package-summary.html">pk\
                    g</a> declared as <a href="../RegClass.html" title="class in pkg1">RegClass</a><\
                    /span></div>
                    <div class="summary-table three-column-summary">""",
                """
                    <footer role="contentinfo">""",
                """
                    bottom text""");
    }

    void html5NegatedOutput() {
        // Negated test for overview-summary page
        checkOutput("overview-summary.html", false,
                """
                    <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">""",
                "<meta name=\"date\"",
                """
                    <a name="navbar-top-firstrow">
                    <!--   -->
                    </a>""",
                """
                    <table summary="Package Summary table, listing packages, and an explanation">
                    <caption>""",
                """
                    </noscript>
                    <!-- ========= START OF TOP NAVBAR ======= -->""");

        // Negated test for package-summary page
        checkOutput("pkg/package-summary.html", false,
                """
                    <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">""",
                "<meta name=\"date\"",
                """
                    <a name="navbar-top-firstrow">
                    <!--   -->
                    </a>""",
                """
                    <section>
                    <h2 title="PackageAnotherClass.ModalExclusionType.html pkg Description">Package pkg Description</h2>
                    """,
                """
                    <div class="type-summary">
                    <table summary="Interface Summary table, listing interfaces, and an explanation">""",
                """
                    <div class="type-summary">
                    <table summary="Class Summary table, listing classes, and an explanation">""",
                """
                    <div class="type-summary">
                    <table summary="Enum Summary table, listing enums, and an explanation">""",
                """
                    <div class="type-summary">
                    <table summary="Exception Summary table, listing exceptions, and an explanation">""",
                """
                    <div class="type-summary">
                    <table summary="Error Summary table, listing errors, and an explanation">""",
                """
                    <div class="type-summary">
                    <table summary="Annotation Types Summary table, listing annotation types, and an explanation">""");

        // Negated test for package-tree page
        checkOutput("pkg/package-tree.html", false,
                """
                    <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">""",
                "<meta name=\"date\"",
                """
                    <a name="navbar-top-firstrow">
                    <!--   -->
                    </a>""");

        // Negated test for package-use page
        checkOutput("pkg1/package-use.html", false,
                """
                    <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">""",
                "<meta name=\"date\"",
                """
                    <a name="navbar-top-firstrow">
                    <!--   -->
                    </a>""",
                """
                    <div class="use-summary">
                    <table summary="Use table, listing packages, and an explanation">""");

        // Negated test for constant-values page
        checkOutput("constant-values.html", false,
                """
                    <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">""",
                "<meta name=\"date\"",
                """
                    <a name="navbar-top-firstrow">
                    <!--   -->
                    </a>""",
                """
                    <!-- ========= END OF TOP NAVBAR ========= -->
                    </div>
                    <div class="header">""",
                """
                    <div class="constants-summary">
                    <table summary="Constant Field Values table, listing constant fields, and values">""");

        // Negated test for deprecated-list page
        checkOutput("deprecated-list.html", false,
                """
                    <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">""",
                "<meta name=\"date\"",
                """
                    <a name="navbar-top-firstrow">
                    <!--   -->
                    </a>""",
                """
                    <!-- ========= END OF TOP NAVBAR ========= -->
                    </div>
                    <div class="header">
                    <h1 title="Deprecated API" class="title">Deprecated API</h1>
                    <h2 title="Contents">Contents</h2>""",
                """
                    <div class="deprecated-summary">
                    <table summary="Classes table, listing classes, and an explanation">""",
                """
                    <div class="deprecated-summary">
                    <table summary="Enums table, listing enums, and an explanation">""",
                """
                    <div class="deprecated-summary">
                    <table summary="Exceptions table, listing exceptions, and an explanation">""",
                """
                    <div class="deprecated-summary">
                    <table summary="Errors table, listing errors, and an explanation">""",
                """
                    <div class="deprecated-summary">
                    <table summary="Annotation Types table, listing annotation types, and an explanation">""",
                """
                    <div class="deprecated-summary">
                    <table summary="Fields table, listing fields, and an explanation">""",
                """
                    <div class="deprecated-summary">
                    <table summary="Methods table, listing methods, and an explanation">""",
                """
                    <div class="deprecated-summary">
                    <table summary="Constructors table, listing constructors, and an explanation">""",
                """
                    <div class="deprecated-summary">
                    <table summary="Enum Constants table, listing enum constants, and an explanation">""",
                """
                    <div class="deprecated-summary">
                    <table summary="Annotation Type Elements table, listing annotation type elements, and an explanation">""");

        // Negated test for serialized-form page
        checkOutput("serialized-form.html", false,
                """
                    <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">""",
                "<meta name=\"date\"",
                """
                    <a name="navbar-top-firstrow">
                    <!--   -->
                    </a>""",
                """
                    <!-- ========= END OF TOP NAVBAR ========= -->
                    </div>
                    <div class="header">""",
                """
                    <li>
                    <h2 title="Package">Package&nbsp;pkg</h2>""");

        // Negated test for overview-tree page
        checkOutput("overview-tree.html", false,
                """
                    <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">""",
                "<meta name=\"date\"",
                """
                    <a name="navbar-top-firstrow">
                    <!--   -->
                    </a>""",
                """
                    <!-- ========= END OF TOP NAVBAR ========= -->
                    </div>
                    <div class="header">""",
                """
                    <div class="contentContainer">
                    <h2 title="Class Hierarchy">Class Hierarchy</h2>""",
                """
                    </ul>
                    <h2 title="Interface Hierarchy">Interface Hierarchy</h2>""",
                """
                    </ul>
                    <h2 title="Enum Class Hierarchy">Enum Class Hierarchy</h2>""");

        // Negated test for index-all page
        checkOutput("index-all.html", false,
                """
                    <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">""",
                "<meta name=\"date\"",
                """
                    <a name="navbar-top-firstrow">
                    <!--   -->
                    </a>""",
                """
                    <!-- ========= END OF TOP NAVBAR ========= -->
                    </div>
                    <div class="contentContainer">""");

        // Negated test for src-html page
        checkOutput("src-html/pkg/AnotherClass.html", false,
                """
                    <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">""",
                """
                    <body>
                    <div class="source-container">""");

        // Negated test for help-doc page
        checkOutput("help-doc.html", false,
                """
                    <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">""",
                "<meta name=\"date\"",
                """
                    <a name="navbar-top-firstrow">
                    <!--   -->
                    </a>""",
                """
                    <!-- ========= END OF TOP NAVBAR ========= -->
                    </div>
                    <div class="header">""",
                """
                    <ul class="block-list">
                    <li>
                    <h2>Overview</h2>""",
                "<li>\n"
                + "<h2>Package</h2>",
                "<li>\n"
                + "<h2>Class/Interface</h2>");

        // Negated test for a regular class page and members (nested class, field, constructore and method)
        checkOutput("pkg/AnotherClass.html", false,
                """
                    <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">""",
                "<meta name=\"date\"",
                """
                    <a name="navbar-top-firstrow">
                    <!--   -->
                    </a>""",
                """
                    <!-- ======== NESTED CLASS SUMMARY ======== -->
                    <ul class="block-list">
                    <li><a name="nested.class.summary">
                    <!--   -->
                    </a>
                    <h2>Nested Class Summary</h2>
                    <div class="member-summary">
                    <table summary="Nested Class Summary table, listing nested classes, and an explanation">""",
                """
                    <!-- =========== FIELD SUMMARY =========== -->
                    <ul class="block-list">
                    <li><a name="field.summary">
                    <!--   -->
                    </a>
                    <h2>Field Summary</h2>
                    <div class="member-summary">
                    <table summary="Field Summary table, listing fields, and an explanation">""",
                """
                    <!-- ======== CONSTRUCTOR SUMMARY ======== -->
                    <ul class="block-list">
                    <li><a name="constructor.summary">
                    <!--   -->
                    </a>
                    <h2>Constructor Summary</h2>
                    <div class="member-summary">
                    <table summary="Constructor Summary table, listing constructors, and an explanation">""",
                """
                    <!-- ========== METHOD SUMMARY =========== -->
                    <ul class="block-list">
                    <li><a name="method.summary">
                    <!--   -->
                    </a>
                    <h2>Method Summary</h2>
                    <div class="member-summary">
                    <table summary="Method Summary table, listing methods, and an explanation">""",
                """
                    <!-- ============ FIELD DETAIL =========== -->
                    <ul class="block-list">
                    <li><a name="field.detail">
                    <!--   -->
                    </a>
                    <h2>Field Details</h2>""",
                """
                    <!-- ========= CONSTRUCTOR DETAIL ======== -->
                    <ul class="block-list">
                    <li><a name="constructor.detail">
                    <!--   -->
                    </a>
                    <h2>Constructor Details</h2>""",
                """
                    <!-- ============ METHOD DETAIL ========== -->
                    <ul class="block-list">
                    <li><a name="method.detail">
                    <!--   -->
                    </a>
                    <h2>Method Details</h2>""");

        // Negated test for enum page
        checkOutput("pkg/AnotherClass.ModalExclusionType.html", false,
                """
                    <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">""",
                "<meta name=\"date\"",
                """
                    <a name="navbar-top-firstrow">
                    <!--   -->
                    </a>""",
                """
                    <!-- =========== ENUM CONSTANT SUMMARY =========== -->
                    <ul class="block-list">
                    <li><a name="enum.constant.summary">
                    <!--   -->
                    </a>
                    <h2>Enum Constant Summary</h2>
                    <div class="member-summary">
                    <table summary="Enum Constant Summary table, listing enum constants, and an explanation">""",
                """
                    <!-- ========== METHOD SUMMARY =========== -->
                    <ul class="block-list">
                    <li><a name="method.summary">
                    <!--   -->
                    </a>
                    <h2>Method Summary</h2>
                    <div class="member-summary">
                    <table summary="Method Summary table, listing methods, and an explanation">""",
                """
                    <!-- ============ ENUM CONSTANT DETAIL =========== -->
                    <ul class="block-list">
                    <li><a name="enum.constant.detail">
                    <!--   -->
                    </a>
                    <h2>Enum Constant Details</h2>""",
                """
                    <!-- ============ METHOD DETAIL ========== -->
                    <ul class="block-list">
                    <li><a name="method.detail">
                    <!--   -->
                    </a>
                    <h2>Method Details</h2>""");

        // Negated test for interface page
        checkOutput("pkg2/Interface.html", false,
                """
                    <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">""",
                "<meta name=\"date\"",
                """
                    <a name="navbar-top-firstrow">
                    <!--   -->
                    </a>""",
                """
                    <!-- ========== METHOD SUMMARY =========== -->
                    <ul class="block-list">
                    <li><a name="method.summary">
                    <!--   -->
                    </a>
                    <h2>Method Summary</h2>
                    <div class="member-summary">
                    <table summary="Method Summary table, listing methods, and an explanation">""",
                """
                    <!-- ============ METHOD DETAIL ========== -->
                    <ul class="block-list">
                    <li><a name="method.detail">
                    <!--   -->
                    </a>
                    <h2>Method Details</h2>""");

        // Negated test for error page
        checkOutput("pkg/TestError.html", false,
                """
                    <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">""",
                "<meta name=\"date\"",
                """
                    <a name="navbar-top-firstrow">
                    <!--   -->
                    </a>""",
                """
                    <!-- ======== CONSTRUCTOR SUMMARY ======== -->
                    <ul class="block-list">
                    <li><a name="constructor.summary">
                    <!--   -->
                    </a>
                    <h2>Constructor Summary</h2>""",
                """
                    <!-- ========= CONSTRUCTOR DETAIL ======== -->
                    <ul class="block-list">
                    <li><a name="constructor.detail">
                    <!--   -->
                    </a>
                    <h2>Constructor Details</h2>""");

        // Negated test for exception page
        checkOutput("pkg/TestException.html", false,
                """
                    <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">""",
                "<meta name=\"date\"",
                """
                    <a name="navbar-top-firstrow">
                    <!--   -->
                    </a>""",
                """
                    <!-- ======== CONSTRUCTOR SUMMARY ======== -->
                    <ul class="block-list">
                    <li><a name="constructor.summary">
                    <!--   -->
                    </a>
                    <h2>Constructor Summary</h2>""",
                """
                    <!-- ========= CONSTRUCTOR DETAIL ======== -->
                    <ul class="block-list">
                    <li><a name="constructor.detail">
                    <!--   -->
                    </a>
                    <h2>Constructor Details</h2>""");

        // Negated test for annotation page
        checkOutput("pkg2/TestAnnotationType.html", false,
                """
                    <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">""",
                "<meta name=\"date\"",
                """
                    <a name="navbar-top-firstrow">
                    <!--   -->
                    </a>""",
                """
                    <!-- =========== ANNOTATION TYPE REQUIRED MEMBER SUMMARY =========== -->
                    <ul class="block-list">
                    <li><a name="annotation.type.required.element.summary">
                    <!--   -->
                    </a>
                    <h2>Required Element Summary</h2>
                    <div class="member-summary">
                    <table summary="Required Element Summary table, listing required elements, and an explanation">""",
                """
                    <!-- =========== ANNOTATION TYPE OPTIONAL MEMBER SUMMARY =========== -->
                    <ul class="block-list">
                    <li><a name="annotation.type.optional.element.summary">
                    <!--   -->
                    </a>
                    <h2>Optional Element Summary</h2>
                    <div class="member-summary">
                    <table summary="Optional Element Summary table, listing optional elements, and an explanation">""",
                """
                    <!-- ============ ANNOTATION TYPE MEMBER DETAIL =========== -->
                    <ul class="block-list">
                    <li><a name="annotation.type.element.detail">
                    <!--   -->
                    </a>
                    <h2>Element Details</h2>""");

        // Negated test for class use page
        checkOutput("pkg1/class-use/RegClass.html", false,
                """
                    <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">""",
                "<meta name=\"date\"",
                """
                    <a name="navbar-top-firstrow">
                    <!--   -->
                    </a>""",
                """
                    <!-- ========= END OF TOP NAVBAR ========= -->
                    </div>
                    <div class="header">""",
                """
                    <div class="use-summary">
                    <table summary="Use table, listing packages, and an explanation">""",
                """
                    <li><a name="pkg">
                    <!--   -->
                    </a>
                    <h2>Uses of <a href="../RegClass.html" title="class in pkg1">RegClass</a> in <a \
                    href="../../pkg/package-summary.html">pkg</a></h2>
                    <div class="use-summary">
                    <table summary="Use table, listing fields, and an explanation">""");

        // Negated test for main index page
        checkOutput("index.html", false,
                """
                    <!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">""",
                """
                    <body>
                    <script type="text/javascript">
                    if (targetPage == "" || targetPage == "undefined")
                         window.location.replace('overview-summary.html');
                    </script>
                    <noscript>JavaScript is disabled on your browser.</noscript>
                    <div class="mainContainer">
                    """);
    }
}
