/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;

public final class TableExample
implements LayoutManager {
    static String[] ConnectOptionNames = new String[]{"Connect"};
    static String ConnectTitle = "Connection Information";
    Dimension origin = new Dimension(0, 0);
    JButton fetchButton;
    JButton showConnectionInfoButton;
    JPanel connectionPanel;
    JFrame frame;
    JLabel userNameLabel;
    JTextField userNameField;
    JLabel passwordLabel;
    JTextField passwordField;
    JTextArea queryTextArea;
    JComponent queryAggregate;
    JLabel serverLabel;
    JTextField serverField;
    JLabel driverLabel;
    JTextField driverField;
    JPanel mainPanel = new JPanel();
    TableSorter sorter;
    JDBCAdapter dataBase;
    JScrollPane tableAggregate;

    void activateConnectionDialog() {
        if (JOptionPane.showOptionDialog(this.tableAggregate, this.connectionPanel, ConnectTitle, -1, 1, null, ConnectOptionNames, ConnectOptionNames[0]) == 0) {
            this.connect();
            this.frame.setVisible(true);
        } else if (!this.frame.isVisible()) {
            System.exit(0);
        }
    }

    public void createConnectionDialog() {
        this.userNameLabel = new JLabel("User name: ", 4);
        this.userNameField = new JTextField("app");
        this.passwordLabel = new JLabel("Password: ", 4);
        this.passwordField = new JTextField("app");
        this.serverLabel = new JLabel("Database URL: ", 4);
        this.serverField = new JTextField("jdbc:derby://localhost:1527/sample");
        this.driverLabel = new JLabel("Driver: ", 4);
        this.driverField = new JTextField("org.apache.derby.jdbc.ClientDriver");
        this.connectionPanel = new JPanel(false);
        this.connectionPanel.setLayout(new BoxLayout(this.connectionPanel, 0));
        JPanel namePanel = new JPanel(false);
        namePanel.setLayout(new GridLayout(0, 1));
        namePanel.add(this.userNameLabel);
        namePanel.add(this.passwordLabel);
        namePanel.add(this.serverLabel);
        namePanel.add(this.driverLabel);
        JPanel fieldPanel = new JPanel(false);
        fieldPanel.setLayout(new GridLayout(0, 1));
        fieldPanel.add(this.userNameField);
        fieldPanel.add(this.passwordField);
        fieldPanel.add(this.serverField);
        fieldPanel.add(this.driverField);
        this.connectionPanel.add(namePanel);
        this.connectionPanel.add(fieldPanel);
    }

    public TableExample() {
        this.createConnectionDialog();
        this.showConnectionInfoButton = new JButton("Configuration");
        this.showConnectionInfoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableExample.this.activateConnectionDialog();
            }
        });
        this.fetchButton = new JButton("Fetch");
        this.fetchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableExample.this.fetch();
            }
        });
        this.queryTextArea = new JTextArea("SELECT * FROM APP.CUSTOMER", 25, 25);
        this.queryAggregate = new JScrollPane(this.queryTextArea);
        this.queryAggregate.setBorder(new BevelBorder(1));
        this.tableAggregate = this.createTable();
        this.tableAggregate.setBorder(new BevelBorder(1));
        this.mainPanel.add(this.fetchButton);
        this.mainPanel.add(this.showConnectionInfoButton);
        this.mainPanel.add(this.queryAggregate);
        this.mainPanel.add(this.tableAggregate);
        this.mainPanel.setLayout(this);
        this.frame = new JFrame("TableExample");
        this.frame.addWindowListener(new WindowAdapter(this){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.frame.setBackground(Color.lightGray);
        this.frame.getContentPane().add(this.mainPanel);
        this.frame.pack();
        this.frame.setVisible(false);
        this.frame.setBounds(200, 200, 640, 480);
        this.activateConnectionDialog();
    }

    public void connect() {
        this.dataBase = new JDBCAdapter(this.serverField.getText(), this.driverField.getText(), this.userNameField.getText(), this.passwordField.getText());
        this.sorter.setModel(this.dataBase);
    }

    public void fetch() {
        this.dataBase.executeQuery(this.queryTextArea.getText());
    }

    public JScrollPane createTable() {
        this.sorter = new TableSorter();
        JTable table = new JTable(this.sorter);
        table.setAutoResizeMode(0);
        this.sorter.addMouseListenerToHeaderInTable(table);
        JScrollPane scrollpane = new JScrollPane(table);
        return scrollpane;
    }

    public static void main(String[] s) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (Exception ex) {
            Logger.getLogger(TableExample.class.getName()).log(Level.SEVERE, "Failed to apply Nimbus look and feel", ex);
        }
        new TableExample();
    }

    @Override
    public Dimension preferredLayoutSize(Container c) {
        return this.origin;
    }

    @Override
    public Dimension minimumLayoutSize(Container c) {
        return this.origin;
    }

    @Override
    public void addLayoutComponent(String s, Component c) {
    }

    @Override
    public void removeLayoutComponent(Component c) {
    }

    @Override
    public void layoutContainer(Container c) {
        Rectangle b = c.getBounds();
        int topHeight = 90;
        int inset = 4;
        this.showConnectionInfoButton.setBounds(b.width - 2 * inset - 120, inset, 120, 25);
        this.fetchButton.setBounds(b.width - 2 * inset - 120, 60, 120, 25);
        this.queryAggregate.setBounds(inset, inset, b.width - 2 * inset - 150, 80);
        this.tableAggregate.setBounds(new Rectangle(inset, inset + topHeight, b.width - 2 * inset, b.height - 2 * inset - topHeight));
    }
}

