/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2020 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.text.resources.cldr.ext;

import java.util.ListResourceBundle;

public class FormatData_ml extends ListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] metaValue_MonthNames = new String[] {
               "\u0d1c\u0d28\u0d41\u0d35\u0d30\u0d3f",
               "\u0d2b\u0d46\u0d2c\u0d4d\u0d30\u0d41\u0d35\u0d30\u0d3f",
               "\u0d2e\u0d3e\u0d7c\u0d1a\u0d4d\u0d1a\u0d4d",
               "\u0d0f\u0d2a\u0d4d\u0d30\u0d3f\u0d7d",
               "\u0d2e\u0d47\u0d2f\u0d4d",
               "\u0d1c\u0d42\u0d7a",
               "\u0d1c\u0d42\u0d32\u0d48",
               "\u0d13\u0d17\u0d38\u0d4d\u0d31\u0d4d\u0d31\u0d4d",
               "\u0d38\u0d46\u0d2a\u0d4d\u0d31\u0d4d\u0d31\u0d02\u0d2c\u0d7c",
               "\u0d12\u0d15\u0d4d\u200c\u0d1f\u0d4b\u0d2c\u0d7c",
               "\u0d28\u0d35\u0d02\u0d2c\u0d7c",
               "\u0d21\u0d3f\u0d38\u0d02\u0d2c\u0d7c",
               "",
            };
        final String[] metaValue_MonthAbbreviations = new String[] {
               "\u0d1c\u0d28\u0d41",
               "\u0d2b\u0d46\u0d2c\u0d4d\u0d30\u0d41",
               "\u0d2e\u0d3e\u0d7c",
               "\u0d0f\u0d2a\u0d4d\u0d30\u0d3f",
               "\u0d2e\u0d47\u0d2f\u0d4d",
               "\u0d1c\u0d42\u0d7a",
               "\u0d1c\u0d42\u0d32\u0d48",
               "\u0d13\u0d17",
               "\u0d38\u0d46\u0d2a\u0d4d\u0d31\u0d4d\u0d31\u0d02",
               "\u0d12\u0d15\u0d4d\u0d1f\u0d4b",
               "\u0d28\u0d35\u0d02",
               "\u0d21\u0d3f\u0d38\u0d02",
               "",
            };
        final String[] metaValue_MonthNarrows = new String[] {
               "\u0d1c",
               "\u0d2b\u0d46",
               "\u0d2e\u0d3e",
               "\u0d0f",
               "\u0d2e\u0d46",
               "\u0d1c\u0d42\u0d7a",
               "\u0d1c\u0d42",
               "\u0d13",
               "\u0d38\u0d46",
               "\u0d12",
               "\u0d28",
               "\u0d21\u0d3f",
               "",
            };
        final String[] metaValue_DayNames = new String[] {
               "\u0d1e\u0d3e\u0d2f\u0d31\u0d3e\u0d34\u0d4d\u200c\u0d1a",
               "\u0d24\u0d3f\u0d19\u0d4d\u0d15\u0d33\u0d3e\u0d34\u0d4d\u200c\u0d1a",
               "\u0d1a\u0d4a\u0d35\u0d4d\u0d35\u0d3e\u0d34\u0d4d\u0d1a",
               "\u0d2c\u0d41\u0d27\u0d28\u0d3e\u0d34\u0d4d\u200c\u0d1a",
               "\u0d35\u0d4d\u0d2f\u0d3e\u0d34\u0d3e\u0d34\u0d4d\u200c\u0d1a",
               "\u0d35\u0d46\u0d33\u0d4d\u0d33\u0d3f\u0d2f\u0d3e\u0d34\u0d4d\u200c\u0d1a",
               "\u0d36\u0d28\u0d3f\u0d2f\u0d3e\u0d34\u0d4d\u200c\u0d1a",
            };
        final String[] metaValue_DayAbbreviations = new String[] {
               "\u0d1e\u0d3e\u0d2f\u0d7c",
               "\u0d24\u0d3f\u0d19\u0d4d\u0d15\u0d7e",
               "\u0d1a\u0d4a\u0d35\u0d4d\u0d35",
               "\u0d2c\u0d41\u0d27\u0d7b",
               "\u0d35\u0d4d\u0d2f\u0d3e\u0d34\u0d02",
               "\u0d35\u0d46\u0d33\u0d4d\u0d33\u0d3f",
               "\u0d36\u0d28\u0d3f",
            };
        final String[] metaValue_DayNarrows = new String[] {
               "\u0d1e",
               "\u0d24\u0d3f",
               "\u0d1a\u0d4a",
               "\u0d2c\u0d41",
               "\u0d35\u0d4d\u0d2f\u0d3e",
               "\u0d35\u0d46",
               "\u0d36",
            };
        final String[] metaValue_QuarterNames = new String[] {
               "\u0d12\u0d28\u0d4d\u0d28\u0d3e\u0d02 \u0d2a\u0d3e\u0d26\u0d02",
               "\u0d30\u0d23\u0d4d\u0d1f\u0d3e\u0d02 \u0d2a\u0d3e\u0d26\u0d02",
               "\u0d2e\u0d42\u0d28\u0d4d\u0d28\u0d3e\u0d02 \u0d2a\u0d3e\u0d26\u0d02",
               "\u0d28\u0d3e\u0d32\u0d3e\u0d02 \u0d2a\u0d3e\u0d26\u0d02",
            };
        final String[] metaValue_AmPmMarkers = new String[] {
               "AM",
               "PM",
               "\u0d05\u0d7c\u0d26\u0d4d\u0d27\u0d30\u0d3e\u0d24\u0d4d\u0d30\u0d3f",
               "\u0d09\u0d1a\u0d4d\u0d1a",
               "\u0d2a\u0d41\u0d32\u0d7c\u0d1a\u0d4d\u0d1a\u0d46",
               "\u0d30\u0d3e\u0d35\u0d3f\u0d32\u0d46",
               "\u0d09\u0d1a\u0d4d\u0d1a\u0d2f\u0d4d\u0d15\u0d4d\u0d15\u0d4d",
               "\u0d09\u0d1a\u0d4d\u0d1a\u0d24\u0d3f\u0d30\u0d3f\u0d1e\u0d4d\u0d1e\u0d4d",
               "\u0d35\u0d48\u0d15\u0d41\u0d28\u0d4d\u0d28\u0d47\u0d30\u0d02",
               "\u0d38\u0d28\u0d4d\u0d27\u0d4d\u0d2f",
               "\u0d30\u0d3e\u0d24\u0d4d\u0d30\u0d3f",
               "",
            };
        final String[] metaValue_narrow_AmPmMarkers = new String[] {
               "AM",
               "PM",
               "\u0d05",
               "\u0d09\u0d1a\u0d4d\u0d1a",
               "\u0d2a\u0d41\u0d32\u0d7c\u0d1a\u0d4d\u0d1a\u0d46",
               "\u0d30\u0d3e\u0d35\u0d3f\u0d32\u0d46",
               "\u0d09\u0d1a\u0d4d\u0d1a\u0d2f\u0d4d\u0d15\u0d4d\u0d15\u0d4d",
               "\u0d09\u0d1a\u0d4d\u0d1a\u0d24\u0d3f\u0d30\u0d3f\u0d1e\u0d4d\u0d1e\u0d4d",
               "\u0d35\u0d48\u0d15\u0d41\u0d28\u0d4d\u0d28\u0d47\u0d30\u0d02",
               "\u0d38\u0d28\u0d4d\u0d27\u0d4d\u0d2f",
               "\u0d30\u0d3e\u0d24\u0d4d\u0d30\u0d3f",
               "",
            };
        final String[] metaValue_Eras = new String[] {
               "\u0d15\u0d4d\u0d30\u0d3f.\u0d2e\u0d41.",
               "\u0d0e\u0d21\u0d3f",
            };
        final String[] metaValue_TimePatterns = new String[] {
               "h:mm:ss a zzzz",
               "h:mm:ss a z",
               "h:mm:ss a",
               "h:mm a",
            };
        final String[] metaValue_buddhist_QuarterNarrows = new String[] {
               "1",
               "2",
               "3",
               "4",
            };
        final String[] metaValue_java_time_buddhist_long_Eras = new String[] {
               "BC",
               "BE",
            };
        final String[] metaValue_java_time_buddhist_DatePatterns = new String[] {
               "G y, MMMM d, EEEE",
               "G y, MMMM d",
               "G y, MMM d",
               "GGGGG y-MM-dd",
            };
        final String[] metaValue_buddhist_DatePatterns = new String[] {
               "GGGG y, MMMM d, EEEE",
               "GGGG y, MMMM d",
               "GGGG y, MMM d",
               "G y-MM-dd",
            };
        final String[] metaValue_java_time_roc_long_Eras = new String[] {
               "R.O.C-\u0d2f\u0d4d\u200c\u0d15\u0d4d\u0d15\u0d4d \u0d2e\u0d41\u0d2e\u0d4d\u0d2a\u0d4d",
               "\u0d2e\u0d3f\u0d02\u0d17\u0d4d\u0d35\u0d4b",
            };
        final String[] metaValue_java_time_roc_Eras = new String[] {
               "R.O.C-\u0d2f\u0d4d\u200c\u0d15\u0d4d\u0d15\u0d4d \u0d2e\u0d41.",
               "\u0d2e\u0d3f\u0d02\u0d17\u0d4d\u0d35\u0d4b",
            };
        final String[] metaValue_java_time_islamic_long_Eras = new String[] {
               "",
               "\u0d39\u0d3f\u0d1c\u0d31",
            };
        final String metaValue_calendarname_gregorian = "\u0d07\u0d02\u0d17\u0d4d\u0d32\u0d40\u0d37\u0d4d \u0d15\u0d32\u0d23\u0d4d\u0d1f\u0d7c";
        final Object[][] data = new Object[][] {
            { "MonthNames", metaValue_MonthNames },
            { "field.year", "\u0d35\u0d7c\u0d37\u0d02" },
            { "calendarname.islamic-umalqura", "\u0d07\u0d38\u0d4d\u200c\u0d32\u0d3e\u0d2e\u0d3f\u0d15\u0d4d \u0d15\u0d32\u0d23\u0d4d\u0d1f\u0d7c (\u0d09\u0d02 \u0d05\u0d7d \u0d16\u0d41\u0d31)" },
            { "japanese.AmPmMarkers", metaValue_AmPmMarkers },
            { "buddhist.narrow.Eras", metaValue_java_time_buddhist_long_Eras },
            { "AmPmMarkers", metaValue_AmPmMarkers },
            { "timezone.gmtFormat", "\u0d1c\u0d3f\u0d0e\u0d02\u0d1f\u0d3f {0}" },
            { "java.time.japanese.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "standalone.QuarterAbbreviations", metaValue_QuarterNames },
            { "roc.QuarterNames", metaValue_QuarterNames },
            { "roc.MonthNarrows", metaValue_MonthNarrows },
            { "calendarname.islamic-civil", "\u0d07\u0d38\u0d4d\u0d32\u0d3e\u0d02-\u0d38\u0d3f\u0d35\u0d3f\u0d7d \u0d15\u0d32\u0d23\u0d4d\u0d1f\u0d7c" },
            { "islamic.narrow.AmPmMarkers", metaValue_narrow_AmPmMarkers },
            { "japanese.TimePatterns", metaValue_TimePatterns },
            { "narrow.Eras", metaValue_Eras },
            { "roc.long.Eras", metaValue_java_time_roc_long_Eras },
            { "abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
            { "timezone.regionFormat.standard", "{0} \u0d38\u0d4d\u0d31\u0d4d\u0d31\u0d3e\u0d7b\u0d21\u0d47\u0d7c\u0d21\u0d4d \u0d38\u0d2e\u0d2f\u0d02" },
            { "japanese.abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
            { "calendarname.japanese", "\u0d1c\u0d3e\u0d2a\u0d4d\u0d2a\u0d28\u0d40\u0d38\u0d4d \u0d15\u0d32\u0d23\u0d4d\u0d1f\u0d7c" },
            { "timezone.gmtZeroFormat", "\u0d1c\u0d3f\u0d0e\u0d02\u0d1f\u0d3f" },
            { "japanese.MonthNames", metaValue_MonthNames },
            { "standalone.DayAbbreviations", metaValue_DayAbbreviations },
            { "roc.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "java.time.islamic.narrow.Eras", metaValue_java_time_islamic_long_Eras },
            { "long.Eras",
                new String[] {
                    "\u0d15\u0d4d\u0d30\u0d3f\u0d38\u0d4d\u200c\u0d24\u0d41\u0d35\u0d3f\u0d28\u0d4d \u0d2e\u0d41\u0d2e\u0d4d\u0d2a\u0d4d",
                    "\u0d06\u0d28\u0d4d\u0d28\u0d4b \u0d21\u0d4a\u0d2e\u0d3f\u0d28\u0d3f",
                }
            },
            { "roc.QuarterNarrows", metaValue_buddhist_QuarterNarrows },
            { "islamic.DayNames", metaValue_DayNames },
            { "buddhist.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "buddhist.MonthNames", metaValue_MonthNames },
            { "DateTimePatterns",
                new String[] {
                    "{1} {0}",
                    "{1} {0}",
                    "{1} {0}",
                    "{1} {0}",
                }
            },
            { "narrow.AmPmMarkers", metaValue_narrow_AmPmMarkers },
            { "latn.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "0",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "MonthNarrows", metaValue_MonthNarrows },
            { "japanese.DatePatterns", metaValue_buddhist_DatePatterns },
            { "buddhist.DayNames", metaValue_DayNames },
            { "field.minute", "\u0d2e\u0d3f\u0d28\u0d3f\u0d31\u0d4d\u0d31\u0d4d" },
            { "field.era", "\u0d15\u0d3e\u0d32\u0d18\u0d1f\u0d4d\u0d1f\u0d02" },
            { "buddhist.AmPmMarkers", metaValue_AmPmMarkers },
            { "field.dayperiod", "AM/PM" },
            { "standalone.MonthNarrows", metaValue_MonthNarrows },
            { "islamic.MonthNames",
                new String[] {
                    "\u0d2e\u0d41\u0d39\u0d31\u0d02",
                    "\u0d38\u0d2b\u0d7c",
                    "\u0d31\u0d2c\u0d40\u0d39\u0d41\u0d7d \u0d05\u0d35\u0d4d\u0d35\u0d7d",
                    "\u0d31\u0d2c\u0d40\u0d39\u0d41\u0d7d \u0d06\u0d16\u0d3f\u0d7c",
                    "\u0d1c\u0d2e\u0d3e\u0d26\u0d41\u0d7d \u0d05\u0d35\u0d4d\u0d35\u0d7d",
                    "\u0d1c\u0d2e\u0d3e\u0d26\u0d41\u0d7d \u0d06\u0d16\u0d3f\u0d7c",
                    "\u0d31\u0d1c\u0d2c\u0d4d",
                    "\u0d36\u0d39\u0d2c\u0d3e\u0d7b",
                    "\u0d31\u0d2e\u0d33\u0d3e\u0d7b",
                    "\u0d36\u0d35\u0d4d\u0d35\u0d3e\u0d7d",
                    "\u0d26\u0d41\u0d7d \u0d16\u0d39\u0d26\u0d4d",
                    "\u0d26\u0d41\u0d7d \u0d39\u0d3f\u0d1c\u0d4d\u0d1c",
                    "",
                }
            },
            { "japanese.QuarterNarrows", metaValue_buddhist_QuarterNarrows },
            { "calendarname.roc", "\u0d2e\u0d3f\u0d02\u0d17\u0d4d\u0d35\u0d4b \u0d15\u0d32\u0d23\u0d4d\u0d1f\u0d7c" },
            { "islamic.DatePatterns", metaValue_buddhist_DatePatterns },
            { "roc.QuarterAbbreviations", metaValue_QuarterNames },
            { "islamic.Eras", metaValue_java_time_islamic_long_Eras },
            { "field.month", "\u0d2e\u0d3e\u0d38\u0d02" },
            { "roc.Eras", metaValue_java_time_roc_Eras },
            { "field.second", "\u0d38\u0d46\u0d15\u0d4d\u0d15\u0d7b\u0d21\u0d4d" },
            { "islamic.MonthNarrows",
                new String[] {
                    "\u0d2e\u0d41",
                    "\u0d38",
                    "\u0d31",
                    "\u0d31",
                    "\u0d1c",
                    "\u0d1c",
                    "\u0d31",
                    "\u0d36",
                    "\u0d31",
                    "\u0d36",
                    "\u0d26\u0d41",
                    "\u0d26\u0d41",
                    "",
                }
            },
            { "DayAbbreviations", metaValue_DayAbbreviations },
            { "DayNarrows", metaValue_DayNarrows },
            { "roc.DatePatterns", metaValue_buddhist_DatePatterns },
            { "calendarname.islamic", "\u0d07\u0d38\u0d4d\u200c\u0d32\u0d3e\u0d2e\u0d3f\u0d15\u0d4d \u0d15\u0d32\u0d23\u0d4d\u0d1f\u0d7c" },
            { "java.time.roc.long.Eras", metaValue_java_time_roc_long_Eras },
            { "DayPeriodRules", "midnight:00:00;noon:12:00;evening2:18:00-19:00;night1:19:00-03:00;morning2:06:00-12:00;afternoon1:12:00-14:00;morning1:03:00-06:00;afternoon2:14:00-15:00;evening1:15:00-18:00" },
            { "java.time.roc.narrow.Eras", metaValue_java_time_roc_Eras },
            { "japanese.narrow.AmPmMarkers", metaValue_narrow_AmPmMarkers },
            { "buddhist.TimePatterns", metaValue_TimePatterns },
            { "standalone.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "timezone.regionFormat", "{0} \u0d38\u0d2e\u0d2f\u0d02" },
            { "long.CompactNumberPatterns",
                new String[] {
                    "",
                    "",
                    "",
                    "{one:0' '\u0d06\u0d2f\u0d3f\u0d30\u0d02 other:0' '\u0d06\u0d2f\u0d3f\u0d30\u0d02}",
                    "{one:00' '\u0d06\u0d2f\u0d3f\u0d30\u0d02 other:00' '\u0d06\u0d2f\u0d3f\u0d30\u0d02}",
                    "{one:000' '\u0d06\u0d2f\u0d3f\u0d30\u0d02 other:000' '\u0d06\u0d2f\u0d3f\u0d30\u0d02}",
                    "{one:0' '\u0d26\u0d36\u0d32\u0d15\u0d4d\u0d37\u0d02 other:0' '\u0d26\u0d36\u0d32\u0d15\u0d4d\u0d37\u0d02}",
                    "{one:00' '\u0d26\u0d36\u0d32\u0d15\u0d4d\u0d37\u0d02 other:00' '\u0d26\u0d36\u0d32\u0d15\u0d4d\u0d37\u0d02}",
                    "{one:000' '\u0d26\u0d36\u0d32\u0d15\u0d4d\u0d37\u0d02 other:000' '\u0d26\u0d36\u0d32\u0d15\u0d4d\u0d37\u0d02}",
                    "{one:0' '\u0d32\u0d15\u0d4d\u0d37\u0d02' '\u0d15\u0d4b\u0d1f\u0d3f other:0' '\u0d32\u0d15\u0d4d\u0d37\u0d02' '\u0d15\u0d4b\u0d1f\u0d3f}",
                    "{one:00' '\u0d32\u0d15\u0d4d\u0d37\u0d02' '\u0d15\u0d4b\u0d1f\u0d3f other:00' '\u0d32\u0d15\u0d4d\u0d37\u0d02' '\u0d15\u0d4b\u0d1f\u0d3f}",
                    "{one:000' '\u0d32\u0d15\u0d4d\u0d37\u0d02' '\u0d15\u0d4b\u0d1f\u0d3f other:000' '\u0d32\u0d15\u0d4d\u0d37\u0d02' '\u0d15\u0d4b\u0d1f\u0d3f}",
                    "{one:0' '\u0d1f\u0d4d\u0d30\u0d3f\u0d32\u0d4d\u0d2f\u0d7a other:0' '\u0d1f\u0d4d\u0d30\u0d3f\u0d32\u0d4d\u0d2f\u0d7a}",
                    "{one:00' '\u0d1f\u0d4d\u0d30\u0d3f\u0d32\u0d4d\u0d2f\u0d7a other:00' '\u0d1f\u0d4d\u0d30\u0d3f\u0d32\u0d4d\u0d2f\u0d7a}",
                    "{one:000' '\u0d1f\u0d4d\u0d30\u0d3f\u0d32\u0d4d\u0d2f\u0d7a other:000' '\u0d1f\u0d4d\u0d30\u0d3f\u0d32\u0d4d\u0d2f\u0d7a}",
                }
            },
            { "roc.narrow.AmPmMarkers", metaValue_narrow_AmPmMarkers },
            { "buddhist.QuarterNarrows", metaValue_buddhist_QuarterNarrows },
            { "standalone.QuarterNames", metaValue_QuarterNames },
            { "japanese.MonthNarrows", metaValue_MonthNarrows },
            { "islamic.QuarterAbbreviations", metaValue_QuarterNames },
            { "roc.DayAbbreviations", metaValue_DayAbbreviations },
            { "java.time.buddhist.long.Eras", metaValue_java_time_buddhist_long_Eras },
            { "standalone.DayNarrows",
                new String[] {
                    "\u0d1e\u0d3e",
                    "\u0d24\u0d3f",
                    "\u0d1a\u0d4a",
                    "\u0d2c\u0d41",
                    "\u0d35\u0d4d\u0d2f\u0d3e",
                    "\u0d35\u0d46",
                    "\u0d36",
                }
            },
            { "islamic.AmPmMarkers", metaValue_AmPmMarkers },
            { "buddhist.long.Eras", metaValue_java_time_buddhist_long_Eras },
            { "mlym.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u0d66",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "TimePatterns", metaValue_TimePatterns },
            { "islamic.DayNarrows", metaValue_DayNarrows },
            { "java.time.roc.Eras", metaValue_java_time_roc_Eras },
            { "field.zone", "\u0d38\u0d2e\u0d2f \u0d2e\u0d47\u0d16\u0d32" },
            { "japanese.QuarterAbbreviations", metaValue_QuarterNames },
            { "roc.narrow.Eras", metaValue_java_time_roc_Eras },
            { "buddhist.narrow.AmPmMarkers", metaValue_narrow_AmPmMarkers },
            { "buddhist.abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
            { "Eras", metaValue_Eras },
            { "roc.DayNames", metaValue_DayNames },
            { "islamic.QuarterNames", metaValue_QuarterNames },
            { "islamic.abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
            { "java.time.islamic.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "field.weekday", "\u0d06\u0d34\u0d4d\u0d1a\u0d2f\u0d3f\u0d32\u0d46 \u0d26\u0d3f\u0d35\u0d38\u0d02" },
            { "japanese.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "islamic.DayAbbreviations", metaValue_DayAbbreviations },
            { "islamic.long.Eras", metaValue_java_time_islamic_long_Eras },
            { "java.time.islamic.Eras", metaValue_java_time_islamic_long_Eras },
            { "japanese.QuarterNames", metaValue_QuarterNames },
            { "buddhist.QuarterAbbreviations", metaValue_QuarterNames },
            { "java.time.buddhist.Eras", metaValue_java_time_buddhist_long_Eras },
            { "japanese.DayNames", metaValue_DayNames },
            { "japanese.DayAbbreviations", metaValue_DayAbbreviations },
            { "DayNames", metaValue_DayNames },
            { "buddhist.DatePatterns", metaValue_buddhist_DatePatterns },
            { "roc.MonthNames", metaValue_MonthNames },
            { "buddhist.Eras", metaValue_java_time_buddhist_long_Eras },
            { "field.week", "\u0d06\u0d34\u0d4d\u0d1a" },
            { "buddhist.MonthNarrows", metaValue_MonthNarrows },
            { "buddhist.QuarterNames", metaValue_QuarterNames },
            { "islamic.QuarterNarrows", metaValue_buddhist_QuarterNarrows },
            { "roc.DayNarrows", metaValue_DayNarrows },
            { "roc.AmPmMarkers", metaValue_AmPmMarkers },
            { "java.time.roc.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "java.time.buddhist.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "mlym.NumberPatterns",
                new String[] {
                    "#,##,##0.###",
                    "\u00a4#,##0.00",
                    "#,##0%",
                    "",
                }
            },
            { "short.CompactNumberPatterns",
                new String[] {
                    "",
                    "",
                    "",
                    "{one:0K other:0K}",
                    "{one:00K other:00K}",
                    "{one:000K other:000K}",
                    "{one:0M other:0M}",
                    "{one:00M other:00M}",
                    "{one:000M other:000M}",
                    "{one:0B other:0B}",
                    "{one:00B other:00B}",
                    "{one:000B other:000B}",
                    "{one:0T other:0T}",
                    "{one:00T other:00T}",
                    "{one:000T other:000T}",
                }
            },
            { "calendarname.gregorian", metaValue_calendarname_gregorian },
            { "java.time.buddhist.narrow.Eras", metaValue_java_time_buddhist_long_Eras },
            { "timezone.regionFormat.daylight", "{0} \u0d21\u0d47\u0d32\u0d48\u0d31\u0d4d\u0d31\u0d4d \u0d38\u0d2e\u0d2f\u0d02" },
            { "DatePatterns",
                new String[] {
                    "y, MMMM d, EEEE",
                    "y, MMMM d",
                    "y, MMM d",
                    "d/M/yy",
                }
            },
            { "buddhist.DayAbbreviations", metaValue_DayAbbreviations },
            { "islamic.TimePatterns", metaValue_TimePatterns },
            { "MonthAbbreviations", metaValue_MonthAbbreviations },
            { "standalone.DayNames",
                new String[] {
                    "\u0d1e\u0d3e\u0d2f\u0d31\u0d3e\u0d34\u0d4d\u200c\u0d1a",
                    "\u0d24\u0d3f\u0d19\u0d4d\u0d15\u0d33\u0d3e\u0d34\u0d4d\u200c\u0d1a",
                    "\u0d1a\u0d4a\u0d35\u0d4d\u0d35\u0d3e\u0d34\u0d4d\u200c\u0d1a",
                    "\u0d2c\u0d41\u0d27\u0d28\u0d3e\u0d34\u0d4d\u200c\u0d1a",
                    "\u0d35\u0d4d\u0d2f\u0d3e\u0d34\u0d3e\u0d34\u0d4d\u200c\u0d1a",
                    "\u0d35\u0d46\u0d33\u0d4d\u0d33\u0d3f\u0d2f\u0d3e\u0d34\u0d4d\u200c\u0d1a",
                    "\u0d36\u0d28\u0d3f\u0d2f\u0d3e\u0d34\u0d4d\u200c\u0d1a",
                }
            },
            { "PluralRules", "one:n = 1" },
            { "field.hour", "\u0d2e\u0d23\u0d3f\u0d15\u0d4d\u0d15\u0d42\u0d7c" },
            { "islamic.MonthAbbreviations",
                new String[] {
                    "\u0d2e\u0d41\u0d39.",
                    "\u0d38\u0d2b.",
                    "\u0d31\u0d2c\u0d40\u0d39\u0d41\u0d7d \u0d05\u0d35\u0d4d\u0d35.",
                    "\u0d31\u0d2c\u0d40\u0d39\u0d41\u0d7d \u0d06\u0d16\u0d3f.",
                    "\u0d1c\u0d2e\u0d3e\u0d26\u0d41\u0d7d \u0d05\u0d35\u0d4d\u0d35.",
                    "\u0d1c\u0d2e\u0d3e\u0d26\u0d41\u0d7d \u0d06\u0d16\u0d3f.",
                    "\u0d31\u0d1c.",
                    "\u0d36\u0d39\u0d2c\u0d3e.",
                    "\u0d31\u0d2e\u0d26\u0d3e.",
                    "\u0d36\u0d35\u0d4d\u0d35\u0d3e.",
                    "\u0d26\u0d41\u0d7d \u0d16\u0d39.",
                    "\u0d26\u0d41\u0d7d \u0d39\u0d3f.",
                    "",
                }
            },
            { "islamic.narrow.Eras", metaValue_java_time_islamic_long_Eras },
            { "calendarname.buddhist", "\u0d2c\u0d41\u0d26\u0d4d\u0d27\u0d2e\u0d24\u0d15\u0d32\u0d23\u0d4d\u0d1f\u0d7c" },
            { "standalone.MonthNames", metaValue_MonthNames },
            { "latn.NumberPatterns",
                new String[] {
                    "#,##,##0.###",
                    "\u00a4#,##0.00",
                    "#,##0%",
                    "\u00a4#,##0.00;(\u00a4#,##0.00)",
                }
            },
            { "buddhist.DayNarrows", metaValue_DayNarrows },
            { "java.time.islamic.long.Eras", metaValue_java_time_islamic_long_Eras },
            { "japanese.DayNarrows", metaValue_DayNarrows },
            { "QuarterNames", metaValue_QuarterNames },
            { "roc.TimePatterns", metaValue_TimePatterns },
            { "QuarterAbbreviations", metaValue_QuarterNames },
            { "roc.abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
            { "calendarname.gregory", metaValue_calendarname_gregorian },
        };
        return data;
    }
}
