/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.internal.tools.wizards.model;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.fragment.MFragmentFactory;
import org.eclipse.e4.ui.model.fragment.MModelFragments;
import org.eclipse.e4.ui.model.fragment.MStringModelFragment;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class FragmentExtractHelper {
    public static void resolveImports(MApplicationElement moe, Map<MApplicationElement, MApplicationElement> importedElements) {
        EObject element = (EObject)moe;
        EContentsEList.FeatureIterator featureIterator = (EContentsEList.FeatureIterator)element.eCrossReferences().iterator();
        while (featureIterator.hasNext()) {
            EObject objectToBeImported = (EObject)featureIterator.next();
            EReference eReference = (EReference)featureIterator.feature();
            MApplicationElement alreadyImportedElement = null;
            if (objectToBeImported instanceof MApplicationElement) {
                alreadyImportedElement = importedElements.get((MApplicationElement)objectToBeImported);
            }
            if (alreadyImportedElement == null) {
                alreadyImportedElement = (MApplicationElement)EcoreUtil.copy((EObject)objectToBeImported);
                importedElements.put((MApplicationElement)objectToBeImported, alreadyImportedElement);
            }
            if (eReference.isMany()) {
                EList ref = (EList)element.eGet((EStructuralFeature)eReference);
                ref.remove((Object)objectToBeImported);
                ref.add((Object)((EObject)alreadyImportedElement));
                continue;
            }
            element.eSet((EStructuralFeature)eReference, (Object)alreadyImportedElement);
        }
    }

    public static MModelFragments createInitialModel(List<MApplicationElement> extractedElements) {
        MModelFragments mModelFragments = MFragmentFactory.INSTANCE.createModelFragments();
        HashMap<MApplicationElement, MApplicationElement> importCommands = new HashMap<MApplicationElement, MApplicationElement>();
        HashMap<CallSite, MStringModelFragment> createdFragments = new HashMap<CallSite, MStringModelFragment>();
        for (MApplicationElement moe : extractedElements) {
            EObject eObject = (EObject)moe;
            TreeIterator eAllContents = eObject.eAllContents();
            boolean hasNext = eAllContents.hasNext();
            if (!hasNext) {
                FragmentExtractHelper.resolveImports(moe, importCommands);
            }
            while (hasNext) {
                MApplicationElement next = (MApplicationElement)eAllContents.next();
                FragmentExtractHelper.resolveImports(next, importCommands);
                hasNext = eAllContents.hasNext();
            }
            MApplicationElement copy = (MApplicationElement)EcoreUtil.copy((EObject)((EObject)moe));
            String featurename = ((EObject)moe).eContainmentFeature().getName();
            String containerID = ((MApplicationElement)((EObject)moe).eContainer()).getElementId();
            String combinedID = containerID + featurename;
            MStringModelFragment modelFragment = (MStringModelFragment)createdFragments.get(combinedID);
            if (modelFragment == null) {
                modelFragment = MFragmentFactory.INSTANCE.createStringModelFragment();
                modelFragment.setParentElementId(containerID);
                modelFragment.setFeaturename(featurename);
                createdFragments.put((CallSite)((Object)combinedID), modelFragment);
                mModelFragments.getFragments().add(modelFragment);
            }
            modelFragment.getElements().add(copy);
        }
        Set keySet = importCommands.keySet();
        for (MApplicationElement key : keySet) {
            mModelFragments.getImports().add(importCommands.get(key));
        }
        return mModelFragments;
    }
}

