/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.core.internal.model;

import com.google.common.base.Strings;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Arrays;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.tea.core.internal.model.iface.TaskingContainer;
import org.eclipse.tea.core.internal.model.impl.TaskingModelCreator;
import org.eclipse.tea.core.services.TaskChain;

@Creatable
public class TaskingModel {
    private final TaskingModelCreator creator;

    @Inject
    public TaskingModel(TaskingModelCreator creator) {
        this.creator = creator;
    }

    public TaskingContainer getRootGroup() {
        return this.creator.createModel();
    }

    public static String getTaskName(Object task) {
        return TaskingModel.toTaskingObjectName(task);
    }

    public static String getTaskChainName(TaskChain chain) {
        TaskChain.TaskChainId id = chain.getClass().getAnnotation(TaskChain.TaskChainId.class);
        if (id == null) {
            return TaskingModel.toTaskingObjectName(chain);
        }
        return id.description();
    }

    private static String toTaskingObjectName(Object obj) {
        Named named = obj.getClass().getAnnotation(Named.class);
        if (named != null) {
            return named.value();
        }
        if (Arrays.asList(obj.getClass().getMethods()).stream().filter(m -> m.getName().equals("toString") && !m.getDeclaringClass().equals(Object.class)).findAny().isPresent()) {
            return obj.toString();
        }
        String name = obj.getClass().getSimpleName();
        if (Strings.isNullOrEmpty((String)name)) {
            return obj.getClass().getName();
        }
        return name;
    }
}

