/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.core;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swtchart.Resources;

public class ResourceSupport
extends Resources {
    public static final String ICON_SET_RANGE = "set_range.svg";
    public static final String ICON_RESTRICT_RANGE = "restrict_range.gif";
    public static final String ICON_HIDE = "hide.svg";
    public static final String ICON_RESET = "reset.svg";
    public static final String ICON_CHECKED = "checked.svg";
    public static final String ICON_UNCHECKED = "unchecked.svg";
    public static final String ICON_CHECK_ALL = "checkAll.svg";
    public static final String ICON_UNCHECK_ALL = "uncheckAll.svg";
    public static final String ICON_LEGEND = "legend.gif";
    public static final String ICON_SORT = "sort.svg";
    public static final String ICON_POSITION = "position.gif";
    public static final String ICON_SETTINGS = "preferences.gif";
    public static final String ICON_MAPPINGS = "mappings.svg";
    public static final String ICON_DELETE = "delete.svg";
    public static final String ICON_DELETE_ALL = "deleteAll.png";
    public static final String ARROW_LEFT = "arrowLeft.svg";
    public static final String ARROW_RIGHT = "arrowRight.svg";
    public static final String ARROW_UP = "arrowUp.svg";
    public static final String ARROW_DOWN = "arrowDown.svg";
    public static final String ICON_SERIES_MARKER = "seriesMarker.gif";
    public static final String ICON_IMPORT = "import.svg";
    public static final String ICON_EXPORT = "export.svg";
    public static final String ICON_RESET_SELECTED = "resetSelected.gif";
    public static final String ICON_RESET_ALL = "resetAll.gif";
    public static final String ICON_RESET_SELECTION = "reset-selection.gif";
    public static final String ICON_REDO = "redo.svg";
    public static final String ICON_UNDO = "undo.svg";
    public static final String ICON_COPY_CLIPBOARD = "copy-clipboard.svg";
    public static final String ICON_CSV = "csv.gif";
    public static final String ICON_FIGURE = "figure.gif";
    public static final String ICON_BITMAP = "bitmap.gif";
    public static final String ICON_PRINT = "print.svg";
    public static final String ICON_TEX = "tex.gif";
    public static final String ICON_R = "r.gif";
    public static final String ICON_TRANSFER = "transfer.png";
    public static final String ICON_SAVE = "save.svg";
    public static final String ICON_ADD = "add.svg";
    private static ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
    private static IPreferenceStore preferenceStore = null;
    private static ImageRegistry imageRegistry = null;

    private ResourceSupport() {
    }

    public static IPreferenceStore getPreferenceStore() {
        if (preferenceStore == null) {
            try {
                Path path = Paths.get(System.getProperty("user.home"), ".eclipse", "org.eclipse.swtchart.extensions", "chart.properties");
                if (!path.toFile().exists()) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    Files.createFile(path, new FileAttribute[0]);
                }
                preferenceStore = new PreferenceStore(path.toAbsolutePath().toString());
                ((PreferenceStore)preferenceStore).load();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return preferenceStore;
    }

    public static void savePreferenceStore() {
        IPreferenceStore preferenceStore = ResourceSupport.getPreferenceStore();
        if (preferenceStore instanceof PreferenceStore) {
            PreferenceStore savablePreferenceStore = (PreferenceStore)preferenceStore;
            try {
                savablePreferenceStore.save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static Image getImage(String key) {
        if (imageRegistry == null) {
            imageRegistry = ResourceSupport.initializeImageRegistry();
        }
        return resourceManager.createImageWithDefault(imageRegistry.getDescriptor(key));
    }

    public static Image getImageDisabled(String key) {
        if (imageRegistry == null) {
            imageRegistry = ResourceSupport.initializeImageRegistry();
        }
        return resourceManager.createImageWithDefault(ImageDescriptor.createWithFlags((ImageDescriptor)imageRegistry.getDescriptor(key), (int)1));
    }

    protected void finalize() throws Throwable {
        if (imageRegistry != null) {
            imageRegistry.dispose();
        }
        super.finalize();
    }

    private static ImageRegistry initializeImageRegistry() {
        if (ResourceSupport.getDisplay() == null) {
            throw new SWTException(22);
        }
        imageRegistry = new ImageRegistry();
        HashSet<String> imageSet = new HashSet<String>();
        imageSet.add(ICON_SET_RANGE);
        imageSet.add(ICON_RESTRICT_RANGE);
        imageSet.add(ICON_HIDE);
        imageSet.add(ICON_RESET);
        imageSet.add(ICON_CHECKED);
        imageSet.add(ICON_UNCHECKED);
        imageSet.add(ICON_CHECK_ALL);
        imageSet.add(ICON_UNCHECK_ALL);
        imageSet.add(ICON_LEGEND);
        imageSet.add(ICON_SORT);
        imageSet.add(ICON_POSITION);
        imageSet.add(ICON_SETTINGS);
        imageSet.add(ICON_MAPPINGS);
        imageSet.add(ICON_DELETE);
        imageSet.add(ICON_DELETE_ALL);
        imageSet.add(ARROW_LEFT);
        imageSet.add(ARROW_RIGHT);
        imageSet.add(ARROW_UP);
        imageSet.add(ARROW_DOWN);
        imageSet.add(ICON_SERIES_MARKER);
        imageSet.add(ICON_IMPORT);
        imageSet.add(ICON_EXPORT);
        imageSet.add(ICON_RESET_SELECTED);
        imageSet.add(ICON_RESET_ALL);
        imageSet.add(ICON_RESET_SELECTION);
        imageSet.add(ICON_REDO);
        imageSet.add(ICON_UNDO);
        imageSet.add(ICON_COPY_CLIPBOARD);
        imageSet.add(ICON_CSV);
        imageSet.add(ICON_FIGURE);
        imageSet.add(ICON_BITMAP);
        imageSet.add(ICON_PRINT);
        imageSet.add(ICON_TEX);
        imageSet.add(ICON_R);
        imageSet.add(ICON_TRANSFER);
        imageSet.add(ICON_SAVE);
        imageSet.add(ICON_ADD);
        for (String image : imageSet) {
            imageRegistry.put(image, ResourceSupport.createImageDescriptor(image));
        }
        return imageRegistry;
    }

    private static ImageDescriptor createImageDescriptor(String fileName) {
        URL url = fileName.endsWith("svg") ? ResourceSupport.class.getResource("/resources/icons/svg/" + fileName) : ResourceSupport.class.getResource("/resources/icons/16x16/" + fileName);
        return ImageDescriptor.createFromURL((URL)url);
    }
}

