/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.migration;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.CollapseFilter;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DiagramFactory;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.GraphicalFilter;
import org.eclipse.sirius.diagram.IndirectlyCollapseFilter;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.eclipse.sirius.diagram.ui.business.api.query.NodeQuery;
import org.eclipse.sirius.diagram.ui.edit.internal.part.PortLayoutHelper;
import org.eclipse.sirius.diagram.ui.internal.refresh.GMFHelper;
import org.eclipse.sirius.diagram.ui.internal.refresh.borderednode.CanonicalDBorderItemLocator;
import org.eclipse.sirius.diagram.ui.part.SiriusVisualIDRegistry;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IBorderItemOffsets;
import org.osgi.framework.Version;

public class DiagramRepresentationsFileMigrationParticipantV670 {
    public static final Version MIGRATION_VERSION = new Version("6.7.0.201302181200");
    private Predicate<Node> isBorderedNode = new IsBorderedNodePredicate();
    private Predicate<Node> isDirectlyCollapsedNode = new IsDirectlyCollapsedNodePredicate();

    public void migrateLabelConstraintFromBoundsToLocation(List<Diagram> diagrams) {
        for (Diagram diagram : diagrams) {
            TreeIterator iterator = diagram.eAllContents();
            while (iterator.hasNext()) {
                LayoutConstraint layoutConstraint;
                Node node;
                int typeInt;
                EObject element = (EObject)iterator.next();
                if (!(element instanceof Node) || (typeInt = SiriusVisualIDRegistry.getVisualID((node = (Node)element).getType())) != 5002 && typeInt != 5001 && typeInt != 5003 && typeInt != 5010 || !((layoutConstraint = node.getLayoutConstraint()) instanceof Bounds)) continue;
                Location location = NotationFactory.eINSTANCE.createLocation();
                location.setX(((Bounds)layoutConstraint).getX());
                location.setY(((Bounds)layoutConstraint).getY());
                node.setLayoutConstraint((LayoutConstraint)location);
            }
        }
    }

    public void migrateGMFBoundsOfBorderedNodes(List<Diagram> diagrams) {
        for (Diagram diagram : Iterables.filter(diagrams, (Predicate)new IsStandardDiagramPredicate())) {
            this.migrateChildrenOfCollapsedNode(diagram);
            this.migrateGraphicalFiltersAndGMFBounds(diagram);
            this.avoidOverlaps(diagram);
        }
    }

    private void avoidOverlaps(Diagram diagram) {
        UnmodifiableIterator viewIterator = Iterators.filter((Iterator)Iterators.filter((Iterator)diagram.eAllContents(), Node.class), this.isBorderedNode);
        ArrayList otherBorderedNodesToIgnore = Lists.newArrayList((Iterator)Iterators.filter((Iterator)Iterators.filter((Iterator)diagram.eAllContents(), Node.class), this.isBorderedNode));
        while (viewIterator.hasNext()) {
            Node node = (Node)viewIterator.next();
            Node parentNode = (Node)node.eContainer();
            CanonicalDBorderItemLocator borderItemLocator = new CanonicalDBorderItemLocator(parentNode, 29);
            borderItemLocator.setBorderItemOffset(IBorderItemOffsets.DEFAULT_OFFSET);
            LayoutConstraint layoutConstraint = node.getLayoutConstraint();
            if (layoutConstraint instanceof Location) {
                Rectangle constraint;
                if (layoutConstraint instanceof Bounds) {
                    Bounds bounds = (Bounds)layoutConstraint;
                    constraint = new Rectangle(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
                } else {
                    Location location = (Location)layoutConstraint;
                    constraint = new Rectangle(location.getX(), location.getY(), -1, -1);
                }
                Point parentAbsoluteLocation = GMFHelper.getAbsoluteLocation(parentNode, false, false);
                constraint.translate(parentAbsoluteLocation.x, parentAbsoluteLocation.y);
                Point realLocation = borderItemLocator.getValidLocation(constraint, node, otherBorderedNodesToIgnore);
                Dimension d = realLocation.getDifference(parentAbsoluteLocation);
                realLocation.setLocation(new Point(d.width, d.height));
                Location location = (Location)layoutConstraint;
                location.setX(realLocation.x);
                location.setY(realLocation.y);
            }
            otherBorderedNodesToIgnore.remove(node);
        }
    }

    private void migrateGraphicalFiltersAndGMFBounds(Diagram diagram) {
        UnmodifiableIterator viewIterator = Iterators.filter((Iterator)Iterators.filter((Iterator)diagram.eAllContents(), Node.class), this.isBorderedNode);
        while (viewIterator.hasNext()) {
            DNode dNode;
            Node node = (Node)viewIterator.next();
            if (!(node.getElement() instanceof DNode) || !(node.eContainer() instanceof Node) || !new DDiagramElementQuery((DDiagramElement)(dNode = (DNode)node.getElement())).isIndirectlyCollapsed()) continue;
            Dimension expectedCollapsedSize = new NodeQuery(node).getCollapsedSize();
            LayoutConstraint layoutConstraint = node.getLayoutConstraint();
            if (!(layoutConstraint instanceof Bounds)) continue;
            Bounds bounds = (Bounds)layoutConstraint;
            Rectangle rectBounds = GMFHelper.getAbsoluteBounds(node, false, false, false, true);
            for (GraphicalFilter graphicalFilter : dNode.getGraphicalFilters()) {
                if (!(graphicalFilter instanceof CollapseFilter)) continue;
                ((CollapseFilter)graphicalFilter).setWidth(bounds.getWidth());
                ((CollapseFilter)graphicalFilter).setHeight(bounds.getHeight());
            }
            Rectangle parentBorder = new NodeQuery((Node)node.eContainer()).getHandleBounds();
            Rectangle newCollapsedBounds = PortLayoutHelper.getCollapseCandidateLocation(expectedCollapsedSize, rectBounds, parentBorder);
            newCollapsedBounds.translate(parentBorder.getLocation().negate());
            Bounds newBounds = NotationFactory.eINSTANCE.createBounds();
            newBounds.setX(newCollapsedBounds.x);
            newBounds.setY(newCollapsedBounds.y);
            newBounds.setWidth(newCollapsedBounds.width);
            newBounds.setHeight(newCollapsedBounds.height);
            node.setLayoutConstraint((LayoutConstraint)newBounds);
        }
    }

    private void migrateChildrenOfCollapsedNode(Diagram diagram) {
        ArrayList indirectlyCollaspedDDEs = new ArrayList();
        UnmodifiableIterator viewIterator = Iterators.filter((Iterator)Iterators.filter((Iterator)diagram.eAllContents(), Node.class), this.isDirectlyCollapsedNode);
        while (viewIterator.hasNext()) {
            Node node = (Node)viewIterator.next();
            if (!(node.getElement() instanceof AbstractDNode)) continue;
            AbstractDNode abstractDNode = (AbstractDNode)node.getElement();
            indirectlyCollaspedDDEs.addAll(abstractDNode.getOwnedBorderedNodes());
            if (abstractDNode instanceof DNodeContainer) {
                DNodeContainer dDiagramElementContainer = (DNodeContainer)abstractDNode;
                indirectlyCollaspedDDEs.addAll(dDiagramElementContainer.getOwnedDiagramElements());
                continue;
            }
            if (!(abstractDNode instanceof DNodeList)) continue;
            DNodeList dNodeList = (DNodeList)abstractDNode;
            indirectlyCollaspedDDEs.addAll(dNodeList.getOwnedElements());
        }
        for (DDiagramElement indirectlyCollaspedDDE : indirectlyCollaspedDDEs) {
            if (Iterables.any((Iterable)indirectlyCollaspedDDE.getGraphicalFilters(), (Predicate)Predicates.instanceOf(IndirectlyCollapseFilter.class))) continue;
            IndirectlyCollapseFilter indirectlyCollapseFilter = DiagramFactory.eINSTANCE.createIndirectlyCollapseFilter();
            indirectlyCollaspedDDE.getGraphicalFilters().add((Object)indirectlyCollapseFilter);
        }
    }

    private static class IsBorderedNodePredicate
    implements Predicate<Node> {
        private IsBorderedNodePredicate() {
        }

        public boolean apply(Node input) {
            return new NodeQuery(input).isBorderedNode();
        }
    }

    private static class IsDirectlyCollapsedNodePredicate
    implements Predicate<Node> {
        private IsDirectlyCollapsedNodePredicate() {
        }

        public boolean apply(Node input) {
            boolean apply = false;
            int type = SiriusVisualIDRegistry.getVisualID(input.getType());
            boolean result = type == 3001 || type == 3012;
            result = result || type == 2001 || type == 3007;
            result = result || type == 2002 || type == 3008;
            boolean bl = result = result || type == 2003 || type == 3009;
            if (result) {
                return new NodeQuery(input).isDirectlyCollapsed();
            }
            return apply;
        }
    }

    private static class IsStandardDiagramPredicate
    implements Predicate<Diagram> {
        private IsStandardDiagramPredicate() {
        }

        public boolean apply(Diagram input) {
            DDiagram diag;
            EPackage diagPackage;
            boolean apply = false;
            if (input.getElement() instanceof DDiagram && (apply = DiagramPackage.eINSTANCE.equals(diagPackage = (diag = (DDiagram)input.getElement()).eClass().getEPackage())) && diag.getDescription() != null) {
                EPackage descriptionPackage = diag.getDescription().eClass().getEPackage();
                apply = DescriptionPackage.eINSTANCE.equals(descriptionPackage);
            }
            return apply;
        }
    }
}

