/**
 * Copyright (c) 2008, 2015 IBM Corporation and others.
 *
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *      IBM Corporation - initial API and implementation
 */
package org.eclipse.e4.ui.model.application.ui.basic.impl;

import java.util.Collection;
import java.util.List;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MGenericTile;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.model.application.ui.impl.UiPackageImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Composite Part</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.e4.ui.model.application.ui.basic.impl.CompositePartImpl#getChildren <em>Children</em>}</li>
 *   <li>{@link org.eclipse.e4.ui.model.application.ui.basic.impl.CompositePartImpl#getSelectedElement <em>Selected Element</em>}</li>
 *   <li>{@link org.eclipse.e4.ui.model.application.ui.basic.impl.CompositePartImpl#isHorizontal <em>Horizontal</em>}</li>
 * </ul>
 *
 * @since 1.1
 * @generated
 */
public class CompositePartImpl extends PartImpl implements MCompositePart {
	/**
	 * The cached value of the '{@link #getChildren() <em>Children</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getChildren()
	 * @generated
	 * @ordered
	 */
	protected EList<MPartSashContainerElement> children;

	/**
	 * The cached value of the '{@link #getSelectedElement() <em>Selected Element</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSelectedElement()
	 * @generated
	 * @ordered
	 */
	protected MPartSashContainerElement selectedElement;

	/**
	 * The default value of the '{@link #isHorizontal() <em>Horizontal</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isHorizontal()
	 * @generated
	 * @ordered
	 */
	protected static final boolean HORIZONTAL_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isHorizontal() <em>Horizontal</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isHorizontal()
	 * @generated
	 * @ordered
	 */
	protected boolean horizontal = HORIZONTAL_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CompositePartImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return BasicPackageImpl.Literals.COMPOSITE_PART;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public List<MPartSashContainerElement> getChildren() {
		if (children == null) {
			children = new EObjectContainmentWithInverseEList<>(
					MPartSashContainerElement.class, this, BasicPackageImpl.COMPOSITE_PART__CHILDREN,
					UiPackageImpl.UI_ELEMENT__PARENT) {
				private static final long serialVersionUID = 1L;

				@Override
				public Class<?> getInverseFeatureClass() {
					return MUIElement.class;
				}
			};
		}
		return children;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public MPartSashContainerElement getSelectedElement() {
		if (selectedElement != null && ((EObject) selectedElement).eIsProxy()) {
			InternalEObject oldSelectedElement = (InternalEObject) selectedElement;
			selectedElement = (MPartSashContainerElement) eResolveProxy(oldSelectedElement);
			if (selectedElement != oldSelectedElement) {
				if (eNotificationRequired()) {
					eNotify(new ENotificationImpl(this, Notification.RESOLVE,
							BasicPackageImpl.COMPOSITE_PART__SELECTED_ELEMENT, oldSelectedElement, selectedElement));
				}
			}
		}
		return selectedElement;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MPartSashContainerElement basicGetSelectedElement() {
		return selectedElement;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSelectedElement(MPartSashContainerElement newSelectedElement) {
		MPartSashContainerElement oldSelectedElement = selectedElement;
		selectedElement = newSelectedElement;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET, BasicPackageImpl.COMPOSITE_PART__SELECTED_ELEMENT,
					oldSelectedElement, selectedElement));
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isHorizontal() {
		return horizontal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setHorizontal(boolean newHorizontal) {
		boolean oldHorizontal = horizontal;
		horizontal = newHorizontal;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET, BasicPackageImpl.COMPOSITE_PART__HORIZONTAL,
					oldHorizontal, horizontal));
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
		case BasicPackageImpl.COMPOSITE_PART__CHILDREN:
			return ((InternalEList<InternalEObject>) (InternalEList<?>) getChildren()).basicAdd(otherEnd, msgs);
		default:
			return super.eInverseAdd(otherEnd, featureID, msgs);
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
		case BasicPackageImpl.COMPOSITE_PART__CHILDREN:
			return ((InternalEList<?>) getChildren()).basicRemove(otherEnd, msgs);
		default:
			return super.eInverseRemove(otherEnd, featureID, msgs);
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case BasicPackageImpl.COMPOSITE_PART__CHILDREN:
			return getChildren();
		case BasicPackageImpl.COMPOSITE_PART__SELECTED_ELEMENT:
			if (resolve) {
				return getSelectedElement();
			}
			return basicGetSelectedElement();
		case BasicPackageImpl.COMPOSITE_PART__HORIZONTAL:
			return isHorizontal();
		default:
			return super.eGet(featureID, resolve, coreType);
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case BasicPackageImpl.COMPOSITE_PART__CHILDREN:
			getChildren().clear();
			getChildren().addAll((Collection<? extends MPartSashContainerElement>) newValue);
			return;
		case BasicPackageImpl.COMPOSITE_PART__SELECTED_ELEMENT:
			setSelectedElement((MPartSashContainerElement) newValue);
			return;
		case BasicPackageImpl.COMPOSITE_PART__HORIZONTAL:
			setHorizontal((Boolean) newValue);
			return;
		default:
			super.eSet(featureID, newValue);
			return;
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case BasicPackageImpl.COMPOSITE_PART__CHILDREN:
			getChildren().clear();
			return;
		case BasicPackageImpl.COMPOSITE_PART__SELECTED_ELEMENT:
			setSelectedElement((MPartSashContainerElement) null);
			return;
		case BasicPackageImpl.COMPOSITE_PART__HORIZONTAL:
			setHorizontal(HORIZONTAL_EDEFAULT);
			return;
		default:
			super.eUnset(featureID);
			return;
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case BasicPackageImpl.COMPOSITE_PART__CHILDREN:
			return children != null && !children.isEmpty();
		case BasicPackageImpl.COMPOSITE_PART__SELECTED_ELEMENT:
			return selectedElement != null;
		case BasicPackageImpl.COMPOSITE_PART__HORIZONTAL:
			return horizontal != HORIZONTAL_EDEFAULT;
		default:
			return super.eIsSet(featureID);
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == MElementContainer.class) {
			switch (derivedFeatureID) {
			case BasicPackageImpl.COMPOSITE_PART__CHILDREN:
				return UiPackageImpl.ELEMENT_CONTAINER__CHILDREN;
			case BasicPackageImpl.COMPOSITE_PART__SELECTED_ELEMENT:
				return UiPackageImpl.ELEMENT_CONTAINER__SELECTED_ELEMENT;
			default:
				return -1;
			}
		}
		if (baseClass == MGenericTile.class) {
			switch (derivedFeatureID) {
			case BasicPackageImpl.COMPOSITE_PART__HORIZONTAL:
				return UiPackageImpl.GENERIC_TILE__HORIZONTAL;
			default:
				return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == MElementContainer.class) {
			switch (baseFeatureID) {
			case UiPackageImpl.ELEMENT_CONTAINER__CHILDREN:
				return BasicPackageImpl.COMPOSITE_PART__CHILDREN;
			case UiPackageImpl.ELEMENT_CONTAINER__SELECTED_ELEMENT:
				return BasicPackageImpl.COMPOSITE_PART__SELECTED_ELEMENT;
			default:
				return -1;
			}
		}
		if (baseClass == MGenericTile.class) {
			switch (baseFeatureID) {
			case UiPackageImpl.GENERIC_TILE__HORIZONTAL:
				return BasicPackageImpl.COMPOSITE_PART__HORIZONTAL;
			default:
				return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) {
			return super.toString();
		}

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (horizontal: "); //$NON-NLS-1$
		result.append(horizontal);
		result.append(')');
		return result.toString();
	}

} //CompositePartImpl
