/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.contexts;

import java.util.Iterator;
import org.eclipse.core.expressions.Expression;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.internal.contexts.SlaveContextService;
import org.eclipse.ui.internal.services.INestable;

public class NestableContextService
extends SlaveContextService
implements INestable {
    private boolean fActive = false;

    public NestableContextService(IContextService parentService, Expression defaultExpression) {
        super(parentService, defaultExpression);
    }

    @Override
    protected IContextActivation doActivateContext(IContextActivation activation) {
        if (this.fActive) {
            return super.doActivateContext(activation);
        }
        this.fLocalActivations.put(activation, null);
        return activation;
    }

    @Override
    public void activate() {
        if (this.fActive) {
            return;
        }
        for (IContextActivation activation : this.fLocalActivations.keySet()) {
            super.doActivateContext(activation);
        }
        this.fActive = true;
    }

    @Override
    public void deactivate() {
        if (!this.fActive) {
            return;
        }
        this.deactivateContexts(this.fParentActivations);
        this.fParentActivations.clear();
        Iterator c = this.fLocalActivations.keySet().iterator();
        while (c.hasNext()) {
            this.fLocalActivations.put(c.next(), null);
        }
        this.fActive = false;
    }
}

