/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.util;

import java.util.ArrayList;
import java.util.List;

public final class EncodingUtil {
    private static final String UNIX_NEWLINE = "\\n";

    public static String replaceNewLines(String input) {
        return EncodingUtil.replaceNewLines(input, UNIX_NEWLINE);
    }

    public static String replaceNewLines(String input, String replacement) {
        StringBuilder resultBuffer = null;
        int length = input.length();
        int start = 0;
        int i = 0;
        while (i < length) {
            char ch = input.charAt(i);
            if (ch == '\n' || ch == '\r') {
                if (resultBuffer == null) {
                    resultBuffer = new StringBuilder();
                }
                resultBuffer.append(input, start, i);
                resultBuffer.append(replacement);
                if (ch == '\r' && i + 1 < length && input.charAt(i + 1) == '\n') {
                    ++i;
                }
                start = i + 1;
            }
            ++i;
        }
        if (resultBuffer != null) {
            resultBuffer.append(input, start, i);
            return resultBuffer.toString();
        }
        return input;
    }

    public static List<String> splitNewLines(String input) {
        ArrayList<String> lines = new ArrayList<String>();
        int length = input.length();
        int start = 0;
        int last = 0;
        int i = 0;
        while (i < length) {
            char ch = input.charAt(i);
            if (ch == '\n') {
                if (last != 13) {
                    lines.add(input.substring(start, i));
                }
                start = i + 1;
            } else if (ch == '\r') {
                lines.add(input.substring(start, i));
                start = i + 1;
            }
            last = ch;
            ++i;
        }
        lines.add(input.substring(start, length));
        return lines;
    }

    private EncodingUtil() {
    }
}

