/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.http.servlet.internal.customizer;

import jakarta.servlet.Filter;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.rap.http.servlet.internal.HttpServiceRuntimeImpl;
import org.eclipse.rap.http.servlet.internal.context.ContextController;
import org.eclipse.rap.http.servlet.internal.customizer.RegistrationServiceTrackerCustomizer;
import org.eclipse.rap.http.servlet.internal.error.HttpWhiteboardFailureException;
import org.eclipse.rap.http.servlet.internal.registration.FilterRegistration;
import org.eclipse.rap.http.servlet.internal.util.BooleanPlus;
import org.eclipse.rap.http.servlet.internal.util.ServiceProperties;
import org.eclipse.rap.http.servlet.internal.util.StringPlus;
import org.eclipse.rap.service.servlet.internal.runtime.dto.FailedFilterDTO;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ContextFilterTrackerCustomizer
extends RegistrationServiceTrackerCustomizer<Filter, FilterRegistration> {
    public ContextFilterTrackerCustomizer(BundleContext bundleContext, HttpServiceRuntimeImpl httpServiceRuntime, ContextController contextController) {
        super(bundleContext, httpServiceRuntime, contextController);
    }

    public AtomicReference<FilterRegistration> addingService(ServiceReference<Filter> serviceReference) {
        AtomicReference<FilterRegistration> result = new AtomicReference<FilterRegistration>();
        if (!this.httpServiceRuntime.matches(serviceReference)) {
            return result;
        }
        try {
            this.contextController.checkShutdown();
            if (!this.contextController.matches(serviceReference)) {
                if (this.httpServiceRuntime.isDefaultContext(this.contextController) && !this.httpServiceRuntime.matchesAnyContext(serviceReference)) {
                    throw new HttpWhiteboardFailureException("Doesn't match any contexts. " + String.valueOf(serviceReference), 1);
                }
                AtomicReference<FilterRegistration> atomicReference = result;
                return atomicReference;
            }
            try {
                this.httpServiceRuntime.removeFailedFilterDTO(serviceReference);
                result.set(this.contextController.addFilterRegistration(serviceReference));
            }
            catch (HttpWhiteboardFailureException hwfe) {
                this.httpServiceRuntime.debug(hwfe.getMessage(), hwfe);
                this.recordFailed(serviceReference, hwfe.getFailureReason());
            }
            catch (Throwable t) {
                this.httpServiceRuntime.error(t.getMessage(), t);
                this.recordFailed(serviceReference, 4);
            }
        }
        finally {
            this.httpServiceRuntime.incrementServiceChangecount();
        }
        return result;
    }

    @Override
    void removeFailed(ServiceReference<Filter> serviceReference) {
        this.contextController.getHttpServiceRuntime().removeFailedFilterDTO(serviceReference);
    }

    private void recordFailed(ServiceReference<Filter> serviceReference, int failureReason) {
        FailedFilterDTO failedFilterDTO = new FailedFilterDTO();
        failedFilterDTO.asyncSupported = BooleanPlus.from(serviceReference.getProperty("osgi.http.whiteboard.filter.asyncSupported"), false);
        failedFilterDTO.dispatcher = StringPlus.from(serviceReference.getProperty("osgi.http.whiteboard.filter.dispatcher")).toArray(new String[0]);
        failedFilterDTO.failureReason = failureReason;
        failedFilterDTO.initParams = ServiceProperties.parseInitParams(serviceReference, "filter.init.");
        failedFilterDTO.name = (String)serviceReference.getProperty("osgi.http.whiteboard.filter.name");
        failedFilterDTO.patterns = StringPlus.from(serviceReference.getProperty("osgi.http.whiteboard.filter.pattern")).toArray(new String[0]);
        failedFilterDTO.regexs = StringPlus.from(serviceReference.getProperty("osgi.http.whiteboard.filter.regex")).toArray(new String[0]);
        failedFilterDTO.serviceId = (Long)serviceReference.getProperty("service.id");
        failedFilterDTO.servletContextId = this.contextController.getServiceId();
        failedFilterDTO.servletNames = StringPlus.from(serviceReference.getProperty("osgi.http.whiteboard.filter.servlet")).toArray(new String[0]);
        this.contextController.getHttpServiceRuntime().recordFailedFilterDTO(serviceReference, failedFilterDTO);
    }
}

