/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.resolver;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.felix.resolver.Candidates;
import org.apache.felix.resolver.ResolutionError;
import org.apache.felix.resolver.ResolveSession;

public class Backlog {
    private final ResolveSession session;
    private final Map<Candidates, Candidates.FaultyResourcesReport> backlog = new LinkedHashMap<Candidates, Candidates.FaultyResourcesReport>();

    public Backlog(ResolveSession session) {
        this.session = session;
    }

    public Candidates getNext() {
        Candidates candidates;
        while ((candidates = this.session.getNextPermutation()) != null) {
            ResolutionError substituteError = candidates.checkSubstitutes();
            Candidates.FaultyResourcesReport report = candidates.getFaultyResources(Collections.emptyMap());
            if (!report.isMissing() || this.session.isCancelled()) {
                return candidates;
            }
            this.backlog.put(candidates, candidates.getFaultyResources(Collections.emptyMap()));
        }
        if (this.backlog.isEmpty()) {
            return null;
        }
        Map.Entry<Candidates, Candidates.FaultyResourcesReport> bestEntry = null;
        for (Map.Entry<Candidates, Candidates.FaultyResourcesReport> entry : this.backlog.entrySet()) {
            if (bestEntry != null && !entry.getValue().isBetterThan(bestEntry.getValue())) continue;
            bestEntry = entry;
        }
        Candidates result = (Candidates)bestEntry.getKey();
        this.backlog.remove(result);
        return result;
    }
}

