/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.test.assertj.bundle;

import java.net.URL;
import java.util.Objects;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractDateAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AssertFactory;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.test.assertj.date.Dates;
import org.osgi.test.assertj.version.VersionAssert;
import org.osgi.test.common.bitmaps.BundleState;

public abstract class AbstractBundleAssert<SELF extends AbstractBundleAssert<SELF, ACTUAL>, ACTUAL extends Bundle>
extends AbstractAssert<SELF, ACTUAL> {
    protected AbstractBundleAssert(ACTUAL actual, Class<SELF> selfType) {
        super(actual, selfType);
    }

    public SELF isFragment() {
        this.isNotNull();
        if ((((BundleRevision)((Bundle)this.actual).adapt(BundleRevision.class)).getTypes() & 1) == 0) {
            throw this.failure("%nExpecting%n  <%s>%nto be a fragment, but it was not", new Object[]{this.actual});
        }
        return (SELF)((Object)((AbstractBundleAssert)this.myself));
    }

    public SELF isNotFragment() {
        this.isNotNull();
        if ((((BundleRevision)((Bundle)this.actual).adapt(BundleRevision.class)).getTypes() & 1) != 0) {
            String host = (String)((Bundle)this.actual).getHeaders().get("Fragment-Host");
            throw this.failure("%nExpecting%n  <%s>%nto not be a fragment, but it was, with host:%n  <%s>", new Object[]{this.actual, host});
        }
        return (SELF)((Object)((AbstractBundleAssert)this.myself));
    }

    public SELF hasPermission(Object permission) {
        this.isNotNull();
        if (!((Bundle)this.actual).hasPermission(permission)) {
            throw this.failure("%nExpecting%n  <%s>%nto have permission%n  <%s>%nbut it did not", new Object[]{this.actual, permission});
        }
        return (SELF)((Object)((AbstractBundleAssert)this.myself));
    }

    public SELF doesNotHavePermission(Object permission) {
        this.isNotNull();
        if (((Bundle)this.actual).hasPermission(permission)) {
            throw this.failure("%nExpecting%n  <%s>%nnot to have permission%n  <%s>%nbut it did", new Object[]{this.actual, permission});
        }
        return (SELF)((Object)((AbstractBundleAssert)this.myself));
    }

    public SELF hasSymbolicName(String expected) {
        this.isNotNull();
        if (!Objects.equals(((Bundle)this.actual).getSymbolicName(), expected)) {
            throw this.failureWithActualExpected(((Bundle)this.actual).getSymbolicName(), expected, "%nExpecting%n  <%s>%nto have symbolic name:%n  <%s>%n but was:%n  <%s>", new Object[]{this.actual, expected, ((Bundle)this.actual).getSymbolicName()});
        }
        return (SELF)((Object)((AbstractBundleAssert)this.myself));
    }

    public AbstractStringAssert<?> hasSymbolicNameThat() {
        return (AbstractStringAssert)((AbstractStringAssert)((AbstractBundleAssert)this.isNotNull()).extracting(Bundle::getSymbolicName, (AssertFactory)InstanceOfAssertFactories.STRING)).as(this.actual + ".symbolicName", new Object[0]);
    }

    public SELF hasLocation(String expected) {
        this.isNotNull();
        if (!Objects.equals(((Bundle)this.actual).getLocation(), expected)) {
            throw this.failureWithActualExpected(((Bundle)this.actual).getLocation(), expected, "%nExpecting%n  <%s>%nto have location:%n  <%s>%n but was:%n  <%s>", new Object[]{this.actual, expected, ((Bundle)this.actual).getLocation()});
        }
        return (SELF)((Object)((AbstractBundleAssert)this.myself));
    }

    public AbstractStringAssert<?> hasLocationThat() {
        return (AbstractStringAssert)((AbstractStringAssert)((AbstractBundleAssert)this.isNotNull()).extracting(Bundle::getLocation, (AssertFactory)InstanceOfAssertFactories.STRING)).as(this.actual + ".location", new Object[0]);
    }

    public SELF hasEntry(String entry) {
        this.isNotNull();
        if (((Bundle)this.actual).getEntry(entry) == null) {
            throw this.failure("%nExpecting%n <%s>%nto have entry:%n <%s>%n but it did not", new Object[]{this.actual, entry});
        }
        return (SELF)((Object)((AbstractBundleAssert)this.myself));
    }

    public SELF doesNotHaveEntry(String resource) {
        this.isNotNull();
        URL url = ((Bundle)this.actual).getEntry(resource);
        if (url != null) {
            throw this.failure("%nExpecting%n  <%s>%nto not have entry:%n  <%s>%n but it did:%n  <%s>", new Object[]{this.actual, resource, url});
        }
        return (SELF)((Object)((AbstractBundleAssert)this.myself));
    }

    public SELF hasResource(String resource) {
        this.isNotNull();
        if (((Bundle)this.actual).getResource(resource) == null) {
            throw this.failure("%nExpecting%n  <%s>%nto have resource:%n  <%s>%n but it did not", new Object[]{this.actual, resource});
        }
        return (SELF)((Object)((AbstractBundleAssert)this.myself));
    }

    public SELF doesNotHaveResource(String resource) {
        this.isNotNull();
        URL url = ((Bundle)this.actual).getResource(resource);
        if (url != null) {
            throw this.failure("%nExpecting%n  <%s>%nto not have resource:%n  <%s>%n but it did:%n  <%s>", new Object[]{this.actual, resource, url});
        }
        return (SELF)((Object)((AbstractBundleAssert)this.myself));
    }

    public SELF hasBundleId(long expected) {
        this.isNotNull();
        if (((Bundle)this.actual).getBundleId() != expected) {
            throw this.failureWithActualExpected(((Bundle)this.actual).getBundleId(), expected, "%nExpecting%n  <%s>%nto have bundle ID:%n  <%d>%n but was:%n  <%d>", new Object[]{this.actual, expected, ((Bundle)this.actual).getBundleId()});
        }
        return (SELF)((Object)((AbstractBundleAssert)this.myself));
    }

    private static Version getVersion(Object version) {
        if (version == null) {
            return null;
        }
        if (version instanceof Version) {
            return (Version)version;
        }
        if (version instanceof CharSequence) {
            return Version.valueOf((String)version.toString());
        }
        throw new IllegalArgumentException("expected should be an instance of CharSequence or Version; was " + version.getClass().getName());
    }

    public VersionAssert hasVersionThat() {
        return (VersionAssert)((VersionAssert)((AbstractBundleAssert)this.isNotNull()).extracting(Bundle::getVersion, (AssertFactory)VersionAssert.VERSION)).as(this.actual + ".version", new Object[0]);
    }

    public SELF hasVersion(Object expected) {
        this.isNotNull();
        Version expectedVersion = AbstractBundleAssert.getVersion(expected);
        if (!Objects.equals(((Bundle)this.actual).getVersion(), expectedVersion)) {
            throw this.failureWithActualExpected(((Bundle)this.actual).getVersion(), expected, "%nExpecting%n  <%s>%nto have version:%n  <%s>%n but was:%n  <%s>", new Object[]{this.actual, expected, ((Bundle)this.actual).getVersion()});
        }
        return (SELF)((Object)((AbstractBundleAssert)this.myself));
    }

    public SELF hasLastModified(Object expected) {
        this.isNotNull();
        long expectedTime = Dates.getTime(expected);
        if (((Bundle)this.actual).getLastModified() != expectedTime) {
            throw this.failure("%nExpecting%n <%s>%nto have last modified time:%n  <%d>%n but it was:%n  <%d>", new Object[]{this.actual, expectedTime, ((Bundle)this.actual).getLastModified()});
        }
        return (SELF)((Object)((AbstractBundleAssert)this.myself));
    }

    public AbstractLongAssert<?> hasLastModifiedLongThat() {
        return (AbstractLongAssert)((AbstractLongAssert)((AbstractBundleAssert)this.isNotNull()).extracting(Bundle::getLastModified, (AssertFactory)InstanceOfAssertFactories.LONG)).as(this.actual + ".lastModified", new Object[0]);
    }

    public AbstractDateAssert<?> hasLastModifiedDateThat() {
        return (AbstractDateAssert)((AbstractDateAssert)((AbstractBundleAssert)this.isNotNull()).extracting(Bundle::getLastModified, (AssertFactory)Dates.LONG_AS_DATE)).as(this.actual + ".lastModified", new Object[0]);
    }

    public SELF isInState(int expected) {
        this.isNotNull();
        if ((expected & expected - 1) != 0) {
            throw new IllegalArgumentException("Multiple bits set in expected (" + expected + ") - do you mean to use isInStateMaskedBy()?");
        }
        String expectedString = BundleState.BITMAP.toString(expected);
        if ((((Bundle)this.actual).getState() & expected) == 0) {
            throw this.failure("%nExpecting%n  <%s>%nto be in state:%n  <%d:%s>%n but was in state:%n  <%s>", new Object[]{this.actual, expected, expectedString, BundleState.BITMAP.maskToString(((Bundle)this.actual).getState())});
        }
        return (SELF)((Object)((AbstractBundleAssert)this.myself));
    }

    public SELF isNotInState(int expected) {
        this.isNotNull();
        String expectedState = BundleState.BITMAP.toString(expected);
        if ((((Bundle)this.actual).getState() & expected) != 0) {
            throw this.failure("%nExpecting%n  <%s>%nnot to be in state:%n  <%d:%s>%n but it was", new Object[]{this.actual, expected, expectedState});
        }
        return (SELF)((Object)((AbstractBundleAssert)this.myself));
    }

    public SELF isInStateMaskedBy(int mask) {
        this.isNotNull();
        if (mask <= 0 || mask >= 64) {
            throw new IllegalArgumentException("Mask testing for an illegal state: " + mask);
        }
        if ((((Bundle)this.actual).getState() & mask) == 0) {
            String states = BundleState.BITMAP.maskToString(mask);
            throw this.failure("%nExpecting%n  <%s>%nto be in one of states:%n  [%s]%n but was in state:%n  <%s>", new Object[]{this.actual, states, BundleState.BITMAP.maskToString(((Bundle)this.actual).getState())});
        }
        return (SELF)((Object)((AbstractBundleAssert)this.myself));
    }

    public SELF isNotInStateMask(int mask) {
        this.isNotNull();
        if (mask <= 0 || mask >= 64) {
            throw new IllegalArgumentException("Mask testing for an illegal state: " + mask);
        }
        if ((((Bundle)this.actual).getState() & mask) != 0) {
            String states = BundleState.BITMAP.maskToString(mask);
            throw this.failure("%nExpecting%n  <%s>%nto not be in one of states:%n  [%s]%n but was in state:%n  <%s>", new Object[]{this.actual, states, BundleState.BITMAP.maskToString(((Bundle)this.actual).getState())});
        }
        return (SELF)((Object)((AbstractBundleAssert)this.myself));
    }
}

