/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.service.policy.ui.properties;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.wst.ws.internal.service.policy.ui.ServicePoliciesComposite;
import org.eclipse.wst.ws.internal.service.policy.ui.WstSPUIPluginMessages;
import org.eclipse.wst.ws.service.policy.ServicePolicyPlatform;

public class ServicePoliciesPropertyPage
extends PropertyPage
implements SelectionListener {
    private ServicePoliciesComposite propertyPage;
    private IProject project;
    public static final String PAGE_ID = "org.eclipse.wst.ws.internal.ui.wsi.properties.WSICompliancePropertyPage";
    private Button fUseProjectSettings;
    private Link fChangeWorkspaceSettings;
    private ControlEnableState fBlockEnableState = null;
    private Control fConfigurationBlockControl;
    private ServicePolicyPlatform platform = ServicePolicyPlatform.getInstance();

    protected Control createContents(Composite superparent) {
        this.project = (IProject)this.getElement().getAdapter(IProject.class);
        boolean projectPrefsEnabled = this.platform.isProjectPreferencesEnabled(this.project);
        if (!projectPrefsEnabled) {
            this.platform.setProjectPreferencesEnabled(this.project, true);
        }
        this.propertyPage = new ServicePoliciesComposite(superparent, this.project, this);
        this.platform.setProjectPreferencesEnabled(this.project, projectPrefsEnabled);
        this.fConfigurationBlockControl = this.propertyPage;
        this.enablePreferenceContent(projectPrefsEnabled);
        this.fUseProjectSettings.setSelection(projectPrefsEnabled);
        this.updateLinkVisibility();
        Dialog.applyDialogFont((Control)superparent);
        return this.propertyPage;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.propertyPage.widgetDefaultSelected(e);
    }

    public void dispose() {
        super.dispose();
        this.propertyPage.dispose();
    }

    public boolean okToLeave() {
        return this.propertyPage.getError() == null;
    }

    protected void performApply() {
        if (!this.fUseProjectSettings.getSelection()) {
            this.platform.setProjectPreferencesEnabled(this.project, false);
        }
        this.storeValues();
    }

    public boolean performCancel() {
        this.platform.discardChanges(this.project);
        return true;
    }

    protected void performDefaults() {
        this.enableProjectSpecificSettings(false);
        this.platform.setProjectPreferencesEnabled(this.project, false);
        this.propertyPage.performDefaults();
        IStatus error = this.propertyPage.getError();
        if (error == null) {
            super.setValid(true);
            super.setErrorMessage(null);
        } else {
            super.setErrorMessage(error.getMessage());
            super.setValid(false);
        }
    }

    public boolean performOk() {
        if (!this.fUseProjectSettings.getSelection()) {
            this.platform.setProjectPreferencesEnabled(this.project, false);
        }
        this.storeValues();
        return true;
    }

    private void storeValues() {
        this.platform.commitChanges(this.project);
    }

    public void widgetSelected(SelectionEvent e) {
        IStatus error = this.propertyPage.getError();
        if (error == null) {
            super.setValid(true);
            super.setErrorMessage(null);
        } else {
            super.setErrorMessage(error.getMessage());
            super.setValid(false);
        }
    }

    protected Label createDescriptionLabel(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        SelectionListener listener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent se) {
            }

            public void widgetSelected(SelectionEvent se) {
                ServicePoliciesPropertyPage.this.enableProjectSpecificSettings(ServicePoliciesPropertyPage.this.fUseProjectSettings.getSelection());
                ServicePoliciesPropertyPage.this.platform.setProjectPreferencesEnabled(ServicePoliciesPropertyPage.this.project, ServicePoliciesPropertyPage.this.fUseProjectSettings.getSelection());
            }
        };
        this.fUseProjectSettings = new Button(composite, 32);
        this.fUseProjectSettings.addSelectionListener(listener);
        this.fUseProjectSettings.setText(WstSPUIPluginMessages.LABEL_ENABLE_PROJECT_SETTINGS);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        gd.horizontalAlignment = 4;
        this.fUseProjectSettings.setLayoutData((Object)gd);
        this.fChangeWorkspaceSettings = this.createLink(composite, WstSPUIPluginMessages.LINK_CONFIGWORKSPACE_SETTINGS);
        this.fChangeWorkspaceSettings.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        Label horizontalLine = new Label(composite, 258);
        horizontalLine.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        horizontalLine.setFont(composite.getFont());
        return super.createDescriptionLabel(parent);
    }

    private Link createLink(Composite composite, String text) {
        Link link = new Link(composite, 0);
        link.setFont(composite.getFont());
        link.setText("<A>" + text + "</A>");
        link.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ServicePoliciesPropertyPage.this.openWorkspacePreferences((Link)e.widget);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ServicePoliciesPropertyPage.this.openWorkspacePreferences((Link)e.widget);
            }
        });
        return link;
    }

    private void updateLinkVisibility() {
        if (this.fChangeWorkspaceSettings == null || this.fChangeWorkspaceSettings.isDisposed()) {
            return;
        }
        this.fChangeWorkspaceSettings.setEnabled(!this.useProjectSettings());
    }

    protected boolean useProjectSettings() {
        return this.fUseProjectSettings.getSelection();
    }

    protected void enablePreferenceContent(boolean enable) {
        if (enable) {
            if (this.fBlockEnableState != null) {
                this.fBlockEnableState.restore();
                this.fBlockEnableState = null;
            }
        } else if (this.fBlockEnableState == null) {
            this.fBlockEnableState = ControlEnableState.disable((Control)this.fConfigurationBlockControl);
        }
    }

    protected void enableProjectSpecificSettings(boolean useProjectSpecificSettings) {
        this.fUseProjectSettings.setSelection(useProjectSpecificSettings);
        this.enablePreferenceContent(useProjectSpecificSettings);
        this.updateLinkVisibility();
        this.doStatusChanged();
    }

    protected void doStatusChanged() {
        if (this.useProjectSettings()) {
            Status status = this.propertyPage.getError() == null ? new Status(0, "org.eclipse.wst.ws.service.policy.ui", "") : this.propertyPage.getError();
            this.updateStatus((IStatus)status);
        } else {
            this.updateStatus((IStatus)new Status(0, "org.eclipse.wst.ws.service.policy.ui", ""));
        }
    }

    private void updateStatus(IStatus status) {
        boolean valid = status == null || !status.matches(4);
        this.setValid(valid);
        ServicePoliciesPropertyPage.applyToStatusLine((DialogPage)this, status);
    }

    public static void applyToStatusLine(DialogPage page, IStatus status) {
        String message = status.getMessage();
        if (message != null && message.length() == 0) {
            message = null;
        }
        switch (status.getSeverity()) {
            case 0: {
                page.setMessage(message, 0);
                page.setErrorMessage(null);
                break;
            }
            case 2: {
                page.setMessage(message, 2);
                page.setErrorMessage(null);
                break;
            }
            case 1: {
                page.setMessage(message, 1);
                page.setErrorMessage(null);
                break;
            }
            default: {
                page.setMessage(null);
                page.setErrorMessage(message);
            }
        }
    }

    protected final void openWorkspacePreferences(Object data) {
        String id = "org.eclipse.wst.ws.internal.ui.wsi.preferences.WSICompliancePreferencePage";
        PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)id, (String[])new String[]{id}, (Object)data).open();
    }
}

