/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.model.tree;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.tmf.core.model.AbstractStateSystemAnalysisDataProvider;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public abstract class AbstractTreeDataProvider<A extends TmfStateSystemAnalysisModule, M extends ITmfTreeDataModel>
extends AbstractStateSystemAnalysisDataProvider
implements ITmfTreeDataProvider<M> {
    protected static final Logger LOGGER = TraceCompassLog.getLogger(AbstractTreeDataProvider.class);
    private static final AtomicLong ID_GENERATOR = new AtomicLong();
    private static final Table<String, Object, Long> fScopedIdTable = HashBasedTable.create();
    private static final String DEFAULT_SCOPE = "DEFAULT";
    private final A fAnalysisModule;
    private final ReentrantReadWriteLock fLock = new ReentrantReadWriteLock(false);
    private final BiMap<Long, Integer> fIdToQuark = HashBiMap.create();
    private @Nullable TmfModelResponse<TmfTreeModel<M>> fCached;
    private final Map<Long, Multimap<String, Object>> fEntryMetadata = new HashMap<Long, Multimap<String, Object>>();
    private @Nullable String fScope;
    private Map<Object, Long> fIdTable = new HashMap<Object, Long>();
    private volatile boolean fInitialized = false;

    public AbstractTreeDataProvider(ITmfTrace trace, A analysisModule) {
        super(trace);
        this.fAnalysisModule = analysisModule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        ITmfTreeDataProvider.super.dispose();
        if (this.fScope != null) {
            Table<String, Object, Long> table = fScopedIdTable;
            synchronized (table) {
                fScopedIdTable.row((Object)Objects.requireNonNull(this.fScope)).clear();
            }
        }
    }

    protected A getAnalysisModule() {
        return this.fAnalysisModule;
    }

    protected @Nullable String getScope() {
        return DEFAULT_SCOPE;
    }

    protected long getId(int quark) {
        return (Long)this.fIdToQuark.inverse().computeIfAbsent((Object)quark, q -> this.getEntryId());
    }

    protected long getId(int quark, Object key) {
        return (Long)this.fIdToQuark.inverse().computeIfAbsent((Object)quark, q -> this.getEntryId(key));
    }

    protected long getEntryId() {
        return ID_GENERATOR.getAndIncrement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getEntryId(Object key) {
        Table<String, Object, Long> table = fScopedIdTable;
        synchronized (table) {
            this.checkScopeInitialized();
            return this.fIdTable.computeIfAbsent(key, k -> ID_GENERATOR.getAndIncrement());
        }
    }

    protected Map<Long, Integer> getSelectedEntries(SelectionTimeQueryFilter selectedItems) {
        return this.getSelectedEntries((Collection<Long>)selectedItems.getSelectedItems());
    }

    protected Map<Long, Integer> getSelectedEntries(Collection<Long> selectedItems) {
        this.fLock.readLock().lock();
        try {
            HashMap<Long, Integer> selectedEntries = new HashMap<Long, Integer>();
            for (Long selectedItem : selectedItems) {
                Integer quark = (Integer)this.fIdToQuark.get((Object)selectedItem);
                if (quark == null || quark < 0) continue;
                selectedEntries.put(selectedItem, quark);
            }
            HashMap<Long, Integer> hashMap = selectedEntries;
            return hashMap;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    protected static Collection<Long> getTimes(TimeQueryFilter filter, long start, long end) {
        HashSet<Long> times = new HashSet<Long>();
        long[] lArray = filter.getTimesRequested();
        int n = lArray.length;
        int n2 = 0;
        while (n2 < n) {
            long time = lArray[n2];
            if (start <= time && time <= end) {
                times.add(time);
            }
            ++n2;
        }
        return times;
    }

    /*
     * Exception decompiling
     */
    @Override
    public final TmfModelResponse<TmfTreeModel<M>> fetchTree(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Multimap<String, Object> getEntryMetadata(Long entryId) {
        return this.fEntryMetadata.getOrDefault(entryId, (Multimap<String, Object>)ImmutableMultimap.of());
    }

    protected abstract boolean isCacheable();

    protected abstract TmfTreeModel<M> getTree(ITmfStateSystem var1, Map<String, Object> var2, @Nullable IProgressMonitor var3) throws StateSystemDisposedException;

    private void checkScopeInitialized() {
        if (!this.fInitialized) {
            this.fScope = this.getScope();
            if (this.fScope != null) {
                this.fIdTable = fScopedIdTable.row((Object)Objects.requireNonNull(this.fScope));
            }
            this.fInitialized = true;
        }
    }
}

