/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.properties.core.api;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.properties.PropertiesPackage;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;

public final class PreconfiguredPreprocessorUtils {
    private PreconfiguredPreprocessorUtils() {
    }

    public static List<EStructuralFeature> getFeaturesToFilter(EClass eClass) {
        ArrayList<EStructuralFeature> featuresToFilter = new ArrayList<EStructuralFeature>();
        eClass.getEAllStructuralFeatures().stream().filter(feature -> feature.getName().equals("extends")).forEach(featuresToFilter::add);
        return featuresToFilter;
    }

    public static List<EStructuralFeature> getFeaturesToCopy(EClass eClass) {
        ArrayList<EStructuralFeature> featuresToCopy = new ArrayList<EStructuralFeature>();
        eClass.getEAllStructuralFeatures().stream().filter(EReference.class::isInstance).map(EReference.class::cast).forEach(eReference -> {
            EClass featureType = eReference.getEReferenceType();
            if (PreconfiguredPreprocessorUtils.shouldCopy(featureType)) {
                featuresToCopy.add((EStructuralFeature)eReference);
            }
        });
        return featuresToCopy;
    }

    private static boolean shouldCopy(EClass eClass) {
        boolean shouldCopy = false;
        shouldCopy = shouldCopy || ToolPackage.Literals.INITIAL_OPERATION.equals(eClass);
        shouldCopy = shouldCopy || PropertiesPackage.Literals.WIDGET_STYLE.isSuperTypeOf(eClass);
        shouldCopy = shouldCopy || PropertiesPackage.Literals.GROUP_STYLE.isSuperTypeOf(eClass);
        shouldCopy = shouldCopy || PropertiesPackage.Literals.GROUP_CONDITIONAL_STYLE.isSuperTypeOf(eClass);
        shouldCopy = shouldCopy || PropertiesPackage.Literals.WIDGET_CONDITIONAL_STYLE.isSuperTypeOf(eClass);
        return shouldCopy;
    }
}

