/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.helper.filter;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.EObjectVariableValue;
import org.eclipse.sirius.diagram.TypedVariableValue;
import org.eclipse.sirius.diagram.VariableValue;
import org.eclipse.sirius.diagram.description.filter.FilterPackage;
import org.eclipse.sirius.diagram.description.filter.VariableFilter;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.TypedVariable;

public class VariableFilterWrapper
implements Adapter {
    private VariableFilter variableFilter;
    private Multimap<String, EObject> variables;
    private Map<String, Object> typedVariables;
    private DDiagram curDiagram;

    public VariableFilterWrapper(VariableFilter variableFilter) {
        this.variableFilter = variableFilter;
    }

    public boolean isVisible(DDiagramElement element) {
        Object value;
        DDiagram parentDiagram = element.getParentDiagram();
        if (parentDiagram == null) {
            return false;
        }
        this.getVariablesFromDiagram(parentDiagram);
        boolean valid = true;
        IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter((EObject)element);
        if (this.variables != null) {
            for (String key : this.variables.keySet()) {
                value = this.variables.get((Object)key);
                interpreter.setVariable(key, value);
            }
        }
        if (this.typedVariables != null) {
            for (String key : this.typedVariables.keySet()) {
                value = this.typedVariables.get(key);
                interpreter.setVariable(key, value);
            }
        }
        if (this.variableFilter.getSemanticConditionExpression() != null) {
            EObject target = element.getTarget();
            if (target == null || target.eResource() == null) {
                valid = false;
            } else {
                try {
                    valid = interpreter.evaluateBoolean(element.getTarget(), this.variableFilter.getSemanticConditionExpression());
                }
                catch (EvaluationException e) {
                    RuntimeLoggerManager.INSTANCE.error((EObject)this.variableFilter, (EStructuralFeature)FilterPackage.eINSTANCE.getVariableFilter_SemanticConditionExpression(), (Throwable)e);
                }
            }
        }
        if (this.variables != null) {
            for (String key : this.variables.keySet()) {
                interpreter.unSetVariable(key);
            }
        }
        if (this.typedVariables != null) {
            for (String key : this.typedVariables.keySet()) {
                interpreter.unSetVariable(key);
            }
        }
        return valid;
    }

    private void getVariablesFromDiagram(DDiagram dDiagram) {
        if (this.curDiagram == null || dDiagram != this.curDiagram) {
            this.variables = ArrayListMultimap.create();
            this.typedVariables = new LinkedHashMap<String, Object>();
            if (dDiagram.getFilterVariableHistory() != null) {
                for (VariableValue value : dDiagram.getFilterVariableHistory().getOwnedValues()) {
                    if (value instanceof EObjectVariableValue) {
                        EObjectVariableValue objectVarValue = (EObjectVariableValue)value;
                        if (!this.variableFilter.getOwnedVariables().contains((Object)objectVarValue.getVariableDefinition())) continue;
                        this.variables.put((Object)objectVarValue.getVariableDefinition().getName(), (Object)objectVarValue.getModelElement());
                        continue;
                    }
                    if (!(value instanceof TypedVariableValue)) continue;
                    TypedVariableValue typeVariableValue = (TypedVariableValue)value;
                    TypedVariable variableDefinition = typeVariableValue.getVariableDefinition();
                    if (!this.variableFilter.getOwnedVariables().contains((Object)variableDefinition)) continue;
                    Object convertedObject = EcoreUtil.createFromString((EDataType)variableDefinition.getValueType(), (String)typeVariableValue.getValue());
                    this.typedVariables.put(typeVariableValue.getVariableDefinition().getName(), convertedObject);
                }
            }
            this.curDiagram = dDiagram;
        }
    }

    public void resetVariables() {
        this.curDiagram = null;
    }

    public void notifyChanged(Notification notification) {
    }

    public Notifier getTarget() {
        return null;
    }

    public void setTarget(Notifier newTarget) {
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }
}

