/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.evaluators.phpdoc;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ITypeHierarchy;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.typeinference.IModelAccessCache;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferenceUtils;
import org.eclipse.php.internal.core.typeinference.context.TypeContext;
import org.eclipse.php.internal.core.typeinference.evaluators.AbstractPHPGoalEvaluator;
import org.eclipse.php.internal.core.typeinference.evaluators.PHPEvaluationUtils;
import org.eclipse.php.internal.core.typeinference.goals.phpdoc.PHPDocClassVariableGoal;

public class PHPDocClassVariableEvaluator
extends AbstractPHPGoalEvaluator {
    private List<IEvaluatedType> evaluated = new LinkedList<IEvaluatedType>();

    public PHPDocClassVariableEvaluator(IGoal goal) {
        super(goal);
    }

    public IGoal[] init() {
        int index;
        PHPDocClassVariableGoal typedGoal = (PHPDocClassVariableGoal)this.goal;
        TypeContext context = (TypeContext)typedGoal.getContext();
        String variableName = typedGoal.getVariableName();
        int offset = typedGoal.getOffset();
        IModelAccessCache cache = context.getCache();
        IType[] types = PHPTypeInferenceUtils.getModelElements(context.getInstanceType(), (ISourceModuleContext)context, offset, cache);
        if (variableName.endsWith("]") && (index = variableName.indexOf("[")) != -1) {
            variableName = variableName.substring(0, index);
        }
        if (types == null) {
            return IGoal.NO_GOALS;
        }
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            try {
                IType[] superTypes;
                ITypeHierarchy superHierarchy = cache != null ? cache.getSuperTypeHierarchy(type, null) : type.newSupertypeHierarchy(null);
                IType[] iTypeArray2 = superTypes = superHierarchy.getAllTypes();
                int n3 = superTypes.length;
                int n4 = 0;
                while (n4 < n3) {
                    IType superType = iTypeArray2[n4];
                    IField[] typeField = PHPModelUtils.getTypeField(superType, variableName, true);
                    if (typeField.length > 0 && typeField[0].exists()) {
                        this.addFieldType(typeField[0]);
                    }
                    ++n4;
                }
            }
            catch (ModelException e) {
                Logger.logException(e);
            }
            ++n2;
        }
        return IGoal.NO_GOALS;
    }

    private void addFieldType(IField typeField) throws ModelException {
        String fieldType = typeField.getType();
        if (fieldType == null) {
            return;
        }
        String[] typeNames = StringUtils.split((String)fieldType, (char)'|');
        IType currentNamespace = PHPModelUtils.getCurrentNamespace((IModelElement)typeField);
        IType space = currentNamespace != null ? currentNamespace : typeField.getSourceModule();
        this.evaluated.addAll(Arrays.asList(PHPEvaluationUtils.evaluatePHPDocType(typeNames, (IModelElement)space, typeField.getSourceRange().getOffset(), null)));
    }

    public Object produceResult() {
        return PHPTypeInferenceUtils.combineTypes(this.evaluated);
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        if (state != GoalState.RECURSIVE && result != null) {
            this.evaluated.add((IEvaluatedType)result);
        }
        return IGoal.NO_GOALS;
    }
}

