/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.emf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.internal.emf.BlindResource;
import org.eclipse.passage.lic.internal.emf.i18n.EmfMessages;

public final class EObjectToBytes {
    private final EObject source;

    public EObjectToBytes(EObject source) {
        this.source = Objects.requireNonNull(source, this.getClass().getSimpleName() + "::source");
    }

    public byte[] get() throws LicensingException {
        return this.get(Collections.emptyMap());
    }

    public byte[] get(Map<?, ?> options) throws LicensingException {
        Resource resource = new BlindResource(this.source).get();
        resource.getContents().add((Object)this.source);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
                resource.save((OutputStream)stream, options);
                return stream.toByteArray();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new LicensingException(EmfMessages.EObjectToBytes_failure, (Throwable)e);
        }
    }
}

