/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.instanceScope;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.AbstractNavigationStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.AlwaysEmptyChangeListener;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.CompositeNavigationStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.EmptyResultNavigationStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.IdentityNavigationStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.NavigationStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.SourceTypeChangeListener;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.TargetTypeChangeListener;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.TracebackCache;
import org.eclipse.ocl.examples.impactanalyzer.util.AnnotatedEObject;

public class NavigationStepSequence
extends CompositeNavigationStep {
    public NavigationStepSequence(OCLExpression debugInfo, NavigationStep ... steps) {
        super(null, null, debugInfo, NavigationStepSequence.compactSteps(steps, debugInfo));
        this.setSourceType(this.getSteps()[0].getSourceType());
        this.getSteps()[0].addSourceTypeChangeListener(new SourceTypeChangeListener(){

            @Override
            public void sourceTypeChanged(NavigationStep stepForWhichSourceTypeChanged) {
                if (!$assertionsDisabled && stepForWhichSourceTypeChanged != NavigationStepSequence.this.getSteps()[0]) {
                    throw new AssertionError();
                }
                NavigationStepSequence.this.setSourceType(stepForWhichSourceTypeChanged.getSourceType());
            }
        });
        this.setTargetType(this.getSteps()[this.getSteps().length - 1].getTargetType());
        this.getSteps()[this.getSteps().length - 1].addTargetTypeChangeListener(new TargetTypeChangeListener(){

            @Override
            public void targetTypeChanged(NavigationStep stepForWhichTargetTypeChanged) {
                if (!$assertionsDisabled && stepForWhichTargetTypeChanged != NavigationStepSequence.this.getSteps()[NavigationStepSequence.this.getSteps().length - 1]) {
                    throw new AssertionError();
                }
                NavigationStepSequence.this.setTargetType(stepForWhichTargetTypeChanged.getTargetType());
            }
        });
        if (this.isOneStepAlwaysEmpty()) {
            this.setAlwaysEmpty();
        }
        int i = 0;
        while (i < this.getSteps().length) {
            int pos;
            final NavigationStep step = this.getSteps()[i];
            if (!this.isAlwaysEmpty()) {
                step.addAlwaysEmptyChangeListener(new AlwaysEmptyChangeListener(){

                    @Override
                    public void alwaysEmptyChanged(NavigationStep stepForWhichAlwaysEmptyChanged) {
                        NavigationStepSequence.this.setAlwaysEmpty();
                    }
                });
            }
            if (step.getSourceType() == null && i > 0) {
                pos = i;
                step.addSourceTypeChangeListener(new SourceTypeChangeListener(){

                    @Override
                    public void sourceTypeChanged(NavigationStep stepForWhichSourceTypeChanged) {
                        if (!$assertionsDisabled && stepForWhichSourceTypeChanged != step) {
                            throw new AssertionError();
                        }
                        if (!AbstractNavigationStep.haveIntersectingSubclassTree(NavigationStepSequence.this.getSteps()[pos - 1].getTargetType(), step.getSourceType())) {
                            NavigationStepSequence.this.setAlwaysEmpty();
                        }
                    }
                });
            }
            if (step.getTargetType() == null && i < this.getSteps().length - 1) {
                pos = i;
                step.addTargetTypeChangeListener(new TargetTypeChangeListener(){

                    @Override
                    public void targetTypeChanged(NavigationStep stepForWhichTargetTypeChanged) {
                        if (!$assertionsDisabled && stepForWhichTargetTypeChanged != step) {
                            throw new AssertionError();
                        }
                        if (!AbstractNavigationStep.haveIntersectingSubclassTree(NavigationStepSequence.this.getSteps()[pos - 1].getTargetType(), step.getTargetType())) {
                            NavigationStepSequence.this.setAlwaysEmpty();
                        }
                    }
                });
            }
            ++i;
        }
    }

    private boolean isOneStepAlwaysEmpty() {
        NavigationStep[] navigationStepArray = this.getSteps();
        int n = navigationStepArray.length;
        int n2 = 0;
        while (n2 < n) {
            NavigationStep step = navigationStepArray[n2];
            if (step.isAlwaysEmpty()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static boolean conformsTo(EClass sub, EClass sup) {
        return sub.equals(sup) || sub.getEAllSuperTypes().contains((Object)sup);
    }

    private static NavigationStep[] compactSteps(NavigationStep[] steps, OCLExpression debugInfo) {
        if (steps.length == 0) {
            throw new RuntimeException("NavigationStepSequence must at least have one element");
        }
        ArrayList<NavigationStep> result = new ArrayList<NavigationStep>();
        if (steps[steps.length - 1].isAlwaysEmpty()) {
            result.add(steps[steps.length - 1]);
        } else {
            boolean alwaysEmptyBecauseOfTypeMismatch = false;
            NavigationStep firstRedundantIdentityNavigationStep = null;
            int i = 0;
            while (i < steps.length && !alwaysEmptyBecauseOfTypeMismatch) {
                if (i > 0 && !AbstractNavigationStep.haveIntersectingSubclassTree(steps[i - 1].getTargetType(), steps[i].getSourceType())) {
                    alwaysEmptyBecauseOfTypeMismatch = true;
                } else if (!(steps[i] instanceof IdentityNavigationStep && (i != 0 && NavigationStepSequence.conformsTo(steps[i - 1].getTargetType(), steps[i].getSourceType()) || i != steps.length - 1 && NavigationStepSequence.conformsTo(steps[i].getTargetType(), steps[i + 1].getSourceType())))) {
                    result.add(steps[i]);
                } else if (firstRedundantIdentityNavigationStep == null) {
                    firstRedundantIdentityNavigationStep = steps[i];
                }
                ++i;
            }
            if (alwaysEmptyBecauseOfTypeMismatch) {
                result.clear();
                result.add(new EmptyResultNavigationStep(debugInfo));
            } else if (result.size() == 0) {
                result.add(firstRedundantIdentityNavigationStep);
            }
        }
        return result.toArray(new NavigationStep[0]);
    }

    @Override
    public boolean isAbsolute() {
        return this.isAlwaysEmpty();
    }

    @Override
    protected Set<AnnotatedEObject> navigate(AnnotatedEObject fromObject, TracebackCache cache, Notification changeEvent) {
        Set<AnnotatedEObject> result = Collections.singleton(fromObject);
        if (this.isAlwaysEmpty()) {
            result = Collections.emptySet();
        } else {
            int i = 0;
            while (!result.isEmpty() && i < this.getSteps().length) {
                result = this.getSteps()[i].navigate(result, cache, changeEvent);
                ++i;
            }
        }
        return result;
    }

    @Override
    public String contentToString(Map<NavigationStep, Integer> visited, int indent) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        NavigationStep[] navigationStepArray = this.getSteps();
        int n = navigationStepArray.length;
        int n2 = 0;
        while (n2 < n) {
            NavigationStep step = navigationStepArray[n2];
            if (!first) {
                sb.append('.');
            } else {
                first = false;
            }
            if (step instanceof AbstractNavigationStep) {
                sb.append(((AbstractNavigationStep)step).toString(visited, indent));
            } else {
                sb.append(step);
            }
            ++n2;
        }
        return sb.toString();
    }
}

