/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.vm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.engine.vm.ASM;
import org.eclipse.m2m.atl.engine.vm.ASMExecEnv;
import org.eclipse.m2m.atl.engine.vm.ASMInstruction;
import org.eclipse.m2m.atl.engine.vm.ASMInstructionWithOperand;
import org.eclipse.m2m.atl.engine.vm.ASMParameter;
import org.eclipse.m2m.atl.engine.vm.ASMStackFrame;
import org.eclipse.m2m.atl.engine.vm.Operation;
import org.eclipse.m2m.atl.engine.vm.StackFrame;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMBoolean;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMCollection;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMInteger;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModelElement;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMNativeObject;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclSimpleType;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclType;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMReal;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMString;

public class ASMOperation
extends Operation {
    public static ASMOclType myType = new ASMOclSimpleType("ASMOperation", ASMOperation.getOclAnyType());
    private static Pattern pattern1 = Pattern.compile("^.*\\(");
    private static Pattern simple = Pattern.compile("^J|I|B|S|D|A|(M|N)[^;]*;|L");
    private static Pattern pattern2 = Pattern.compile("^(Q|G|C|E|O).*");
    private Map lineNumberEntries = new HashMap();
    private String lastLNE = null;
    private Map localVariableEntries = new HashMap();
    private List slots = new ArrayList();
    private String name;
    private String context;
    private List parameters = new ArrayList();
    private List instructions = new ArrayList();
    private Map labels = new HashMap();
    private List lineNumberTable = new ArrayList();
    private List localVariableTable = new ArrayList();
    private ASM asm;
    private ASMOclType contextType;

    public ASMOperation(ASM asm, String name) {
        this.setType(myType);
        this.name = name;
        this.asm = asm;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setContext(String context) {
        this.context = context;
    }

    @Override
    public String getContextSignature() {
        return this.context;
    }

    public void addParameter(ASMParameter parameter) {
        this.parameters.add(parameter);
    }

    @Override
    public List getParameters() {
        return this.parameters;
    }

    public void addInstruction(ASMInstruction instruction) {
        this.instructions.add(instruction);
    }

    public void addLabeledInstruction(ASMInstructionWithOperand instruction, String labelName) {
        int index;
        this.instructions.add(instruction);
        Label label = (Label)this.labels.get(labelName);
        if (label == null) {
            label = new Label(labelName);
            this.labels.put(labelName, label);
        }
        if ((index = label.getIndex()) != -1) {
            instruction.setOperand("" + index);
        } else {
            label.addInstruction(instruction);
        }
    }

    public List getInstructions() {
        return this.instructions;
    }

    public void addLabel(String labelName) {
        Label label = (Label)this.labels.get(labelName);
        if (label == null) {
            label = new Label(labelName);
            this.labels.put(labelName, label);
        }
        label.setIndex(this.instructions.size());
    }

    public void addVariableInstruction(ASMInstructionWithOperand instruction, String varId) {
        LocalVariableEntry lve = (LocalVariableEntry)this.localVariableEntries.get(varId);
        if (lve == null) {
            ATLLogger.severe((String)("No slot reserved for variable: " + varId + " used at " + this.lastLNE + "."));
        } else {
            instruction.setOperand("" + lve.slot);
            this.instructions.add(instruction);
        }
    }

    @Override
    public String getSignature() {
        return "<TODO>";
    }

    public String toString() {
        StringBuffer ret = new StringBuffer(this.context);
        ret.append(".");
        ret.append(this.name);
        ret.append("(");
        Iterator i = this.parameters.iterator();
        while (i.hasNext()) {
            ret.append(i.next());
            if (!i.hasNext()) continue;
            ret.append(", ");
        }
        ret.append(") : ??");
        return ret.toString();
    }

    @Override
    public ASMOclAny exec(StackFrame frame) {
        ASMOclAny ret = null;
        this.realExec((ASMStackFrame)frame);
        ret = frame.leaveFrame();
        return ret;
    }

    private void realExec(ASMStackFrame frame) {
        block2: while (frame.hasNextInstruction()) {
            ASMOclAny ret;
            String opName;
            String me;
            ASMInstruction instr = frame.nextInstruction();
            String mn = instr.getMnemonic();
            ASMString op = null;
            String ops = null;
            if (instr instanceof ASMInstructionWithOperand) {
                ops = ((ASMInstructionWithOperand)instr).getOperand();
                op = new ASMString(ops);
            }
            frame.step();
            if (mn == "push") {
                frame.push(op);
                continue;
            }
            if (mn == "pop") {
                frame.pop();
                continue;
            }
            if (mn == "swap") {
                ASMOclAny o1 = frame.pop();
                ASMOclAny o2 = frame.pop();
                frame.push(o1);
                frame.push(o2);
                continue;
            }
            if (mn == "new") {
                String mname = ((ASMString)frame.pop()).getSymbol();
                me = ((ASMString)frame.pop()).getSymbol();
                if (mname.equals("#native")) {
                    Class c = ASMNativeObject.getNativeImpl(me);
                    if (c != null) {
                        try {
                            frame.push((ASMOclAny)c.newInstance());
                        }
                        catch (Exception e) {
                            frame.printStackTrace("Cannot instantiate " + me);
                        }
                        continue;
                    }
                    frame.printStackTrace("Element " + me + " not found in native");
                    continue;
                }
                ASMModel mm = frame.getModel(mname);
                for (ASMModel model : frame.getExecEnv().getModels().values()) {
                    if (!model.getMetamodel().equals(mm) || !model.isTarget()) continue;
                    frame.push(model.newModelElement(frame, me));
                    continue block2;
                }
                continue;
            }
            if (mn == "newin") {
                String modelname = ((ASMString)frame.pop()).getSymbol();
                ((ASMString)frame.pop()).getSymbol();
                me = ((ASMString)frame.pop()).getSymbol();
                for (ASMModel model : frame.getExecEnv().getModels().values()) {
                    if (!model.getName().equals(modelname) || !model.isTarget()) continue;
                    frame.push(model.newModelElement(frame, me));
                    continue block2;
                }
                continue;
            }
            if (mn == "call" || mn == "pcall") {
                int nb = ASMOperation.getNbArgs(ops);
                opName = ASMOperation.getOpName(ops);
                ArrayList<ASMOclAny> arguments = new ArrayList<ASMOclAny>();
                int j = 0;
                while (j < nb) {
                    arguments.add(0, frame.pop());
                    ++j;
                }
                ASMOclAny o = frame.pop();
                ret = o.invoke((StackFrame)frame, opName, arguments);
                if (mn != "call" || ret == null) continue;
                frame.push(ret);
                continue;
            }
            if (mn.equals("supercall")) {
                int nb = ASMOperation.getNbArgs(ops);
                opName = ASMOperation.getOpName(ops);
                ArrayList<ASMOclAny> arguments = new ArrayList<ASMOclAny>();
                int j = 0;
                while (j < nb) {
                    arguments.add(0, frame.pop());
                    ++j;
                }
                ASMOclAny o = frame.pop();
                ret = o.invokeSuper(frame, opName, arguments);
                if (ret == null) continue;
                frame.push(ret);
                continue;
            }
            if (mn.equals("store")) {
                frame.popVariable(ops);
                continue;
            }
            if (mn.equals("load")) {
                frame.pushVariable(ops);
                continue;
            }
            if (mn.equals("dup")) {
                frame.push(frame.peek());
                continue;
            }
            if (mn.equals("dup_x1")) {
                ASMOclAny val1 = frame.pop();
                ASMOclAny val2 = frame.pop();
                frame.push(val1);
                frame.push(val2);
                frame.push(val1);
                continue;
            }
            if (mn.equals("delete")) continue;
            if (mn.equals("findme")) {
                String mname = ((ASMString)frame.pop()).getSymbol();
                String name = ((ASMString)frame.pop()).getSymbol();
                if (mname.equals("#native")) {
                    if (name.equals("String")) {
                        frame.push(ASMString.myType);
                        continue;
                    }
                    if (name.equals("OclAny")) {
                        frame.push(ASMOclAny.myType);
                        continue;
                    }
                    if (name.equals("Integer")) {
                        frame.push(ASMInteger.myType);
                        continue;
                    }
                    if (name.equals("Boolean")) {
                        frame.push(ASMBoolean.myType);
                        continue;
                    }
                    if (name.equals("Real")) {
                        frame.push(ASMReal.myType);
                        continue;
                    }
                    frame.printStackTrace("Element " + name + " not found in native");
                    continue;
                }
                ASMModel model = frame.getModel(mname);
                if (model == null) {
                    frame.printStackTrace("Cannot find model " + mname);
                    continue;
                }
                ASMModelElement ame = model.findModelElement(name);
                if (ame == null) {
                    frame.printStackTrace("Cannot find metamodel element " + name + " in model " + mname);
                }
                frame.push(ame);
                continue;
            }
            if (mn == "get") {
                frame.push(frame.pop().get(frame, ops));
                continue;
            }
            if (mn == "set") {
                ASMOclAny value = frame.pop();
                ASMOclAny o = frame.pop();
                o.set(frame, ops, value);
                continue;
            }
            if (mn == "pushi") {
                ASMInteger ai = new ASMInteger(Integer.parseInt(ops));
                frame.push(ai);
                continue;
            }
            if (mn == "pushd") {
                ASMReal ar = new ASMReal(Double.parseDouble(ops));
                frame.push(ar);
                continue;
            }
            if (mn == "pusht") {
                frame.push(new ASMBoolean(true));
                continue;
            }
            if (mn == "pushf") {
                frame.push(new ASMBoolean(false));
                continue;
            }
            if (mn == "enditerate") {
                return;
            }
            if (mn == "if") {
                if (!((ASMBoolean)frame.pop()).getSymbol()) continue;
                int target = Integer.parseInt(ops);
                frame.setLocation(target - 1);
                continue;
            }
            if (mn == "goto") {
                int target = Integer.parseInt(ops);
                frame.setLocation(target - 1);
                continue;
            }
            if (mn == "getasm") {
                frame.push(((ASMExecEnv)frame.getExecEnv()).getASMModule());
                continue;
            }
            if (mn == "iterate") {
                ASMOclAny v = frame.pop();
                if (!(v instanceof ASMCollection)) {
                    frame.printStackTrace("Cannot iterate on non-collection");
                }
                ASMCollection c = (ASMCollection)v;
                int oldLocation = frame.getLocation();
                Iterator j = c.iterator();
                while (j.hasNext()) {
                    frame.push((ASMOclAny)j.next());
                    this.realExec(frame);
                    frame.setLocation(oldLocation);
                }
                int nested = 0;
                while (true) {
                    String mnc;
                    if ((mnc = frame.nextInstruction().getMnemonic()) == "enditerate") {
                        if (nested == 0) continue block2;
                        --nested;
                        continue;
                    }
                    if (mnc != "iterate") continue;
                    ++nested;
                }
            }
            frame.printStackTrace("Instruction not implemented yet : " + mn);
        }
    }

    private static int getNbArgs(String s) {
        int ret = 0;
        s = pattern1.matcher(s).replaceFirst("");
        while (!s.startsWith(")") && s.length() > 0) {
            ++ret;
            s = ASMOperation.removeFirst(s);
        }
        return ret;
    }

    private static String removeFirst(String s) {
        if (s.startsWith("T")) {
            s = s.substring(1);
            while (!s.startsWith(";")) {
                s = ASMOperation.removeFirst(s);
            }
            s = s.substring(1);
        } else {
            s = pattern2.matcher(s).matches() ? ASMOperation.removeFirst(s.substring(1)) : simple.matcher(s).replaceFirst("");
        }
        return s;
    }

    private static String getOpName(String s) {
        return s.substring(s.indexOf(".") + 1, s.indexOf("("));
    }

    public void beginLineNumberEntry(String id) {
        this.lastLNE = id;
        this.lineNumberEntries.put(id, new LineNumberEntry(id, this.instructions.size(), -1));
    }

    public void endLineNumberEntry(String id) {
        LineNumberEntry lne = (LineNumberEntry)this.lineNumberEntries.remove(id);
        lne.end = this.instructions.size() - 1;
        this.lineNumberTable.add(lne);
    }

    public void addLineNumberEntry(String id, int begin, int end) {
        this.lineNumberTable.add(new LineNumberEntry(id, begin, end));
    }

    public List getLineNumberTable() {
        return this.lineNumberTable;
    }

    public String resolveLineNumber(int l) {
        String ret = null;
        Iterator i = this.lineNumberTable.iterator();
        while (i.hasNext() && ret == null) {
            LineNumberEntry lne = (LineNumberEntry)i.next();
            if (l < lne.begin || l > lne.end) continue;
            ret = lne.id;
        }
        return ret;
    }

    public int beginLocalVariableEntry(String id, String name) {
        LocalVariableEntry lve = (LocalVariableEntry)this.localVariableEntries.get(id);
        if (lve != null) {
            throw new Error("variable id already in use: " + id);
        }
        int slot = this.reserveSlot();
        this.localVariableEntries.put(id, new LocalVariableEntry(slot, name, this.instructions.size(), -1));
        return slot;
    }

    public int endLocalVariableEntry(String id) {
        LocalVariableEntry lve = (LocalVariableEntry)this.localVariableEntries.remove(id);
        if (lve == null) {
            ATLLogger.severe((String)("Variable id not defined: " + id));
            return -1;
        }
        lve.end = this.instructions.size() - 1;
        this.localVariableTable.add(lve);
        this.freeSlot(lve.slot);
        return lve.slot;
    }

    public void addLocalVariableEntry(int slot, String name, int begin, int end) {
        this.localVariableTable.add(new LocalVariableEntry(slot, name, begin, end));
    }

    public List getLocalVariableTable() {
        return this.localVariableTable;
    }

    public String resolveVariableName(int slot, int l) {
        String ret = null;
        Iterator i = this.localVariableTable.iterator();
        while (i.hasNext() & ret == null) {
            LocalVariableEntry lve = (LocalVariableEntry)i.next();
            if (slot != lve.slot || l < lve.begin || l > lve.end) continue;
            ret = lve.name;
        }
        return ret;
    }

    public ASM getASM() {
        return this.asm;
    }

    private int reserveSlot() {
        int ret = -1;
        int i = 0;
        while (i < this.slots.size() && ret == -1) {
            if (!((Boolean)this.slots.get(i)).booleanValue()) {
                ret = i;
                this.slots.set(ret, new Boolean(true));
            }
            ++i;
        }
        if (ret == -1) {
            ret = this.slots.size();
            this.slots.add(new Boolean(true));
        }
        return ret;
    }

    private void freeSlot(int slot) {
        this.slots.set(slot, new Boolean(false));
    }

    public void setContextType(ASMOclType contextType) {
        this.contextType = contextType;
    }

    @Override
    public ASMOclType getReturnType() {
        return null;
    }

    @Override
    public ASMOclType getContextType() {
        return this.contextType;
    }

    protected class Label {
        private String name;
        private int index = -1;
        private ArrayList instr = new ArrayList();

        public Label(String name) {
            this.name = name;
        }

        public int getIndex() {
            return this.index;
        }

        public void addInstruction(ASMInstruction i) {
            this.instr.add(i);
        }

        public void setIndex(int index) {
            this.index = index;
            String id = "" + index;
            Iterator i = this.instr.iterator();
            while (i.hasNext()) {
                ((ASMInstructionWithOperand)i.next()).setOperand(id);
            }
        }

        public String getName() {
            return this.name;
        }
    }

    public class LineNumberEntry {
        public String id;
        public int begin;
        public int end;

        public LineNumberEntry(String id, int begin, int end) {
            this.id = id;
            this.begin = begin;
            this.end = end;
        }
    }

    public class LocalVariableEntry {
        public int slot;
        public String name;
        public int begin;
        public int end;

        public LocalVariableEntry(int slot, String name, int begin, int end) {
            this.slot = slot;
            this.name = name;
            this.begin = begin;
            this.end = end;
        }
    }
}

