/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.emfvm.lib;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.core.IModel;
import org.eclipse.m2m.atl.core.IReferenceModel;
import org.eclipse.m2m.atl.engine.emfvm.Messages;
import org.eclipse.m2m.atl.engine.emfvm.StackFrame;
import org.eclipse.m2m.atl.engine.emfvm.VMException;
import org.eclipse.m2m.atl.engine.emfvm.adapter.IModelAdapter;
import org.eclipse.m2m.atl.engine.emfvm.launch.ITool;
import org.eclipse.m2m.atl.engine.emfvm.lib.AbstractStackFrame;
import org.eclipse.m2m.atl.engine.emfvm.lib.Bag;
import org.eclipse.m2m.atl.engine.emfvm.lib.EnumLiteral;
import org.eclipse.m2m.atl.engine.emfvm.lib.OclParametrizedType;
import org.eclipse.m2m.atl.engine.emfvm.lib.OclType;
import org.eclipse.m2m.atl.engine.emfvm.lib.OclUndefined;
import org.eclipse.m2m.atl.engine.emfvm.lib.Operation;
import org.eclipse.m2m.atl.engine.emfvm.lib.TransientLink;
import org.eclipse.m2m.atl.engine.emfvm.lib.TransientLinkSet;
import org.eclipse.m2m.atl.engine.emfvm.lib.Tuple;

public class ExecEnv {
    private static final ArrayList EMPTY_ARRAY_LIST = new ArrayList(0);
    private Map<Object, Map<String, Operation>> vmTypeOperations = new HashMap<Object, Map<String, Operation>>();
    private Map<Object, Map<String, Operation>> operationsByType;
    private long nbExecutedBytecodes;
    private IModelAdapter modelAdapter;
    private boolean cacheAttributeHelperResults;
    private Map<Object, Map<String, String>> weavingHelperToPersistToByType;
    private Map<Object, Map<String, SoftReference<?>>> helperValuesByElement;
    private Map<Object, Map<String, Operation>> attributeInitializers;
    private Map<IModel, String> nameByModel;
    private Operation noInitializer;
    private Map<String, IModel> modelsByName;
    private boolean step;
    private ITool[] tools;

    public ExecEnv(Map<String, IModel> models, ITool[] tools) {
        HashMap<String, Operation> operationsByName = new HashMap<String, Operation>();
        this.vmTypeOperations.put(Float.class, operationsByName);
        this.registerOperation(operationsByName, new Operation(2, "/"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Float(((Number)localVars[0]).floatValue() / ((Number)localVars[1]).floatValue());
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "*"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Float(((Number)localVars[0]).floatValue() * ((Number)localVars[1]).floatValue());
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "-"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Float(((Number)localVars[0]).floatValue() - ((Number)localVars[1]).floatValue());
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "+"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Float(((Number)localVars[0]).floatValue() + ((Number)localVars[1]).floatValue());
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "<"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((Number)localVars[0]).floatValue() < ((Number)localVars[1]).floatValue();
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "<="){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((Number)localVars[0]).floatValue() <= ((Number)localVars[1]).floatValue();
            }
        });
        this.registerOperation(operationsByName, new Operation(2, ">"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((Number)localVars[0]).floatValue() > ((Number)localVars[1]).floatValue();
            }
        });
        this.registerOperation(operationsByName, new Operation(2, ">="){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((Number)localVars[0]).floatValue() >= ((Number)localVars[1]).floatValue();
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "="){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((Number)localVars[0]).floatValue() == ((Number)localVars[1]).floatValue();
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "toString"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return localVars[0].toString();
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "abs"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Float(Math.abs(((Number)localVars[0]).floatValue()));
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "round"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return Math.round(((Number)localVars[0]).floatValue());
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "floor"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return (int)Math.floor(((Number)localVars[0]).floatValue());
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "max"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Float(Math.max(((Number)localVars[0]).floatValue(), ((Number)localVars[1]).floatValue()));
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "min"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Float(Math.min(((Number)localVars[0]).floatValue(), ((Number)localVars[1]).floatValue()));
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "acos"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Float(Math.acos(((Number)localVars[0]).floatValue()));
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "asin"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Float(Math.asin(((Number)localVars[0]).floatValue()));
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "atan"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Float(Math.atan(((Number)localVars[0]).floatValue()));
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "cos"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Float(Math.cos(((Number)localVars[0]).floatValue()));
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "sin"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Float(Math.sin(((Number)localVars[0]).floatValue()));
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "tan"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Float(Math.tan(((Number)localVars[0]).floatValue()));
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "toDegrees"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Float(Math.toDegrees(((Number)localVars[0]).floatValue()));
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "toRadians"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Float(Math.toRadians(((Number)localVars[0]).floatValue()));
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "exp"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Float(Math.exp(((Number)localVars[0]).floatValue()));
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "log"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Float(Math.log(((Number)localVars[0]).floatValue()));
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "sqrt"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Float(Math.sqrt(((Number)localVars[0]).floatValue()));
            }
        });
        operationsByName = new HashMap();
        this.vmTypeOperations.put(Double.class, operationsByName);
        this.registerOperation(operationsByName, new Operation(2, "/"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Double(((Number)localVars[0]).doubleValue() / ((Number)localVars[1]).doubleValue());
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "*"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Double(((Number)localVars[0]).doubleValue() * ((Number)localVars[1]).doubleValue());
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "-"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Double(((Number)localVars[0]).doubleValue() - ((Number)localVars[1]).doubleValue());
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "+"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Double(((Number)localVars[0]).doubleValue() + ((Number)localVars[1]).doubleValue());
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "<"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((Number)localVars[0]).doubleValue() < ((Number)localVars[1]).doubleValue();
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "<="){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((Number)localVars[0]).doubleValue() <= ((Number)localVars[1]).doubleValue();
            }
        });
        this.registerOperation(operationsByName, new Operation(2, ">"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((Number)localVars[0]).doubleValue() > ((Number)localVars[1]).doubleValue();
            }
        });
        this.registerOperation(operationsByName, new Operation(2, ">="){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((Number)localVars[0]).doubleValue() >= ((Number)localVars[1]).doubleValue();
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "="){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((Number)localVars[0]).doubleValue() == ((Number)localVars[1]).doubleValue();
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "toString"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return localVars[0].toString();
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "abs"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Double(Math.abs(((Number)localVars[0]).doubleValue()));
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "round"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return (int)Math.round(((Number)localVars[0]).doubleValue());
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "floor"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return (int)Math.floor(((Number)localVars[0]).doubleValue());
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "max"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Double(Math.max(((Number)localVars[0]).doubleValue(), ((Number)localVars[1]).doubleValue()));
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "min"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Double(Math.min(((Number)localVars[0]).doubleValue(), ((Number)localVars[1]).doubleValue()));
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "acos"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Double(Math.acos(((Number)localVars[0]).doubleValue()));
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "asin"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Double(Math.asin(((Number)localVars[0]).doubleValue()));
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "atan"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Double(Math.atan(((Number)localVars[0]).doubleValue()));
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "cos"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Double(Math.cos(((Number)localVars[0]).doubleValue()));
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "sin"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Double(Math.sin(((Number)localVars[0]).doubleValue()));
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "tan"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Double(Math.tan(((Number)localVars[0]).doubleValue()));
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "toDegrees"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Double(Math.toDegrees(((Number)localVars[0]).doubleValue()));
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "toRadians"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Double(Math.toRadians(((Number)localVars[0]).doubleValue()));
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "exp"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Double(Math.exp(((Number)localVars[0]).doubleValue()));
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "log"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Double(Math.log(((Number)localVars[0]).doubleValue()));
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "sqrt"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Double(Math.sqrt(((Number)localVars[0]).doubleValue()));
            }
        });
        operationsByName = new HashMap();
        this.vmTypeOperations.put(Integer.class, operationsByName);
        this.registerOperation(operationsByName, new Operation(2, "*"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                if (localVars[1] instanceof Integer) {
                    return (Integer)localVars[0] * (Integer)localVars[1];
                }
                return new Double(((Number)localVars[0]).doubleValue() * ((Number)localVars[1]).doubleValue());
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "-"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                if (localVars[1] instanceof Integer) {
                    return (Integer)localVars[0] - (Integer)localVars[1];
                }
                return new Double(((Number)localVars[0]).doubleValue() - ((Number)localVars[1]).doubleValue());
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "+"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                if (localVars[1] instanceof Integer) {
                    return (Integer)localVars[0] + (Integer)localVars[1];
                }
                return new Double(((Number)localVars[0]).doubleValue() + ((Number)localVars[1]).doubleValue());
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "div"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return (Integer)localVars[0] / (Integer)localVars[1];
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "mod"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return (Integer)localVars[0] % (Integer)localVars[1];
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "/"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Double((double)((Integer)localVars[0]).intValue() / ((Number)localVars[1]).doubleValue());
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "<"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                if (localVars[1] instanceof Integer) {
                    return (Integer)localVars[0] < (Integer)localVars[1];
                }
                return ((Number)localVars[0]).doubleValue() < ((Number)localVars[1]).doubleValue();
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "<="){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                if (localVars[1] instanceof Integer) {
                    return (Integer)localVars[0] <= (Integer)localVars[1];
                }
                return ((Number)localVars[0]).doubleValue() <= ((Number)localVars[1]).doubleValue();
            }
        });
        this.registerOperation(operationsByName, new Operation(2, ">"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                if (localVars[1] instanceof Integer) {
                    return (Integer)localVars[0] > (Integer)localVars[1];
                }
                return ((Number)localVars[0]).doubleValue() > ((Number)localVars[1]).doubleValue();
            }
        });
        this.registerOperation(operationsByName, new Operation(2, ">="){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                if (localVars[1] instanceof Integer) {
                    return (Integer)localVars[0] >= (Integer)localVars[1];
                }
                return ((Number)localVars[0]).doubleValue() >= ((Number)localVars[1]).doubleValue();
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "="){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                if (localVars[1] instanceof Integer) {
                    return ((Integer)localVars[0]).intValue() == ((Integer)localVars[1]).intValue();
                }
                return ((Number)localVars[0]).doubleValue() == ((Number)localVars[1]).doubleValue();
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "max"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return Math.max((Integer)localVars[0], ((Number)localVars[1]).intValue());
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "abs"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return Math.abs((Integer)localVars[0]);
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "min"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return Math.min((Integer)localVars[0], ((Number)localVars[1]).intValue());
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "toString"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return localVars[0].toString();
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "toHexString"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return Integer.toHexString((Integer)localVars[0]);
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "toBinaryString"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return Integer.toBinaryString((Integer)localVars[0]);
            }
        });
        operationsByName = new HashMap();
        this.vmTypeOperations.put(Boolean.class, operationsByName);
        this.registerOperation(operationsByName, new Operation(1, "not"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return (Boolean)localVars[0] == false;
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "and"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return (Boolean)localVars[0] != false && (Boolean)localVars[1] != false;
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "or"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return (Boolean)localVars[0] != false || (Boolean)localVars[1] != false;
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "xor"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return (Boolean)localVars[0] ^ (Boolean)localVars[1];
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "implies"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return (Boolean)localVars[0] != false ? (Boolean)localVars[1] : true;
            }
        });
        operationsByName = new HashMap();
        this.vmTypeOperations.put(ArrayList.class, operationsByName);
        this.registerOperation(operationsByName, new Operation(3, "insertAt"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                int index = (Integer)localVars[1];
                ArrayList<Object> ret = new ArrayList<Object>((Collection)localVars[0]);
                ret.add(index - 1, localVars[2]);
                return ret;
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "at"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                int index = (Integer)localVars[1];
                return ((List)localVars[0]).get(index - 1);
            }
        });
        this.registerOperation(operationsByName, new Operation(3, "subSequence"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                int start = (Integer)localVars[1];
                int end = (Integer)localVars[2];
                if (end >= start) {
                    return new ArrayList(((List)localVars[0]).subList(start - 1, end));
                }
                return EMPTY_ARRAY_LIST;
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "indexOf"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((List)localVars[0]).indexOf(localVars[1]) + 1;
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "prepend"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                ArrayList<Object> ret = new ArrayList<Object>((Collection)localVars[0]);
                ret.add(0, localVars[1]);
                return ret;
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "including"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                ArrayList<Object> ret = new ArrayList<Object>((Collection)localVars[0]);
                ret.add(localVars[1]);
                return ret;
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "excluding"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                ArrayList ret = new ArrayList((Collection)localVars[0]);
                ret.removeAll(Arrays.asList(localVars[1]));
                return ret;
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "append"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                ArrayList<Object> ret = new ArrayList<Object>((Collection)localVars[0]);
                ret.add(localVars[1]);
                return ret;
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "union"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                ArrayList ret = new ArrayList((Collection)localVars[0]);
                ret.addAll((Collection)localVars[1]);
                return ret;
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "asSequence"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return localVars[0];
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "first"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                List l = (List)localVars[0];
                if (l.isEmpty()) {
                    return OclUndefined.SINGLETON;
                }
                return l.get(0);
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "last"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                List l = (List)localVars[0];
                if (l.isEmpty()) {
                    return OclUndefined.SINGLETON;
                }
                return l.get(l.size() - 1);
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "flatten"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                boolean containsCollection;
                Object[] localVars = frame.localVars;
                ArrayList base = null;
                ArrayList ret = new ArrayList((Collection)localVars[0]);
                do {
                    base = ret;
                    ret = new ArrayList();
                    containsCollection = false;
                    for (Object object : base) {
                        if (object instanceof Collection) {
                            Collection subCollection = (Collection)object;
                            ret.addAll(subCollection);
                            Iterator iterator2 = subCollection.iterator();
                            while (!containsCollection && iterator2.hasNext()) {
                                Object subCollectionObject = iterator2.next();
                                if (!(subCollectionObject instanceof Collection)) continue;
                                containsCollection = true;
                            }
                            continue;
                        }
                        ret.add(object);
                    }
                } while (containsCollection);
                return ret;
            }
        });
        operationsByName = new HashMap();
        this.vmTypeOperations.put(Bag.class, operationsByName);
        this.registerOperation(operationsByName, new Operation(2, "including"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                Bag ret = new Bag((Collection)localVars[0]);
                ret.add(localVars[1]);
                return ret;
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "excluding"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                Bag ret = new Bag((Collection)localVars[0]);
                ret.removeAll(Arrays.asList(localVars[1]));
                return ret;
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "asBag"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return localVars[0];
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "flatten"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                boolean containsCollection;
                Object[] localVars = frame.localVars;
                Bag base = null;
                Bag ret = new Bag((Collection)localVars[0]);
                do {
                    base = ret;
                    ret = new Bag();
                    containsCollection = false;
                    for (Object object : base) {
                        if (object instanceof Collection) {
                            Collection subCollection = (Collection)object;
                            ret.addAll((Collection<?>)subCollection);
                            Iterator iterator2 = subCollection.iterator();
                            while (!containsCollection && iterator2.hasNext()) {
                                Object subCollectionObject = iterator2.next();
                                if (!(subCollectionObject instanceof Collection)) continue;
                                containsCollection = true;
                            }
                            continue;
                        }
                        ret.add(object);
                    }
                } while (containsCollection);
                return ret;
            }
        });
        operationsByName = new HashMap();
        this.vmTypeOperations.put(LinkedHashSet.class, operationsByName);
        this.registerOperation(operationsByName, new Operation(3, "insertAt"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                int idx = (Integer)localVars[1] - 1;
                LinkedHashSet<Object> ret = new LinkedHashSet<Object>();
                LinkedHashSet s = (LinkedHashSet)localVars[0];
                int k = 0;
                Iterator i = s.iterator();
                while (i.hasNext()) {
                    if (k++ == idx) {
                        ret.add(localVars[2]);
                    }
                    ret.add(i.next());
                }
                return ret;
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "prepend"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                int idx = 0;
                LinkedHashSet<Object> ret = new LinkedHashSet<Object>();
                LinkedHashSet s = (LinkedHashSet)localVars[0];
                int k = 0;
                Iterator i = s.iterator();
                while (i.hasNext()) {
                    if (k++ == idx) {
                        ret.add(localVars[1]);
                    }
                    ret.add(i.next());
                }
                return ret;
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "indexOf"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                LinkedHashSet s = (LinkedHashSet)localVars[0];
                int idx = 0;
                Iterator iterator = s.iterator();
                while (iterator.hasNext()) {
                    ++idx;
                    if (!iterator.next().equals(localVars[1])) continue;
                    return idx;
                }
                return 0;
            }
        });
        this.registerOperation(operationsByName, new Operation(3, "subOrderedSet"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                LinkedHashSet ret = new LinkedHashSet();
                LinkedHashSet s = (LinkedHashSet)localVars[0];
                int deb = (Integer)localVars[1];
                int end = (Integer)localVars[2];
                int idx = 0;
                for (Object tmp : s) {
                    if (deb > ++idx || idx > end) continue;
                    ret.add(tmp);
                }
                return ret;
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "including"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                LinkedHashSet<Object> ret = new LinkedHashSet<Object>((Collection)localVars[0]);
                ret.add(localVars[1]);
                return ret;
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "excluding"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                LinkedHashSet ret = new LinkedHashSet((Collection)localVars[0]);
                ret.removeAll(Arrays.asList(localVars[1]));
                return ret;
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "append"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                LinkedHashSet<Object> ret = new LinkedHashSet<Object>((Collection)localVars[0]);
                ret.add(localVars[1]);
                return ret;
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "asOrderedSet"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return localVars[0];
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "first"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((LinkedHashSet)localVars[0]).iterator().next();
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "last"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                LinkedHashSet l = (LinkedHashSet)localVars[0];
                OclUndefined ret2 = OclUndefined.SINGLETON;
                for (OclUndefined ret2 : l) {
                }
                return ret2;
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "count"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                Object o = localVars[1];
                return ((HashSet)localVars[0]).contains(o) ? Integer.valueOf(1) : Integer.valueOf(0);
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "union"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                LinkedHashSet ret = new LinkedHashSet((Collection)localVars[0]);
                ret.addAll((Collection)localVars[1]);
                return ret;
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "flatten"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                boolean containsCollection;
                Object[] localVars = frame.localVars;
                LinkedHashSet base = null;
                LinkedHashSet ret = new LinkedHashSet((Collection)localVars[0]);
                do {
                    base = ret;
                    ret = new LinkedHashSet();
                    containsCollection = false;
                    for (Object object : base) {
                        if (object instanceof Collection) {
                            Collection subCollection = (Collection)object;
                            ret.addAll(subCollection);
                            Iterator iterator2 = subCollection.iterator();
                            while (!containsCollection && iterator2.hasNext()) {
                                Object subCollectionObject = iterator2.next();
                                if (!(subCollectionObject instanceof Collection)) continue;
                                containsCollection = true;
                            }
                            continue;
                        }
                        ret.add(object);
                    }
                } while (containsCollection);
                return ret;
            }
        });
        operationsByName = new HashMap();
        this.vmTypeOperations.put(HashSet.class, operationsByName);
        this.registerOperation(operationsByName, new Operation(2, "including"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                HashSet<Object> ret = new HashSet<Object>((Collection)localVars[0]);
                ret.add(localVars[1]);
                return ret;
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "excluding"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                HashSet ret = new HashSet((Collection)localVars[0]);
                ret.removeAll(Arrays.asList(localVars[1]));
                return ret;
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "intersection"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                HashSet ret = new HashSet((Collection)localVars[0]);
                ret.retainAll((Collection)localVars[1]);
                return ret;
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "-"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                HashSet ret = new HashSet((Collection)localVars[0]);
                ret.removeAll((Collection)localVars[1]);
                return ret;
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "symetricDifference"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                HashSet ret = new HashSet((Collection)localVars[0]);
                HashSet t = new HashSet((Collection)localVars[1]);
                t.removeAll(ret);
                ret.removeAll((Collection)localVars[1]);
                ret.addAll(t);
                return ret;
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "asSet"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return localVars[0];
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "flatten"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                boolean containsCollection;
                Object[] localVars = frame.localVars;
                HashSet base = null;
                HashSet ret = new HashSet((Collection)localVars[0]);
                do {
                    base = ret;
                    ret = new HashSet();
                    containsCollection = false;
                    for (Object object : base) {
                        if (object instanceof Collection) {
                            Collection subCollection = (Collection)object;
                            ret.addAll(subCollection);
                            Iterator iterator2 = subCollection.iterator();
                            while (!containsCollection && iterator2.hasNext()) {
                                Object subCollectionObject = iterator2.next();
                                if (!(subCollectionObject instanceof Collection)) continue;
                                containsCollection = true;
                            }
                            continue;
                        }
                        ret.add(object);
                    }
                } while (containsCollection);
                return ret;
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "count"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                Object o = localVars[1];
                return ((HashSet)localVars[0]).contains(o) ? Integer.valueOf(1) : Integer.valueOf(0);
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "union"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                HashSet ret = new HashSet((Collection)localVars[0]);
                ret.addAll((Collection)localVars[1]);
                return ret;
            }
        });
        operationsByName = new HashMap();
        this.vmTypeOperations.put(Collection.class, operationsByName);
        this.registerOperation(operationsByName, new Operation(1, "size"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((Collection)localVars[0]).size();
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "sum"){

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Override
            public Object exec(AbstractStackFrame frame) {
                localVars = frame.localVars;
                c = (Collection)localVars[0];
                if (c.isEmpty()) {
                    return OclUndefined.SINGLETON;
                }
                i = c.iterator();
                ret /* !! */  = i.next();
                operation = ExecEnv.this.getOperation(ExecEnv.access$1(ExecEnv.this).getType(ret /* !! */ ), "+");
                if (operation != null) ** GOTO lbl15
                throw new VMException(frame, Messages.getString("ExecEnv.CANNOTFINDOPERATION", new Object[]{ExecEnv.this.toPrettyPrintedString(ExecEnv.access$1(ExecEnv.this).getType(ret /* !! */ )), "+"}));
lbl-1000:
                // 1 sources

                {
                    callee = frame.newFrame(operation);
                    callee.localVars[0] = ret /* !! */ ;
                    callee.localVars[1] = i.next();
                    ret /* !! */  = operation.exec(callee.enter());
                    callee.leave();
lbl15:
                    // 2 sources

                    ** while (i.hasNext())
                }
lbl16:
                // 1 sources

                return ret /* !! */ ;
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "includes"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((Collection)localVars[0]).contains(localVars[1]);
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "excludes"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return !((Collection)localVars[0]).contains(localVars[1]);
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "count"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                int ret = 0;
                Object o = localVars[1];
                Iterator i = ((Collection)localVars[0]).iterator();
                while (i.hasNext()) {
                    if (!i.next().equals(o)) continue;
                    ++ret;
                }
                return ret;
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "includesAll"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((Collection)localVars[0]).containsAll((Collection)localVars[1]);
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "excludesAll"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                boolean ret = true;
                Collection s = (Collection)localVars[0];
                for (Object next : (Collection)localVars[1]) {
                    boolean bl = ret = ret && !s.contains(next);
                }
                return ret;
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "isEmpty"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((Collection)localVars[0]).isEmpty();
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "notEmpty"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return !((Collection)localVars[0]).isEmpty();
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "asSequence"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return new ArrayList((Collection)localVars[0]);
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "asSet"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                HashSet ret = new HashSet((Collection)localVars[0]);
                return ret;
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "asBag"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Bag((Collection)localVars[0]);
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "asOrderedSet"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return new LinkedHashSet((Collection)localVars[0]);
            }
        });
        operationsByName = new HashMap();
        this.vmTypeOperations.put(String.class, operationsByName);
        this.registerOperation(operationsByName, new Operation(1, "size"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((String)localVars[0]).length();
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "toString"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return localVars[0];
            }
        });
        this.registerOperation(operationsByName, new Operation(3, "regexReplaceAll"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((String)localVars[0]).replaceAll((String)localVars[1], (String)localVars[2]);
            }
        });
        this.registerOperation(operationsByName, new Operation(3, "replaceAll"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((String)localVars[0]).replace(((String)localVars[1]).charAt(0), ((String)localVars[2]).charAt(0));
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "split"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return new ArrayList<String>(Arrays.asList(((String)localVars[0]).split((String)localVars[1])));
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "toInteger"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return Integer.valueOf((String)localVars[0]);
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "toReal"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return Double.valueOf((String)localVars[0]);
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "toUpper"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((String)localVars[0]).toUpperCase();
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "toLower"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((String)localVars[0]).toLowerCase();
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "toSequence"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                String tmp = (String)localVars[0];
                ArrayList<String> ret = new ArrayList<String>();
                int i = 0;
                while (i < tmp.length()) {
                    ret.add("" + tmp.charAt(i));
                    ++i;
                }
                return ret;
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "startsWith"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((String)localVars[0]).startsWith((String)localVars[1]);
            }
        });
        this.registerOperation(operationsByName, new Operation(3, "substring"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((String)localVars[0]).substring(((Number)localVars[1]).intValue() - 1, ((Number)localVars[2]).intValue());
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "indexOf"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((String)localVars[0]).indexOf((String)localVars[1]);
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "lastIndexOf"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((String)localVars[0]).lastIndexOf((String)localVars[1]);
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "endsWith"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((String)localVars[0]).endsWith((String)localVars[1]);
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "+"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return String.valueOf((String)localVars[0]) + localVars[1];
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "concat"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return String.valueOf((String)localVars[0]) + localVars[1];
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "<"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((String)localVars[0]).compareTo((String)localVars[1]) < 0;
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "<="){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((String)localVars[0]).compareTo((String)localVars[1]) <= 0;
            }
        });
        this.registerOperation(operationsByName, new Operation(2, ">"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((String)localVars[0]).compareTo((String)localVars[1]) > 0;
            }
        });
        this.registerOperation(operationsByName, new Operation(2, ">="){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((String)localVars[0]).compareTo((String)localVars[1]) >= 0;
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "="){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((String)localVars[0]).equals(localVars[1]);
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "println"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                ATLLogger.info((String)localVars[0].toString());
                return null;
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "writeTo"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return ExecEnv.writeToWithCharset(frame, (String)localVars[0], (String)localVars[1], null);
            }
        });
        this.registerOperation(operationsByName, new Operation(3, "writeToWithCharset"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return ExecEnv.writeToWithCharset(frame, (String)localVars[0], (String)localVars[1], (String)localVars[2]);
            }
        });
        operationsByName = new HashMap();
        this.vmTypeOperations.put(Tuple.class, operationsByName);
        this.registerOperation(operationsByName, new Operation(2, "="){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((Tuple)localVars[0]).equals(localVars[1]);
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "asMap"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((Tuple)localVars[0]).getMap();
            }
        });
        operationsByName = new HashMap();
        this.vmTypeOperations.put(EnumLiteral.class, operationsByName);
        this.registerOperation(operationsByName, new Operation(1, "toString"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((EnumLiteral)localVars[0]).toString();
            }
        });
        operationsByName = new HashMap();
        this.vmTypeOperations.put(Object.class, operationsByName);
        this.registerOperation(operationsByName, new Operation(1, "toString"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return ExecEnv.this.toPrettyPrintedString(localVars[0]);
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "="){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return localVars[0].equals(localVars[1]);
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "<>"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return !localVars[0].equals(localVars[1]);
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "oclIsUndefined"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                return Boolean.FALSE;
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "debug"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                if (localVars[1] != null && !"".equals(localVars[1])) {
                    ATLLogger.info((String)(localVars[1] + ": " + ExecEnv.this.toPrettyPrintedString(localVars[0])));
                } else {
                    ATLLogger.info((String)ExecEnv.this.toPrettyPrintedString(localVars[0]));
                }
                return localVars[0];
            }
        });
        this.registerOperation(operationsByName, new Operation(3, "registerWeavingHelper"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                String name = (String)localVars[1];
                String initOperationName = (String)localVars[2];
                frame.execEnv.registerWeavingHelper(localVars[0], name, initOperationName);
                return null;
            }
        });
        operationsByName = new HashMap();
        this.vmTypeOperations.put(OclUndefined.class, operationsByName);
        this.registerOperation(operationsByName, new Operation(1, "oclIsUndefined"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                return Boolean.TRUE;
            }
        });
        this.registerOperation(operationsByName, new Operation(3, "getNamedTargetFromSource"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                return OclUndefined.SINGLETON;
            }
        });
        operationsByName = new HashMap();
        this.vmTypeOperations.put(OclType.class, operationsByName);
        this.registerOperation(operationsByName, new Operation(2, "setName"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                ((OclType)localVars[0]).setName((String)localVars[1]);
                return null;
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "conformsTo"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((OclType)localVars[0]).conformsTo((OclType)localVars[1]);
            }
        });
        operationsByName = new HashMap();
        this.vmTypeOperations.put(OclParametrizedType.class, operationsByName);
        this.registerOperation(operationsByName, new Operation(2, "setElementType"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                ((OclParametrizedType)localVars[0]).setElementType(localVars[1]);
                return null;
            }
        });
        operationsByName = new HashMap();
        this.vmTypeOperations.put(Class.class, operationsByName);
        this.registerOperation(operationsByName, new Operation(3, "registerHelperAttribute"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                String name = (String)localVars[1];
                String initOperationName = (String)localVars[2];
                frame.execEnv.registerHelperAttribute(localVars[0], name, initOperationName);
                return null;
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "conformsTo"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((Class)localVars[1]).isAssignableFrom((Class)localVars[0]);
            }
        });
        operationsByName = new HashMap();
        this.vmTypeOperations.put(TransientLink.class, operationsByName);
        this.registerOperation(operationsByName, new Operation(2, "setRule"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                ((TransientLink)localVars[0]).setRule((String)localVars[1]);
                return null;
            }
        });
        this.registerOperation(operationsByName, new Operation(3, "addSourceElement"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                ((TransientLink)localVars[0]).getSourceElements().put(localVars[1], localVars[2]);
                return null;
            }
        });
        this.registerOperation(operationsByName, new Operation(3, "addTargetElement"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                TransientLink tl = (TransientLink)localVars[0];
                tl.getTargetElements().put(localVars[1], localVars[2]);
                tl.getTargetElementsList().add(localVars[2]);
                return null;
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "getSourceElement"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((TransientLink)localVars[0]).getSourceElements().get(localVars[1]);
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "getTargetElement"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                Object ret = ((TransientLink)localVars[0]).getTargetElements().get(localVars[1]);
                if (ret == null) {
                    ret = OclUndefined.SINGLETON;
                }
                return ret;
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "getTargetFromSource"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                Object ret = ((TransientLink)localVars[0]).getTargetElementsList().iterator().next();
                if (ret == null) {
                    ret = OclUndefined.SINGLETON;
                }
                return ret;
            }
        });
        this.registerOperation(operationsByName, new Operation(3, "getNamedTargetFromSource"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                Object ret = ((TransientLink)localVars[0]).getTargetElements().get(localVars[2]);
                if (ret == null) {
                    ret = OclUndefined.SINGLETON;
                }
                return ret;
            }
        });
        this.registerOperation(operationsByName, new Operation(3, "addVariable"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                ((TransientLink)localVars[0]).getVariables().put(localVars[1], localVars[2]);
                return null;
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "getVariable"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((TransientLink)localVars[0]).getVariables().get(localVars[1]);
            }
        });
        operationsByName = new HashMap();
        this.vmTypeOperations.put(TransientLinkSet.class, operationsByName);
        this.registerOperation(operationsByName, new Operation(2, "addLink"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                TransientLink tl = (TransientLink)localVars[1];
                TransientLinkSet tls = (TransientLinkSet)localVars[0];
                tls.addLink(tl);
                return null;
            }
        });
        this.registerOperation(operationsByName, new Operation(3, "addLink2"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                TransientLink tl = (TransientLink)localVars[1];
                TransientLinkSet tls = (TransientLinkSet)localVars[0];
                boolean isDefault = (Boolean)localVars[2];
                tls.addLink2(tl, isDefault);
                return null;
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "getLinksByRule"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return ((TransientLinkSet)localVars[0]).getLinksByRule(localVars[1]);
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "getLinkBySourceElement"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                TransientLink ret = ((TransientLinkSet)localVars[0]).getLinkBySourceElement(localVars[1]);
                if (ret == null) {
                    return OclUndefined.SINGLETON;
                }
                return ret;
            }
        });
        operationsByName.put("getLinkByRuleAndSourceElement", new Operation(3, "getLinkByRuleAndSourceElement"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                TransientLink ret = ((TransientLinkSet)localVars[0]).getLinkByRuleAndSourceElement(localVars[1], localVars[2]);
                if (ret == null) {
                    return OclUndefined.SINGLETON;
                }
                return ret;
            }
        });
        operationsByName = new HashMap();
        this.vmTypeOperations.put(HashMap.class, operationsByName);
        this.registerOperation(operationsByName, new Operation(2, "get"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                Object ret = ((Map)localVars[0]).get(localVars[1]);
                if (ret == null) {
                    ret = OclUndefined.SINGLETON;
                }
                return ret;
            }
        });
        this.registerOperation(operationsByName, new Operation(3, "including"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                HashMap<Object, Object> ret = new HashMap<Object, Object>((Map)localVars[0]);
                ret.put(localVars[1], localVars[2]);
                return ret;
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "getKeys"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return new HashSet(((Map)localVars[0]).keySet());
            }
        });
        this.registerOperation(operationsByName, new Operation(1, "getValues"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                return new Bag(((Map)localVars[0]).values());
            }
        });
        this.registerOperation(operationsByName, new Operation(2, "union"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                Object[] localVars = frame.localVars;
                HashMap ret = new HashMap((Map)localVars[0]);
                ret.putAll((Map)localVars[1]);
                return ret;
            }
        });
        this.operationsByType = new HashMap<Object, Map<String, Operation>>();
        this.cacheAttributeHelperResults = true;
        this.weavingHelperToPersistToByType = new HashMap<Object, Map<String, String>>();
        this.helperValuesByElement = new HashMap();
        this.attributeInitializers = new HashMap<Object, Map<String, Operation>>();
        this.noInitializer = new Operation(0, "noInitializer"){

            @Override
            public Object exec(AbstractStackFrame frame) {
                return null;
            }
        };
        this.modelsByName = models;
        this.tools = tools;
        if (tools == null) {
            this.tools = new ITool[0];
        }
        this.nameByModel = new HashMap<IModel, String>();
        for (String name : this.modelsByName.keySet()) {
            IModel model = this.modelsByName.get(name);
            this.nameByModel.put(model, name);
        }
    }

    public void stepTools(AbstractStackFrame frame) {
        int i = 0;
        while (i < this.tools.length) {
            this.tools[i].step(frame);
            ++i;
        }
    }

    public void enterTools(AbstractStackFrame frame) {
        int i = 0;
        while (i < this.tools.length) {
            this.tools[i].enter(frame);
            ++i;
        }
    }

    public void leaveTools(AbstractStackFrame frame) {
        int i = 0;
        while (i < this.tools.length) {
            this.tools[i].leave(frame);
            ++i;
        }
    }

    public void terminateTools() {
        int i = 0;
        while (i < this.tools.length) {
            this.tools[i].terminated();
            ++i;
        }
    }

    public void init(IModelAdapter modelAdapterParam) {
        this.modelAdapter = modelAdapterParam;
        this.modelAdapter.registerVMSupertypes(OclType.getSupertypes());
        this.modelAdapter.registerVMTypeOperations(this.vmTypeOperations);
    }

    public String getModelNameOf(Object element) {
        if (this.modelAdapter.isMetametaElement(element)) {
            return "MOF";
        }
        return this.nameByModel.get(this.getModelOf(element));
    }

    public String getNameOf(IModel model) {
        return this.nameByModel.get(model);
    }

    public IModel getModel(Object name) {
        return this.modelsByName.get(name);
    }

    public Iterator<IModel> getModels() {
        return this.modelsByName.values().iterator();
    }

    public Operation getOperation(Object type, Object name) {
        boolean debug = false;
        Operation ret = null;
        Map<String, Operation> map = this.getOperations(type, false);
        if (map != null) {
            ret = map.get(name);
        }
        if (ret == null) {
            Iterator<Object> i = this.modelAdapter.getSupertypes(type).iterator();
            while (i.hasNext() && ret == null) {
                Object st = i.next();
                ret = this.getOperation(st, name);
            }
            if (map != null) {
                map.put(name.toString(), ret);
            }
        }
        return ret;
    }

    public void registerHelperAttribute(Object type, String name, String initOperationName) {
        Operation op = this.getOperation(type, initOperationName);
        this.getAttributeInitializers(type, true).put(name, op);
    }

    public Operation getAttributeInitializer(Object type, String name) {
        Operation ret = null;
        Map<String, Operation> map = this.getAttributeInitializers(type, true);
        if (map != null) {
            ret = map.get(name);
        }
        if (ret == null) {
            Iterator<Object> i = this.modelAdapter.getSupertypes(type).iterator();
            while (i.hasNext() && ret == null) {
                Object st = i.next();
                ret = this.getAttributeInitializer(st, name);
            }
            if (map != null) {
                if (ret == null) {
                    ret = this.noInitializer;
                }
                map.put(name, ret);
            }
        }
        if (ret == this.noInitializer) {
            ret = null;
        }
        return ret;
    }

    private Map<String, Operation> getAttributeInitializers(Object type, boolean createIfMissing) {
        Map<String, Operation> ret = this.attributeInitializers.get(type);
        if (createIfMissing && ret == null) {
            ret = new HashMap<String, Operation>();
            this.attributeInitializers.put(type, ret);
        }
        return ret;
    }

    private Map<String, SoftReference<?>> getHelperValues(Object element) {
        Map<String, SoftReference<?>> ret = this.helperValuesByElement.get(element);
        if (ret == null) {
            ret = new HashMap();
            this.helperValuesByElement.put(element, ret);
        }
        return ret;
    }

    public Object getHelperValue(AbstractStackFrame frame, Object type, Object element, String name) {
        Object ret = null;
        Map<String, SoftReference<?>> helperValues = this.getHelperValues(element);
        SoftReference<?> sr = helperValues.get(name);
        if (sr != null) {
            ret = sr.get();
        }
        if (ret == null) {
            Operation o = this.getAttributeInitializer(type, name);
            if (o != null) {
                AbstractStackFrame calleeFrame = frame.newFrame(o);
                Object[] arguments = calleeFrame.localVars;
                arguments[0] = element;
                ret = o.exec(calleeFrame.enter());
                calleeFrame.leave();
                if (this.cacheAttributeHelperResults) {
                    helperValues.put(name, new SoftReference<Object>(ret));
                }
            } else {
                ret = OclUndefined.SINGLETON;
            }
        }
        return ret;
    }

    public void registerOperation(Object type, Operation oper, String name) {
        this.getOperations(type, true).put(name, oper);
    }

    public void registerOperation(Object type, Operation oper) {
        this.registerOperation(this.getOperations(type, true), oper);
    }

    private void registerOperation(Map<String, Operation> map, Operation oper) {
        map.put(oper.getName(), oper);
    }

    private Map<String, Operation> getOperations(Object type, boolean createIfMissing) {
        Map<String, Operation> ret = this.operationsByType.get(type);
        if (ret == null) {
            Map<String, Operation> vmops = this.getVMOperations(type);
            if (createIfMissing || vmops != null && !vmops.isEmpty()) {
                ret = new HashMap<String, Operation>();
                this.operationsByType.put(type, ret);
                if (vmops != null) {
                    ret.putAll(vmops);
                }
            }
        }
        return ret;
    }

    private Map<String, Operation> getVMOperations(Object type) {
        return this.vmTypeOperations.get(type);
    }

    public String toPrettyPrintedString(Object value) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.prettyPrint(new PrintStream(out), value);
        return out.toString();
    }

    public void prettyPrint(Object value) {
        ATLLogger.info((String)this.toPrettyPrintedString(value));
    }

    public void prettyPrint(PrintStream out, Object value) {
        if (value == null) {
            out.print("<null>");
        } else if (value instanceof String) {
            out.print('\'');
            out.print(value);
            out.print('\'');
        } else if (value instanceof EnumLiteral) {
            out.print('#');
            out.print(value);
        } else if (value instanceof LinkedHashSet) {
            out.print("OrderedSet {");
            this.prettyPrintCollection(out, (Collection)value);
        } else if (value instanceof HashSet) {
            out.print("Set {");
            this.prettyPrintCollection(out, (Collection)value);
        } else if (value instanceof ArrayList) {
            out.print("Sequence {");
            this.prettyPrintCollection(out, (Collection)value);
        } else if (value instanceof Bag) {
            out.print("Bag {");
            this.prettyPrintCollection(out, (Collection)value);
        } else if (value instanceof Tuple) {
            out.print("Tuple {");
            boolean first = true;
            for (Map.Entry<Object, Object> entry : ((Tuple)value).getMap().entrySet()) {
                if (first) {
                    first = false;
                } else {
                    out.print(", ");
                }
                out.print(entry.getKey());
                out.print(" = ");
                this.prettyPrint(out, entry.getValue());
            }
            out.print('}');
        } else if (value instanceof HashMap) {
            out.print("Map {");
            boolean first = true;
            for (Map.Entry entry : ((Map)value).entrySet()) {
                if (first) {
                    first = false;
                } else {
                    out.print(", ");
                }
                out.print('(');
                this.prettyPrint(out, entry.getKey());
                out.print(", ");
                this.prettyPrint(out, entry.getValue());
                out.print(')');
            }
            out.print('}');
        } else if (value instanceof OclUndefined) {
            out.print("OclUndefined");
        } else if (!this.modelAdapter.prettyPrint(this, out, value)) {
            out.print(value);
        }
    }

    public void prettyPrintCollection(PrintStream out, Collection<?> col) {
        boolean first = true;
        Iterator<?> i = col.iterator();
        while (i.hasNext()) {
            if (!first) {
                out.print(", ");
            }
            this.prettyPrint(out, i.next());
            first = false;
        }
        out.print('}');
    }

    public static Object findMetaElement(AbstractStackFrame frame, Object mname, Object me) {
        Object ret = null;
        IReferenceModel referenceModel = (IReferenceModel)frame.execEnv.getModel(mname);
        if (referenceModel != null) {
            ret = referenceModel.getMetaElementByName((String)me);
            if (ret == null) {
                throw new VMException(frame, Messages.getString("ExecEnv.CANNOTFINDCLASS", me, mname));
            }
        } else {
            throw new VMException(frame, Messages.getString("ExecEnv.CANNOTFINDMETAMODEL", mname));
        }
        return ret;
    }

    public Object newElement(AbstractStackFrame frame, Object ec) {
        Object s = null;
        Iterator<IModel> i = this.getModels();
        while (i.hasNext()) {
            IModel model = i.next();
            if (!model.isTarget() || !model.getReferenceModel().isModelOf(ec)) continue;
            s = model.newElement(ec);
            break;
        }
        if (s == null) {
            throw new VMException(frame, Messages.getString("ExecEnv.CANNOTCREATE", this.toPrettyPrintedString(ec)));
        }
        return s;
    }

    public Object newElement(AbstractStackFrame frame, Object ec, String metamodelName) {
        Object s = null;
        IReferenceModel metamodel = (IReferenceModel)this.getModel(metamodelName);
        if (metamodel != null) {
            Iterator<IModel> i = this.getModels();
            while (i.hasNext()) {
                IModel model = i.next();
                if (!model.getReferenceModel().equals(metamodel) || !model.isTarget() || !model.getReferenceModel().isModelOf(ec)) continue;
                s = model.newElement(ec);
                break;
            }
        }
        if (s == null) {
            throw new VMException(frame, Messages.getString("ExecEnv.CANNOTCREATE", this.toPrettyPrintedString(ec)));
        }
        return s;
    }

    public Object newElementIn(AbstractStackFrame frame, Object ec, String modelName) {
        Object s = null;
        IModel model = this.modelsByName.get(modelName);
        if (model == null) {
            throw new VMException(frame, Messages.getString("ExecEnv.MODEL_NOT_FOUND", modelName));
        }
        if (model.isTarget()) {
            s = model.newElement(ec);
        }
        if (!model.getReferenceModel().isModelOf(ec)) {
            throw new VMException(frame, Messages.getString("ExecEnv.UNABLE_TO_CREATE", ec, modelName));
        }
        if (s == null) {
            throw new VMException(frame, Messages.getString("ExecEnv.CANNOTCREATE", this.toPrettyPrintedString(ec)));
        }
        return s;
    }

    private static boolean writeToWithCharset(AbstractStackFrame frame, String self, String fileName, String charset) throws VMException {
        boolean ret = false;
        try {
            File file = new File(fileName);
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            PrintStream out = null;
            out = charset == null ? new PrintStream(new BufferedOutputStream(new FileOutputStream(file)), true) : new PrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), true, charset);
            out.print(self);
            out.close();
            ret = true;
        }
        catch (IOException ioe) {
            throw new VMException(frame, ioe.getLocalizedMessage(), ioe);
        }
        return ret;
    }

    public Map<String, IModel> getModelsByName() {
        return this.modelsByName;
    }

    public boolean isStep() {
        return this.step;
    }

    public void setStep(boolean step) {
        this.step = step;
    }

    public IModelAdapter getModelAdapter() {
        return this.modelAdapter;
    }

    public long getNbExecutedBytecodes() {
        return this.nbExecutedBytecodes;
    }

    public void incNbExecutedBytecodes() {
        ++this.nbExecutedBytecodes;
    }

    private Map<String, String> getWeavingHelperToPersistTo(Object type, boolean createIfMissing) {
        Map<String, String> ret = this.weavingHelperToPersistToByType.get(type);
        if (createIfMissing && ret == null) {
            ret = new HashMap<String, String>();
            this.weavingHelperToPersistToByType.put(type, ret);
        }
        return ret;
    }

    public boolean isWeavingHelper(Object type, String name) {
        Map<String, String> weavingHelperToPersistTo = this.getWeavingHelperToPersistTo(type, false);
        if (weavingHelperToPersistTo != null) {
            return weavingHelperToPersistTo.containsKey(name);
        }
        return false;
    }

    public void registerWeavingHelper(Object type, String name, String persistTo) {
        this.getWeavingHelperToPersistTo(type, true).put(name, persistTo);
    }

    public boolean isHelper(Object type, String name) {
        return this.getAttributeInitializer(type, name) != null || this.isWeavingHelper(type, name);
    }

    public void setHelperValue(Object element, String name, Object value) {
        Map<String, SoftReference<?>> helperValues = this.getHelperValues(element);
        helperValues.put(name, new SoftReference<Object>(value));
    }

    public void terminated() {
        this.terminateTools();
        for (Map.Entry<Object, Map<String, String>> entry : this.weavingHelperToPersistToByType.entrySet()) {
            Object type;
            Map<String, String> weavingHelperToPersistTo = entry.getValue();
            if (weavingHelperToPersistTo == null || !this.modelAdapter.isModelElement(type = entry.getKey())) continue;
            this.persistWeavingHelpers(type, weavingHelperToPersistTo);
        }
        for (IModel model : this.modelsByName.values()) {
            this.modelAdapter.finalizeModel(model);
        }
    }

    private void persistWeavingHelpers(Object type, Map<String, String> weavingHelperToPersistTo) {
        for (Map.Entry<String, String> entry : weavingHelperToPersistTo.entrySet()) {
            String persistTo = entry.getValue();
            if (persistTo == null) continue;
            String name = entry.getKey();
            IModel metamodel = this.getModelOf(type);
            Iterator<IModel> j = this.getModels();
            while (j.hasNext()) {
                IModel model = j.next();
                if (model.getReferenceModel() != metamodel) continue;
                for (Object ame : model.getElementsByType(type)) {
                    Object value = this.getHelperValue(null, this.modelAdapter.getType(ame), ame, name);
                    if (this.modelAdapter.isDeleted(value)) continue;
                    this.modelAdapter.set(new StackFrame(this), ame, persistTo, this.modelAdapter.getID(value));
                }
            }
        }
    }

    public IModel getModelOf(Object element) {
        for (IModel model : this.getModelsByName().values()) {
            if (!model.isModelOf(element)) continue;
            return model;
        }
        return null;
    }

    static /* synthetic */ IModelAdapter access$1(ExecEnv execEnv) {
        return execEnv.modelAdapter;
    }
}

