/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.dsls.tcs.injector;

import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.m2m.atl.dsls.tcs.injector.CompletionInformation;
import org.eclipse.m2m.atl.dsls.tcs.injector.ElementTrace;
import org.eclipse.m2m.atl.dsls.tcs.injector.ModelAdapter;
import org.eclipse.m2m.atl.dsls.tcs.injector.ReferenceLocation;
import org.eclipse.m2m.atl.dsls.tcs.injector.wrappers.ParserWrapper;

public class TCSRuntime {
    private ModelAdapter targetModelAdapter;
    private ModelAdapter problemsModelAdapter;
    private boolean keepLocation;
    private boolean keepNL;
    private boolean keepComments;
    private Map locationByElement;
    private Map hyperlinks;
    private Map trace;
    private ParserWrapper parserWrapper;
    private Context currentContext;
    private Map contextByElement;
    private Stack previousElement;
    private boolean lastWasCreation;
    private List refSettings;
    private Object lastToken;
    private CompletionInformation completionInformation = null;
    private int nbErrors = 0;
    private static final boolean debug = false;

    public TCSRuntime(ModelAdapter targetModelAdapter, ParserWrapper parserWrapper, List refSettings, Map arguments) {
        this.targetModelAdapter = targetModelAdapter;
        this.problemsModelAdapter = (ModelAdapter)arguments.get("problems");
        this.parserWrapper = parserWrapper;
        this.refSettings = refSettings;
        this.keepNL = "true".equals(arguments.get("keepNL"));
        this.keepLocation = !"false".equals(arguments.get("keepLocation"));
        this.keepComments = !"false".equals(arguments.get("keepComments"));
        this.completionInformation = (CompletionInformation)arguments.get("completionInformation");
        this.hyperlinks = (Map)arguments.get("hyperlinks");
        this.trace = (Map)arguments.get("trace");
        this.locationByElement = arguments.get("locationByElement") == null ? new HashMap() : (Map)arguments.get("locationByElement");
        this.previousElement = new Stack();
        this.currentContext = new Context();
        this.contextByElement = new HashMap();
        this.lastWasCreation = true;
    }

    public int getNbErrors() {
        return this.nbErrors;
    }

    public ModelAdapter getTargetModelAdapter() {
        return this.targetModelAdapter;
    }

    public boolean isKeepNL() {
        return this.keepNL;
    }

    public Object createEnumLiteral(String name) {
        return this.getTargetModelAdapter().createEnumLiteral(name);
    }

    public Object create(String name, boolean context, boolean addToContext) {
        Object ret = null;
        ret = this.getTargetModelAdapter().createElement(name);
        if (addToContext) {
            this.currentContext.add(ret);
        }
        if (context) {
            this.currentContext = this.currentContext.enterContext(ret);
        }
        if (this.lastWasCreation) {
            this.previousElement.push(null);
        }
        this.lastWasCreation = true;
        return ret;
    }

    public void leaveContext(boolean leave) {
        if (leave) {
            this.currentContext = this.currentContext.parent();
        }
    }

    public void addToContext(Object ame, boolean addToContext) {
        if (addToContext) {
            this.currentContext.add(ame);
        }
    }

    public void setLocation(Object ame, String location) {
        if (location.matches("^0:0-.+")) {
            location = location.split("-")[1];
            location = String.valueOf(location) + "-" + location;
        }
        this.locationByElement.put(ame, location);
        if (this.keepLocation) {
            try {
                this.getTargetModelAdapter().set(ame, "location", location);
            }
            catch (Exception e) {
                this.reportProblem("Warning", "could not set location of " + ame + ", disabling further location settings", location);
                this.keepLocation = false;
            }
        }
    }

    public void setCommentsBefore(Object ame, Object token) {
        this.parserWrapper.setCommentsBefore(ame, token);
    }

    public void setCommentsAfter(Object ame, Object token) {
        this.parserWrapper.setCommentsAfter(ame, token);
    }

    public void set(Object ame, String prop, Object value) {
        this.getTargetModelAdapter().set(ame, prop, value);
        if (this.trace != null) {
            ElementTrace et = (ElementTrace)this.trace.get(ame);
            if (et == null) {
                et = new ElementTrace(ame);
                this.trace.put(ame, et);
            }
            Object lastToken = this.parserWrapper.getLastToken();
            et.addPropertyLocation(prop, this.parserWrapper.getLocation(lastToken));
        }
    }

    public void setRef(Object object, String propertyName, String valueTypeName, String keyName, Object keyValue, String lookIn, String autoCreate, String createAs, boolean importContext, String createIn) {
        if (keyValue == null) {
            return;
        }
        new RefSetting(this.currentContext, object, propertyName, valueTypeName, keyName, keyValue, lookIn, autoCreate, createAs, importContext, createIn, this.lastToken);
    }

    public void reportProblem(String severity, String msg, Object ame) {
        String location = "<unknown location>";
        if (this.locationByElement.containsKey(ame)) {
            location = (String)this.locationByElement.get(ame);
        }
        this.reportProblem(severity, msg, location);
    }

    public void reportProblem(String severity, String msg, String location) {
        if ("error".equals(severity.toLowerCase())) {
            ++this.nbErrors;
        }
        if (this.problemsModelAdapter == null) {
            System.err.println(String.valueOf(severity) + ": " + location + ": " + msg + ".");
        } else {
            Object ame = this.problemsModelAdapter.createElement("Problem");
            this.problemsModelAdapter.set(ame, "severity", this.problemsModelAdapter.createEnumLiteral(severity.toLowerCase()));
            this.problemsModelAdapter.set(ame, "location", location);
            this.problemsModelAdapter.set(ame, "description", msg);
        }
    }

    public void reportError(Exception re) {
        this.parserWrapper.reportError(re);
    }

    public void reportError(String msg) {
        this.reportProblem("Error", msg, "?");
    }

    public void reportWarning(String msg) {
        this.reportProblem("Warning", msg, "?");
    }

    public void setToken(Object token) {
        this.lastToken = token;
    }

    public String unescapeString(String s, int delimLength) {
        char c;
        StringBuffer ret = new StringBuffer();
        s = s.substring(delimLength, s.length() - (delimLength * 2 - 1));
        StringCharacterIterator ci = new StringCharacterIterator(s);
        char c2 = ci.first();
        while (c != '\uffff') {
            int tc = 0;
            block0 : switch (c) {
                case '\\': {
                    c = ci.next();
                    switch (c) {
                        case 'n': {
                            tc = 10;
                            break block0;
                        }
                        case 'r': {
                            tc = 13;
                            break block0;
                        }
                        case 't': {
                            tc = 9;
                            break block0;
                        }
                        case 'b': {
                            tc = 8;
                            break block0;
                        }
                        case 'f': {
                            tc = 12;
                            break block0;
                        }
                        case '\"': {
                            tc = 34;
                            break block0;
                        }
                        case '\'': {
                            tc = 39;
                            break block0;
                        }
                        case '\\': {
                            tc = 92;
                            break block0;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': {
                            throw new RuntimeException("octal escape sequences not supported yet");
                        }
                    }
                    throw new RuntimeException("unknown escape sequence: '\\" + c + "'");
                }
                default: {
                    tc = c;
                }
            }
            ret.append((char)tc);
            c = ci.next();
        }
        return ret.toString();
    }

    private void debug(String msg) {
        System.out.println(msg);
    }

    public void setKeepComments(boolean keepComments) {
        this.keepComments = keepComments;
    }

    public boolean isKeepComments() {
        return this.keepComments;
    }

    public void setLastWasCreation(boolean lastWasCreation) {
        this.lastWasCreation = lastWasCreation;
    }

    protected class Context {
        private Object element;
        private Context parent;
        private Set contents = new HashSet();
        private Set importedContexts = new HashSet();
        private Map mapByTypeAndKey = new HashMap();

        public Context enterContext(Object element) {
            Context ret = new Context(element, this);
            TCSRuntime.this.contextByElement.put(element, ret);
            return ret;
        }

        public Context() {
            this.parent = null;
        }

        private Context(Object element, Context parent) {
            this.parent = parent;
            this.element = element;
        }

        public void add(Object e) {
            this.contents.add(e);
        }

        public void add(Object e, String valueTypeName, String keyName, Object keyVal) {
            this.add(e);
            Map elementByVal = this.getElementByVal(valueTypeName, keyName);
            this.addElementByVal(elementByVal, e, keyVal);
        }

        private void addElementByVal(Map elementByVal, Object ame, Object val) {
            Object element = elementByVal.get(val);
            if (element == null) {
                elementByVal.put(val, ame);
            } else if (element instanceof Collection) {
                ((Collection)element).add(ame);
            } else {
                ArrayList<Object> c = new ArrayList<Object>();
                c.add(element);
                c.add(ame);
                elementByVal.put(val, c);
            }
        }

        public Context parent() {
            return this.parent;
        }

        public void importContext(Context c) {
            this.importedContexts.add(c);
        }

        public Object getElement() {
            return this.element;
        }

        public Map getElementByVal(String valueTypeName, String keyName) {
            String key = "__" + valueTypeName + "_" + keyName;
            HashMap elementByVal = (HashMap)this.mapByTypeAndKey.get(key);
            if (elementByVal == null) {
                elementByVal = new HashMap();
                for (Object ame : this.contents) {
                    if (!this.isCandidate(ame, valueTypeName)) continue;
                    Object val = TCSRuntime.this.getTargetModelAdapter().get(ame, keyName);
                    this.addElementByVal(elementByVal, ame, val);
                }
                this.mapByTypeAndKey.put(key, elementByVal);
                for (Context importedContext : this.importedContexts) {
                    Map map = importedContext.getElementByVal(valueTypeName, keyName);
                    for (Map.Entry entry : map.entrySet()) {
                        if (elementByVal.containsKey(entry.getKey())) continue;
                        elementByVal.put(entry.getKey(), entry.getValue());
                    }
                }
            }
            return elementByVal;
        }

        private boolean isCandidate(Object ame, String valueTypeName) {
            return TCSRuntime.this.getTargetModelAdapter().isCandidate(ame, valueTypeName);
        }
    }

    protected class RefSetting {
        private Context currentContext;
        private Object object;
        private String propertyName;
        private String valueTypeName;
        private String keyName;
        private Object keyValue;
        private String lookIn;
        private String autoCreate;
        private String createAs;
        protected boolean importContext;
        private String createIn;
        private Object token;
        private Object realValue = null;

        public RefSetting(Context currentContext, Object object, String propertyName, String valueTypeName, String keyName, Object keyValue, String lookIn, String autoCreate, String createAs, boolean importContext, String createIn, Object token) {
            this.currentContext = currentContext;
            this.object = object;
            this.propertyName = propertyName;
            this.valueTypeName = valueTypeName;
            this.keyName = keyName;
            this.keyValue = keyValue;
            this.lookIn = lookIn;
            this.autoCreate = autoCreate;
            this.createAs = createAs;
            this.importContext = importContext;
            this.createIn = createIn;
            this.token = token;
            TCSRuntime.this.refSettings.add(this);
        }

        private boolean doItForContext(Context context) {
            Object ame;
            boolean done = false;
            Object keyVal = this.keyValue;
            Map elementByVal = context.getElementByVal(this.valueTypeName, this.keyName);
            int offset = -1;
            List proposals = null;
            if (TCSRuntime.this.completionInformation != null && (offset = TCSRuntime.this.completionInformation.getOffset()) >= TCSRuntime.this.parserWrapper.getStartOffset(this.token) - 1 && offset <= TCSRuntime.this.parserWrapper.getEndOffset(this.token)) {
                proposals = TCSRuntime.this.completionInformation.getProposals();
                proposals.addAll(elementByVal.keySet());
                if (TCSRuntime.this.completionInformation.getPrefix() == null && keyVal instanceof String) {
                    TCSRuntime.this.completionInformation.setPrefix(((String)keyVal).substring(0, offset - TCSRuntime.this.parserWrapper.getStartOffset(this.token) + 1));
                }
            }
            if ((ame = elementByVal.get(keyVal)) instanceof Collection) {
                Iterator i = ((Collection)ame).iterator();
                while (i.hasNext()) {
                    TCSRuntime.this.reportProblem("Error", "found several " + this.valueTypeName + " with the same " + this.keyName + " equals to " + keyVal, i.next());
                }
                done = true;
            } else if (ame != null) {
                this.realValue = ame;
                TCSRuntime.this.getTargetModelAdapter().set(this.object, this.propertyName, ame);
                if (TCSRuntime.this.hyperlinks != null) {
                    String location = TCSRuntime.this.parserWrapper.getLocation(this.token);
                    TCSRuntime.this.hyperlinks.put(location, TCSRuntime.this.locationByElement.get(ame));
                }
                if (TCSRuntime.this.trace != null) {
                    ElementTrace et = (ElementTrace)TCSRuntime.this.trace.get(this.object);
                    if (et == null) {
                        et = new ElementTrace(this.object);
                        TCSRuntime.this.trace.put(this.object, et);
                    }
                    ReferenceLocation location = new ReferenceLocation(TCSRuntime.this.parserWrapper.getLocation(this.token), ame);
                    et.addPropertyLocation(this.propertyName, location);
                }
                done = true;
            }
            if (!done && (context = context.parent()) != null) {
                done = this.doItForContext(context);
            }
            return done;
        }

        private void create() {
            Object e;
            String[] path;
            Object ro = null;
            ro = this.createAs != null ? TCSRuntime.this.getTargetModelAdapter().createElement(this.createAs) : TCSRuntime.this.getTargetModelAdapter().createElement(this.valueTypeName);
            this.realValue = ro;
            TCSRuntime.this.getTargetModelAdapter().set(ro, this.keyName, this.keyValue);
            TCSRuntime.this.getTargetModelAdapter().set(this.object, this.propertyName, ro);
            try {
                String location = TCSRuntime.this.parserWrapper.getLocation(this.token);
                TCSRuntime.this.setLocation(ro, location);
            }
            catch (Exception location) {
                // empty catch block
            }
            if (this.createIn != null) {
                path = this.createIn.split("\\.");
                Object e2 = this.navigateLookIn(path, false);
                if (e2 != null) {
                    TCSRuntime.this.getTargetModelAdapter().set(e2, path[path.length - 1], ro);
                    this.currentContext.add(ro, this.valueTypeName, this.keyName, this.keyValue);
                }
            } else if (this.lookIn != null && !this.lookIn.equals("#all") && (e = this.navigateLookIn(path = this.lookIn.split("\\."), false)) != null) {
                TCSRuntime.this.getTargetModelAdapter().set(e, path[path.length - 1], ro);
                this.currentContext.add(ro, this.valueTypeName, this.keyName, this.keyValue);
            }
        }

        private Object navigateLookIn(String[] path, boolean navigateLast) {
            Object ret = this.object;
            int i = 0;
            while (i < path.length - (navigateLast ? 0 : 1) && ret != null) {
                if (path[i].equals("#context")) {
                    ret = this.currentContext.getElement();
                } else {
                    Object v = TCSRuntime.this.getTargetModelAdapter().get(ret, path[i]);
                    ret = TCSRuntime.this.getTargetModelAdapter().isAModelElement(v) ? v : null;
                }
                ++i;
            }
            return ret;
        }

        public void doIt() {
            Context context;
            boolean done = false;
            if (this.autoCreate.equals("always")) {
                this.create();
                done = true;
            } else {
                context = this.currentContext;
                if ("#all".equals(this.lookIn)) {
                    Object val = null;
                    Iterator i = TCSRuntime.this.getTargetModelAdapter().getElementsByType(this.valueTypeName).iterator();
                    while (i.hasNext() && val == null) {
                        Object ame = i.next();
                        if (!TCSRuntime.this.getTargetModelAdapter().get(ame, this.keyName).equals(this.keyValue)) continue;
                        val = ame;
                    }
                    if (val != null) {
                        this.realValue = val;
                        TCSRuntime.this.getTargetModelAdapter().set(this.object, this.propertyName, val);
                        done = true;
                    }
                } else if (this.lookIn != null && !this.lookIn.equals("#all")) {
                    String[] path = this.lookIn.split("\\.");
                    Object e = this.navigateLookIn(path, true);
                    if (e != null) {
                        context = (Context)TCSRuntime.this.contextByElement.get(e);
                        done = this.doItForContext(context);
                    }
                } else {
                    done = this.doItForContext(context);
                }
            }
            if (!done) {
                if (!this.autoCreate.equals("never")) {
                    this.create();
                } else {
                    TCSRuntime.this.reportProblem("Error", String.valueOf(this.valueTypeName) + " with " + this.keyName + " = " + this.keyValue + " was not found for " + this.propertyName + " of " + TCSRuntime.this.getTargetModelAdapter().getType(this.object), this.object);
                }
            }
            if (this.realValue != null) {
                context = (Context)TCSRuntime.this.contextByElement.get(this.realValue);
                if (this.importContext && context != null) {
                    ((Context)TCSRuntime.this.contextByElement.get(this.object)).importContext(context);
                }
            }
        }
    }
}

