/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.core.ui.vm.asm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.atl.core.ATLCoreException;
import org.eclipse.m2m.atl.core.IInjector;
import org.eclipse.m2m.atl.core.IModel;
import org.eclipse.m2m.atl.core.ui.vm.asm.ASMModelWrapper;
import org.eclipse.m2m.atl.drivers.emf4atl.EMFModelLoader;
import org.eclipse.m2m.atl.engine.vm.ModelLoader;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;

public class ASMInjector
implements IInjector {
    public void inject(IModel targetModel, String source, Map<String, Object> options) throws ATLCoreException {
        this.inject(targetModel, source, ((ASMModelWrapper)targetModel).getName());
    }

    public void inject(IModel targetModel, String source) throws ATLCoreException {
        this.inject(targetModel, source, ((ASMModelWrapper)targetModel).getName());
    }

    public void inject(IModel targetModel, InputStream source, Map<String, Object> options) throws ATLCoreException {
        ASMModelWrapper modelWrapper = (ASMModelWrapper)targetModel;
        try {
            ModelLoader ml = modelWrapper.getModelLoader();
            ASMModel asmModel = ml.loadModel(modelWrapper.getName(), ((ASMModelWrapper)modelWrapper.getReferenceModel()).getAsmModel(), source);
            modelWrapper.setAsmModel(asmModel);
        }
        catch (IOException e) {
            throw new ATLCoreException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void inject(IModel targetModel, Reader source, Map<String, Object> options) throws ATLCoreException {
        throw new UnsupportedOperationException();
    }

    private void inject(IModel targetModel, String source, String modelName) throws ATLCoreException {
        ASMModelWrapper modelWrapper = (ASMModelWrapper)targetModel;
        try {
            ModelLoader ml = modelWrapper.getModelLoader();
            Object asmModel = null;
            if (source.startsWith("#")) {
                return;
            }
            asmModel = ml instanceof EMFModelLoader ? (source.startsWith("pathmap:") ? ((EMFModelLoader)ml).loadModel(modelName, ((ASMModelWrapper)modelWrapper.getReferenceModel()).getAsmModel(), URI.createURI((String)source).trimFragment()) : ((EMFModelLoader)ml).loadModel(modelName, ((ASMModelWrapper)modelWrapper.getReferenceModel()).getAsmModel(), URI.createURI((String)source))) : ml.loadModel(modelName, ((ASMModelWrapper)modelWrapper.getReferenceModel()).getAsmModel(), ASMInjector.fileNameToInputStream(source));
            modelWrapper.setAsmModel((ASMModel)asmModel);
        }
        catch (CoreException e) {
            throw new ATLCoreException(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new ATLCoreException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private static InputStream fileNameToInputStream(String filePath) throws FileNotFoundException, CoreException {
        String usedFilePath = filePath;
        if (usedFilePath.startsWith("file:/")) {
            File f = new File(usedFilePath.substring(6));
            return new FileInputStream(f);
        }
        if (usedFilePath.startsWith("platform:/resource/")) {
            usedFilePath = usedFilePath.substring(19);
        }
        IWorkspaceRoot iwr = ResourcesPlugin.getWorkspace().getRoot();
        usedFilePath = usedFilePath.replace('#', '/');
        return iwr.getFile((IPath)new Path(usedFilePath)).getContents();
    }
}

