/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jpa.core.JpaFactory;
import org.eclipse.jpt.jpa.core.context.java.DefaultJavaAttributeMappingDefinition;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.AttributeOverrideAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.EmbeddedAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JPA;

public class JavaEmbeddedMappingDefinition
implements DefaultJavaAttributeMappingDefinition {
    private static final DefaultJavaAttributeMappingDefinition INSTANCE = new JavaEmbeddedMappingDefinition();
    private static final String[] SUPPORTING_ANNOTATION_NAMES_ARRAY = new String[]{AttributeOverrideAnnotation.ANNOTATION_NAME, JPA.ATTRIBUTE_OVERRIDES};
    private static final Iterable<String> SUPPORTING_ANNOTATION_NAMES = IterableTools.iterable((Object[])SUPPORTING_ANNOTATION_NAMES_ARRAY);

    public static DefaultJavaAttributeMappingDefinition instance() {
        return INSTANCE;
    }

    private JavaEmbeddedMappingDefinition() {
    }

    @Override
    public String getKey() {
        return "embedded";
    }

    @Override
    public String getAnnotationName() {
        return EmbeddedAnnotation.ANNOTATION_NAME;
    }

    @Override
    public boolean isSpecified(JavaSpecifiedPersistentAttribute persistentAttribute) {
        return persistentAttribute.getResourceAttribute().getAnnotation(this.getAnnotationName()) != null;
    }

    @Override
    public Iterable<String> getSupportingAnnotationNames() {
        return SUPPORTING_ANNOTATION_NAMES;
    }

    @Override
    public JavaAttributeMapping buildMapping(JavaSpecifiedPersistentAttribute persistentAttribute, JpaFactory factory) {
        return factory.buildJavaEmbeddedMapping(persistentAttribute);
    }

    @Override
    public boolean isDefault(JavaSpecifiedPersistentAttribute persistentAttribute) {
        String targetEmbeddable = persistentAttribute.getSingleReferenceTargetTypeName();
        return targetEmbeddable != null && persistentAttribute.getPersistenceUnit().getEmbeddable(targetEmbeddable) != null;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

